/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.ConstantsSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.FileGroupSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.IndexPropertyDialogSqlServer;
import oracle.dbtools.crest.util.propertymap.PropertiesPropagator;
import oracle.dbtools.crest.util.propertymap.PropertyWrapper;

public class IndexProxySqlServer
extends IndexProxy
implements PropertiesPropagator {
    private FileGroupSqlServer filegroup;
    private String padIndex = "NO";
    private int fillFactor = 0;
    private String recomputeStatistics = "AUTO";
    private String sortInTempDB = "NO";
    private String ignoreDupKey = "NO";
    private String props = "";
    private InlineList extPropsSet = null;
    private List propertyWrapperList = null;

    public IndexProxySqlServer(Index index, StorageDesign storageDesign) {
        super(index, storageDesign);
    }

    public IndexProxySqlServer(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            IndexPropertyDialogSqlServer dialog = new IndexPropertyDialogSqlServer(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public void changed(DesignObject object, ObjectChangeEvent event) {
        super.changed(object, event);
        if (event.isType(ObjectChangeEvent.KEY_CHANGED_TO_PK)) {
            this.getStorageDesign().getIndexProxySet().remove(this);
            ((StorageDesignSqlServer)this.getStorageDesign()).getPKProxySet().add(object);
            this.fireChangeNoDirty(event);
        } else if (event.isType(ObjectChangeEvent.ADD_FK)) {
            this.getStorageDesign().getIndexProxySet().remove(this);
            ((StorageDesignSqlServer)this.getStorageDesign()).getFKProxySet().add(object);
            this.fireChangeNoDirty(event);
        } else if (event.isType(ObjectChangeEvent.KEY_CHANGED_TO_UNIQUE)) {
            this.getStorageDesign().getIndexProxySet().remove(this);
            ((StorageDesignSqlServer)this.getStorageDesign()).getUniqueProxySet().add(object);
            this.fireChangeNoDirty(event);
        }
    }

    public String getTableName() {
        return this.getTable().getName();
    }

    public String getTableUser() {
        if (((TableProxySqlServer)this.getTableProxy()).getUser() != null) {
            return ((TableProxySqlServer)this.getTableProxy()).getUser().getName();
        }
        return "";
    }

    public FileGroupSqlServer getFilegroup() {
        return this.filegroup;
    }

    public void setFilegroup(FileGroupSqlServer filegroup) {
        this.filegroup = filegroup;
        this.fireDataFieldChange();
    }

    public int getFillFactor() {
        return this.fillFactor;
    }

    public void setFillFactor(int fillFactor) {
        if (fillFactor >= 0 && fillFactor <= 100) {
            this.fillFactor = fillFactor;
        }
    }

    public String getIgnoreDupKey() {
        return this.ignoreDupKey;
    }

    public void setIgnoreDupKey(String ignoreDupKey) {
        if (ConstantsSqlServer.checkYesNo(ignoreDupKey)) {
            this.ignoreDupKey = ignoreDupKey;
            this.fireDataFieldChange();
        }
    }

    public String getPadIndex() {
        return this.padIndex;
    }

    public void setPadIndex(String padIndex) {
        if (ConstantsSqlServer.checkYesNo(padIndex)) {
            this.padIndex = padIndex;
            this.fireDataFieldChange();
        }
    }

    public String getRecomputeStatistics() {
        return this.recomputeStatistics;
    }

    public void setRecomputeStatistics(String recomputeStatistics) {
        if (ConstantsSqlServer.checkAutoNo(recomputeStatistics)) {
            this.recomputeStatistics = recomputeStatistics;
            this.fireDataFieldChange();
        }
    }

    public String getSortInTempDB() {
        return this.sortInTempDB;
    }

    public void setSortInTempDB(String sortInTempDB) {
        if (ConstantsSqlServer.checkYesNo(sortInTempDB)) {
            this.sortInTempDB = sortInTempDB;
            this.fireDataFieldChange();
        }
    }

    public String getUnique() {
        if (this.getIndex().getIndexState().equalsIgnoreCase("Unique Plain Index")) {
            return "YES";
        }
        return "NO";
    }

    public boolean isUniqueConstraint() {
        return this.getIndex().getIndexState().equalsIgnoreCase("Unique Constraint");
    }

    public String getProps() {
        return this.props;
    }

    public void setProps(String prop) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateExtPropertiesSet(prop);
        } else {
            this.addExtProperty(prop);
        }
        this.props = this.getExtPropsSet().toString();
        this.fireDataFieldChange();
    }

    private void addExtProperty(String props2) {
        this.getExtPropsSet().add(props2);
    }

    protected void recreateExtPropertiesSet(String props1) {
        this.getExtPropsSet().clear();
        StringTokenizer st = new StringTokenizer(props1, ",");
        this.extPropsSet = new InlineList();
        while (st.hasMoreTokens()) {
            this.getExtPropsSet().add(st.nextToken().trim());
        }
    }

    public InlineList getExtPropsSet() {
        if (this.extPropsSet == null) {
            this.extPropsSet = new InlineList();
        }
        return this.extPropsSet;
    }

    public void clear() {
        this.getExtPropsSet().removeAllElements();
        this.props = "";
    }

    @Override
    public List getPropertyWrapperList() {
        if (this.propertyWrapperList == null) {
            this.propertyWrapperList = new ArrayList();
            this.propertyWrapperList.add(new PropertyWrapper("Clustered", this, "isClustered", "setClustered", Boolean.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Filegroup", this, "getFilegroup", "setFilegroup", FileGroupSqlServer.class));
            this.propertyWrapperList.add(new PropertyWrapper("Pad Index", this, "getPadIndex", "setPadIndex", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Fill Factor[0,100]", this, "getFillFactor", "setFillFactor", Integer.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Recompute Stat", this, "getRecomputeStatistics", "setRecomputeStatistics", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Sort in temp DB", this, "getSortInTempDB", "setSortInTempDB", String.class));
        }
        return this.propertyWrapperList;
    }

    @Override
    public int getMaxNameLength() {
        return 128;
    }

    @Override
    public String getName() {
        if (this.isNameChanged()) {
            return super.getName();
        }
        Index index = (Index)this.getObject();
        String name = index.getName();
        if (index.isFK() && index.getFKAssociation() != null) {
            name = index.getFKAssociation().getName();
        }
        name = this.applyNameSubstitution(name);
        return name;
    }

    public class InlineList
    extends Vector {
        @Override
        public String toString() {
            StringBuffer result = new StringBuffer();
            Iterator it = this.iterator();
            boolean b = false;
            while (it.hasNext()) {
                if (b) {
                    result.append(", ");
                } else {
                    b = true;
                }
                String obj = (String)it.next();
                result.append(obj);
            }
            return result.toString();
        }
    }
}

