/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.ElementSet;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.CollectionTypeProxySet;
import oracle.dbtools.crest.model.design.storage.DistinctTypeProxySet;
import oracle.dbtools.crest.model.design.storage.MethodProxySet;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.StructuredTypeProxySet;
import oracle.dbtools.crest.model.design.storage.TableViewProxySet;
import oracle.dbtools.crest.model.design.storage.TypeElementProxySet;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataFileSetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DefaultSetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.FKProxySetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.FileGroupSetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.IndexOnViewSetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.InstanceDescriptorColumnSetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.LoginSetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.PKProxySetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.PermissionsSetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.RoleSetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.RuleSetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.SchemaSetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StoredProcedureSetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableViewProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TriggerSetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UniqueProxySetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UsedUserDefinedDataSet;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserDefinedTypeSetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.DistinctTypeSetSqlServerv2k5;
import oracle.dbtools.crest.model.propertyholder.PropertyHolder;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.storage.usertype.UserDefinedTypesDialogSqlServer;

public abstract class StorageDesignSqlServer
extends StorageDesign {
    private boolean dtDialogVisible = false;
    private DistinctTypeProxySet distinctTypeProxies;
    private boolean imported;

    public StorageDesignSqlServer(RelationalDesign physicalDesign, RDBMSSite site, Design design) {
        super(physicalDesign, site, design);
    }

    @Override
    public abstract PropertyHolder getPropertyHolder();

    public abstract void updateGeneralRule();

    public abstract PKProxySetSqlServer getPKProxySet();

    public abstract DesignPartView getSelectedSubView();

    public UniqueProxySetSqlServer getUniqueProxySet() {
        return null;
    }

    public abstract FKProxySetSqlServer getFKProxySet();

    @Override
    public StructuredTypeProxySet getStructuredTypeProxySet() {
        return null;
    }

    @Override
    public CollectionTypeProxySet getCollectionTypeProxySet() {
        return null;
    }

    public DistinctTypeProxySet getDistinctTypeProxySet() {
        if (this.distinctTypeProxies == null) {
            this.distinctTypeProxies = new DistinctTypeSetSqlServerv2k5(this);
            this.distinctTypeProxies.setDesign(this.getDesign());
        }
        return this.distinctTypeProxies;
    }

    @Override
    public TypeElementProxySet getTypeElementProxySet() {
        return null;
    }

    @Override
    public MethodProxySet getMethodProxySet() {
        return null;
    }

    public abstract InstanceDescriptorColumnSetSqlServer getInstanceDescriptorColumnSet();

    @Override
    public StorageObjectSet getStorageObjectSetForType(String objectType) {
        if (objectType == null) {
            return null;
        }
        if (objectType.equalsIgnoreCase("DataBase")) {
            return this.getDataBaseSet();
        }
        if (objectType.equalsIgnoreCase("Role")) {
            return this.getRoleSet();
        }
        if (objectType.equalsIgnoreCase("User")) {
            return this.getUserSet();
        }
        if (objectType.equalsIgnoreCase("Schema")) {
            return this.getSchemaSet();
        }
        if (objectType.equalsIgnoreCase("DataFile")) {
            return this.getDataFileSet();
        }
        if (objectType.equalsIgnoreCase("FileGroup")) {
            return this.getFileGroupSet();
        }
        if (objectType.equalsIgnoreCase("Permissions")) {
            return this.getPermissionsSet();
        }
        if (objectType.equalsIgnoreCase("Login")) {
            return this.getLoginSet();
        }
        if (objectType.equalsIgnoreCase("Rule")) {
            return this.getRuleSet();
        }
        if (objectType.equalsIgnoreCase("Default")) {
            return this.getDefaultSet();
        }
        if (objectType.equalsIgnoreCase("IndexOnView")) {
            return this.getIndexOnViewSet();
        }
        if (objectType.equalsIgnoreCase("Trigger")) {
            return this.getTriggerSet();
        }
        if (objectType.equalsIgnoreCase("StProc") || objectType.equalsIgnoreCase("StoredProcedure")) {
            return this.getStoredProcedureSet();
        }
        if (objectType.equalsIgnoreCase("UDType") || objectType.equalsIgnoreCase("UserDefinedType")) {
            return this.getUserDefinedTypeSet();
        }
        if (objectType.equalsIgnoreCase("InstanceDescriptorCol")) {
            return this.getInstanceDescriptorColumnSet();
        }
        if (objectType.equalsIgnoreCase("UUDD") || objectType.equalsIgnoreCase("UsedUserDefinedData")) {
            return this.getUsedUserDefinedDataSet();
        }
        return null;
    }

    @Override
    public List getStorableSetsList() {
        ArrayList<ModelObject> list = new ArrayList<ModelObject>();
        list.add(this.getDataBaseSet());
        list.add(this.getLoginSet());
        list.add(this.getUserSet());
        list.add(this.getSchemaSet());
        list.add(this.getRoleSet());
        list.add(this.getDefaultSet());
        list.add(this.getTableProxySet());
        list.add(this.getTableViewProxySet());
        list.add(this.getRuleSet());
        list.add(this.getTriggerSet());
        list.add(this.getStoredProcedureSet());
        list.add(this.getUserDefinedTypeSet());
        list.add(this.getDistinctTypeProxySet());
        return list;
    }

    @Override
    public List getAllSetsList() {
        ArrayList<ModelObject> list = new ArrayList<ModelObject>();
        list.add(this.getDataBaseSet());
        list.add(this.getFileGroupSet());
        list.add(this.getDataFileSet());
        list.add(this.getLoginSet());
        list.add(this.getUserSet());
        list.add(this.getSchemaSet());
        list.add(this.getRoleSet());
        list.add(this.getDefaultSet());
        list.add(this.getTableProxySet());
        list.add(this.getColumnProxySet());
        list.add(this.getIndexProxySet());
        list.add(this.getPKProxySet());
        list.add(this.getUniqueProxySet());
        list.add(this.getFKProxySet());
        list.add(this.getTableViewProxySet());
        list.add(this.getIndexOnViewSet());
        list.add(this.getInstanceDescriptorColumnSet());
        list.add(this.getRuleSet());
        list.add(this.getPermissionsSet());
        list.add(this.getTriggerSet());
        list.add(this.getStoredProcedureSet());
        list.add(this.getUserDefinedTypeSet());
        list.add(this.getDistinctTypeProxySet());
        list.add(this.getUsedUserDefinedDataSet());
        return list;
    }

    public abstract DataBaseSetSqlServer getDataBaseSet();

    public abstract RoleSetSqlServer getRoleSet();

    public abstract UserSetSqlServer getUserSet();

    public abstract DataFileSetSqlServer getDataFileSet();

    public abstract FileGroupSetSqlServer getFileGroupSet();

    public abstract PermissionsSetSqlServer getPermissionsSet();

    public abstract RuleSetSqlServer getRuleSet();

    public abstract LoginSetSqlServer getLoginSet();

    public abstract DefaultSetSqlServer getDefaultSet();

    public abstract IndexOnViewSetSqlServer getIndexOnViewSet();

    public abstract TriggerSetSqlServer getTriggerSet();

    public abstract StoredProcedureSetSqlServer getStoredProcedureSet();

    public abstract UserDefinedTypeSetSqlServer getUserDefinedTypeSet();

    public abstract SchemaSetSqlServer getSchemaSet();

    public abstract UsedUserDefinedDataSet getUsedUserDefinedDataSet();

    @Override
    public boolean hasUserDefinedTypes() {
        return true;
    }

    @Override
    public void showUserDefinedTypes() {
        if (!this.dtDialogVisible) {
            UserDefinedTypesDialogSqlServer userDefinedTypesDialog = new UserDefinedTypesDialogSqlServer(this.getDesign().getAppView(), this);
            userDefinedTypesDialog.showDialog();
        }
    }

    public boolean isDtDialogVisible() {
        return this.dtDialogVisible;
    }

    public void setDtDialogVisible(boolean dtDialogVisible) {
        this.dtDialogVisible = dtDialogVisible;
    }

    public boolean isImported() {
        return this.imported;
    }

    public void setImported(boolean imported) {
        this.imported = imported;
    }

    @Override
    public List getDropableSets() {
        ArrayList<ModelObject> list = new ArrayList<ModelObject>();
        list.add(this.getTableProxySet());
        list.add(this.getIndexProxySet());
        list.add(this.getFKProxySet());
        list.add(this.getTableViewProxySet());
        list.add(this.getDataBaseSet());
        return list;
    }

    @Override
    public List getUniqueList() {
        ArrayList<Object> list = new ArrayList<Object>();
        if (this.getUniqueProxySet() != null) {
            Object[] objects = this.getUniqueProxySet().toArray();
            for (int i = 0; i < objects.length; ++i) {
                list.add(objects[i]);
            }
        }
        return list;
    }

    @Override
    public List getFKProxyList() {
        ArrayList<Object> list = new ArrayList<Object>();
        Object[] objects = this.getFKProxySet().toArray();
        for (int i = 0; i < objects.length; ++i) {
            list.add(objects[i]);
        }
        return list;
    }

    @Override
    public List getPKProxyList() {
        ArrayList<Object> list = new ArrayList<Object>();
        Object[] objects = this.getPKProxySet().toArray();
        for (int i = 0; i < objects.length; ++i) {
            list.add(objects[i]);
        }
        return list;
    }

    @Override
    public void reloadAllProxies() {
        super.reloadAllProxies();
        this.getPKProxySet().setDesign(this.getDesign());
        this.getUniqueProxySet().setDesign(this.getDesign());
        this.getFKProxySet().setDesign(this.getDesign());
        this.getDistinctTypeProxySet().setDesign(this.getDesign());
    }

    @Override
    protected List<ElementSet> createDDLSelectionSetsList() {
        List<ElementSet> objectSets = super.createDDLSelectionSetsList();
        objectSets.add(this.getDataBaseSet());
        objectSets.add(this.getUserSet());
        objectSets.add(this.getLoginSet());
        objectSets.add(this.getUserDefinedTypeSet());
        objectSets.add(this.getDefaultSet());
        objectSets.add(this.getStoredProcedureSet());
        objectSets.add(this.getRoleSet());
        objectSets.add(this.getRuleSet());
        objectSets.add(this.getTableProxySet());
        this.addDDLSelectionViewSetsList(objectSets);
        return objectSets;
    }

    protected void addDDLSelectionViewSetsList(List<ElementSet> objectSets) {
        TableViewProxySet tableViewProxySet = this.getTableViewProxySet();
        Iterator tableViewProxySetIterator = tableViewProxySet.iterator();
        while (tableViewProxySetIterator.hasNext()) {
            TableViewProxySqlServer tableViewProxySqlServer = (TableViewProxySqlServer)tableViewProxySetIterator.next();
            objectSets.add(tableViewProxySqlServer.getIndexesOnView());
            objectSets.add(tableViewProxySqlServer.getTriggers());
        }
        objectSets.add(tableViewProxySet);
    }

    @Override
    public void sortCollections() {
        this.getTableProxySet().sort();
        this.getTableViewProxySet().sort();
        this.getDataBaseSet().sort();
        this.getFileGroupSet().sort();
        this.getDataFileSet().sort();
        this.getRoleSet().sort();
        this.getLoginSet().sort();
        this.getUserSet().sort();
        this.getSchemaSet().sort();
        this.getDefaultSet().sort();
        this.getUserDefinedTypeSet().sort();
        this.getIndexOnViewSet().sort();
        this.getPermissionsSet().sort();
        this.getRuleSet().sort();
        this.getTriggerSet().sort();
        this.getStoredProcedureSet().sort();
        this.getUsedUserDefinedDataSet().sort();
    }

    @Override
    public StorageObjectSet getUserSchemaSet() {
        return this.getUserSet();
    }

    @Override
    public String[] getFKDeleteRules() {
        return FKIndexAssociation.DELETE_RULES_WITH_DEFAULT;
    }

    @Override
    public String[] getFKDeleteRulesMandatory() {
        return FKIndexAssociation.DELETE_RULES_WITH_DEFAULT_WITHOUT_NULL;
    }

    @Override
    public String[] getFKDeleteRulesNonTransferable() {
        return FKIndexAssociation.DELETE_RULES_NOACTION_CASCADE;
    }

    @Override
    public String getValidFKRule(String fkRule) {
        if ("RESTRICT".equals(fkRule)) {
            return "NO ACTION";
        }
        return fkRule;
    }
}

