/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import oracle.dbtools.crest.model.design.storage.sqlserver.AbstractStorageObjectSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.LoginSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.PermissionsSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.swingui.GUIConfiguration;

public class UserSqlServer
extends AbstractStorageObjectSqlServer {
    private DataBaseSqlServer database;
    private LoginSqlServer login;
    private static final String[] PRIVILEGES = new String[]{"ALL", "CREATE DEFAULT", "CREATE FUNCTION", "CREATE PROCEDURE", "CREATE RULE", "CREATE TABLE", "CREATE VIEW", "BACKUP DATABASE", "BACKUP LOG"};
    public static final List PRIVILEGESLIST = Arrays.asList(PRIVILEGES);
    private String systemPrivileges = "";
    private InlineList systemPrivilegesSet = null;
    public static final String TYPE_NAME = "User";

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "U";
    }

    @Override
    public void showPropertyDialog() {
    }

    @Override
    public DataBaseSqlServer getDatabase() {
        return this.database;
    }

    public void setDatabase(DataBaseSqlServer database) {
        this.database = database;
        this.fireDataFieldChange();
    }

    public LoginSqlServer getLogin() {
        return this.login;
    }

    public void setLogin(LoginSqlServer login) {
        this.login = login;
        this.fireDataFieldChange();
    }

    @Override
    public boolean canDeleteInGUI() {
        return false;
    }

    public static List getPrivilegesValues() {
        Collections.sort(PRIVILEGESLIST, new StringComparator());
        return PRIVILEGESLIST;
    }

    private void addPrivilege(String systemPrivilege) {
        if (!this.getPrivilegesSet().contains(systemPrivilege)) {
            this.getPrivilegesSet().add(systemPrivilege);
        }
    }

    public void clear() {
        this.getPrivilegesSet().removeAllElements();
        this.systemPrivileges = "";
    }

    public InlineList getPrivilegesSet() {
        if (this.systemPrivilegesSet == null) {
            this.systemPrivilegesSet = new InlineList();
        }
        return this.systemPrivilegesSet;
    }

    public String getSystemPrivileges() {
        return this.systemPrivileges;
    }

    public void recreateSystemPrivilegesSet(String privileges) {
        this.getPrivilegesSet().clear();
        StringTokenizer st = new StringTokenizer(privileges, ",");
        this.systemPrivilegesSet = new InlineList();
        while (st.hasMoreTokens()) {
            String privilege = st.nextToken().trim();
            if (!this.checkPrivileges(privilege)) continue;
            this.getPrivilegesSet().add(privilege);
        }
    }

    protected boolean checkPrivileges(String value) {
        return PRIVILEGESLIST.contains(value);
    }

    public void setSystemPrivileges(String privilege) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateSystemPrivilegesSet(privilege);
        } else if (this.checkPrivileges(privilege)) {
            this.addPrivilege(privilege);
        }
        this.systemPrivileges = this.getPrivilegesSet().toString();
        this.fireDataFieldChange();
    }

    public List getPermissions() {
        ArrayList<PermissionsSqlServer> perms = new ArrayList<PermissionsSqlServer>();
        Iterator it = ((StorageDesignSqlServer)this.getStorageDesign()).getPermissionsSet().iterator();
        while (it.hasNext()) {
            PermissionsSqlServer permission = (PermissionsSqlServer)it.next();
            if (permission.getUser() != this || permission.getTable() == null && permission.getView() == null) continue;
            perms.add(permission);
        }
        return perms;
    }

    public PermissionsSqlServer createPermission() {
        PermissionsSqlServer permission = ((StorageDesignSqlServer)this.getStorageDesign()).getPermissionsSet().createPermissions();
        permission.setUser(this);
        return permission;
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("USER_ICON", 16);
    }

    static class StringComparator
    implements Comparator {
        StringComparator() {
        }

        public int compare(Object one, Object two) {
            return String.valueOf(one).compareTo(String.valueOf(two));
        }
    }

    public class InlineList
    extends Vector {
        @Override
        public String toString() {
            StringBuffer result = new StringBuffer();
            Iterator it = this.iterator();
            boolean b = false;
            while (it.hasNext()) {
                if (b) {
                    result.append(", ");
                } else {
                    b = true;
                }
                String obj = (String)it.next();
                result.append(obj);
            }
            return result.toString();
        }
    }
}

