/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver.v2k5;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxySet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectPlaceHolder;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.TableViewProxy;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataFileSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DefaultSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DistinctTypeProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.FileGroupSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.PartitionFunctionSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.RoleSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.RuleSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.SchemaSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StoredProcedureSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableViewProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UsedUserDefinedData;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.DataFileSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.DefaultSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.DistinctTypeProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.FileGroupSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.PartitionFunctionSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.RoleSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.RuleSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.SchemaSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StoredProcedureSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.TableProxySetSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.TableProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.TableViewProxySetSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.TableViewProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.UsedUserDefinedDatav2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.UserDefinedTypeSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.UserSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.XMLSchemaCollectionSqlServerv2k5;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.v2k5.DataBasePropertyDialogSqlServerv2k5;

public class DataBaseSqlServerv2k5
extends DataBaseSqlServer {
    private StorageObjectCollection transactionLogs;
    private StorageObjectCollection filegroups;
    private StorageObjectCollection defaults;
    private StorageObjectCollection users;
    private StorageObjectCollection schemas;
    private StorageObjectCollection roles;
    private StorageObjectCollection rules;
    private StorageObjectCollection procedures;
    private StorageObjectCollection tables;
    private StorageObjectCollection views;
    private StorageObjectCollection distinctTypes;
    private StorageObjectCollection userDefinedDomains;
    private StorageObjectCollection partitionFunction;
    private StorageObjectCollection xmlSchemaCollections;
    private static final String[] USER_STATES = new String[]{"SINGLE_USER", "RESTRICTED_USER", "MULTI_USER"};
    private static Set userSet = null;
    private static final String[] ON_OFF_STATES = new String[]{"ON", "OFF"};
    private static final String[] SIMPLE_FORCED_STATES = new String[]{"SIMPLE", "FORCED"};
    private static final String[] CHECKSUM_TORNPAGEDETECTION_NONE_STATES = new String[]{"CHECKSUM", "TORN_PAGE_DETECTION", "NONE"};
    private static final String[] LEVEL_80_90_100_STATES = new String[]{"80", "90", "100"};
    private static Set onOffSet = null;
    private static Set simpleForcedSet = null;
    private static Set checkTornNoneSet = null;
    private static Set check8090100Set = null;
    private static final String[] CURSOR_DEFAULT_STATES = new String[]{"LOCAL", "GLOBAL"};
    private static Set cursorDefaultSet = null;
    private static final String[] RECOVERY_STATES = new String[]{"FULL", "BULK_LOGGED", "SIMPLE"};
    private static Set recoverySet = null;
    private String userState = "MULTI_USER";
    private String collationName = " ";
    private String cursorCloseOnCommit = "ON";
    private String cursorDefault = "GLOBAL";
    private String autoClose = "ON";
    private String autoCreateStatistics = "ON";
    private String autoUpdateStatistics = "ON";
    private String autoShrink = "ON";
    private String recovery = "FULL";
    private String tornPageDetection = "ON";
    private String ansiNulls = "OFF";
    private String ansiPadding = "";
    private String ansiWarnings = "";
    private String arithabort = "";
    private String concatNullYieldsNull = "";
    private String numericRoundabort = "";
    private String quotedIdentifier = "OFF";
    private String recursiveTriggers = "";
    private String ansiNullDefault = "OFF";
    private String autoUpdateStatisticsAsync = "OFF";
    private String dateCorrelationOptimization = "OFF";
    private String trustworthy = "OFF";
    private String allowSnapshotIsolation = "OFF";
    private String readCommittedSnapshot = "OFF";
    private String dbChaining = "OFF";
    private boolean enableBroker = false;
    private boolean disableBroker = false;
    private boolean newBroker = false;
    private boolean errorBrokerConversations = false;
    private boolean readWrite = false;
    private boolean readOnly = false;
    private boolean rollbackImmediate = false;
    private boolean noWait = false;
    private String rollbackAfter = "";
    private String parameterization = "SIMPLE";
    private String pageVerify = "NONE";
    private String honorBrokerPriority = "OFF";
    private String compatibilityLevel = "80";
    private String changeTracking = "OFF";
    private String autoCleanup = "OFF";
    private String encryption = "OFF";

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            DataBasePropertyDialogSqlServerv2k5 dialog = new DataBasePropertyDialogSqlServerv2k5(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    public DataBaseSqlServerv2k5(StorageDesign storageDesign) {
        super(storageDesign);
        StorageDesignSqlServerv2k5 design = (StorageDesignSqlServerv2k5)storageDesign;
        this.filegroups = new StorageObjectCollection(((StorageDesignSqlServer)storageDesign).getFileGroupSet());
        this.filegroups.setParent(this);
        this.filegroups.setName(Messages.getString("DataBaseSqlServer.FileGroups"));
        this.filegroups.setSetMethod("setDataBase");
        this.filegroups.setClassForParent(DataBaseSqlServer.class);
        this.filegroups.setIcon(GUIConfiguration.getInstance().getIcon("GROUP_ICON", 16));
        this.transactionLogs = new StorageObjectCollection(((StorageDesignSqlServer)storageDesign).getDataFileSet());
        this.transactionLogs.setParent(this);
        this.transactionLogs.setName(Messages.getString("DataBaseSqlServer.LogsFiles"));
        this.transactionLogs.setSetMethod("setDataBase");
        this.transactionLogs.setClassForParent(DataBaseSqlServer.class);
        this.transactionLogs.setIcon(GUIConfiguration.getInstance().getIcon("DATAFILE_ICON", 16));
        this.defaults = new StorageObjectCollection(((StorageDesignSqlServer)storageDesign).getDefaultSet());
        this.defaults.setParent(this);
        this.defaults.setName(Messages.getString("DataBaseSqlServer.Defaults"));
        this.defaults.setSetMethod("setDataBase");
        this.defaults.setClassForParent(DataBaseSqlServer.class);
        this.defaults.setIcon(GUIConfiguration.getInstance().getIcon("DEFAULT_ICON", 16));
        this.users = new StorageObjectCollection();
        this.users.setParent(this);
        this.users.setName(Messages.getString("StorageDesignOracle.Users"));
        this.users.setSetMethod("setDatabase");
        this.users.setClassForParent(DataBaseSqlServer.class);
        this.users.setIcon(GUIConfiguration.getInstance().getIcon("USER_FOLDER_ICON", 16));
        this.schemas = new StorageObjectCollection(((StorageDesignSqlServer)storageDesign).getSchemaSet());
        this.schemas.setParent(this);
        this.schemas.setName(Messages.getString("RelationalDesign.Schemas"));
        this.schemas.setSetMethod("setDatabase");
        this.schemas.setClassForParent(DataBaseSqlServer.class);
        this.schemas.setIcon(GUIConfiguration.getInstance().getIcon("SCHEMA_FOLDER_ICON", 16));
        this.roles = new StorageObjectCollection(((StorageDesignSqlServer)storageDesign).getRoleSet());
        this.roles.setParent(this);
        this.roles.setName(Messages.getString("StorageDesignOracle.Roles"));
        this.roles.setSetMethod("setDatabase");
        this.roles.setClassForParent(DataBaseSqlServer.class);
        this.roles.setIcon(GUIConfiguration.getInstance().getIcon("ROLE_ICON", 16));
        this.rules = new StorageObjectCollection(((StorageDesignSqlServer)storageDesign).getRuleSet());
        this.rules.setParent(this);
        this.rules.setName(Messages.getString("DataBaseSqlServer.Rules"));
        this.rules.setSetMethod("setDatabase");
        this.rules.setClassForParent(DataBaseSqlServer.class);
        this.rules.setIcon(GUIConfiguration.getInstance().getIcon("RULE_ICON", 16));
        this.partitionFunction = new StorageObjectCollection(design.getPartitionFunctionSet());
        this.partitionFunction.setParent(this);
        this.partitionFunction.setName(Messages.getString("DataBaseSqlServerv2k5.PartitionFunctions"));
        this.partitionFunction.setSetMethod("setDatabase");
        this.partitionFunction.setClassForParent(DataBaseSqlServer.class);
        this.partitionFunction.setIcon(GUIConfiguration.getInstance().getIcon("FUNCTION_FOLDER_ICON", 16));
        this.tables = new StorageObjectCollection();
        this.tables.setParent(this);
        this.tables.setName(Messages.getString("StorageDesignOracle.Tables"));
        this.tables.setIcon(GUIConfiguration.getInstance().getIcon("TABLE_FOLDER_ICON", 16));
        this.registerToTableProxyFromDesign(storageDesign.getTableProxySet());
        storageDesign.getTableProxySet().addSetListener(this);
        this.views = new StorageObjectCollection();
        this.views.setParent(this);
        this.views.setName(Messages.getString("StorageDesignOracle.Views"));
        this.views.setIcon(GUIConfiguration.getInstance().getIcon("VIEW_FOLDER_ICON", 16));
        this.registerToViewProxyFromDesign(storageDesign.getTableViewProxySet());
        storageDesign.getTableViewProxySet().addSetListener(this);
        this.procedures = new StorageObjectCollection(((StorageDesignSqlServer)storageDesign).getStoredProcedureSet());
        this.procedures.setParent(this);
        this.procedures.setName(Messages.getString("StorageDesignOracle.StoredProcedures"));
        this.procedures.setSetMethod("setDatabase");
        this.procedures.setClassForParent(DataBaseSqlServer.class);
        this.procedures.setIcon(GUIConfiguration.getInstance().getIcon("PROCEDURE_FOLDER_ICON", 16));
        this.distinctTypes = new StorageObjectCollection(((StorageDesignSqlServer)storageDesign).getUsedUserDefinedDataSet());
        this.distinctTypes.setForbiddenCreateElement(true);
        this.distinctTypes.setParent(this);
        this.distinctTypes.setName(Messages.getString("StorageDesignSqlServerv2k5.UDDTDistinctTypes"));
        this.distinctTypes.setSetMethod("setDatabase");
        this.distinctTypes.setClassForParent(DataBaseSqlServer.class);
        this.distinctTypes.setIcon(GUIConfiguration.getInstance().getIcon("STRUCTURED_TYPE_ICON", 16));
        this.userDefinedDomains = new StorageObjectCollection(((StorageDesignSqlServer)storageDesign).getUsedUserDefinedDataSet());
        this.userDefinedDomains.setForbiddenCreateElement(true);
        this.userDefinedDomains.setParent(this);
        this.userDefinedDomains.setName(Messages.getString("StorageDesignSqlServerv2k5.UDDTDomains"));
        this.userDefinedDomains.setSetMethod("setDatabase");
        this.userDefinedDomains.setClassForParent(DataBaseSqlServer.class);
        this.userDefinedDomains.setIcon(GUIConfiguration.getInstance().getIcon("DOMAIN_ICON", 16));
        this.xmlSchemaCollections = new StorageObjectCollection(design.getXmlSchemaCollectionSet());
        this.xmlSchemaCollections.setParent(this);
        this.xmlSchemaCollections.setName(Messages.getString("DataBaseSqlServerv2k5.XMLSchemaCollections"));
        this.xmlSchemaCollections.setSetMethod("setDatabase");
        this.xmlSchemaCollections.setClassForParent(DataBaseSqlServer.class);
        this.xmlSchemaCollections.setIcon(GUIConfiguration.getInstance().getIcon("XML_FILE_ICON", 16));
        design.getDataFileSet().addSetListener(this);
        design.getFileGroupSet().addSetListener(this);
        design.getDefaultSet().addSetListener(this);
        design.getUserSet().addSetListener(this);
        design.getSchemaSet().addSetListener(this);
        design.getRoleSet().addSetListener(this);
        design.getRuleSet().addSetListener(this);
        design.getStoredProcedureSet().addSetListener(this);
        design.getDistinctTypeProxySet().addSetListener(this);
        design.getUserDefinedTypeSet().addSetListener(this);
        design.getUsedUserDefinedDataSet().addSetListener(this);
        design.getPartitionFunctionSet().addSetListener(this);
        design.getXmlSchemaCollectionSet().addSetListener(this);
    }

    @Override
    public String getObjectTypeName() {
        return "DataBase";
    }

    @Override
    public String getIDPrefix() {
        return "DB";
    }

    @Override
    public int getNumberOfChildren() {
        return 14;
    }

    @Override
    public ModelObject getChild(int index) {
        switch (index) {
            case 0: {
                return this.filegroups;
            }
            case 1: {
                return this.transactionLogs;
            }
            case 2: {
                return this.defaults;
            }
            case 3: {
                return this.users;
            }
            case 4: {
                return this.schemas;
            }
            case 5: {
                return this.roles;
            }
            case 6: {
                return this.rules;
            }
            case 7: {
                return this.tables;
            }
            case 8: {
                return this.views;
            }
            case 9: {
                return this.partitionFunction;
            }
            case 10: {
                return this.procedures;
            }
            case 11: {
                return this.distinctTypes;
            }
            case 12: {
                return this.userDefinedDomains;
            }
            case 13: {
                return this.xmlSchemaCollections;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int index) {
        return this.getChild(index);
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.filegroups) {
            return 0;
        }
        if (child == this.transactionLogs) {
            return 1;
        }
        if (child == this.defaults) {
            return 2;
        }
        if (child == this.users) {
            return 3;
        }
        if (child == this.schemas) {
            return 4;
        }
        if (child == this.roles) {
            return 5;
        }
        if (child == this.rules) {
            return 6;
        }
        if (child == this.tables) {
            return 7;
        }
        if (child == this.views) {
            return 8;
        }
        if (child == this.partitionFunction) {
            return 9;
        }
        if (child == this.procedures) {
            return 10;
        }
        if (child == this.distinctTypes) {
            return 11;
        }
        if (child == this.userDefinedDomains) {
            return 12;
        }
        if (child == this.xmlSchemaCollections) {
            return 13;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object child) {
        if (child == this.filegroups) {
            return 0;
        }
        if (child == this.transactionLogs) {
            return 1;
        }
        if (child == this.defaults) {
            return 2;
        }
        if (child == this.users) {
            return 3;
        }
        if (child == this.schemas) {
            return 4;
        }
        if (child == this.roles) {
            return 5;
        }
        if (child == this.rules) {
            return 6;
        }
        if (child == this.tables) {
            return 7;
        }
        if (child == this.views) {
            return 8;
        }
        if (child == this.partitionFunction) {
            return 9;
        }
        if (child == this.procedures) {
            return 10;
        }
        if (child == this.distinctTypes) {
            return 11;
        }
        if (child == this.userDefinedDomains) {
            return 12;
        }
        if (child == this.xmlSchemaCollections) {
            return 13;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void clearChildren() {
        this.filegroups.removeAll();
        this.transactionLogs.removeAll();
        this.defaults.removeAll();
        this.users.removeAll();
        this.schemas.removeAll();
        this.roles.removeAll();
        this.rules.removeAll();
        this.tables.removeAll();
        this.views.removeAll();
        this.procedures.removeAll();
        this.distinctTypes.removeAll();
        this.userDefinedDomains.removeAll();
        this.partitionFunction.removeAll();
        this.xmlSchemaCollections.removeAll();
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
        if (event.isType(1)) {
            if (event.getAffected() instanceof DataFileSqlServer) {
                DataFileSqlServer df = (DataFileSqlServer)event.getAffected();
                df.addObjectListener(this);
                if (df.getDataBase() != null && df.getDataBase() == this) {
                    df.setParent(this.transactionLogs);
                    this.transactionLogs.add(df);
                } else {
                    this.transactionLogs.remove(df);
                }
            } else if (event.getAffected() instanceof FileGroupSqlServer) {
                FileGroupSqlServer fg = (FileGroupSqlServer)event.getAffected();
                fg.addObjectListener(this);
                if (fg.getDataBase() != null && fg.getDataBase() == this) {
                    fg.setParent(this.filegroups);
                    this.filegroups.add(fg);
                } else {
                    this.filegroups.remove(fg);
                }
            } else if (event.getAffected() instanceof DefaultSqlServer) {
                DefaultSqlServer d = (DefaultSqlServer)event.getAffected();
                d.addObjectListener(this);
                if (d.getDataBase() != null && d.getDataBase() == this) {
                    d.setParent(this.defaults);
                    this.defaults.add(d);
                } else {
                    this.defaults.remove(d);
                }
            } else if (event.getAffected() instanceof UserSqlServer) {
                UserSqlServer user = (UserSqlServer)event.getAffected();
                user.addObjectListener(this);
                if (user.getDatabase() != null && user.getDatabase() == this) {
                    user.setParent(this.users);
                    this.users.add(user);
                } else {
                    this.users.remove(user);
                }
            } else if (event.getAffected() instanceof SchemaSqlServer) {
                SchemaSqlServer schema = (SchemaSqlServer)event.getAffected();
                schema.addObjectListener(this);
                if (schema.getDatabase() != null && schema.getDatabase() == this) {
                    schema.setParent(this.schemas);
                    this.schemas.add(schema);
                } else {
                    this.schemas.remove(schema);
                }
            } else if (event.getAffected() instanceof RoleSqlServer) {
                RoleSqlServer role = (RoleSqlServer)event.getAffected();
                role.addObjectListener(this);
                if (role.getDatabase() != null && role.getDatabase() == this) {
                    role.setParent(this.roles);
                    this.roles.add(role);
                } else {
                    this.roles.remove(role);
                }
            } else if (event.getAffected() instanceof RuleSqlServer) {
                RuleSqlServer rule = (RuleSqlServer)event.getAffected();
                rule.addObjectListener(this);
                if (rule.getDatabase() != null && rule.getDatabase() == this) {
                    rule.setParent(this.rules);
                    this.rules.add(rule);
                } else {
                    this.rules.remove(rule);
                }
            } else if (event.getAffected() instanceof StoredProcedureSqlServer) {
                StoredProcedureSqlServer proc = (StoredProcedureSqlServer)event.getAffected();
                proc.addObjectListener(this);
                if (proc.getDatabase() != null && proc.getDatabase() == this) {
                    proc.setParent(this.procedures);
                    this.procedures.add(proc);
                } else {
                    this.procedures.remove(proc);
                }
            } else if (event.getAffected() instanceof UserDefinedTypeSqlServerv2k5) {
                UserDefinedTypeSqlServerv2k5 us = (UserDefinedTypeSqlServerv2k5)event.getAffected();
                us.addObjectListener(this);
                if (us.getDatabase() != null && us.getDatabase() == this) {
                    us.setParent(this.userDefinedDomains);
                    this.userDefinedDomains.add(us);
                } else {
                    this.userDefinedDomains.remove(us);
                }
            } else if (event.getAffected() instanceof UsedUserDefinedDatav2k5) {
                UsedUserDefinedDatav2k5 usedUserDefinedData = (UsedUserDefinedDatav2k5)event.getAffected();
                usedUserDefinedData.addObjectListener(this);
                if (usedUserDefinedData.isBaseOnDistinctType()) {
                    if (usedUserDefinedData.getDatabase() == this) {
                        usedUserDefinedData.setParent(this.distinctTypes);
                        this.distinctTypes.add(usedUserDefinedData);
                    } else {
                        this.distinctTypes.remove(usedUserDefinedData);
                    }
                } else if (usedUserDefinedData.getUserDefinedType() != null) {
                    if (usedUserDefinedData.getDatabase() == this) {
                        usedUserDefinedData.setParent(this.userDefinedDomains);
                        this.userDefinedDomains.add(usedUserDefinedData);
                    } else {
                        this.userDefinedDomains.remove(usedUserDefinedData);
                    }
                }
            } else if (event.getAffected() instanceof PartitionFunctionSqlServer) {
                PartitionFunctionSqlServer partFunc = (PartitionFunctionSqlServer)event.getAffected();
                partFunc.addObjectListener(this);
                if (partFunc.getDatabase() != null && partFunc.getDatabase() == this) {
                    partFunc.setParent(this.partitionFunction);
                    this.partitionFunction.add(partFunc);
                } else {
                    this.partitionFunction.remove(partFunc);
                }
            } else if (event.getAffected() instanceof XMLSchemaCollectionSqlServerv2k5) {
                XMLSchemaCollectionSqlServerv2k5 xmlType = (XMLSchemaCollectionSqlServerv2k5)event.getAffected();
                xmlType.addObjectListener(this);
                if (xmlType.getDatabase() != null && xmlType.getDatabase() == this) {
                    xmlType.setParent(this.xmlSchemaCollections);
                    this.xmlSchemaCollections.add(xmlType);
                } else {
                    this.xmlSchemaCollections.remove(xmlType);
                }
            }
        } else if (event.isType(0)) {
            if (event.getAffected() instanceof DataFileSqlServer) {
                DataFileSqlServer df = (DataFileSqlServer)event.getAffected();
                this.transactionLogs.remove(df);
                df.removeObjectListener(this);
            } else if (event.getAffected() instanceof FileGroupSqlServer) {
                FileGroupSqlServer fg = (FileGroupSqlServer)event.getAffected();
                this.filegroups.remove(fg);
                fg.removeObjectListener(this);
            } else if (event.getAffected() instanceof DefaultSqlServer) {
                DefaultSqlServer d = (DefaultSqlServer)event.getAffected();
                this.defaults.remove(d);
                d.removeObjectListener(this);
            } else if (event.getAffected() instanceof UserSqlServer) {
                UserSqlServer user = (UserSqlServer)event.getAffected();
                this.users.remove(user);
                user.removeObjectListener(this);
            } else if (event.getAffected() instanceof SchemaSqlServer) {
                SchemaSqlServer schema = (SchemaSqlServer)event.getAffected();
                this.schemas.remove(schema);
                schema.removeObjectListener(this);
            } else if (event.getAffected() instanceof RoleSqlServer) {
                RoleSqlServer role = (RoleSqlServer)event.getAffected();
                this.roles.remove(role);
                role.removeObjectListener(this);
            } else if (event.getAffected() instanceof RuleSqlServer) {
                RuleSqlServer rule = (RuleSqlServer)event.getAffected();
                this.rules.remove(rule);
                rule.removeObjectListener(this);
            } else if (event.getAffected() instanceof StoredProcedureSqlServer) {
                StoredProcedureSqlServer proc = (StoredProcedureSqlServer)event.getAffected();
                this.procedures.remove(proc);
                proc.removeObjectListener(this);
            } else if (event.getAffected() instanceof UserDefinedTypeSqlServerv2k5) {
                UserDefinedTypeSqlServerv2k5 us = (UserDefinedTypeSqlServerv2k5)event.getAffected();
                this.userDefinedDomains.remove(us);
                us.removeObjectListener(this);
            } else if (event.getAffected() instanceof PartitionFunctionSqlServer) {
                PartitionFunctionSqlServer partFunc = (PartitionFunctionSqlServer)event.getAffected();
                this.partitionFunction.remove(partFunc);
                partFunc.removeObjectListener(this);
            } else if (event.getAffected() instanceof UsedUserDefinedData) {
                UsedUserDefinedDatav2k5 usedUserDefinedData = (UsedUserDefinedDatav2k5)event.getAffected();
                if (usedUserDefinedData.isBaseOnDistinctType()) {
                    this.distinctTypes.remove(usedUserDefinedData);
                    usedUserDefinedData.removeObjectListener(this);
                } else if (usedUserDefinedData.getUserDefinedType() != null) {
                    this.userDefinedDomains.remove(usedUserDefinedData);
                    usedUserDefinedData.removeObjectListener(this);
                }
            } else if (event.getAffected() instanceof XMLSchemaCollectionSqlServerv2k5) {
                XMLSchemaCollectionSqlServerv2k5 xmlType = (XMLSchemaCollectionSqlServerv2k5)event.getAffected();
                this.xmlSchemaCollections.remove(xmlType);
                xmlType.removeObjectListener(this);
            }
        }
    }

    @Override
    public void changed(StorageObject object, ObjectChangeEvent event) {
        if (event.getAffected() instanceof DataFileSqlServer) {
            DataFileSqlServer df = (DataFileSqlServer)event.getAffected();
            if (df.getDataBase() != null && df.getDataBase() == this) {
                df.setParent(this.transactionLogs);
                this.transactionLogs.add(df);
            } else {
                this.transactionLogs.remove(df);
            }
        } else if (event.getAffected() instanceof FileGroupSqlServer) {
            FileGroupSqlServer fg = (FileGroupSqlServer)event.getAffected();
            if (fg.getDataBase() != null && fg.getDataBase() == this) {
                fg.setParent(this.filegroups);
                this.filegroups.add(fg);
            } else {
                this.filegroups.remove(fg);
            }
        } else if (event.getAffected() instanceof DefaultSqlServer) {
            DefaultSqlServer d = (DefaultSqlServer)event.getAffected();
            if (d.getDataBase() != null && d.getDataBase() == this) {
                d.setParent(this.defaults);
                this.defaults.add(d);
            } else {
                this.defaults.remove(d);
            }
        } else if (event.getAffected() instanceof UserSqlServer) {
            UserSqlServer user = (UserSqlServer)event.getAffected();
            if (user.getDatabase() != null && user.getDatabase() == this) {
                user.setParent(this.users);
                this.users.add(user);
            } else {
                this.users.remove(user);
            }
        } else if (event.getAffected() instanceof SchemaSqlServer) {
            SchemaSqlServer schema = (SchemaSqlServer)event.getAffected();
            if (schema.getDatabase() != null && schema.getDatabase() == this) {
                schema.setParent(this.schemas);
                this.schemas.add(schema);
            } else {
                this.schemas.remove(schema);
            }
        } else if (event.getAffected() instanceof RoleSqlServer) {
            RoleSqlServer role = (RoleSqlServer)event.getAffected();
            if (role.getDatabase() != null && role.getDatabase() == this) {
                role.setParent(this.roles);
                this.roles.add(role);
            } else {
                this.roles.remove(role);
            }
        } else if (event.getAffected() instanceof RuleSqlServer) {
            RuleSqlServer rule = (RuleSqlServer)event.getAffected();
            if (rule.getDatabase() != null && rule.getDatabase() == this) {
                rule.setParent(this.rules);
                this.rules.add(rule);
            } else {
                this.rules.remove(rule);
            }
        } else if (event.getAffected() instanceof StoredProcedureSqlServer) {
            StoredProcedureSqlServer proc = (StoredProcedureSqlServer)event.getAffected();
            if (proc.getDatabase() != null && proc.getDatabase() == this) {
                proc.setParent(this.procedures);
                this.procedures.add(proc);
            } else {
                this.procedures.remove(proc);
            }
        } else if (event.getAffected() instanceof TableProxy) {
            TableProxySqlServer tp = (TableProxySqlServer)event.getAffected();
            if (tp.getDatabase() != null && tp.getDatabase() == this) {
                StorageObjectPlaceHolder ph = new StorageObjectPlaceHolder(tp);
                ph.setParent(this.tables);
                ph.setIcon(GUIConfiguration.getInstance().getIcon("TABLE_ICON", 16));
                this.tables.add(ph);
            } else if (tp.getDatabase() == null || tp.getDatabase() != null && tp.getDatabase() != this) {
                this.tables.removePlaceHolderFor(tp);
            }
        } else if (event.getAffected() instanceof TableViewProxy) {
            TableViewProxySqlServer tp = (TableViewProxySqlServer)event.getAffected();
            if (tp.getDataBase() != null && tp.getDataBase() == this) {
                StorageObjectPlaceHolder ph = new StorageObjectPlaceHolder(tp);
                ph.setParent(this.views);
                ph.setIcon(GUIConfiguration.getInstance().getIcon("VIEW_ICON", 16));
                this.views.add(ph);
            } else if (tp.getDataBase() == null || tp.getDataBase() != null && tp.getDataBase() != this) {
                this.views.removePlaceHolderFor(tp);
            }
        } else if (event.getAffected() instanceof UsedUserDefinedDatav2k5) {
            UsedUserDefinedDatav2k5 usedUserDefinedData = (UsedUserDefinedDatav2k5)event.getAffected();
            if (usedUserDefinedData.isBaseOnDistinctType()) {
                if (usedUserDefinedData.getDatabase() == this) {
                    usedUserDefinedData.setParent(this.distinctTypes);
                    this.distinctTypes.add(usedUserDefinedData);
                } else {
                    this.distinctTypes.remove(usedUserDefinedData);
                }
            } else if (usedUserDefinedData.getUserDefinedType() != null) {
                if (usedUserDefinedData.getDatabase() == this) {
                    usedUserDefinedData.setParent(this.userDefinedDomains);
                    this.userDefinedDomains.add(usedUserDefinedData);
                } else {
                    this.userDefinedDomains.remove(usedUserDefinedData);
                }
            }
        } else if (event.getAffected() instanceof PartitionFunctionSqlServer) {
            PartitionFunctionSqlServer partFunc = (PartitionFunctionSqlServer)event.getAffected();
            if (partFunc.getDatabase() != null && partFunc.getDatabase() == this) {
                partFunc.setParent(this.partitionFunction);
                this.partitionFunction.add(partFunc);
            } else {
                this.partitionFunction.remove(partFunc);
            }
        } else if (event.getAffected() instanceof XMLSchemaCollectionSqlServerv2k5) {
            XMLSchemaCollectionSqlServerv2k5 xmlType = (XMLSchemaCollectionSqlServerv2k5)event.getAffected();
            if (xmlType.getDatabase() != null && xmlType.getDatabase() == this) {
                xmlType.setParent(this.xmlSchemaCollections);
                this.xmlSchemaCollections.add(xmlType);
            } else {
                this.xmlSchemaCollections.remove(xmlType);
            }
        }
    }

    @Override
    public void changed(RelationalObjectProxySet set, ModelObjectSetEvent event) {
        if (event.isType(1)) {
            if (event.getAffected() instanceof TableProxy) {
                TableProxySqlServer tp = (TableProxySqlServer)event.getAffected();
                tp.addObjectListener(this);
                if (this == tp.getDatabase()) {
                    StorageObjectPlaceHolder ph = new StorageObjectPlaceHolder(tp);
                    ph.setParent(this.tables);
                    ph.setIcon(GUIConfiguration.getInstance().getIcon("TABLE_ICON", 16));
                    this.tables.add(ph);
                }
            } else if (event.getAffected() instanceof TableViewProxy) {
                TableViewProxySqlServer tp = (TableViewProxySqlServer)event.getAffected();
                tp.addObjectListener(this);
                if (this == tp.getDataBase()) {
                    StorageObjectPlaceHolder ph = new StorageObjectPlaceHolder(tp);
                    ph.setParent(this.views);
                    ph.setIcon(GUIConfiguration.getInstance().getIcon("VIEW_ICON", 16));
                    this.views.add(ph);
                }
            }
        } else if (event.isType(0)) {
            if (event.getAffected() instanceof TableProxy) {
                TableProxySqlServer tp = (TableProxySqlServer)event.getAffected();
                tp.removeObjectListener(this);
                this.tables.removePlaceHolderFor(tp);
            } else if (event.getAffected() instanceof TableViewProxy) {
                TableViewProxySqlServer tp = (TableViewProxySqlServer)event.getAffected();
                tp.removeObjectListener(this);
                this.views.removePlaceHolderFor(tp);
            } else if (event.getAffected() instanceof DistinctTypeProxySqlServerv2k5) {
                DistinctTypeProxySqlServer tp = (DistinctTypeProxySqlServer)event.getAffected();
                tp.removeObjectListener(this);
            }
        }
    }

    @Override
    public void registerToTableProxyFromDesign(RelationalObjectProxySet set) {
        Iterator it = set.iterator();
        while (it.hasNext()) {
            TableProxySqlServer tp = (TableProxySqlServer)it.next();
            tp.addObjectListener(this);
        }
    }

    @Override
    public void registerToViewProxyFromDesign(RelationalObjectProxySet set) {
        Iterator it = set.iterator();
        while (it.hasNext()) {
            TableViewProxySqlServer tp = (TableViewProxySqlServer)it.next();
            tp.addObjectListener(this);
        }
    }

    public static String[] getUserChoices() {
        return USER_STATES;
    }

    @Override
    protected boolean checkUser(String value) {
        if (userSet == null) {
            userSet = new HashSet();
            userSet.addAll(Arrays.asList(DataBaseSqlServerv2k5.getUserChoices()));
        }
        return userSet.contains(value);
    }

    public static String[] getOnOffChoices() {
        return ON_OFF_STATES;
    }

    public static String[] getSimpleForcedSetChoices() {
        return SIMPLE_FORCED_STATES;
    }

    public static String[] getCheckTornNoneSetChoices() {
        return CHECKSUM_TORNPAGEDETECTION_NONE_STATES;
    }

    public static String[] getCheck8090100SetChoices() {
        return LEVEL_80_90_100_STATES;
    }

    @Override
    protected boolean checkOnOff(String value) {
        if (onOffSet == null) {
            onOffSet = new HashSet();
            onOffSet.addAll(Arrays.asList(DataBaseSqlServerv2k5.getOnOffChoices()));
        }
        return onOffSet.contains(value);
    }

    protected boolean checkIfInteger(String value) {
        try {
            Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    protected boolean checkSimpleForced(String value) {
        if (simpleForcedSet == null) {
            simpleForcedSet = new HashSet();
            simpleForcedSet.addAll(Arrays.asList(DataBaseSqlServerv2k5.getSimpleForcedSetChoices()));
        }
        return simpleForcedSet.contains(value);
    }

    protected boolean checkCheckTornNone(String value) {
        if (checkTornNoneSet == null) {
            checkTornNoneSet = new HashSet();
            checkTornNoneSet.addAll(Arrays.asList(DataBaseSqlServerv2k5.getCheckTornNoneSetChoices()));
        }
        return checkTornNoneSet.contains(value);
    }

    protected boolean check8090100(String value) {
        if (check8090100Set == null) {
            check8090100Set = new HashSet();
            check8090100Set.addAll(Arrays.asList(DataBaseSqlServerv2k5.getCheck8090100SetChoices()));
        }
        return check8090100Set.contains(value);
    }

    public static String[] getCursorDefaultChoices() {
        return CURSOR_DEFAULT_STATES;
    }

    @Override
    protected boolean checkCursorDefault(String value) {
        if (cursorDefaultSet == null) {
            cursorDefaultSet = new HashSet();
            cursorDefaultSet.addAll(Arrays.asList(DataBaseSqlServerv2k5.getCursorDefaultChoices()));
        }
        return cursorDefaultSet.contains(value);
    }

    public static String[] getRecoveryChoices() {
        return RECOVERY_STATES;
    }

    @Override
    protected boolean checkRecovery(String value) {
        if (recoverySet == null) {
            recoverySet = new HashSet();
            recoverySet.addAll(Arrays.asList(DataBaseSqlServerv2k5.getRecoveryChoices()));
        }
        return recoverySet.contains(value);
    }

    @Override
    public String getUserState() {
        return this.userState;
    }

    @Override
    public String getAnsiNulls() {
        return this.ansiNulls;
    }

    public String getAnsiNullDefault() {
        return this.ansiNullDefault;
    }

    public String getAutoUpdateStatisticsAsync() {
        return this.autoUpdateStatisticsAsync;
    }

    public String getDateCorrelationOptimization() {
        return this.dateCorrelationOptimization;
    }

    public String getTrustworthy() {
        return this.trustworthy;
    }

    public String getAllowSnapshotIsolation() {
        return this.allowSnapshotIsolation;
    }

    public String getReadCommittedSnapshot() {
        return this.readCommittedSnapshot;
    }

    public String getDbChaining() {
        return this.dbChaining;
    }

    public boolean getEnableBroker() {
        return this.enableBroker;
    }

    public boolean getDisableBroker() {
        return this.disableBroker;
    }

    public boolean getNewBroker() {
        return this.newBroker;
    }

    public boolean getErrorBrokerConversations() {
        return this.errorBrokerConversations;
    }

    public boolean getRollbackImmediate() {
        return this.rollbackImmediate;
    }

    public boolean getNoWait() {
        return this.noWait;
    }

    public String getRollbackAfter() {
        return this.rollbackAfter;
    }

    public boolean getReadWrite() {
        return this.readWrite;
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    public String getParameterization() {
        return this.parameterization;
    }

    public String getPageVerify() {
        return this.pageVerify;
    }

    public String getHonorBrokerPriority() {
        return this.honorBrokerPriority;
    }

    public String getCompatibilityLevel() {
        return this.compatibilityLevel;
    }

    public String getChangeTracking() {
        return this.changeTracking;
    }

    public String getAutoCleanup() {
        return this.autoCleanup;
    }

    public String getEncryption() {
        return this.encryption;
    }

    @Override
    public String getAnsiPadding() {
        return this.ansiPadding;
    }

    @Override
    public String getAnsiWarnings() {
        return this.ansiWarnings;
    }

    @Override
    public String getArithabort() {
        return this.arithabort;
    }

    @Override
    public String getAutoClose() {
        return this.autoClose;
    }

    @Override
    public String getAutoCreateStatistics() {
        return this.autoCreateStatistics;
    }

    @Override
    public String getAutoUpdateStatistics() {
        return this.autoUpdateStatistics;
    }

    @Override
    public String getAutoShrink() {
        return this.autoShrink;
    }

    @Override
    public String getConcatNullYieldsNull() {
        return this.concatNullYieldsNull;
    }

    @Override
    public String getCursorCloseOnCommit() {
        return this.cursorCloseOnCommit;
    }

    @Override
    public String getCursorDefault() {
        return this.cursorDefault;
    }

    @Override
    public String getRecovery() {
        return this.recovery;
    }

    @Override
    public String getRecursiveTriggers() {
        return this.recursiveTriggers;
    }

    @Override
    public String getTornPageDetection() {
        return this.tornPageDetection;
    }

    @Override
    public String getNumericRoundabort() {
        return this.numericRoundabort;
    }

    @Override
    public String getQuotedIdentifier() {
        return this.quotedIdentifier;
    }

    @Override
    public void setAnsiNulls(String ansiNulls) {
        if (this.checkOnOff(ansiNulls)) {
            this.ansiNulls = ansiNulls;
            this.fireDataFieldChange();
        }
    }

    public void setAnsiNullDefault(String ansiNullDefault) {
        if (this.checkOnOff(ansiNullDefault)) {
            this.ansiNullDefault = ansiNullDefault;
            this.fireDataFieldChange();
        }
    }

    public void setAutoUpdateStatisticsAsync(String autoUpdateStatisticsAsync) {
        if (this.checkOnOff(autoUpdateStatisticsAsync)) {
            this.autoUpdateStatisticsAsync = autoUpdateStatisticsAsync;
            this.fireDataFieldChange();
        }
    }

    public void setDateCorrelationOptimization(String dateCorrelationOptimization) {
        if (this.checkOnOff(dateCorrelationOptimization)) {
            this.dateCorrelationOptimization = dateCorrelationOptimization;
            this.fireDataFieldChange();
        }
    }

    public void setTrustworthy(String trustworthy) {
        if (this.checkOnOff(trustworthy)) {
            this.trustworthy = trustworthy;
            this.fireDataFieldChange();
        }
    }

    public void setAllowSnapshotIsolation(String allowSnapshotIsolation) {
        if (this.checkOnOff(allowSnapshotIsolation)) {
            this.allowSnapshotIsolation = allowSnapshotIsolation;
            this.fireDataFieldChange();
        }
    }

    public void setReadCommittedSnapshot(String readCommittedSnapshot) {
        if (this.checkOnOff(readCommittedSnapshot)) {
            this.readCommittedSnapshot = readCommittedSnapshot;
            this.fireDataFieldChange();
        }
    }

    public void setDbChaining(String dbChaining) {
        if (this.checkOnOff(dbChaining)) {
            this.dbChaining = dbChaining;
            this.fireDataFieldChange();
        }
    }

    public void setEnableBroker(boolean enableBroker) {
        this.enableBroker = enableBroker;
        this.fireDataFieldChange();
    }

    public void setDisableBroker(boolean disableBroker) {
        this.disableBroker = disableBroker;
        this.fireDataFieldChange();
    }

    public void setNewBroker(boolean newBroker) {
        this.newBroker = newBroker;
        this.fireDataFieldChange();
    }

    public void setErrorBrokerConversations(boolean errorBrokerConversations) {
        this.errorBrokerConversations = errorBrokerConversations;
        this.fireDataFieldChange();
    }

    public void setRollbackImmediate(boolean rollbackImmediate) {
        this.rollbackImmediate = rollbackImmediate;
        this.fireDataFieldChange();
    }

    public void setNoWait(boolean noWait) {
        this.noWait = noWait;
        this.fireDataFieldChange();
    }

    public void setRollbackAfter(String rollbackAfter) {
        if (this.checkIfInteger(rollbackAfter)) {
            this.rollbackAfter = rollbackAfter;
            this.fireDataFieldChange();
        }
    }

    public void setReadWrite(boolean readWrite) {
        this.readWrite = readWrite;
        this.fireDataFieldChange();
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        this.fireDataFieldChange();
    }

    public void setParameterization(String parameterization) {
        if (this.checkSimpleForced(parameterization)) {
            this.parameterization = parameterization;
            this.fireDataFieldChange();
        }
    }

    public void setPageVerify(String pageVerify) {
        if (this.checkCheckTornNone(pageVerify)) {
            this.pageVerify = pageVerify;
            this.fireDataFieldChange();
        }
    }

    public void setHonorBrokerPriority(String honorBrokerPriority) {
        if (this.checkOnOff(honorBrokerPriority)) {
            this.honorBrokerPriority = honorBrokerPriority;
            this.fireDataFieldChange();
        }
    }

    public void setCompatibilityLevel(String compatibilityLevel) {
        if (this.check8090100(compatibilityLevel)) {
            this.compatibilityLevel = compatibilityLevel;
            this.fireDataFieldChange();
        }
    }

    public void setChangeTracking(String changeTracking) {
        if (this.checkOnOff(changeTracking)) {
            this.changeTracking = changeTracking;
            this.fireDataFieldChange();
        }
    }

    public void setAutoCleanup(String autoCleanup) {
        if (this.checkOnOff(autoCleanup)) {
            this.autoCleanup = autoCleanup;
            this.fireDataFieldChange();
        }
    }

    public void setEncryption(String encryption) {
        if (this.checkOnOff(encryption)) {
            this.encryption = encryption;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void setAnsiPadding(String ansiPadding) {
        if (this.checkOnOff(ansiPadding)) {
            this.ansiPadding = ansiPadding;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void setAnsiWarnings(String ansiWarnings) {
        if (this.checkOnOff(ansiWarnings)) {
            this.ansiWarnings = ansiWarnings;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void setArithabort(String arithabort) {
        if (this.checkOnOff(arithabort)) {
            this.arithabort = arithabort;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void setAutoClose(String autoClose) {
        if (this.checkOnOff(autoClose)) {
            this.autoClose = autoClose;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void setAutoCreateStatistics(String autoCreateStatistics) {
        if (this.checkOnOff(autoCreateStatistics)) {
            this.autoCreateStatistics = autoCreateStatistics;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void setAutoUpdateStatistics(String autoUpdateStatistics) {
        if (this.checkOnOff(autoUpdateStatistics)) {
            this.autoUpdateStatistics = autoUpdateStatistics;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void setAutoShrink(String autoShrink) {
        if (this.checkOnOff(autoShrink)) {
            this.autoShrink = autoShrink;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void setConcatNullYieldsNull(String concatNullYieldsNull) {
        if (this.checkOnOff(concatNullYieldsNull)) {
            this.concatNullYieldsNull = concatNullYieldsNull;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void setCursorCloseOnCommit(String cursorCloseOnCommit) {
        if (this.checkOnOff(cursorCloseOnCommit)) {
            this.cursorCloseOnCommit = cursorCloseOnCommit;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void setCursorDefault(String cursorDefault) {
        if (this.checkCursorDefault(cursorDefault)) {
            this.cursorDefault = cursorDefault;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void setNumericRoundabort(String numericRoundabort) {
        if (this.checkOnOff(numericRoundabort)) {
            this.numericRoundabort = numericRoundabort;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void setQuotedIdentifier(String quotedIdentifier) {
        if (this.checkOnOff(quotedIdentifier)) {
            this.quotedIdentifier = quotedIdentifier;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void setRecovery(String recovery) {
        if (this.checkRecovery(recovery)) {
            this.recovery = recovery;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void setRecursiveTriggers(String recursiveTriggers) {
        if (this.checkOnOff(recursiveTriggers)) {
            this.recursiveTriggers = recursiveTriggers;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void setUserState(String userState) {
        if (this.checkUser(userState)) {
            this.userState = userState;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void setTornPageDetection(String tornPageDetection) {
        if (this.checkOnOff(tornPageDetection)) {
            this.tornPageDetection = tornPageDetection;
            this.fireDataFieldChange();
        }
    }

    @Override
    public String getCollationName() {
        return this.collationName;
    }

    @Override
    public void setCollationName(String collationName) {
        if (collationName != null) {
            this.collationName = collationName;
            this.fireDataFieldChange();
        }
    }

    @Override
    public StorageObjectCollection getDefaults() {
        return this.defaults;
    }

    @Override
    public StorageObjectCollection getFilegroups() {
        return this.filegroups;
    }

    @Override
    public StorageObjectCollection getProcedures() {
        return this.procedures;
    }

    @Override
    public StorageObjectCollection getRoles() {
        return this.roles;
    }

    @Override
    public StorageObjectCollection getRules() {
        return this.rules;
    }

    @Override
    public StorageObjectCollection getTables() {
        return this.tables;
    }

    public List getTablesList() {
        ArrayList list = new ArrayList();
        this.tables.addAllElementsTo(list);
        return list;
    }

    @Override
    public StorageObjectCollection getTransactionLogs() {
        return this.transactionLogs;
    }

    @Override
    public StorageObjectCollection getUsers() {
        return this.users;
    }

    @Override
    public StorageObjectCollection getViews() {
        return this.views;
    }

    @Override
    public StorageObjectCollection getSchemas() {
        return this.schemas;
    }

    public StorageObjectCollection getUsedDistinctTypes() {
        return this.distinctTypes;
    }

    public StorageObjectCollection getUserDefinedDomains() {
        return this.userDefinedDomains;
    }

    public StorageObjectCollection getPartitionFunction() {
        return this.partitionFunction;
    }

    public StorageObjectCollection getXmlSchemaCollection() {
        return this.xmlSchemaCollections;
    }

    @Override
    public FileGroupSqlServer createFilegroup() {
        if (this.filegroups.getStorageObjectSet() != null) {
            return (FileGroupSqlServer)this.filegroups.createElement(null);
        }
        return null;
    }

    @Override
    public DataFileSqlServer createTransactionLog() {
        if (this.transactionLogs.getStorageObjectSet() != null) {
            return (DataFileSqlServer)this.transactionLogs.createElement(null);
        }
        return null;
    }

    public UsedUserDefinedData createUsedDistinctType() {
        if (this.distinctTypes.getStorageObjectSet() != null) {
            return (UsedUserDefinedData)this.distinctTypes.createElement(null);
        }
        return null;
    }

    public UsedUserDefinedData createUserDefinedDomain() {
        if (this.userDefinedDomains.getStorageObjectSet() != null) {
            return (UsedUserDefinedData)this.userDefinedDomains.createElement(null);
        }
        return null;
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        DataBaseSqlServerv2k5 dbSQLServer = null;
        StorageObject stObject = (StorageObject)((StorageDesignSqlServerv2k5)targetDesign).getDataBaseSet().getByName(this.getName());
        if (stObject != null) {
            if (this.isRawObject()) {
                dbSQLServer = (DataBaseSqlServerv2k5)stObject;
            }
        } else {
            dbSQLServer = (DataBaseSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getDataBaseSet().createDataBase();
        }
        if (dbSQLServer != null) {
            dbSQLServer.setName(this.getName());
            dbSQLServer.setUserState(this.getUserState());
            dbSQLServer.setCollationName(this.getCollationName());
            dbSQLServer.setCursorCloseOnCommit(this.getCursorCloseOnCommit());
            dbSQLServer.setCursorDefault(this.getCursorDefault());
            dbSQLServer.setAutoClose(this.getAutoClose());
            dbSQLServer.setAutoCreateStatistics(this.getAutoCreateStatistics());
            dbSQLServer.setAutoUpdateStatistics(this.getAutoUpdateStatistics());
            dbSQLServer.setAutoUpdateStatisticsAsync(this.getAutoUpdateStatisticsAsync());
            dbSQLServer.setDateCorrelationOptimization(this.getDateCorrelationOptimization());
            dbSQLServer.setTrustworthy(this.getTrustworthy());
            dbSQLServer.setAllowSnapshotIsolation(this.getAllowSnapshotIsolation());
            dbSQLServer.setReadCommittedSnapshot(this.getReadCommittedSnapshot());
            dbSQLServer.setDbChaining(this.getDbChaining());
            dbSQLServer.setEnableBroker(this.getEnableBroker());
            dbSQLServer.setDisableBroker(this.getDisableBroker());
            dbSQLServer.setNewBroker(this.getNewBroker());
            dbSQLServer.setErrorBrokerConversations(this.getErrorBrokerConversations());
            dbSQLServer.setRollbackImmediate(this.getRollbackImmediate());
            dbSQLServer.setNoWait(this.getNoWait());
            dbSQLServer.setReadWrite(this.getReadWrite());
            dbSQLServer.setReadOnly(this.getReadOnly());
            dbSQLServer.setParameterization(this.getParameterization());
            dbSQLServer.setAutoShrink(this.getAutoShrink());
            dbSQLServer.setRecovery(this.getRecovery());
            dbSQLServer.setTornPageDetection(this.getTornPageDetection());
            dbSQLServer.setAnsiPadding(this.getAnsiPadding());
            dbSQLServer.setAnsiNulls(this.getAnsiNulls());
            dbSQLServer.setAnsiNullDefault(this.getAnsiNullDefault());
            dbSQLServer.setAnsiWarnings(this.getAnsiWarnings());
            dbSQLServer.setArithabort(this.getArithabort());
            dbSQLServer.setConcatNullYieldsNull(this.getConcatNullYieldsNull());
            dbSQLServer.setNumericRoundabort(this.getNumericRoundabort());
            dbSQLServer.setQuotedIdentifier(this.getQuotedIdentifier());
            dbSQLServer.setRecursiveTriggers(this.getRecursiveTriggers());
            dbSQLServer.setComment(this.getComment());
            dbSQLServer.setRawObject(false);
            Iterator it = this.getFilegroups().iterator();
            while (it.hasNext()) {
                FileGroupSqlServerv2k5 fileGroup = (FileGroupSqlServerv2k5)it.next();
                FileGroupSqlServerv2k5 targetFileGroup = (FileGroupSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getFileGroupSet().getByName(fileGroup.getName());
                if (targetFileGroup == null) {
                    FileGroupSqlServerv2k5 newFileGroup = (FileGroupSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getFileGroupSet().createFileGroup();
                    newFileGroup.setName(fileGroup.getName());
                    newFileGroup.setDataBase(dbSQLServer);
                    newFileGroup.setRawObject(true);
                    dbSQLServer.getFilegroups().add(newFileGroup);
                    continue;
                }
                targetFileGroup.setDataBase(dbSQLServer);
                dbSQLServer.getFilegroups().add(targetFileGroup);
            }
            it = this.getTransactionLogs().iterator();
            while (it.hasNext()) {
                DataFileSqlServerv2k5 dataFile = (DataFileSqlServerv2k5)it.next();
                DataFileSqlServerv2k5 targetDataFile = (DataFileSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getDataFileSet().getByName(dataFile.getName());
                if (targetDataFile == null) {
                    DataFileSqlServerv2k5 newDataFile = (DataFileSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getDataFileSet().createDataFile();
                    newDataFile.setName(dataFile.getName());
                    newDataFile.setDataBase(dbSQLServer);
                    newDataFile.setRawObject(true);
                    dbSQLServer.getTransactionLogs().add(newDataFile);
                    continue;
                }
                targetDataFile.setDataBase(dbSQLServer);
                dbSQLServer.getTransactionLogs().add(targetDataFile);
            }
            it = this.getDefaults().iterator();
            while (it.hasNext()) {
                DefaultSqlServerv2k5 defaultObject = (DefaultSqlServerv2k5)it.next();
                DefaultSqlServerv2k5 targetDefault = (DefaultSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getDefaultSet().getByName(defaultObject.getName());
                if (targetDefault == null) {
                    DefaultSqlServerv2k5 newDefault = (DefaultSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getDefaultSet().createDefault();
                    newDefault.setName(defaultObject.getName());
                    newDefault.setDataBase(dbSQLServer);
                    newDefault.setRawObject(true);
                    dbSQLServer.getDefaults().add(newDefault);
                    continue;
                }
                targetDefault.setDataBase(dbSQLServer);
                dbSQLServer.getDefaults().add(targetDefault);
            }
            it = this.getUsers().iterator();
            while (it.hasNext()) {
                UserSqlServerv2k5 user = (UserSqlServerv2k5)it.next();
                UserSqlServerv2k5 targetUser = (UserSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getUserSet().getByName(user.getName());
                if (targetUser == null) {
                    UserSqlServerv2k5 newUser = (UserSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getUserSet().createUser();
                    newUser.setName(user.getName());
                    newUser.setDatabase(dbSQLServer);
                    newUser.setRawObject(true);
                    continue;
                }
                targetUser.setDatabase(dbSQLServer);
            }
            it = this.getSchemas().iterator();
            while (it.hasNext()) {
                SchemaSqlServerv2k5 schemaObject = (SchemaSqlServerv2k5)it.next();
                SchemaSqlServerv2k5 targetSchema = (SchemaSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getSchemaSet().getByName(schemaObject.getName());
                if (targetSchema == null) {
                    SchemaSqlServerv2k5 newSchema = (SchemaSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getSchemaSet().createSchema();
                    newSchema.setName(schemaObject.getName());
                    newSchema.setDatabase(dbSQLServer);
                    newSchema.setRawObject(true);
                    dbSQLServer.getSchemas().add(newSchema);
                    continue;
                }
                targetSchema.setDatabase(dbSQLServer);
                dbSQLServer.getSchemas().add(targetSchema);
            }
            it = this.getRoles().iterator();
            while (it.hasNext()) {
                RoleSqlServerv2k5 role = (RoleSqlServerv2k5)it.next();
                RoleSqlServerv2k5 targetRole = (RoleSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getRoleSet().getByName(role.getName());
                if (targetRole == null) {
                    RoleSqlServerv2k5 newRole = (RoleSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getRoleSet().createRole();
                    newRole.setName(role.getName());
                    newRole.setDatabase(dbSQLServer);
                    newRole.setRawObject(true);
                    continue;
                }
                targetRole.setDatabase(dbSQLServer);
            }
            it = this.getRules().iterator();
            while (it.hasNext()) {
                RuleSqlServerv2k5 rule = (RuleSqlServerv2k5)it.next();
                RuleSqlServerv2k5 targetRule = (RuleSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getRuleSet().getByName(rule.getName());
                if (targetRule == null) {
                    RuleSqlServerv2k5 newRule = (RuleSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getRuleSet().createRule();
                    newRule.setName(rule.getName());
                    newRule.setDatabase(dbSQLServer);
                    newRule.setRawObject(true);
                    dbSQLServer.getRules().add(newRule);
                    continue;
                }
                targetRule.setDatabase(dbSQLServer);
                dbSQLServer.getRules().add(targetRule);
            }
            it = this.getPartitionFunction().iterator();
            while (it.hasNext()) {
                PartitionFunctionSqlServerv2k5 function = (PartitionFunctionSqlServerv2k5)it.next();
                PartitionFunctionSqlServerv2k5 targetFunction = (PartitionFunctionSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getPartitionFunctionSet().getByName(function.getName());
                if (targetFunction == null) {
                    PartitionFunctionSqlServerv2k5 newFunction = (PartitionFunctionSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getPartitionFunctionSet().createPartitionFunction();
                    newFunction.setName(function.getName());
                    newFunction.setDatabase(dbSQLServer);
                    newFunction.setRawObject(true);
                    dbSQLServer.getPartitionFunction().add(newFunction);
                    continue;
                }
                targetFunction.setDatabase(dbSQLServer);
                dbSQLServer.getPartitionFunction().add(targetFunction);
            }
            it = this.getTables().iterator();
            while (it.hasNext()) {
                StorageObjectPlaceHolder table = (StorageObjectPlaceHolder)it.next();
                TableProxySqlServerv2k5 targetTable = (TableProxySqlServerv2k5)((TableProxySetSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getTableProxySet()).getByName(table.getName());
                if (targetTable == null) {
                    TableProxySqlServerv2k5 newTable = (TableProxySqlServerv2k5)((TableProxySetSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getTableProxySet()).createProxy(table.getGenerator());
                    newTable.setName(table.getName());
                    newTable.setDatabase(dbSQLServer);
                    newTable.setRawObject(true);
                    ((StorageDesignSqlServerv2k5)targetDesign).getTableProxySet().add(newTable);
                    dbSQLServer.registerToTableProxyFromDesign(((StorageDesignSqlServerv2k5)targetDesign).getTableProxySet());
                    continue;
                }
                targetTable.setDatabase(dbSQLServer);
                ((StorageDesignSqlServerv2k5)targetDesign).getTableProxySet().add(targetTable);
                dbSQLServer.registerToTableProxyFromDesign(((StorageDesignSqlServerv2k5)targetDesign).getTableProxySet());
            }
            it = this.getViews().iterator();
            while (it.hasNext()) {
                StorageObjectPlaceHolder view = (StorageObjectPlaceHolder)it.next();
                TableViewProxySqlServerv2k5 targetView = (TableViewProxySqlServerv2k5)((TableViewProxySetSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getTableViewProxySet()).getByName(view.getName());
                if (targetView == null) {
                    TableViewProxySqlServerv2k5 newView = (TableViewProxySqlServerv2k5)((TableViewProxySetSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getTableViewProxySet()).createProxy(view.getGenerator());
                    newView.setName(view.getName());
                    newView.setDataBase(dbSQLServer);
                    newView.setRawObject(true);
                    ((StorageDesignSqlServerv2k5)targetDesign).getTableViewProxySet().add(newView);
                    dbSQLServer.registerToViewProxyFromDesign(((StorageDesignSqlServerv2k5)targetDesign).getTableViewProxySet());
                    continue;
                }
                targetView.setDataBase(dbSQLServer);
                ((StorageDesignSqlServerv2k5)targetDesign).getTableViewProxySet().add(targetView);
                dbSQLServer.registerToViewProxyFromDesign(((StorageDesignSqlServerv2k5)targetDesign).getTableViewProxySet());
            }
            it = this.getProcedures().iterator();
            while (it.hasNext()) {
                StoredProcedureSqlServerv2k5 procedure = (StoredProcedureSqlServerv2k5)it.next();
                StoredProcedureSqlServerv2k5 targetProcedure = (StoredProcedureSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getStoredProcedureSet().getByName(procedure.getName());
                if (targetProcedure == null) {
                    StoredProcedureSqlServerv2k5 newProcedure = (StoredProcedureSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getStoredProcedureSet().createStoredProcedure();
                    newProcedure.setName(procedure.getName());
                    newProcedure.setDatabase(dbSQLServer);
                    newProcedure.setRawObject(true);
                    dbSQLServer.getProcedures().add(newProcedure);
                    continue;
                }
                targetProcedure.setDatabase(dbSQLServer);
                dbSQLServer.getProcedures().add(targetProcedure);
            }
            it = this.getUsedDistinctTypes().iterator();
            while (it.hasNext()) {
                UsedUserDefinedDatav2k5 usedDistType = (UsedUserDefinedDatav2k5)it.next();
                UsedUserDefinedDatav2k5 targetType = (UsedUserDefinedDatav2k5)((StorageDesignSqlServerv2k5)targetDesign).getUsedUserDefinedDataSet().getByName(usedDistType.getName());
                if (targetType == null) {
                    UsedUserDefinedDatav2k5 newType = (UsedUserDefinedDatav2k5)((StorageDesignSqlServerv2k5)targetDesign).getUsedUserDefinedDataSet().createUsedUserDefinedData();
                    newType.setName(usedDistType.getName());
                    newType.setDatabase(dbSQLServer);
                    newType.setRawObject(true);
                    dbSQLServer.getUsedDistinctTypes().add(newType);
                    continue;
                }
                targetType.setDatabase(dbSQLServer);
                dbSQLServer.getUsedDistinctTypes().add(targetType);
            }
            it = this.getUserDefinedDomains().iterator();
            while (it.hasNext()) {
                UsedUserDefinedDatav2k5 userDomain = (UsedUserDefinedDatav2k5)it.next();
                UsedUserDefinedDatav2k5 targetDomain = (UsedUserDefinedDatav2k5)((StorageDesignSqlServerv2k5)targetDesign).getUsedUserDefinedDataSet().getByName(userDomain.getName());
                if (targetDomain == null) {
                    UsedUserDefinedDatav2k5 newDomain = (UsedUserDefinedDatav2k5)((StorageDesignSqlServerv2k5)targetDesign).getUsedUserDefinedDataSet().createUsedUserDefinedData();
                    newDomain.setName(userDomain.getName());
                    newDomain.setDatabase(dbSQLServer);
                    newDomain.setRawObject(true);
                    dbSQLServer.getUserDefinedDomains().add(newDomain);
                    continue;
                }
                targetDomain.setDatabase(dbSQLServer);
                dbSQLServer.getUserDefinedDomains().add(targetDomain);
            }
            it = this.getXmlSchemaCollection().iterator();
            while (it.hasNext()) {
                XMLSchemaCollectionSqlServerv2k5 schemaColl = (XMLSchemaCollectionSqlServerv2k5)it.next();
                XMLSchemaCollectionSqlServerv2k5 targetSchemaColl = (XMLSchemaCollectionSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getXmlSchemaCollectionSet().getByName(schemaColl.getName());
                if (targetSchemaColl == null) {
                    XMLSchemaCollectionSqlServerv2k5 newSchemaColl = (XMLSchemaCollectionSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getXmlSchemaCollectionSet().createType();
                    newSchemaColl.setName(schemaColl.getName());
                    newSchemaColl.setDatabase(dbSQLServer);
                    newSchemaColl.setRawObject(true);
                    dbSQLServer.getXmlSchemaCollection().add(newSchemaColl);
                    continue;
                }
                targetSchemaColl.setDatabase(dbSQLServer);
                dbSQLServer.getXmlSchemaCollection().add(targetSchemaColl);
            }
        }
    }

    @Override
    public void clearMergableStructure(Map reverseMap) {
        if (reverseMap != null) {
            ArrayList list = new ArrayList();
            this.transactionLogs.addAllElementsTo(list);
            this.filegroups.addAllElementsTo(list);
            this.defaults.addAllElementsTo(list);
            this.users.addAllElementsTo(list);
            this.roles.addAllElementsTo(list);
            this.rules.addAllElementsTo(list);
            this.procedures.addAllElementsTo(list);
            this.distinctTypes.addAllElementsTo(list);
            this.userDefinedDomains.addAllElementsTo(list);
            this.partitionFunction.addAllElementsTo(list);
            this.xmlSchemaCollections.addAllElementsTo(list);
            for (StorageObject st : list) {
                if (reverseMap.get(st.getObjectID()) != null) continue;
                st.remove(true);
            }
        }
    }

    @Override
    public void setIsNullInstance(boolean value) {
        super.setIsNullInstance(value);
        this.filegroups.setForbiddenCreateElement(value);
        this.transactionLogs.setForbiddenCreateElement(value);
    }
}

