/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver.v2k5;

import oracle.dbtools.crest.model.Constants;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.IndexProxySetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.IndexProxySqlServerv2k5;

public class IndexProxySetSqlServerv2k5
extends IndexProxySetSqlServer
implements Constants {
    public IndexProxySetSqlServerv2k5(StorageDesign storageDesign) {
        super(storageDesign);
    }

    @Override
    public void add(DesignObject object) {
        String id = object.getObjectID();
        if (this.containsId(id)) {
            if (!this.getProxy(id).isLoaded()) {
                this.getProxy(id).loadDesignObject();
            }
        } else if (object instanceof KeyObject && !((KeyObject)object).isPK() && !((KeyObject)object).isFK() && !((Index)object).getIndexState().equalsIgnoreCase("Unique Constraint")) {
            RelationalObjectProxy proxy = this.createProxy(object);
            try {
                this.add(proxy);
            }
            catch (IllegalStateException e) {
                System.out.println("Error in IndexProxySetSqlServerv2k5.add");
            }
            this.fireUpdate();
        }
    }

    @Override
    protected RelationalObjectProxy createProxy(DesignObject object) {
        return new IndexProxySqlServerv2k5((Index)object, this.getStorageDesign());
    }

    @Override
    protected RelationalObjectProxy createProxy(Design design, String id, String longName) {
        return new IndexProxySqlServerv2k5(design, id, longName, this.getStorageDesign());
    }
}

