/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver.v2k5;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxySet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.FileGroupSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.SchemaSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.SynonymSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.ColumnProxySetSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.ColumnProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.DataBaseSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.FileGroupSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.PartitionSchemeSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.SchemaSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.TriggerSqlServerv2k5;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.v2k5.TablePropertyDialogSqlServerv2k5;
import oracle.dbtools.crest.util.propertymap.PropertyWrapper;

public class TableProxySqlServerv2k5
extends TableProxySqlServer {
    private PartitionSchemeSqlServerv2k5 partitionScheme;
    private ColumnProxy partitioningColumn;
    private List propertyWrapperList = null;

    public TableProxySqlServerv2k5(Table table, StorageDesign storageDesign) {
        super(table, storageDesign);
        this.synonyms = new StorageObjectCollection(((StorageDesignSqlServerv2k5)storageDesign).getSynonymSet());
        this.synonyms.setParent(this);
        this.synonyms.setName(Messages.getString("StorageDesignOracle.Synonyms"));
        this.synonyms.setClassForParent(TableProxySqlServer.class);
        this.synonyms.setSetMethod("setTable");
        this.synonyms.setIcon(GUIConfiguration.getInstance().getIcon("SYNONYM_FOLDER_ICON", 16));
        ((StorageDesignSqlServerv2k5)storageDesign).getSynonymSet().addSetListener(this);
        this.addSynonymsFromDesign(((StorageDesignSqlServerv2k5)storageDesign).getSynonymSet());
    }

    public TableProxySqlServerv2k5(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            TablePropertyDialogSqlServerv2k5 dialog = new TablePropertyDialogSqlServerv2k5(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    private void addSynonymsFromDesign(StorageObjectSet set) {
        Iterator it = set.iterator();
        while (it.hasNext()) {
            SynonymSqlServer syn = (SynonymSqlServer)it.next();
            if (syn.getTable() == this) {
                syn.setParent(this.synonyms);
                this.synonyms.add(syn);
                continue;
            }
            this.synonyms.remove(syn);
        }
    }

    public StorageObjectCollection getSynonyms() {
        return this.synonyms;
    }

    public SynonymSqlServer createSynonym() {
        if (this.synonyms.getStorageObjectSet() != null) {
            return (SynonymSqlServer)this.synonyms.createElement(null);
        }
        return null;
    }

    @Override
    public int getNumberOfChildren() {
        return super.getNumberOfChildren() + 1;
    }

    @Override
    public ModelObject getChild(int index) {
        if (index == this.getNumberOfChildren() - 5) {
            return this.synonyms;
        }
        return super.getChild(index);
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.synonyms) {
            return this.getNumberOfChildren() - 5;
        }
        return super.getIndexForChild(child);
    }

    @Override
    public int getIndexForChild(Object child) {
        if (child == this.synonyms) {
            return this.getNumberOfChildren() - 5;
        }
        return super.getIndexForChild(child);
    }

    @Override
    public void changed(RelationalObjectProxySet set, ModelObjectSetEvent event) {
        super.changed(set, event);
        if (event.isType(1)) {
            if (event.getAffected() instanceof SynonymSqlServer) {
                SynonymSqlServer syn = (SynonymSqlServer)event.getAffected();
                syn.addObjectListener(this);
                if (syn.getTable() == this) {
                    syn.setParent(this.synonyms);
                    this.synonyms.add(syn);
                } else {
                    this.synonyms.remove(syn);
                }
            }
        } else if (event.isType(0)) {
            if (event.getAffected() instanceof SynonymSqlServer) {
                SynonymSqlServer synonymsSqlServer = (SynonymSqlServer)event.getAffected();
                this.synonyms.remove(synonymsSqlServer);
                synonymsSqlServer.removeObjectListener(this);
            }
            if (event.getAffected() instanceof ColumnProxySqlServerv2k5) {
                ColumnProxySqlServerv2k5 col = (ColumnProxySqlServerv2k5)event.getAffected();
                if (this.getPartitioningColumn() == col) {
                    this.setPartitioningColumn(null);
                }
            }
        }
    }

    @Override
    public void changed(StorageObject object, ObjectChangeEvent event) {
        super.changed(object, event);
        if (event.getAffected() instanceof SynonymSqlServer) {
            SynonymSqlServer syn = (SynonymSqlServer)event.getAffected();
            if (syn.getTable() == this) {
                syn.setParent(this.synonyms);
                this.synonyms.add(syn);
            } else {
                this.synonyms.remove(syn);
            }
        }
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
        super.changed(set, event);
        if (event.getAffected() instanceof SynonymSqlServer) {
            SynonymSqlServer syn = (SynonymSqlServer)event.getAffected();
            syn.addObjectListener(this);
            if (syn.getTable() == this) {
                syn.setParent(this.synonyms);
                this.synonyms.add(syn);
            } else {
                this.synonyms.remove(syn);
            }
        } else if (event.isType(0) && event.getAffected() instanceof SynonymSqlServer) {
            SynonymSqlServer syn = (SynonymSqlServer)event.getAffected();
            syn.removeObjectListener(this);
        }
    }

    public ColumnProxy getPartitioningColumn() {
        return this.partitioningColumn;
    }

    public void setPartitioningColumn(ColumnProxy partitionColumn) {
        this.partitioningColumn = partitionColumn;
    }

    public PartitionSchemeSqlServerv2k5 getPartitionScheme() {
        return this.partitionScheme;
    }

    public void setPartitionScheme(PartitionSchemeSqlServerv2k5 partitionScheme) {
        this.partitionScheme = partitionScheme;
    }

    @Override
    public String getLongName() {
        if (this.getSchema() != null) {
            return new StringBuffer(this.getSchema().getLongName()).append('.').append(this.getName()).toString();
        }
        ContainerObject co = (ContainerObject)this.getObject();
        SchemaObject so = co.getSchemaObject();
        if (so != null) {
            StorageObject user = ((StorageDesignSqlServer)this.getStorageDesign()).getSchemaSet().getBySchemaObject(so);
            if (user != null) {
                return new StringBuffer(user.getLongName()).append('.').append(this.getName()).toString();
            }
            if (!this.getStorageDesign().isOpen()) {
                return new StringBuffer(so.getLongName()).append('.').append(this.getName()).toString();
            }
        }
        return super.getLongName();
    }

    @Override
    public List getPropertyWrapperList() {
        if (this.propertyWrapperList == null) {
            this.propertyWrapperList = new ArrayList();
            this.propertyWrapperList.add(new PropertyWrapper("Database", this, "getDatabase", "setDatabase", DataBaseSqlServer.class));
            this.propertyWrapperList.add(new PropertyWrapper("Schema", this, "getSchema", "setSchema", SchemaSqlServer.class));
            this.propertyWrapperList.add(new PropertyWrapper("Filegroup", this, "getFilegroup", "setFilegroup", FileGroupSqlServer.class));
            this.propertyWrapperList.add(new PropertyWrapper("Partition Scheme", this, "getPartitionScheme", "setPartitionScheme", PartitionSchemeSqlServerv2k5.class));
            this.propertyWrapperList.add(new PropertyWrapper("Partition Column", this, "getPartitioningColumn", "setPartitioningColumn", ColumnProxy.class));
            this.propertyWrapperList.add(new PropertyWrapper("TEXTIMAGE group", this, "getTextImageFG", "setTextImageFG", FileGroupSqlServer.class));
        }
        return this.propertyWrapperList;
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        Table table = (Table)targetDesign.getPhysicalDesign().getTableSet().getByName(this.getObject().getName());
        TableProxySqlServerv2k5 tableProxy = null;
        RelationalObjectProxy storageObject = ((StorageDesignSqlServerv2k5)targetDesign).getTableProxySet().getProxy(table.getObjectID());
        if (storageObject != null && !this.isRawObject()) {
            tableProxy = (TableProxySqlServerv2k5)storageObject;
        }
        if (tableProxy != null) {
            tableProxy.setName(this.getName());
            Iterator it = this.synonyms.iterator();
            while (it.hasNext()) {
                SynonymSqlServer synonym = (SynonymSqlServer)it.next();
                SynonymSqlServer targetSynonym = (SynonymSqlServer)((StorageDesignSqlServerv2k5)targetDesign).getSynonymSet().getByName(synonym.getName());
                if (targetSynonym == null) {
                    SynonymSqlServer newSynonym = ((StorageDesignSqlServerv2k5)targetDesign).getSynonymSet().createSynonym();
                    newSynonym.setName(synonym.getName());
                    newSynonym.setRawObject(true);
                    newSynonym.setTable(tableProxy);
                    tableProxy.addSynonymsFromDesign(((StorageDesignSqlServerv2k5)targetDesign).getSynonymSet());
                    continue;
                }
                tableProxy.addSynonymsFromDesign(((StorageDesignSqlServerv2k5)targetDesign).getSynonymSet());
            }
            it = this.getTriggers().iterator();
            while (it.hasNext()) {
                TriggerSqlServerv2k5 trigger = (TriggerSqlServerv2k5)it.next();
                TriggerSqlServerv2k5 targetTrigger = (TriggerSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getTriggerSet().getByName(trigger.getName());
                if (targetTrigger == null) {
                    TriggerSqlServerv2k5 newTrigger = (TriggerSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getTriggerSet().createTrigger();
                    newTrigger.setName(trigger.getName());
                    newTrigger.setRawObject(true);
                    newTrigger.setTable(tableProxy);
                    tableProxy.addTriggersFromDesign(((StorageDesignSqlServerv2k5)targetDesign).getTriggerSet());
                    continue;
                }
                tableProxy.addTriggersFromDesign(((StorageDesignSqlServerv2k5)targetDesign).getTriggerSet());
            }
            if (this.getDatabase() != null) {
                DataBaseSqlServerv2k5 targetDB = (DataBaseSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getDataBaseSet().getByName(this.getDatabase().getName());
                if (targetDB == null) {
                    DataBaseSqlServerv2k5 newDB = (DataBaseSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getDataBaseSet().createDataBase();
                    newDB.setName(this.getDatabase().getName());
                    newDB.setRawObject(true);
                    tableProxy.setDatabase(newDB);
                } else {
                    tableProxy.setDatabase(targetDB);
                }
            }
            if (this.getSchema() != null) {
                SchemaSqlServerv2k5 schema = (SchemaSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getSchemaSet().getByName(this.getSchema().getName());
                if (schema == null) {
                    SchemaSqlServerv2k5 newSchema = (SchemaSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getSchemaSet().createSchema();
                    newSchema.setName(this.getSchema().getName());
                    newSchema.setRawObject(true);
                    tableProxy.setSchema(newSchema);
                } else {
                    tableProxy.setSchema(schema);
                }
            }
            if (this.getFilegroup() != null) {
                FileGroupSqlServerv2k5 fileGroup = (FileGroupSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getFileGroupSet().getByName(this.getFilegroup().getName());
                if (fileGroup == null) {
                    FileGroupSqlServerv2k5 newFileGroup = (FileGroupSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getFileGroupSet().createFileGroup();
                    newFileGroup.setName(this.getFilegroup().getName());
                    newFileGroup.setRawObject(true);
                    tableProxy.setFilegroup(newFileGroup);
                } else {
                    tableProxy.setFilegroup(fileGroup);
                }
            }
            if (this.getPartitionScheme() != null) {
                PartitionSchemeSqlServerv2k5 partScheme = (PartitionSchemeSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getPartitionSchemeSet().getByName(this.getPartitionScheme().getName());
                if (partScheme == null) {
                    PartitionSchemeSqlServerv2k5 newScheme = (PartitionSchemeSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getPartitionSchemeSet().createPartitionScheme();
                    newScheme.setName(this.getPartitionScheme().getName());
                    newScheme.setRawObject(true);
                    tableProxy.setPartitionScheme(newScheme);
                } else {
                    tableProxy.setPartitionScheme(partScheme);
                }
            }
            if (this.getPartitioningColumn() != null) {
                ColumnProxySqlServerv2k5 column = (ColumnProxySqlServerv2k5)((ColumnProxySetSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getColumnProxySet()).getByName(this.getPartitioningColumn().getName());
                if (column == null) {
                    ColumnProxySqlServerv2k5 newColumn = (ColumnProxySqlServerv2k5)((ColumnProxySetSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getColumnProxySet()).createProxy(this.getPartitioningColumn().getObject());
                    newColumn.setName(this.getPartitioningColumn().getName());
                    newColumn.setRawObject(true);
                    tableProxy.setPartitioningColumn(newColumn);
                } else {
                    tableProxy.setPartitioningColumn(column);
                }
            }
            if (this.getTextImageFG() != null) {
                FileGroupSqlServerv2k5 filegroup = (FileGroupSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getFileGroupSet().getByName(this.getTextImageFG().getName());
                if (filegroup == null) {
                    FileGroupSqlServerv2k5 newFilegroup = (FileGroupSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getFileGroupSet().createFileGroup();
                    newFilegroup.setName(this.getTextImageFG().getName());
                    newFilegroup.setRawObject(true);
                    tableProxy.setTextImageFG(newFilegroup);
                } else {
                    tableProxy.setTextImageFG(filegroup);
                }
            }
            for (TableLevelConstraint constraint : ((Table)this.getObject()).getCheckConstraints()) {
                Table targetTable = (Table)tableProxy.getObject();
                TableLevelConstraint targetConstraint = targetTable.createCheckConstraint(constraint.getName(), constraint.getRule());
                targetConstraint.setGenerateInDDL(constraint.getGenerateInDDL());
                targetTable.getCheckConstraints().add(targetConstraint);
            }
            tableProxy.recreateExtPropertiesSet(this.getExtPropsSet().toString());
            tableProxy.setComment(this.getComment());
            tableProxy.setCommentInRDBMS(this.getCommentInRDBMS());
            tableProxy.setRawObject(false);
        }
    }

    @Override
    public StorageObject getUserSchema() {
        return this.getSchema();
    }
}

