/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver.v2k5;

import java.util.Iterator;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxySet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.SynonymSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableViewProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.DataBaseSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.IndexOnViewSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.SchemaSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.TriggerSqlServerv2k5;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.v2k5.ViewPropertyDialogSqlServerv2k5;

public class TableViewProxySqlServerv2k5
extends TableViewProxySqlServer {
    public TableViewProxySqlServerv2k5(TableView view, StorageDesign storage) {
        super(view, storage);
        this.synonyms = new StorageObjectCollection(((StorageDesignSqlServerv2k5)storage).getSynonymSet());
        this.synonyms.setParent(this);
        this.synonyms.setName(Messages.getString("StorageDesignOracle.Synonyms"));
        this.synonyms.setClassForParent(TableViewProxySqlServer.class);
        this.synonyms.setSetMethod("setView");
        this.synonyms.setIcon(GUIConfiguration.getInstance().getIcon("SYNONYM_FOLDER_ICON", 16));
        ((StorageDesignSqlServerv2k5)storage).getSynonymSet().addSetListener(this);
        this.addSynonymsFromDesign(((StorageDesignSqlServerv2k5)storage).getSynonymSet());
    }

    public TableViewProxySqlServerv2k5(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            ViewPropertyDialogSqlServerv2k5 dialog = new ViewPropertyDialogSqlServerv2k5(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    private void addSynonymsFromDesign(StorageObjectSet set) {
        Iterator it = set.iterator();
        while (it.hasNext()) {
            SynonymSqlServer syn = (SynonymSqlServer)it.next();
            if (syn.getView() == this) {
                syn.setParent(this.synonyms);
                this.synonyms.add(syn);
                continue;
            }
            this.synonyms.remove(syn);
        }
    }

    public StorageObjectCollection getSynonyms() {
        return this.synonyms;
    }

    public SynonymSqlServer createSynonym() {
        if (this.synonyms.getStorageObjectSet() != null) {
            return (SynonymSqlServer)this.synonyms.createElement(null);
        }
        return null;
    }

    @Override
    public int getNumberOfChildren() {
        return super.getNumberOfChildren() + 1;
    }

    @Override
    public ModelObject getChild(int index) {
        if (index == this.getNumberOfChildren() - 1) {
            return this.synonyms;
        }
        return super.getChild(index);
    }

    @Override
    public Object getChildPlain(int index) {
        return this.getChild(index);
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.synonyms) {
            return this.getNumberOfChildren() - 1;
        }
        return super.getIndexForChild(child);
    }

    @Override
    public int getIndexForChild(Object child) {
        if (child == this.synonyms) {
            return this.getNumberOfChildren() - 1;
        }
        return super.getIndexForChild(child);
    }

    @Override
    public void clearChildren() {
        super.clearChildren();
        this.synonyms.removeAll();
    }

    public void changed(RelationalObjectProxySet set, ModelObjectSetEvent event) {
        if (event.isType(1)) {
            if (event.getAffected() instanceof SynonymSqlServer) {
                SynonymSqlServer syn = (SynonymSqlServer)event.getAffected();
                syn.addObjectListener(this);
                if (syn.getView() == this) {
                    syn.setParent(this.synonyms);
                    this.synonyms.add(syn);
                } else {
                    this.synonyms.remove(syn);
                }
            }
        } else if (event.isType(0) && event.getAffected() instanceof SynonymSqlServer) {
            SynonymSqlServer synonymsSqlServer = (SynonymSqlServer)event.getAffected();
            this.synonyms.remove(synonymsSqlServer);
            synonymsSqlServer.removeObjectListener(this);
        }
    }

    @Override
    public void changed(StorageObject object, ObjectChangeEvent event) {
        super.changed(object, event);
        if (event.getAffected() instanceof SynonymSqlServer) {
            SynonymSqlServer syn = (SynonymSqlServer)event.getAffected();
            if (syn.getView() == this) {
                syn.setParent(this.synonyms);
                this.synonyms.add(syn);
            } else {
                this.synonyms.remove(syn);
            }
        }
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
        super.changed(set, event);
        if (event.getAffected() instanceof SynonymSqlServer) {
            SynonymSqlServer syn = (SynonymSqlServer)event.getAffected();
            syn.addObjectListener(this);
            if (syn.getView() == this) {
                syn.setParent(this.synonyms);
                this.synonyms.add(syn);
            } else {
                this.synonyms.remove(syn);
            }
        } else if (event.isType(0) && event.getAffected() instanceof SynonymSqlServer) {
            SynonymSqlServer syn = (SynonymSqlServer)event.getAffected();
            syn.removeObjectListener(this);
        }
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        TableView view = (TableView)targetDesign.getPhysicalDesign().getTableViewSet().getByName(this.getObject().getName());
        TableViewProxySqlServerv2k5 viewProxy = null;
        RelationalObjectProxy storageObject = ((StorageDesignSqlServerv2k5)targetDesign).getTableViewProxySet().getProxy(view.getObjectID());
        if (storageObject != null && !this.isRawObject()) {
            viewProxy = (TableViewProxySqlServerv2k5)storageObject;
        }
        if (viewProxy != null) {
            viewProxy.setName(this.getName());
            Iterator it = this.getIndexesOnView().iterator();
            while (it.hasNext()) {
                IndexOnViewSqlServerv2k5 viewIndex = (IndexOnViewSqlServerv2k5)it.next();
                IndexOnViewSqlServerv2k5 targetViewIndex = (IndexOnViewSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getIndexOnViewSet().getByName(viewIndex.getName());
                if (targetViewIndex == null) {
                    IndexOnViewSqlServerv2k5 newViewIndex = (IndexOnViewSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getIndexOnViewSet().createIndexOnView();
                    newViewIndex.setName(viewIndex.getName());
                    newViewIndex.setRawObject(true);
                    newViewIndex.setView(viewProxy);
                    viewProxy.addIndexesFromDesign(((StorageDesignSqlServerv2k5)targetDesign).getIndexOnViewSet());
                    continue;
                }
                targetViewIndex.setView(viewProxy);
                viewProxy.addIndexesFromDesign(((StorageDesignSqlServerv2k5)targetDesign).getIndexOnViewSet());
            }
            it = this.getTriggers().iterator();
            while (it.hasNext()) {
                TriggerSqlServerv2k5 trigger = (TriggerSqlServerv2k5)it.next();
                TriggerSqlServerv2k5 targetTrigger = (TriggerSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getTriggerSet().getByName(trigger.getName());
                if (targetTrigger == null) {
                    TriggerSqlServerv2k5 newTrigger = (TriggerSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getTriggerSet().createTrigger();
                    newTrigger.setName(trigger.getName());
                    newTrigger.setRawObject(true);
                    newTrigger.setView(viewProxy);
                    viewProxy.addTriggersFromDesign(((StorageDesignSqlServerv2k5)targetDesign).getTriggerSet());
                    continue;
                }
                targetTrigger.setView(viewProxy);
                viewProxy.addTriggersFromDesign(((StorageDesignSqlServerv2k5)targetDesign).getTriggerSet());
            }
            it = this.synonyms.iterator();
            while (it.hasNext()) {
                SynonymSqlServer synonym = (SynonymSqlServer)it.next();
                SynonymSqlServer targetSynonym = (SynonymSqlServer)((StorageDesignSqlServerv2k5)targetDesign).getSynonymSet().getByName(synonym.getName());
                if (targetSynonym == null) {
                    SynonymSqlServer newSynonym = ((StorageDesignSqlServerv2k5)targetDesign).getSynonymSet().createSynonym();
                    newSynonym.setName(synonym.getName());
                    newSynonym.setRawObject(true);
                    newSynonym.setView(viewProxy);
                    viewProxy.addSynonymsFromDesign(((StorageDesignSqlServerv2k5)targetDesign).getSynonymSet());
                    continue;
                }
                targetSynonym.setView(viewProxy);
                viewProxy.addSynonymsFromDesign(((StorageDesignSqlServerv2k5)targetDesign).getSynonymSet());
            }
            if (this.getDataBase() != null) {
                DataBaseSqlServerv2k5 database = (DataBaseSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getDataBaseSet().getByName(this.getDataBase().getName());
                if (database == null) {
                    DataBaseSqlServerv2k5 newDatabase = (DataBaseSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getDataBaseSet().createDataBase();
                    newDatabase.setName(this.getDataBase().getName());
                    newDatabase.setRawObject(true);
                    viewProxy.setDataBase(newDatabase);
                } else {
                    viewProxy.setDataBase(database);
                }
            }
            if (this.getSchema() != null) {
                SchemaSqlServerv2k5 user = (SchemaSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getSchemaSet().getByName(this.getSchema().getName());
                if (user == null) {
                    SchemaSqlServerv2k5 newUser = (SchemaSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getSchemaSet().createSchema();
                    newUser.setName(this.getSchema().getName());
                    newUser.setRawObject(true);
                    viewProxy.setSchema(newUser);
                } else {
                    viewProxy.setSchema(user);
                }
            }
            viewProxy.setCheckOption(this.getCheckOption());
            viewProxy.setEncryption(this.getEncryption());
            viewProxy.setSchemaBinding(this.getSchemaBinding());
            viewProxy.setViewMetaData(this.getViewMetaData());
            viewProxy.setDefinition(this.getDefinition());
            viewProxy.recreateExtPropertiesSet(this.getExtPropsSet().toString());
            viewProxy.setComment(this.getComment());
            viewProxy.setCommentInRDBMS(this.getCommentInRDBMS());
            viewProxy.setRawObject(false);
        }
    }

    @Override
    public String getLongName() {
        if (this.getSchema() != null) {
            return new StringBuffer(this.getSchema().getLongName()).append('.').append(this.getName()).toString();
        }
        ContainerObject co = (ContainerObject)this.getObject();
        SchemaObject so = co.getSchemaObject();
        if (so != null) {
            StorageObject user = ((StorageDesignSqlServer)this.getStorageDesign()).getSchemaSet().getBySchemaObject(so);
            if (user != null) {
                return new StringBuffer(user.getLongName()).append('.').append(this.getName()).toString();
            }
            if (!this.getStorageDesign().isOpen()) {
                return new StringBuffer(so.getLongName()).append('.').append(this.getName()).toString();
            }
        }
        return super.getLongName();
    }
}

