/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.udb;

import java.util.Iterator;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.storage.ColumnProxySet;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.udb.ColumnProxyUDB;

public class ColumnProxySetUDB
extends ColumnProxySet {
    public ColumnProxySetUDB(StorageDesign storageDesign) {
        super(storageDesign);
    }

    @Override
    public ColumnProxyUDB getByName(String name) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            ColumnProxyUDB column = (ColumnProxyUDB)it.next();
            if (!name.equals(column.getName())) continue;
            return column;
        }
        return null;
    }

    @Override
    public void doAfterAdd(RelationalObjectProxy addedProxy) {
        ColumnProxyUDB proxy = (ColumnProxyUDB)addedProxy;
        Column column = (Column)proxy.getObject();
        String defaultConstant = proxy.getDefaultValueConstant();
        if (defaultConstant == null || "".equalsIgnoreCase(defaultConstant)) {
            String colDefaultValue = column.getDefaultValue();
            boolean colUsesDefault = colDefaultValue != null && !"".equalsIgnoreCase(colDefaultValue);
            proxy.setDefault(colUsesDefault);
            if (colUsesDefault) {
                proxy.setDefaultValue(ColumnProxyUDB.getDefaultValueChoices()[1]);
                proxy.setDefaultValueConstant(colDefaultValue);
            }
        }
    }
}

