/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.udb;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.datatype.MDDataTypeNames;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.udb.DistinctTypeSetUDB;
import oracle.dbtools.crest.model.design.storage.udb.DistinctTypeUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageObjectConstantsUDB;
import oracle.dbtools.crest.swingui.editor.storage.udb.ColumnPropertyDialogUDB;

public class ColumnProxyUDB
extends ColumnProxy
implements MDDataTypeNames {
    private static final String[] GENERATE = new String[]{"ALWAYS", "BY DEFAULT"};
    private String generate = GENERATE[0];
    private String startWith = "1";
    private int incrementBy = 1;
    private String cache = "NO";
    private boolean useIdentity = false;
    private boolean useIdentityChanged = false;
    public static final String[] DL_COLUMN_TYPES = new String[]{"DATALINK"};
    public static final String[] LOB_COLUMN_TYPES = new String[]{"BLOB", "CLOB", "DBCLOB"};
    private static final String[] LINK_CONTROL = new String[]{"NO", "FILE"};
    protected static final String[] READ_PERMISSION = new String[]{"FS", "DB"};
    protected static final String[] WRITE_PERMISSION = new String[]{"FS", "BLOCKED"};
    private static final String[] ON_UNLINK = new String[]{"RESTORE", "DELETE"};
    private static List linkControlList = Arrays.asList(LINK_CONTROL);
    private static Set linkControlSet = null;
    protected static List readPermissionList = Arrays.asList(READ_PERMISSION);
    protected static Set readPermissionSet = null;
    protected static List writePermissionList = Arrays.asList(WRITE_PERMISSION);
    protected static Set writePermissionSet = null;
    private static List recoveryList = Arrays.asList(StorageObjectConstantsUDB.YES_NO);
    private static Set recoverySet = null;
    private static List onUnlinkList = Arrays.asList(ON_UNLINK);
    private static Set onUnlinkSet = null;
    private static Set dlColumnTypesSet = null;
    private String linkControl = LINK_CONTROL[0];
    private String readPermission = READ_PERMISSION[0];
    private String writePermission = WRITE_PERMISSION[0];
    private String recovery = "NO";
    private String onUnlink = ON_UNLINK[0];
    private static List loggingList = Arrays.asList(StorageObjectConstantsUDB.LOGGING);
    private static Set loggingSet = null;
    private static List compactList = Arrays.asList(StorageObjectConstantsUDB.YES_NO);
    private static Set compactSet = null;
    private static Set lobColumnTypesSet = null;
    private String logging = "NOT LOGGED";
    private String compact = "NO";
    private boolean containDefault = false;
    private static String[] defaultValueChoices = new String[]{"", "constant", "USER", "CURRENT SQLID", "CAST FUNCTION"};
    private String defaultValue = defaultValueChoices[0];
    private String defaultConstant = "";
    private String generationExpression = "";
    private boolean generationExpressionChanged = false;
    private boolean forBitData = false;

    public ColumnProxyUDB(Column column, StorageDesign storageDesign) {
        super(column, storageDesign);
    }

    public ColumnProxyUDB(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
    }

    public boolean getNullsAllowed() {
        return this.getColumn().getNullsAllowed();
    }

    public String getWithDefault() {
        return this.getColumn().getDefaultValue();
    }

    public boolean isPKElement() {
        return this.getColumn().isPKElement();
    }

    public boolean checkDLColumnTypes(Datatype dataType) {
        if (dataType instanceof MDDataType) {
            if (dlColumnTypesSet == null) {
                dlColumnTypesSet = new HashSet();
                dlColumnTypesSet.addAll(Arrays.asList(DL_COLUMN_TYPES));
            }
            return dlColumnTypesSet.contains(dataType.getName());
        }
        return false;
    }

    public static String[] getLinkControlChoices() {
        return LINK_CONTROL;
    }

    protected boolean checkLinkControl(String value) {
        if (linkControlSet == null) {
            linkControlSet = new HashSet();
            linkControlSet.addAll(Arrays.asList(ColumnProxyUDB.getLinkControlChoices()));
        }
        return linkControlSet.contains(value);
    }

    public void setLinkControl(String value) {
        if (this.checkLinkControl(value)) {
            this.linkControl = value;
            this.fireDataFieldChange();
        }
    }

    public String getLinkControl() {
        return this.linkControl;
    }

    public static List getListControlValues() {
        return linkControlList;
    }

    public static String[] getReadPermissionChoices() {
        return READ_PERMISSION;
    }

    protected boolean checkReadPermission(String value) {
        if (readPermissionSet == null) {
            readPermissionSet = new HashSet();
            readPermissionSet.addAll(Arrays.asList(ColumnProxyUDB.getReadPermissionChoices()));
        }
        return readPermissionSet.contains(value);
    }

    public void setReadPermission(String value) {
        if (this.checkReadPermission(value)) {
            this.readPermission = value;
            this.fireDataFieldChange();
        }
    }

    public String getReadPermission() {
        return this.readPermission;
    }

    public static List getReadPermissionValues() {
        return readPermissionList;
    }

    public static String[] getWritePermissionChoices() {
        return WRITE_PERMISSION;
    }

    protected boolean checkWritePermission(String value) {
        if (writePermissionSet == null) {
            writePermissionSet = new HashSet();
            writePermissionSet.addAll(Arrays.asList(ColumnProxyUDB.getWritePermissionChoices()));
        }
        return writePermissionSet.contains(value);
    }

    public void setWritePermission(String value) {
        if (this.checkWritePermission(value)) {
            this.writePermission = value;
            this.fireDataFieldChange();
        }
    }

    public String getWritePermission() {
        return this.writePermission;
    }

    public static List getWritePermissionValues() {
        return writePermissionList;
    }

    public static String[] getRecoveryChoices() {
        return StorageObjectConstantsUDB.YES_NO;
    }

    protected boolean checkRecovery(String value) {
        if (recoverySet == null) {
            recoverySet = new HashSet();
            recoverySet.addAll(Arrays.asList(ColumnProxyUDB.getRecoveryChoices()));
        }
        return recoverySet.contains(value);
    }

    public void setRecovery(String value) {
        if (this.checkRecovery(value)) {
            this.recovery = value;
            this.fireDataFieldChange();
        }
    }

    public String getRecovery() {
        return this.recovery;
    }

    public static List getRecoveryValues() {
        return recoveryList;
    }

    public static String[] getOnUnlinkChoices() {
        return ON_UNLINK;
    }

    protected boolean checkOnUnlink(String value) {
        if (onUnlinkSet == null) {
            onUnlinkSet = new HashSet();
            onUnlinkSet.addAll(Arrays.asList(ColumnProxyUDB.getOnUnlinkChoices()));
        }
        return onUnlinkSet.contains(value);
    }

    public void setOnUnlink(String value) {
        if (this.checkOnUnlink(value)) {
            this.onUnlink = value;
            this.fireDataFieldChange();
        }
    }

    public String getOnUnlink() {
        return this.onUnlink;
    }

    public static List getOnUnlinkValues() {
        return onUnlinkList;
    }

    public boolean checkLobColumnTypes(Datatype dataType) {
        if (dataType instanceof MDDataType) {
            if (lobColumnTypesSet == null) {
                lobColumnTypesSet = new HashSet();
                lobColumnTypesSet.addAll(Arrays.asList(LOB_COLUMN_TYPES));
            }
            return lobColumnTypesSet.contains(dataType.getName());
        }
        return false;
    }

    public static String[] getloggingChoices() {
        return StorageObjectConstantsUDB.LOGGING;
    }

    protected boolean checkLogging(String value) {
        if (loggingSet == null) {
            loggingSet = new HashSet();
            loggingSet.addAll(Arrays.asList(ColumnProxyUDB.getloggingChoices()));
        }
        return loggingSet.contains(value);
    }

    public void setLogging(String value) {
        if (this.checkLogging(value)) {
            this.logging = value;
            this.fireDataFieldChange();
        }
    }

    public String getLogging() {
        return this.logging;
    }

    public static List getLoggingValues() {
        return loggingList;
    }

    public static String[] getCompactChoices() {
        return StorageObjectConstantsUDB.YES_NO;
    }

    protected boolean checkCompact(String value) {
        if (compactSet == null) {
            compactSet = new HashSet();
            compactSet.addAll(Arrays.asList(ColumnProxyUDB.getCompactChoices()));
        }
        return compactSet.contains(value);
    }

    public void setCompact(String value) {
        if (this.checkCompact(value)) {
            this.compact = value;
            this.fireDataFieldChange();
        }
    }

    public String getCompact() {
        return this.compact;
    }

    public static List getCompactValues() {
        return compactList;
    }

    public String getGenerate() {
        if (!this.isGenerateAlwaysChanged()) {
            boolean generateAlways = this.getColumn().isAutoIncrementGenerateAlways();
            return generateAlways ? GENERATE[0] : GENERATE[1];
        }
        return this.generate;
    }

    public void setGenerate(String generate) {
        this.generate = generate;
    }

    public String getStartWith() {
        if (!this.isStartWithChanged()) {
            return this.getColumn().getAutoIncrementStartWith();
        }
        return this.startWith;
    }

    public void setStartWith(String startWith) {
        this.startWith = startWith;
    }

    public int getIncrementBy() {
        if (!this.isIncrementByChanged()) {
            return this.getColumn().getAutoIncrementIncrementBy();
        }
        return this.incrementBy;
    }

    public void setIncrementBy(int incrementBy) {
        this.incrementBy = incrementBy;
    }

    public String getCache() {
        if (!this.isCacheChanged()) {
            Column relColumn = this.getColumn();
            if (relColumn.isAutoIncrementDisableCache()) {
                return "NO";
            }
            Integer columnInteger = relColumn.getAutoIncrementCache();
            if (columnInteger == null || columnInteger <= 1) {
                return "NO";
            }
            return columnInteger.toString();
        }
        return this.cache;
    }

    public void setCache(String cache) {
        try {
            this.cache = "NO".equalsIgnoreCase(cache) || Integer.parseInt(cache) <= 1 ? "NO" : cache;
            this.fireDataFieldChange();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public static String[] getGenerateValues() {
        return GENERATE;
    }

    public boolean getUseIdentity() {
        if (this.useIdentityChanged) {
            return this.useIdentity;
        }
        return this.getColumn().isComputed() != false && this.isNumericDataType() || this.getColumn().isIdentityColumn();
    }

    public void setUseIdentity(boolean useIdentity) {
        this.useIdentity = useIdentity;
        if (useIdentity && !this.getColumn().isComputed().booleanValue()) {
            this.useIdentityChanged = true;
        }
    }

    public boolean isUseIdentityChanged() {
        return this.useIdentityChanged;
    }

    public void setUseIdentityChanged(boolean useIdentityChanged) {
        this.useIdentityChanged = useIdentityChanged;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            ColumnPropertyDialogUDB dialog = new ColumnPropertyDialogUDB(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    public void setDefault(boolean value) {
        this.containDefault = value;
        this.fireDataFieldChange();
    }

    public boolean getDefault() {
        return this.containDefault;
    }

    public static String[] getDefaultValueChoices() {
        return defaultValueChoices;
    }

    public void setDefaultValue(String value) {
        this.defaultValue = value;
        this.fireDataFieldChange();
    }

    public void setDefaultValueConstant(String value) {
        this.defaultConstant = value;
        this.fireDataFieldChange();
    }

    public String getDefaultValueConstant() {
        if (this.defaultConstant == null && this.isLoaded()) {
            return this.getColumn().getDefaultValue();
        }
        return this.defaultConstant;
    }

    public String getDefaultValueConstantString() {
        return this.defaultConstant;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getGenerationExpression() {
        if (this.generationExpressionChanged) {
            return this.generationExpression;
        }
        return this.getColumn().getFormulaDesc();
    }

    public void setGenerationExpression(String generationExpression) {
        this.generationExpression = generationExpression;
        if (generationExpression.length() > 0 && this.getColumn().getFormulaDesc().length() == 0) {
            this.generationExpressionChanged = true;
        }
    }

    public boolean isGenerationExpressionChanged() {
        return this.generationExpressionChanged;
    }

    public void setGenerationExpressionChanged(boolean generationExpressionChanged) {
        this.generationExpressionChanged = generationExpressionChanged;
    }

    public String getDataTypeName() {
        if (this.getColumn().getUse() == 0) {
            Domain dom = this.getColumn().getDomain();
            DistinctTypeSetUDB types = ((StorageDesignUDB)this.getStorageDesign()).getDistinctTypeSet();
            DistinctTypeUDB type = types.getDistinctType(dom);
            if (type != null) {
                return type.getName();
            }
        }
        return this.getColumn().getDatatypeString(this.getRDBMSType().toString()).toString();
    }

    public boolean isNumericDataType() {
        String datatype = this.getDataType().toString().toUpperCase();
        return datatype.indexOf("INT") > -1 || datatype.indexOf("DEC") > -1 || datatype.indexOf("NUM") > -1 || datatype.indexOf("FLOAT") > -1 || datatype.indexOf("REAL") > -1 || datatype.indexOf("DOUBLE") > -1;
    }

    public TableProxy getTableProxy() {
        Column column = this.getColumn();
        Table table = (Table)column.getContainer();
        return (TableProxy)this.getStorageDesign().getTableProxySet().getProxy(table.getObjectID());
    }

    public boolean isForBitData() {
        return this.forBitData;
    }

    public void setForBitData(boolean forBitData) {
        this.forBitData = forBitData;
    }
}

