/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.udb;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.udb.TableProxyUDB;
import oracle.dbtools.crest.swingui.editor.storage.udb.FKPropertyDialogUDB;

public class FKProxyUDB
extends IndexProxy
implements StorageObjectListener {
    private static final String[] ON_DELETE = new String[]{"NO ACTION", "RESTRICT", "CASCADE", "SET NULL"};
    private static final String[] ON_UPDATE = new String[]{"NO ACTION", "RESTRICT"};
    private static List onDeleteList = Arrays.asList(ON_DELETE);
    private static List onUpdateList = Arrays.asList(ON_UPDATE);
    private static Set onDeleteSet = null;
    private static Set onUpdateSet = null;
    private String onDelete = ON_DELETE[0];
    private String onUpdate = ON_UPDATE[0];
    public static final String TYPE_NAME = "FKey";

    public FKProxyUDB(Index index, StorageDesign storageDesign) {
        super(index, storageDesign);
    }

    public FKProxyUDB(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getOldObjectTypeName() {
        return "ForeignKey";
    }

    @Override
    public void changed(StorageObject object, ObjectChangeEvent event) {
        this.fireChange(event);
    }

    public Table getFKTable() {
        return this.getIndex().getFKAssociation().getRemoteTable();
    }

    public String getColumns() {
        return this.getColumns(null);
    }

    public String getColumns(StorageDesign storageDesign) {
        ColumnProxy[] columns = this.getColumnProxies();
        StringBuffer result = new StringBuffer();
        boolean b = false;
        for (int i = 0; i < columns.length; ++i) {
            if (b) {
                result.append(",\n");
            } else {
                b = true;
            }
            String name = columns[i].getName();
            if (storageDesign != null) {
                name = storageDesign.getFormatedName(name);
            }
            result.append("     ").append(name);
        }
        return result.toString();
    }

    public String getReferenceTable() {
        TableProxyUDB tableProxy = (TableProxyUDB)this.getStorageDesign().getTableProxySet().getProxy(this.getFKTable().getObjectID());
        return tableProxy.getLongName();
    }

    public String getReferenceColumns() {
        return this.getReferenceColumns(null);
    }

    public String getReferenceColumns(StorageDesign storageDesign) {
        Index remoteIndex = this.getIndex().getFKAssociation().getRemoteIndex();
        Column[] columns = (Column[])remoteIndex.getElements();
        StringBuffer result = new StringBuffer();
        boolean b = false;
        for (int i = 0; i < columns.length; ++i) {
            if (b) {
                result.append(",\n");
            } else {
                b = true;
            }
            String name = columns[i].getName();
            if (storageDesign != null) {
                name = storageDesign.getFormatedName(name);
            }
            result.append("     ").append(name);
        }
        return result.toString();
    }

    public Column[] getRefColumns() {
        Index remoteIndex = this.getIndex().getFKAssociation().getRemoteIndex();
        return (Column[])remoteIndex.getElements();
    }

    public static String[] getOnDeleteChoices() {
        return ON_DELETE;
    }

    public static String[] getOnUpdateChoices() {
        return ON_UPDATE;
    }

    protected boolean checkOnDelete(String value) {
        if (onDeleteSet == null) {
            onDeleteSet = new HashSet();
            onDeleteSet.addAll(Arrays.asList(FKProxyUDB.getOnDeleteChoices()));
        }
        return onDeleteSet.contains(value);
    }

    public void setOnDelete(String onDelete) {
        if (this.checkOnDelete(onDelete)) {
            this.onDelete = onDelete;
            this.fireDataFieldChange();
        }
    }

    public String getOnDelete() {
        return this.onDelete;
    }

    protected boolean checkOnUpdate(String value) {
        if (onUpdateSet == null) {
            onUpdateSet = new HashSet();
            onUpdateSet.addAll(Arrays.asList(FKProxyUDB.getOnUpdateChoices()));
        }
        return onUpdateSet.contains(value);
    }

    public void setOnUpdate(String onUpdate) {
        if (this.checkOnUpdate(onUpdate)) {
            this.onUpdate = onUpdate;
            this.fireDataFieldChange();
        }
    }

    public String getOnUpdate() {
        return this.onUpdate;
    }

    public static List getOnUpdateValues() {
        return onUpdateList;
    }

    public static List getOnDeleteValues() {
        return onDeleteList;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            FKPropertyDialogUDB dialog = new FKPropertyDialogUDB(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public String getName() {
        if (this.isNameChanged()) {
            return super.getName();
        }
        Index index = (Index)this.getObject();
        String name = index.isFK() && index.getFKAssociation() != null ? index.getFKAssociation().getName() : index.getName();
        name = this.applyNameSubstitution(name);
        return name;
    }
}

