/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.udb;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageObjectDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;

public abstract class SequenceUDB
extends AbstractStorageObjectDB2 {
    protected Owner owner;
    protected SchemaUDB schema;
    protected String datatype = DATA_TYPES[0];
    protected int startWith = 1;
    protected int incrementBy = 1;
    protected String maxValue = "NO";
    protected String minValue = "NO";
    protected String cycle = YES_NO_STATES[1];
    protected int cache = 20;
    protected String order = YES_NO_STATES[1];
    protected static final String[] YES_NO_STATES = new String[]{"YES", "NO"};
    private static Set yesNoSet = null;
    public static final String[] DATA_TYPES = new String[]{"INTEGER", "SMALLINT", "DECIMAL"};
    private static Set dataTypeSet = null;
    public static final String TYPE_NAME = "Sequence";

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    public static String[] getYesNoChoices() {
        return YES_NO_STATES;
    }

    protected boolean checkYesNo(String value) {
        if (yesNoSet == null) {
            yesNoSet = new HashSet();
            yesNoSet.addAll(Arrays.asList(SequenceUDB.getYesNoChoices()));
        }
        return yesNoSet.contains(value);
    }

    public static String[] getDataTypes() {
        return DATA_TYPES;
    }

    protected boolean checkDataTypes(String value) {
        if (dataTypeSet == null) {
            dataTypeSet = new HashSet();
            dataTypeSet.addAll(Arrays.asList(SequenceUDB.getDataTypes()));
        }
        return dataTypeSet.contains(value);
    }

    public int getCache() {
        return this.cache;
    }

    public void setCache(int cache) {
        if (cache != 1) {
            this.cache = cache;
        }
    }

    public String getCycle() {
        return this.cycle;
    }

    public void setCycle(String cycle) {
        if (this.checkYesNo(cycle)) {
            this.cycle = cycle;
        }
    }

    public String getDatatype() {
        return this.datatype;
    }

    public void setDatatype(String datatype) {
        if (this.checkDataTypes(datatype)) {
            this.datatype = datatype;
            this.fireDataFieldChange();
        }
    }

    public int getIncrementBy() {
        return this.incrementBy;
    }

    public void setIncrementBy(int incrementBy) {
        if (incrementBy >= 1) {
            this.incrementBy = incrementBy;
        }
    }

    public String getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(String maxValue) {
        this.maxValue = maxValue;
    }

    public String getMinValue() {
        return this.minValue;
    }

    public void setMinValue(String minValue) {
        this.minValue = minValue;
    }

    public String getOrder() {
        return this.order;
    }

    public void setOrder(String order) {
        if (this.checkYesNo(order)) {
            this.order = order;
            this.fireDataFieldChange();
        }
    }

    public Owner getOwner() {
        return this.owner;
    }

    public void setOwner(Owner owner) {
        this.owner = owner;
        this.fireChange(ObjectChangeEvent.NAME_CHANGED);
    }

    public int getStartWith() {
        return this.startWith;
    }

    public void setStartWith(int startWith) {
        this.startWith = startWith;
    }

    public void setSchema(SchemaUDB schema) {
        this.schema = schema;
        this.fireDataFieldChange();
    }

    public SchemaUDB getSchema() {
        return this.schema;
    }

    @Override
    public String getLongName() {
        if (this.getSchema() != null) {
            return new StringBuffer(this.getSchema().getName()).append('.').append(this.getName()).toString();
        }
        return super.getLongName();
    }

    @Override
    public boolean allowName(String name, boolean isLongName) {
        if (this.getStorageDesign() != null && this.getStorageDesign().isLoading()) {
            return true;
        }
        ModelObjectSet objectSet = this.getObjectSet();
        if (objectSet == null) {
            return true;
        }
        if (!isLongName && this.getSchema() != null) {
            name = this.getSchema().getName() + '.' + name;
        }
        return !objectSet.containsLongName(this, name);
    }
}

