/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.udb;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageObjectDB2;
import oracle.dbtools.crest.model.design.storage.udb.StorageObjectConstantsUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableProxyUDB;

public class StagingTableUDB
extends AbstractStorageObjectDB2 {
    protected TableProxyUDB table;
    protected boolean defineColumnNames = false;
    protected String generateSIC = "YES";
    protected String columns = "";
    protected ColumnSet columnSet = null;
    protected static final String GLOBALTRANSID = "GLOBALTRANSID";
    protected static final String GLOBALTRANSTIME = "GLOBALTRANSTIME";
    protected static final String OPERATIONTYPE = "OPERATIONTYPE";
    public static final String TYPE_NAME = "StagingTable";

    @Override
    public void showPropertyDialog() {
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    public TableProxyUDB getTable() {
        return this.table;
    }

    public void setTable(TableProxyUDB table) {
        this.table = table;
        this.fireDataFieldChange();
    }

    private void addColumn(String column) {
        String columnName = column.substring(column.lastIndexOf(46) + 1, column.length());
        if (!this.getColumnSet().contains(columnName)) {
            this.getColumnSet().add(columnName);
        }
    }

    private void recreateColumnSet(String columns) {
        this.getColumnSet().clear();
        StringTokenizer st = new StringTokenizer(columns, ",");
        while (st.hasMoreTokens()) {
            this.getColumnSet().add(st.nextToken().trim());
        }
    }

    public void setColumns(String columns) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateColumnSet(columns);
        } else {
            this.addColumn(columns);
        }
        this.columns = this.getColumnSet().toString();
        this.fireDataFieldChange();
    }

    public String getColumns() {
        return this.columns;
    }

    public ColumnSet getColumnSet() {
        if (this.columnSet == null) {
            this.columnSet = new ColumnSet();
        }
        return this.columnSet;
    }

    public void clear() {
        this.getColumnSet().removeAllElements();
        this.columns = "";
    }

    public boolean getDefineColumnNames() {
        return this.defineColumnNames;
    }

    public void setDefineColumnNames(boolean defineColumnNames) {
        this.defineColumnNames = defineColumnNames;
    }

    public String getGenerateSIC() {
        return this.generateSIC;
    }

    public void setGenerateSIC(String generateSIC) {
        if (StorageObjectConstantsUDB.checkYesNo(generateSIC)) {
            this.generateSIC = generateSIC;
            this.fireDataFieldChange();
        }
    }

    public ArrayList getTableColumnNames() {
        ArrayList<String> columns = new ArrayList<String>();
        for (int i = 0; i < this.table.getColumnProxies().length; ++i) {
            columns.add(this.table.getColumnProxies()[i].getName());
        }
        if (this.table.getSummaryQuery().toUpperCase().indexOf("GROUP BY") > -1) {
            columns.add(GLOBALTRANSID);
            columns.add(GLOBALTRANSTIME);
        } else {
            columns.add(GLOBALTRANSID);
            columns.add(GLOBALTRANSTIME);
            columns.add(OPERATIONTYPE);
        }
        return columns;
    }

    public class ColumnSet
    extends Vector {
        @Override
        public String toString() {
            StringBuffer result = new StringBuffer();
            Iterator it = this.iterator();
            boolean b = false;
            while (it.hasNext()) {
                if (b) {
                    result.append(", ");
                } else {
                    b = true;
                }
                String obj = (String)it.next();
                result.append(obj);
            }
            return result.toString();
        }
    }
}

