/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.udb;

import javax.swing.Icon;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StoredProcedure;
import oracle.dbtools.crest.model.design.storage.udb.OwnerUDB;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.udb.StoredProcedurePropertyDialogUDB;

public class StoredProcedureUDB
extends StoredProcedure {
    protected OwnerUDB owner;
    protected SchemaUDB schema;
    protected String specificName = "";

    public StoredProcedureUDB(StorageDesign storageDesign) {
        super(storageDesign);
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            StoredProcedurePropertyDialogUDB dialog = new StoredProcedurePropertyDialogUDB(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    public OwnerUDB getOwner() {
        return this.owner;
    }

    public void setOwner(OwnerUDB owner) {
        this.owner = owner;
        this.fireChange(ObjectChangeEvent.NAME_CHANGED);
    }

    public void setSchema(SchemaUDB schema) {
        this.schema = schema;
        this.fireDataFieldChange();
    }

    public SchemaUDB getSchema() {
        return this.schema;
    }

    @Override
    public String getLongName() {
        if (this.getSchema() != null) {
            return new StringBuffer(this.getSchema().getName()).append('.').append(this.getName()).toString();
        }
        return super.getLongName();
    }

    @Override
    public boolean allowName(String name, boolean isLongName) {
        if (this.getStorageDesign() != null && this.getStorageDesign().isLoading()) {
            return true;
        }
        ModelObjectSet objectSet = this.getObjectSet();
        if (objectSet == null) {
            return true;
        }
        if (!isLongName && this.getSchema() != null) {
            name = this.getSchema().getName() + '.' + name;
        }
        return !objectSet.containsLongName(this, name);
    }

    public String getSpecificName() {
        return this.specificName;
    }

    public void setSpecificName(String specificName) {
        this.specificName = specificName;
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("PROCEDURE_ICON", 16);
    }
}

