/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.udb;

import java.util.ArrayList;
import java.util.Map;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.TableViewProxy;
import oracle.dbtools.crest.model.design.storage.udb.OwnerUDB;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.swingui.editor.storage.udb.TableViewPropertyDialogUDB;

public class TableViewProxyUDB
extends TableViewProxy {
    private OwnerUDB owner = null;
    private SchemaUDB schema = null;
    private String oidColumnName = "Oid";
    private boolean oidColumnUniqueness = true;
    public static final String CASCADED_CHECK_OPTIONS = "CASCADED";
    public static final String LOCAL_CHECK_OPTIONS = "LOCAL";
    public static String[] availableCheckOptionScopes = new String[]{"CASCADED", "LOCAL"};
    protected String checkOptionScope = "CASCADED";
    protected StorageObjectCollection triggers;

    public TableViewProxyUDB(TableView tableView, StorageDesign storageDesign) {
        super(tableView, storageDesign);
    }

    public TableViewProxyUDB(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
    }

    public void setOwner(OwnerUDB owner) {
        this.owner = owner;
        this.fireChange(ObjectChangeEvent.NAME_CHANGED);
    }

    public OwnerUDB getOwner() {
        return this.owner;
    }

    public void setSchema(SchemaUDB schema) {
        this.schema = schema;
        this.fireDataFieldChange();
    }

    public SchemaUDB getSchema() {
        return this.schema;
    }

    @Override
    public String getLongName() {
        if (this.getSchema() != null) {
            return new StringBuffer(this.getSchema().getLongName()).append('.').append(this.getName()).toString();
        }
        ContainerObject co = (ContainerObject)this.getObject();
        SchemaObject so = co.getSchemaObject();
        if (so != null) {
            StorageObject user = ((StorageDesignUDB)this.getStorageDesign()).getSchemaSet().getBySchemaObject(so);
            if (user != null) {
                return new StringBuffer(user.getLongName()).append('.').append(this.getName()).toString();
            }
            if (!this.getStorageDesign().isOpen()) {
                return new StringBuffer(so.getLongName()).append('.').append(this.getName()).toString();
            }
        }
        return super.getLongName();
    }

    public String getLongSuperViewName() {
        TableViewProxyUDB tvp;
        TableView view = (TableView)this.getObject();
        if (!view.isRoot() && view.getTypeSubstitution() != null && (tvp = (TableViewProxyUDB)this.getStorageDesign().getTableViewProxySet().getProxy(view.getTypeSubstitution().getParentContainerObject().getObjectID())) != null) {
            return tvp.getLongName();
        }
        return "";
    }

    public static String[] getAvailableCheckOptionScopes() {
        return availableCheckOptionScopes;
    }

    public void setCheckOptionScope(String checkOptionScope) {
        this.checkOptionScope = checkOptionScope;
    }

    public String getCheckOptionScope() {
        return this.checkOptionScope;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            TableViewPropertyDialogUDB dialog = new TableViewPropertyDialogUDB(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    public String getOidColumnName() {
        return this.oidColumnName;
    }

    public void setOidColumnName(String oidColumnName) {
        this.oidColumnName = oidColumnName;
    }

    public boolean isOidColumnUniqueness() {
        return this.oidColumnUniqueness;
    }

    public void setOidColumnUniqueness(boolean oidColumnUniqueness) {
        this.oidColumnUniqueness = oidColumnUniqueness;
    }

    public String getSuperViewName() {
        TableView view = (TableView)this.getObject();
        if (!view.isRoot() && view.getTypeSubstitution() != null) {
            return view.getTypeSubstitution().getParentContainerObject().getName();
        }
        return "";
    }

    public boolean isBasedOnStructuredType() {
        return ((TableView)this.getObject()).isBST();
    }

    @Override
    public StorageObject getUserSchema() {
        if (this.getSchema() != null) {
            return this.getSchema();
        }
        return this.getOwner();
    }

    @Override
    public void clearMergableStructure(Map reverseMap) {
        if (reverseMap != null) {
            ArrayList list = new ArrayList();
            if (this.triggers != null) {
                this.triggers.addAllElementsTo(list);
            }
            for (StorageObject st : list) {
                if (reverseMap.get(st.getObjectID()) != null) continue;
                st.remove(true);
            }
        }
    }
}

