/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.udb.v71;

import java.util.Iterator;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.OwnerUDB;
import oracle.dbtools.crest.model.design.storage.udb.PrivilegesUDB;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.v71.StorageDesignUDBv71;

public class SchemaUDBv71
extends SchemaUDB {
    private PrivilegesUDB getPrivileges(SchemaUDBv71 schema) {
        PrivilegesUDB priv;
        Iterator it = ((StorageDesignUDBv71)this.getStorageDesign()).getPrivilegesSet().iterator();
        while (it.hasNext()) {
            priv = (PrivilegesUDB)it.next();
            if (priv.getSchema() != schema) continue;
            return priv;
        }
        priv = ((StorageDesignUDBv71)this.getStorageDesign()).getPrivilegesSet().createPriv();
        priv.setSchema(schema);
        return priv;
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        SchemaUDBv71 schema = null;
        StorageObject storageObject = (StorageObject)((StorageDesignUDBv71)targetDesign).getSchemaSet().getByName(this.getName());
        if (storageObject != null) {
            if (!this.isRawObject()) {
                schema = (SchemaUDBv71)storageObject;
            }
        } else {
            schema = (SchemaUDBv71)((StorageDesignUDBv71)targetDesign).getSchemaSet().createSchema();
        }
        if (schema != null) {
            schema.setName(this.getName());
            if (this.getOwner() != null) {
                OwnerUDB owner = (OwnerUDB)((StorageDesignUDBv71)targetDesign).getOwnerSet().getByName(this.getOwner().getName());
                if (owner == null) {
                    OwnerUDB newOwner = (OwnerUDB)((StorageDesignUDBv71)targetDesign).getOwnerSet().createElement(null);
                    newOwner.setName(this.getOwner().getName());
                    newOwner.setRawObject(true);
                    schema.setOwner(newOwner);
                } else {
                    schema.setOwner(owner);
                }
            }
            PrivilegesUDB priv = this.getPrivileges(this);
            String[] privileges = (String[])PrivilegesUDB.getPrivilegesValues().toArray();
            for (int i = 0; i < privileges.length; ++i) {
                if (!priv.getSystemPrivilegesSet().contains(privileges[i])) continue;
                priv.setSchema(schema);
            }
            schema.setComment(this.getComment());
            schema.setCommentInRDBMS(this.getCommentInRDBMS());
            schema.setRawObject(false);
        }
    }
}

