/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.udb.v71;

import java.util.Iterator;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.udb.TableProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.v71.SchemaUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v71.StorageDesignUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v71.TableProxySetUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v71.TableSpaceUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v71.TriggerUDBv71;

public class TableProxyUDBv71
extends TableProxyUDB {
    public TableProxyUDBv71(Table table, StorageDesign storageDesign) {
        super(table, storageDesign);
    }

    public TableProxyUDBv71(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
    }

    @Override
    public int getMaxNameLength() {
        return 128;
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        Table table = (Table)((StorageDesignUDBv71)targetDesign).getPhysicalDesign().getTableSet().getByName(this.getObject().getName());
        TableProxyUDBv71 tableProxy = null;
        RelationalObjectProxy storageObject = ((TableProxySetUDBv71)((StorageDesignUDBv71)targetDesign).getTableProxySet()).getProxy(table.getObjectID());
        if (storageObject != null && !this.isRawObject()) {
            tableProxy = (TableProxyUDBv71)storageObject;
        }
        if (tableProxy != null) {
            TableSpaceUDBv71 newTablespace;
            TableSpaceUDBv71 tablespace;
            tableProxy.setName(this.getName());
            Iterator it = this.triggers.iterator();
            while (it.hasNext()) {
                TriggerUDBv71 trigger = (TriggerUDBv71)it.next();
                TriggerUDBv71 targetTrigger = (TriggerUDBv71)((StorageDesignUDBv71)targetDesign).getTriggerSet().getByName(trigger.getName());
                if (targetTrigger == null) {
                    TriggerUDBv71 newTrigger = (TriggerUDBv71)((StorageDesignUDBv71)targetDesign).getTriggerSet().createTrigger();
                    newTrigger.setName(trigger.getName());
                    newTrigger.setRawObject(true);
                    newTrigger.setTable(tableProxy);
                    tableProxy.addTriggersFromDesign(((StorageDesignUDBv71)targetDesign).getTriggerSet());
                    continue;
                }
                targetTrigger.setTable(tableProxy);
                tableProxy.addTriggersFromDesign(((StorageDesignUDBv71)targetDesign).getTriggerSet());
            }
            if (this.getSchema() != null) {
                SchemaUDBv71 schema = (SchemaUDBv71)((StorageDesignUDBv71)targetDesign).getSchemaSet().getByName(this.getSchema().getName());
                if (schema == null) {
                    SchemaUDBv71 newSchema = (SchemaUDBv71)((StorageDesignUDBv71)targetDesign).getSchemaSet().createSchema();
                    newSchema.setName(this.getSchema().getName());
                    newSchema.setRawObject(true);
                    tableProxy.setSchema(newSchema);
                } else {
                    tableProxy.setSchema(schema);
                }
            }
            tableProxy.setPartKeyHashing(this.getPartKeyHashing());
            if (this.getTableSpace() != null) {
                tablespace = (TableSpaceUDBv71)((StorageDesignUDBv71)targetDesign).getTableSpaceSet().getByName(this.getTableSpace().getName());
                if (tablespace == null) {
                    newTablespace = (TableSpaceUDBv71)((StorageDesignUDBv71)targetDesign).getTableSpaceSet().createTableSpace();
                    newTablespace.setName(this.getTableSpace().getName());
                    newTablespace.setRawObject(true);
                    tableProxy.setTableSpace(newTablespace);
                } else {
                    tableProxy.setTableSpace(tablespace);
                }
            }
            if (this.getIndexInTableSpace() != null) {
                tablespace = (TableSpaceUDBv71)((StorageDesignUDBv71)targetDesign).getTableSpaceSet().getByName(this.getIndexInTableSpace().getName());
                if (tablespace == null) {
                    newTablespace = (TableSpaceUDBv71)((StorageDesignUDBv71)targetDesign).getTableSpaceSet().createTableSpace();
                    newTablespace.setName(this.getIndexInTableSpace().getName());
                    newTablespace.setRawObject(true);
                    tableProxy.setIndexInTableSpace(newTablespace);
                } else {
                    tableProxy.setIndexInTableSpace(tablespace);
                }
            }
            if (this.getLongInTableSpace() != null) {
                tablespace = (TableSpaceUDBv71)((StorageDesignUDBv71)targetDesign).getTableSpaceSet().getByName(this.getLongInTableSpace().getName());
                if (tablespace == null) {
                    newTablespace = (TableSpaceUDBv71)((StorageDesignUDBv71)targetDesign).getTableSpaceSet().createTableSpace();
                    newTablespace.setName(this.getLongInTableSpace().getName());
                    newTablespace.setRawObject(true);
                    tableProxy.setLongInTableSpace(newTablespace);
                } else {
                    tableProxy.setLongInTableSpace(tablespace);
                }
            }
            tableProxy.setInitialLogging(this.getInitialLogging());
            tableProxy.setDataCapture(this.getDataCapture());
            tableProxy.setFederated(this.getFederated());
            tableProxy.setSummaryQuery(this.getSummaryQuery());
            tableProxy.recreateColumnListSet(this.getColumnSet().toString());
            tableProxy.setSummaryQueryDefinition(this.getSummaryQueryDefinition());
            tableProxy.setSummaryStatus(this.getSummaryStatus());
            tableProxy.setSummaryMaintenance(this.getSummaryMaintenance());
            tableProxy.setSummaryRefreshOptions(this.getSummaryRefreshOptions());
            tableProxy.setSummaryQueryOptimization(this.getSummaryQueryOptimization());
            tableProxy.setSummaryIdentityColumn(this.getSummaryIdentityColumn());
            tableProxy.setSummaryCopyColumnDefaults(this.getSummaryCopyColumnDefaults());
            tableProxy.setReplicated(this.getReplicated());
            tableProxy.setComment(this.getComment());
            tableProxy.setCommentInRDBMS(this.getCommentInRDBMS());
            tableProxy.setRawObject(false);
        }
    }
}

