/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.udb.v81;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.udb.IndexProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.SchemaUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.swingui.editor.storage.udb.v81.IndexPropertyDialogUDBv81;
import oracle.dbtools.crest.util.propertymap.PropertiesPropagator;
import oracle.dbtools.crest.util.propertymap.PropertyWrapper;

public class IndexProxyUDBv81
extends IndexProxyUDB
implements PropertiesPropagator {
    protected String collectStatistics = "NONE";
    public static final String NONE = "NONE";
    public static final String BASIC = "BASIC";
    public static final String DETAILED = "DETAILED";
    public static final String SAMPLED_DETAILED = "SAMPLED DETAILED";
    public static final String[] COLLECT_STATISTICS_STATES = new String[]{"NONE", "BASIC", "DETAILED", "SAMPLED DETAILED"};
    private static Set collectStatisticsSet = null;
    private List propertyWrapperList = null;

    public IndexProxyUDBv81(Index index, StorageDesign storageDesign) {
        super(index, storageDesign);
    }

    public IndexProxyUDBv81(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
    }

    protected boolean checkCollectStatistics(String value) {
        if (collectStatisticsSet == null) {
            collectStatisticsSet = new HashSet();
            collectStatisticsSet.addAll(Arrays.asList(COLLECT_STATISTICS_STATES));
        }
        return collectStatisticsSet.contains(value);
    }

    public String getCollectStatistics() {
        return this.collectStatistics;
    }

    public void setCollectStatistics(String collectStatistics) {
        if (this.checkCollectStatistics(collectStatistics)) {
            this.collectStatistics = collectStatistics;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            IndexPropertyDialogUDBv81 dialog = new IndexPropertyDialogUDBv81(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public List getPropertyWrapperList() {
        if (this.propertyWrapperList == null) {
            this.propertyWrapperList = new ArrayList();
            this.propertyWrapperList.add(new PropertyWrapper("Schema", this, "getSchema", "setSchema", SchemaUDB.class));
            this.propertyWrapperList.add(new PropertyWrapper("Cluster", this, "getCluster", "setCluster", Boolean.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("PCTFREE", this, "getPercentageFree", "setPercentageFree", Integer.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Min % Used", this, "getMinimumPercentageUsed", "setMinimumPercentageUsed", Integer.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Reverse Scan", this, "getReverseScanSupport", "setReverseScanSupport", Boolean.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Collect Statistics", this, "getCollectStatistics", "setCollectStatistics", String.class));
        }
        return this.propertyWrapperList;
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        Index index = (Index)targetDesign.getPhysicalDesign().getTableSet().getGlobalIndexSet().getByName(this.getName());
        IndexProxyUDBv81 indexProxy = null;
        RelationalObjectProxy storageObject = ((StorageDesignUDBv81)targetDesign).getIndexProxySet().getProxy(index.getObjectID());
        if (storageObject != null && !this.isRawObject()) {
            indexProxy = (IndexProxyUDBv81)storageObject;
        }
        if (indexProxy != null) {
            indexProxy.setName(this.getName());
            if (this.getSchema() != null) {
                SchemaUDBv81 scheme = (SchemaUDBv81)((StorageDesignUDBv81)targetDesign).getSchemaSet().getByName(this.getSchema().getName());
                if (scheme == null) {
                    SchemaUDBv81 newScheme = (SchemaUDBv81)((StorageDesignUDBv81)targetDesign).getSchemaSet().createSchema();
                    newScheme.setName(this.getSchema().getName());
                    newScheme.setRawObject(true);
                    indexProxy.setSchema(newScheme);
                } else {
                    indexProxy.setSchema(scheme);
                }
            }
            indexProxy.setCluster(this.getCluster());
            indexProxy.setPercentageFree(this.getPercentageFree());
            indexProxy.setMinimumPercentageUsed(this.getMinimumPercentageUsed());
            indexProxy.setReverseScanSupport(this.getReverseScanSupport());
            indexProxy.setCollectStatistics(this.getCollectStatistics());
            indexProxy.recreateColumnListSet(this.getColumnSet().toString());
            indexProxy.recreateUserGroupSet(this.getUserGroupSet().toString());
            indexProxy.recreateUserSet(this.getUserSet().toString());
            indexProxy.setComment(this.getComment());
            indexProxy.setCommentInRDBMS(this.getCommentInRDBMS());
            indexProxy.setRawObject(false);
        }
    }
}

