/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.udb.v81;

import java.util.Iterator;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.OwnerUDB;
import oracle.dbtools.crest.model.design.storage.udb.PrivilegesUDB;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;

public class SchemaUDBv81
extends SchemaUDB {
    private PrivilegesUDB getPrivileges(SchemaUDBv81 schema) {
        PrivilegesUDB priv;
        Iterator it = ((StorageDesignUDBv81)this.getStorageDesign()).getPrivilegesSet().iterator();
        while (it.hasNext()) {
            priv = (PrivilegesUDB)it.next();
            if (priv.getSchema() != schema) continue;
            return priv;
        }
        priv = ((StorageDesignUDBv81)this.getStorageDesign()).getPrivilegesSet().createPriv();
        priv.setSchema(schema);
        return priv;
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        SchemaUDBv81 schema = null;
        StorageObject storageObject = (StorageObject)((StorageDesignUDBv81)targetDesign).getSchemaSet().getByName(this.getName());
        if (storageObject != null) {
            if (!this.isRawObject()) {
                schema = (SchemaUDBv81)storageObject;
            }
        } else {
            schema = (SchemaUDBv81)((StorageDesignUDBv81)targetDesign).getSchemaSet().createSchema();
        }
        if (schema != null) {
            schema.setName(this.getName());
            if (this.getOwner() != null) {
                OwnerUDB owner = (OwnerUDB)((StorageDesignUDBv81)targetDesign).getOwnerSet().getByName(this.getOwner().getName());
                if (owner == null) {
                    OwnerUDB newOwner = (OwnerUDB)((StorageDesignUDBv81)targetDesign).getOwnerSet().createElement(null);
                    newOwner.setName(this.getOwner().getName());
                    newOwner.setRawObject(true);
                    schema.setOwner(newOwner);
                } else {
                    schema.setOwner(owner);
                }
            }
            PrivilegesUDB priv = this.getPrivileges(this);
            String[] privileges = (String[])PrivilegesUDB.getPrivilegesValues().toArray();
            for (int i = 0; i < privileges.length; ++i) {
                if (!priv.getSystemPrivilegesSet().contains(privileges[i])) continue;
                priv.setSchema(schema);
            }
            schema.setComment(this.getComment());
            schema.setCommentInRDBMS(this.getCommentInRDBMS());
            schema.setRawObject(false);
        }
    }
}

