/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.udb.v81;

import java.util.Iterator;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.udb.StorageObjectConstantsUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableViewProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.SchemaUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TriggerUDBv81;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.udb.v81.TableViewPropertyDialogUDBv81;

public class TableViewProxyUDBv81
extends TableViewProxyUDB
implements ModelObjectSetListener,
StorageObjectListener {
    protected String federated = "NO";

    public TableViewProxyUDBv81(TableView tableView, StorageDesign storageDesign) {
        super(tableView, storageDesign);
        this.triggers = new StorageObjectCollection(((StorageDesignUDBv81)storageDesign).getTriggerSet());
        this.triggers.setParent(this);
        this.triggers.setName(Messages.getString("TableProxyOracle.Triggers"));
        this.triggers.setClassForParent(TableViewProxyUDBv81.class);
        this.triggers.setSetMethod("setView");
        this.triggers.setIcon(GUIConfiguration.getInstance().getIcon("TRIGGER_FOLDER_ICON", 16));
        ((StorageDesignUDBv81)storageDesign).getTriggerSet().addSetListener(this);
        this.addTriggersFromDesign(((StorageDesignUDBv81)storageDesign).getTriggerSet());
    }

    public TableViewProxyUDBv81(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
        this.triggers = new StorageObjectCollection(((StorageDesignUDBv81)storageDesign).getTriggerSet());
        this.triggers.setParent(this);
        this.triggers.setName(Messages.getString("TableProxyOracle.Triggers"));
        this.triggers.setClassForParent(TableViewProxyUDBv81.class);
        this.triggers.setSetMethod("setView");
        this.triggers.setIcon(GUIConfiguration.getInstance().getIcon("TRIGGER_FOLDER_ICON", 16));
        ((StorageDesignUDBv81)storageDesign).getTriggerSet().addSetListener(this);
        this.addTriggersFromDesign(((StorageDesignUDBv81)storageDesign).getTriggerSet());
    }

    public String getFederated() {
        return this.federated;
    }

    public void setFederated(String federated) {
        if (StorageObjectConstantsUDB.checkYesNo(federated)) {
            this.federated = federated;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            TableViewPropertyDialogUDBv81 dialog = new TableViewPropertyDialogUDBv81(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    private void addTriggersFromDesign(StorageObjectSet set) {
        Iterator it = set.iterator();
        while (it.hasNext()) {
            TriggerUDBv81 trigger = (TriggerUDBv81)it.next();
            trigger.addObjectListener(this);
            if (trigger.getView() != null && trigger.getView() == this) {
                trigger.setParent(this.triggers);
                this.triggers.add(trigger);
                continue;
            }
            this.triggers.remove(trigger);
        }
    }

    @Override
    public Object getChildPlain(int index) {
        return this.getChild(index);
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public int getNumberOfChildren() {
        return super.getNumberOfChildren() + 1;
    }

    @Override
    public ModelObject getChild(int index) {
        if (index == this.getNumberOfChildren() - 1) {
            return this.triggers;
        }
        return super.getChild(index);
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.triggers) {
            return this.getNumberOfChildren() - 1;
        }
        return super.getIndexForChild(child);
    }

    @Override
    public int getIndexForChild(Object child) {
        if (child == this.triggers) {
            return this.getNumberOfChildren() - 1;
        }
        return super.getIndexForChild(child);
    }

    @Override
    public void changed(StorageObject object, ObjectChangeEvent event) {
        if (event.getAffected() instanceof TriggerUDBv81) {
            TriggerUDBv81 tr = (TriggerUDBv81)event.getAffected();
            if (tr.getView() != null && tr.getView() == this) {
                tr.setParent(this.triggers);
                this.triggers.add(tr);
            } else {
                this.triggers.remove(tr);
            }
        }
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
        if (event.isType(1)) {
            if (event.getAffected() instanceof TriggerUDBv81) {
                TriggerUDBv81 tr = (TriggerUDBv81)event.getAffected();
                tr.addObjectListener(this);
                if (tr.getView() != null && tr.getView() == this) {
                    tr.setParent(this.triggers);
                    this.triggers.add(tr);
                } else {
                    this.triggers.remove(tr);
                }
            }
        } else if (event.isType(0) && event.getAffected() instanceof TriggerUDBv81) {
            TriggerUDBv81 tr = (TriggerUDBv81)event.getAffected();
            this.triggers.remove(tr);
            tr.removeObjectListener(this);
        }
    }

    @Override
    public int getMaxNameLength() {
        return 128;
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        TableView view = (TableView)targetDesign.getPhysicalDesign().getTableViewSet().getByName(this.getObject().getName());
        TableViewProxyUDBv81 viewProxy = null;
        RelationalObjectProxy storageObject = ((StorageDesignUDBv81)targetDesign).getTableViewProxySet().getProxy(view.getObjectID());
        if (storageObject != null && !this.isRawObject()) {
            viewProxy = (TableViewProxyUDBv81)storageObject;
        }
        if (viewProxy != null) {
            viewProxy.setName(this.getName());
            if (this.getSchema() != null) {
                SchemaUDBv81 scheme = (SchemaUDBv81)((StorageDesignUDBv81)targetDesign).getSchemaSet().getByName(this.getSchema().getName());
                if (scheme == null) {
                    SchemaUDBv81 newScheme = (SchemaUDBv81)((StorageDesignUDBv81)targetDesign).getSchemaSet().createSchema();
                    newScheme.setName(this.getSchema().getName());
                    newScheme.setRawObject(true);
                    viewProxy.setSchema(newScheme);
                } else {
                    viewProxy.setSchema(scheme);
                }
            }
            viewProxy.setCheckOption(this.getCheckOption());
            viewProxy.setCheckOptionScope(this.getCheckOptionScope());
            viewProxy.setOidColumnName(this.getOidColumnName());
            viewProxy.setOidColumnUniqueness(this.isOidColumnUniqueness());
            viewProxy.setDefinition(this.getDefinition());
            viewProxy.setComment(this.getComment());
            viewProxy.setCommentInRDBMS(this.getCommentInRDBMS());
            viewProxy.setRawObject(false);
        }
    }
}

