/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.undo;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.design.undo.UpdateDO_Edit;
import oracle.dbtools.crest.swingui.TopView;

public class FormatLineEdit
extends UpdateDO_Edit {
    Object[] topViews;
    List savedItems = new ArrayList();
    boolean useDefault;
    Color bgColor;
    int lineWidth;

    public FormatLineEdit(Object[] topViews, boolean useDefault, Color bgColor, int lineWidth) {
        super(((TopView)topViews[0]).getModel());
        this.topViews = topViews;
        this.useDefault = useDefault;
        this.bgColor = bgColor;
        this.lineWidth = lineWidth;
        this.saveState();
    }

    @Override
    public void applyUpdates() {
        if (this.useDefault) {
            for (int i = 0; i < this.topViews.length; ++i) {
                TopView topView = (TopView)this.topViews[i];
                topView.setUseDefaultColor(true);
                topView.setBackgroundColor(null);
                topView.setLineWidth(1);
            }
        } else {
            for (int i = 0; i < this.topViews.length; ++i) {
                TopView topView = (TopView)this.topViews[i];
                topView.setUseDefaultColor(false);
                topView.setBackgroundColor(this.bgColor);
                topView.setLineWidth(this.lineWidth);
            }
        }
        if (this.topViews.length > 0) {
            ((TopView)this.topViews[0]).getDesignPartView().repaint();
        }
    }

    @Override
    protected void restoreObject() {
        for (LineTVWrap wr : this.savedItems) {
            if (wr.useDefault) {
                wr.tv.setUseDefaultColor(true);
                wr.tv.setBackgroundColor(null);
                wr.tv.setLineWidth(1);
                continue;
            }
            wr.tv.setUseDefaultColor(false);
            wr.tv.setBackgroundColor(wr.bgColor);
            wr.tv.setLineWidth(wr.lineWidth);
        }
        if (this.topViews.length > 0) {
            ((TopView)this.topViews[0]).getDesignPartView().repaint();
        }
    }

    private void saveState() {
        for (int i = 0; i < this.topViews.length; ++i) {
            TopView topView = (TopView)this.topViews[i];
            LineTVWrap wr = new LineTVWrap();
            wr.useDefault = topView.useDefaultColor();
            wr.bgColor = topView.getBackgroundColor();
            wr.tv = topView;
            wr.lineWidth = topView.getLineWidth();
            this.savedItems.add(wr);
        }
    }

    @Override
    public String getRedoPresentationName() {
        if (this.topViews.length > 1) {
            return "Redo Format Group Of Objects";
        }
        if (this.topViews.length == 1) {
            TopView tv = (TopView)this.topViews[0];
            return "Redo Format " + tv.toString();
        }
        return "Redo Format";
    }

    @Override
    public String getUndoPresentationName() {
        if (this.topViews.length > 1) {
            return "Undo Format Group Of Objects";
        }
        if (this.topViews.length == 1) {
            TopView tv = (TopView)this.topViews[0];
            return "Undo Format " + tv.toString();
        }
        return "Undo Format";
    }

    class LineTVWrap {
        TopView tv;
        boolean useDefault;
        Color bgColor;
        int lineWidth = 1;

        LineTVWrap() {
        }
    }
}

