/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.undo.relational;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.undo.relational.FKColumnPreserver;

public class ColumnPreserver
extends FKColumnPreserver {
    private Column column;
    private Column backup;
    private String id;
    private Table table;
    private int position;
    private int[][] occurences;
    private KeyObject[] keys;
    private RelationalDesign phdes;
    private List fk_col_preservers = new ArrayList();

    public ColumnPreserver(Column oldColumn) {
        this.phdes = (RelationalDesign)oldColumn.getDesignPart();
        this.preserve(oldColumn);
    }

    @Override
    public void preserve(Column oldColumn) {
        this.column = oldColumn;
        this.backup = new Column(this.phdes);
        this.column.copy(this.backup);
        this.id = this.column.getObjectID();
        this.backup.setObjectID(this.id);
        this.position = this.column.getIndex();
        this.table = (Table)this.column.getContainerWithKeyObject();
        this.keys = this.table.getKeys();
        this.occurences = this.occursInCandidateKeys(this.keys, this.column);
        this.saveMappings(this.column, this.mappings);
        ColumnPreserver.saveFKandDelegates(oldColumn, this.delegates);
        List pu_keys = this.getUK_PKFor(oldColumn);
        if (pu_keys.size() > 0) {
            List fkeys = this.phdes.getFKIndexAssociationSet().getFKeysToListOfKeys(pu_keys);
            for (FKIndexAssociation fk : fkeys) {
                Column fk_colum = fk.getColumnForDelegate(oldColumn);
                if (fk_colum == null) continue;
                FKColumnPreserver fpres = new FKColumnPreserver();
                fpres.preserve(fk_colum);
                this.fk_col_preservers.add(fpres);
            }
        }
    }

    @Override
    public void restore(Column newColumn) {
        this.backup.copy(newColumn);
        newColumn.setObjectID(this.id);
        this.table.moveToIndex(newColumn, this.position);
        if (this.occurences != null) {
            this.insertInCandidateKeys(this.keys, newColumn, this.occurences);
        }
        this.restoreMappings(this.mappings);
        ColumnPreserver.restoreFKandDelegates(newColumn, this.delegates);
        for (FKColumnPreserver fpres : this.fk_col_preservers) {
            fpres.restore(newColumn);
        }
    }

    @Override
    public void restore() {
        Column newColumn = (Column)this.table.getElementByID(this.id);
        if (newColumn == null) {
            newColumn = this.column;
            this.column.setObjectID(this.id);
            this.table.add(newColumn);
        }
        this.backup.copy(newColumn);
        this.table.moveToIndex(newColumn, this.position);
        if (this.occurences != null) {
            this.insertInCandidateKeys(this.keys, newColumn, this.occurences);
        }
        this.restoreMappings(this.mappings);
        ColumnPreserver.restoreFKandDelegates(newColumn, this.delegates);
        for (FKColumnPreserver fpres : this.fk_col_preservers) {
            fpres.restore();
        }
    }

    private List getUK_PKFor(Column column) {
        Table table = (Table)column.getContainerWithKeyObject();
        ArrayList<KeyObject> list = new ArrayList<KeyObject>();
        KeyObject[] keys = table.getKeys();
        for (int i = 0; i < keys.length; ++i) {
            if (!keys[i].isPK() && !keys[i].isUnique()) continue;
            list.add(keys[i]);
        }
        return list;
    }
}

