/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.undo.relational;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;

public class FKColumnPreserver {
    private Column column;
    private Column backup;
    private String id;
    private Table table;
    private int position;
    private int[][] occurences;
    private KeyObject[] keys;
    List delegates = new ArrayList();
    protected List mappings = new ArrayList();

    public void preserve(Column oldColumn) {
        this.column = oldColumn;
        this.backup = new Column(oldColumn.getDesignPart());
        this.column.copy(this.backup);
        this.id = this.column.getObjectID();
        this.backup.setObjectID(this.id);
        this.position = this.column.getIndex();
        this.table = (Table)this.column.getContainerWithKeyObject();
        this.keys = this.table.getKeys();
        this.occurences = this.occursInCandidateKeys(this.keys, this.column);
        this.saveMappings(this.column, this.mappings);
        FKColumnPreserver.saveFKandDelegates(oldColumn, this.delegates);
    }

    public void restore(Column newColumn) {
        this.backup.copy(newColumn);
        newColumn.setObjectID(this.id);
        this.table.moveToIndex(newColumn, this.position);
        if (this.occurences != null) {
            this.insertInCandidateKeys(this.keys, newColumn, this.occurences);
        }
        this.restoreMappings(this.mappings);
        FKColumnPreserver.restoreFKandDelegates(newColumn, this.delegates);
    }

    public void restore() {
        this.validateKeys();
        Column newColumn = (Column)this.table.getElementByID(this.id);
        if (newColumn == null) {
            newColumn = this.column;
            this.column.setObjectID(this.id);
            this.table.add(newColumn);
        }
        this.backup.copy(newColumn);
        this.table.moveToIndex(newColumn, this.position);
        if (this.occurences != null) {
            this.insertInCandidateKeys(this.keys, newColumn, this.occurences);
        }
        this.restoreMappings(this.mappings);
        FKColumnPreserver.restoreFKandDelegates(newColumn, this.delegates);
    }

    protected int[][] occursInCandidateKeys(KeyObject[] keys, Column column) {
        ArrayList<int[]> list = new ArrayList<int[]>();
        for (int i = 0; i < keys.length; ++i) {
            if (!keys[i].contains(column)) continue;
            list.add(new int[]{i, keys[i].getIndexOf(column)});
        }
        return (int[][])list.toArray((T[])new int[list.size()][]);
    }

    protected void insertInCandidateKeys(KeyObject[] keys, Column newColumn, int[][] occurences) {
        for (int i = 0; i < occurences.length; ++i) {
            int[] item = occurences[i];
            keys[item[0]].add(newColumn);
            keys[item[0]].moveToIndex(newColumn, item[1]);
        }
    }

    public static void saveFKandDelegates(Column column, List savedItems) {
        for (Column.FK_And_Delegate_Holder fkh : column.getAllDelegatesAndFK()) {
            Column.DelegateHolder dh = column.new Column.DelegateHolder();
            dh.fkid = fkh.fk.getObjectID();
            dh.delegateID = fkh.delegateColumn.getObjectID();
            savedItems.add(dh);
        }
    }

    public static void restoreFKandDelegates(Column column, List savedItems) {
        for (Column.DelegateHolder dh : savedItems) {
            column.addFKAssociation(dh.delegateID, dh.fkid);
        }
    }

    public void saveMappings(Column object, List savediItems) {
        ColumnMappingWr wr = new ColumnMappingWr();
        wr.object = object;
        wr.table = (Table)object.getContainerWithKeyObject();
        savediItems.add(wr);
        wr.mappings.addAll(object.getDesign().getExtendedMap().getOrCreateCollector(object).getAllMappings());
    }

    public void restoreMappings(List savediItems) {
        for (ColumnMappingWr wr : savediItems) {
            for (XtdMapping mapping : wr.mappings) {
                boolean a;
                if (wr.object.getObjectID().equals(mapping.getDeletedID())) {
                    Column column = (Column)wr.table.getLocalObject(wr.object.getObjectID());
                    if (column != null) {
                        wr.object = column;
                    }
                    wr.object.getDesign().getExtendedMap().restoreDeletedMapping(mapping, wr.object);
                    continue;
                }
                boolean b = a = false;
            }
        }
    }

    private void validateKeys() {
        if (this.keys.length > 0) {
            ArrayList<Index> list = new ArrayList<Index>();
            for (int i = 0; i < this.keys.length; ++i) {
                Index ind = this.table.getIndexByID(this.keys[i].getObjectID());
                if (ind == null) continue;
                list.add(ind);
            }
            this.keys = list.toArray(new KeyObject[0]);
        }
    }

    public class ColumnMappingWr {
        public List mappings = new ArrayList();
        Column object;
        Table table;
    }
}

