/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.undo.relational;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.undo.UndoableEdit;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.IndexSet;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.undo.DesignObjectEdit;
import oracle.dbtools.crest.model.design.undo.UpdateDO_Edit;
import oracle.dbtools.crest.model.design.undo.relational.ColumnPreserver;
import oracle.dbtools.crest.model.design.undo.relational.ColumnRemoveEdit;
import oracle.dbtools.crest.model.design.undo.relational.FKCreateEdit;
import oracle.dbtools.crest.model.design.undo.relational.FKRemoveEdit;
import oracle.dbtools.crest.model.design.undo.relational.FKUpdateEdit;
import oracle.dbtools.crest.model.design.undo.relational.IndexRemoveEdit;
import oracle.dbtools.crest.model.design.undo.relational.memento.IndexMemento;

public class TableUpdateEdit
extends UpdateDO_Edit {
    private Table oldTableBackup;
    private Table oldTable;
    private Table newTable;
    private List removedColumnsEdit = new ArrayList();
    private List removedKeysEdit = new ArrayList();
    private List newColumns = new ArrayList();
    private List newIndexes = new ArrayList();
    private List newIndOrder = new ArrayList();
    private List oldIndOrder = new ArrayList();
    private List columnPreservers = new ArrayList();
    private boolean createEdits = true;
    private List<Index> indexesForUpdate;
    private List<FKIndexAssociation.FKMemento> fkMementosForUpdate;
    private List<FKIndexAssociation.FKMemento> fkMementosForCreate;
    private List<FKIndexAssociation.FKMemento> fkMementosForRemove;
    private List<DesignObjectEdit> fkEdits = new ArrayList<DesignObjectEdit>();
    List todelete = new ArrayList();
    List updatedIndexes = new ArrayList();
    List updatedColumns = new ArrayList();

    public TableUpdateEdit(Table oldTable, Table newTable, List<Index> indexesForUpdate, List<FKIndexAssociation.FKMemento> fkMementosForUpdate, List<FKIndexAssociation.FKMemento> fkMementosForCreate, List<FKIndexAssociation.FKMemento> fkMementosForRemove, List<Table.ColumnGroup> columnGroups) {
        super(oldTable);
        this.oldTableBackup = new Table(oldTable.getDesignPart());
        this.oldTable = oldTable;
        this.newTable = newTable;
        oldTable.backupTo(this.oldTableBackup);
        this.indexesForUpdate = indexesForUpdate;
        this.fkMementosForCreate = fkMementosForCreate;
        this.fkMementosForUpdate = fkMementosForUpdate;
        this.fkMementosForRemove = fkMementosForRemove;
    }

    @Override
    public void applyUpdates() {
        this.newTable.applyChangesTo(this.oldTable);
        this.changeStructure(this.createEdits);
        this.newTable.applyValidTimeDimensions(this.oldTable);
        this.newTable.applySpatialColumndefinitions(this.oldTable);
        this.createEdits = false;
    }

    @Override
    protected void restoreObject() {
        this.oldTableBackup.applyChangesTo(this.oldTable);
        this.restoreStructure();
        this.oldTableBackup.applyValidTimeDimensions(this.oldTable);
        this.oldTableBackup.applySpatialColumndefinitions(this.oldTable);
        for (int i = this.fkEdits.size() - 1; i > -1; --i) {
            this.fkEdits.get(i).undo();
        }
    }

    private void changeStructure(boolean createEdits) {
        this.changeColumns(createEdits);
        this.changeIndexes(createEdits);
        this.changeForeignKeys(createEdits);
        this.changeColumnGroups();
    }

    private void saveIndexOrder(List oldixs, List newixs) {
        for (Index index : oldixs) {
            this.oldIndOrder.add(index.getObjectID());
        }
        for (Index index : newixs) {
            this.newIndOrder.add(index.getObjectID());
        }
    }

    private void setIndexOrder(Table table, List index_IDs) {
        ArrayList<Index> list = new ArrayList<Index>();
        for (String id : index_IDs) {
            Index index = (Index)table.getKeySet().getObjectByID(id);
            if (index == null) continue;
            list.add(index);
        }
        ((IndexSet)table.getKeySet()).addAndApplyOrderFromList(list);
    }

    private void changeIndexes(boolean createEdits) {
        if (createEdits) {
            IndWr wr;
            for (Index index : this.indexesForUpdate) {
                if (index.isPK()) continue;
                index.restoreFromMemento(index.getIndexMemento());
            }
            List oldixs = this.oldTable.getAllInds_PK_UK_NoFKeys();
            List newixs = this.newTable.getAllInds_PK_UK_NoFKeys();
            this.saveIndexOrder(oldixs, newixs);
            this.todelete.clear();
            for (Index ind : oldixs) {
                Index indcopy;
                if (ind.isFK() || (indcopy = (Index)this.getObjectByID(newixs, ind.getObjectID())) == null && this.oldTable.isBST() && ind.isOidKey() && (indcopy = (Index)this.newTable.getOidKey()) == null && this.newTable.isBST()) continue;
                if (indcopy == null) {
                    this.todelete.add(ind);
                    continue;
                }
                wr = new IndWr();
                wr.old = ind;
                wr.omem = ind.getIndexMemento();
                wr.nmem = indcopy.getIndexMemento();
                if (!this.oldTable.getAppView().getXMLTransformationManager().equal(ind, indcopy, false)) {
                    wr.old.restoreFromMemento(wr.nmem);
                }
                wr.old.setMarkedGenerate(wr.nmem.generate_in_DDL);
                this.updatedIndexes.add(wr);
            }
            for (Index index : this.todelete) {
                IndexRemoveEdit ie = new IndexRemoveEdit(index);
                ie.end();
                this.removedKeysEdit.add(ie);
                index.remove();
            }
            for (Index newind : newixs) {
                Index oldind = (Index)this.getObjectByID(oldixs, newind.getObjectID());
                if (oldind == null && this.oldTable.isBST() && newind.isOidKey()) {
                    oldind = (Index)this.oldTable.getOidKey();
                }
                if (oldind == null) {
                    wr = new IndWr();
                    wr.old = this.oldTable.createIndex(newind.getObjectID());
                    wr.nmem = newind.getIndexMemento();
                    wr.old.restoreFromMemento(wr.nmem);
                    this.newIndexes.add(wr);
                }
                if (!newind.isFK()) continue;
            }
        } else {
            for (IndWr wr : this.newIndexes) {
                wr.old.setContainerObject(this.oldTable);
                wr.old.restoreFromMemento(wr.nmem);
                this.oldTable.add(wr.old);
            }
            for (IndWr wr : this.updatedIndexes) {
                wr.old.restoreFromMemento(wr.nmem);
            }
            for (int i = 0; i < this.removedKeysEdit.size(); ++i) {
                UndoableEdit edit = (UndoableEdit)this.removedKeysEdit.get(i);
                edit.redo();
            }
        }
        this.setIndexOrder(this.oldTable, this.newIndOrder);
    }

    private void changeColumns(boolean createEdits) {
        Object[] cols_old = this.oldTable.getElements();
        Object[] cols_new = this.newTable.getElements();
        if (createEdits) {
            this.todelete.clear();
            for (int i = 0; i < cols_old.length; ++i) {
                Column col = (Column)cols_old[i];
                Column colcopy = (Column)this.getObjectByID(cols_new, col.getObjectID());
                if (colcopy == null && this.oldTable.isBST()) {
                    colcopy = col.isOid() ? (Column)this.oldTable.getOidElement() : (Column)this.getObjectByStructAttributeID(cols_new, col.getStructAttributeID());
                }
                if (colcopy == null) {
                    this.todelete.add(col);
                    continue;
                }
                ColWr wr = new ColWr();
                wr.old = col;
                wr.upd = colcopy;
                wr.bckup = (Column)this.oldTableBackup.getElementByID(col.getObjectID());
                wr.upd.copy(wr.old);
                wr.newpos = colcopy.getIndex();
                wr.oldpos = col.getIndex();
                this.updatedColumns.add(wr);
            }
            for (Column col : this.todelete) {
                ColumnRemoveEdit ce = new ColumnRemoveEdit(col);
                ce.end();
                this.removedColumnsEdit.add(ce);
                col.remove();
            }
            for (int i = 0; i < cols_new.length; ++i) {
                Column newcol = (Column)cols_new[i];
                Column col = (Column)this.getObjectByID(cols_old, newcol.getObjectID());
                if (col == null && this.oldTable.isBST()) {
                    if (newcol.isOid()) {
                        col = (Column)this.oldTable.getOidElement();
                    } else {
                        String id = newcol.getStructAttributeID();
                        if (id != null && !"".equals(id)) {
                            col = (Column)this.oldTable.getElementByStructAttributeID(id);
                        }
                    }
                }
                if (col != null) continue;
                Column column = this.oldTable.createColumn(newcol.getName(), newcol.getObjectID());
                newcol.copy(column);
                this.newColumns.add(column);
                column.moveToIndex(i);
            }
            for (ColWr wr : this.updatedColumns) {
                wr.old.moveToIndex(wr.newpos);
            }
            for (Column column : this.newColumns) {
                ColumnPreserver cp = new ColumnPreserver(column);
                this.columnPreservers.add(cp);
            }
        } else {
            for (ColWr wr : this.updatedColumns) {
                wr.upd.copy(wr.old);
                wr.old.moveToIndex(wr.newpos);
            }
            for (int i = 0; i < this.removedColumnsEdit.size(); ++i) {
                UndoableEdit edit = (UndoableEdit)this.removedColumnsEdit.get(i);
                edit.redo();
            }
            for (ColumnPreserver cp : this.columnPreservers) {
                cp.restore();
            }
        }
    }

    private void changeColumnGroups() {
        List colGroups_new = this.newTable.getColumnGroupsSet();
        Iterator it = colGroups_new.iterator();
        this.oldTable.getColumnGroupsSet().clear();
        while (it.hasNext()) {
            Table.ColumnGroup columnGrupOld = (Table.ColumnGroup)it.next();
            Table table = this.newTable;
            table.getClass();
            Table.ColumnGroup columnGrupNew = table.new Table.ColumnGroup(columnGrupOld.getName());
            columnGrupOld.copy(columnGrupNew);
            this.oldTable.addColumnGroup(columnGrupNew);
        }
    }

    private void changeForeignKeys(boolean createEdits) {
        if (createEdits) {
            this.createForeignKeyEdits();
        } else {
            for (DesignObjectEdit fkEdit : this.fkEdits) {
                fkEdit.redo();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createForeignKeyEdits() {
        FKIndexAssociation fk;
        if (!this.fkMementosForCreate.isEmpty()) {
            boolean propagatePKChahges = this.oldTable.getDesign().isPropagatePKChahges();
            try {
                this.oldTable.getDesign().setPropagatePKChahges(false);
                for (FKIndexAssociation.FKMemento fkMemento : this.fkMementosForCreate) {
                    fk = fkMemento.fk;
                    fk.resetFromMemento(fkMemento);
                    this.oldTable.getKeySet().remove(fk.getLocalFKIndex());
                    Index ind = (Index)fkMemento.remoteTable.getKeyObject(fkMemento.remoteKeyID);
                    FKIndexAssociation nfk = this.oldTable.addFK(ind);
                    nfk.setObjectID(fk.getObjectID());
                    fk.restoreToCandidateOrigFK(nfk, fkMemento.dpv);
                    nfk.resetEdgeParams();
                    this.addFKCreateEdit(nfk);
                }
            }
            finally {
                this.oldTable.getDesign().setPropagatePKChahges(propagatePKChahges);
                this.fkMementosForCreate.clear();
            }
        }
        if (!this.fkMementosForUpdate.isEmpty()) {
            Object[] fkeys = this.oldTable.getFKAssociations();
            for (FKIndexAssociation.FKMemento fkMemento : this.fkMementosForUpdate) {
                fk = (FKIndexAssociation)this.getObjectByID(fkeys, fkMemento.fk.getObjectID());
                if (fk != null) {
                    FKIndexAssociation fKIndexAssociation = fk;
                    fKIndexAssociation.getClass();
                    FKIndexAssociation.FKMemento newmem = fKIndexAssociation.new FKIndexAssociation.FKMemento(fk);
                    String oldStatus = fk.getAppView().getXMLTransformationManager().getFilteredXMLString(fk);
                    fkMemento.copyTo(newmem);
                    FKUpdateEdit edit = new FKUpdateEdit(fk, newmem);
                    edit.end();
                    edit.applyUpdates();
                    String newStatus = fk.getAppView().getXMLTransformationManager().getFilteredXMLString(fk);
                    if (!oldStatus.equals(newStatus)) {
                        fk.setDirty(true);
                    }
                    this.fkEdits.add(edit);
                    continue;
                }
                FKUpdateEdit edit = this.addFKUpdateEdit(fkMemento);
                edit.applyUpdates();
            }
            this.fkMementosForUpdate.clear();
        }
        try {
            for (FKIndexAssociation.FKMemento fkMemento : this.fkMementosForRemove) {
                FKIndexAssociation originatingFK = fkMemento.fk.getOriginatingFK();
                this.addFKRemoveEdit(originatingFK);
                this.oldTable.removeFKAssociation(originatingFK);
            }
        }
        finally {
            this.fkMementosForRemove.clear();
        }
    }

    private Object getObjectByID(Object[] objects, String id) {
        for (int i = 0; i < objects.length; ++i) {
            if (!(objects[i] instanceof ModelIDObject) || !((ModelIDObject)objects[i]).getObjectID().equals(id)) continue;
            return objects[i];
        }
        return null;
    }

    private Object getObjectByStructAttributeID(Object[] objects, String id) {
        for (int i = 0; i < objects.length; ++i) {
            if (!(objects[i] instanceof ContainedObject) || !((ContainedObject)objects[i]).getStructAttributeID().equals(id)) continue;
            return objects[i];
        }
        return null;
    }

    private Object getObjectByID(List objects, String id) {
        for (Object object : objects) {
            if (!(object instanceof ModelIDObject) || !((ModelIDObject)object).getObjectID().equals(id)) continue;
            return object;
        }
        return null;
    }

    private void restoreStructure() {
        UndoableEdit edit;
        for (Column column : this.newColumns) {
            column.remove();
        }
        for (int i = this.removedColumnsEdit.size() - 1; i > -1; --i) {
            edit = (UndoableEdit)this.removedColumnsEdit.get(i);
            edit.undo();
        }
        for (ColWr wr : this.updatedColumns) {
            wr.bckup.copy(wr.old);
            wr.old.moveToIndex(wr.oldpos);
        }
        for (IndWr wr : this.newIndexes) {
            wr.old.remove();
        }
        for (IndWr wr : this.updatedIndexes) {
            wr.old.restoreFromMemento(wr.omem);
            wr.old.setIndexState(wr.bckstate);
        }
        for (int i = this.removedKeysEdit.size() - 1; i > -1; --i) {
            edit = (UndoableEdit)this.removedKeysEdit.get(i);
            edit.undo();
        }
        this.setIndexOrder(this.oldTable, this.oldIndOrder);
    }

    public FKUpdateEdit addFKUpdateEdit(FKIndexAssociation.FKMemento fkMemento) {
        FKUpdateEdit edit = new FKUpdateEdit(fkMemento.fk, fkMemento);
        edit.end();
        this.fkEdits.add(edit);
        return edit;
    }

    public FKCreateEdit addFKCreateEdit(FKIndexAssociation fk) {
        FKCreateEdit edit = new FKCreateEdit(fk);
        edit.end();
        this.fkEdits.add(edit);
        return edit;
    }

    public FKRemoveEdit addFKRemoveEdit(FKIndexAssociation fk) {
        FKRemoveEdit edit = new FKRemoveEdit(fk);
        edit.end();
        this.fkEdits.add(edit);
        return edit;
    }

    class ColWr {
        Column old;
        Column upd;
        Column bckup;
        int newpos;
        int oldpos;

        ColWr() {
        }
    }

    class IndWr {
        Index old;
        Index upd;
        Index bckup;
        IndexMemento omem;
        IndexMemento nmem;
        String bckstate;

        IndWr() {
        }
    }
}

