/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules;

import java.text.MessageFormat;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.swing.JOptionPane;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.DRLibrary;
import oracle.dbtools.crest.model.designrules.DesignRule;
import oracle.dbtools.crest.util.GUID;

public class DRCustomScript
extends DesignRule {
    protected String name;
    protected String ruleId;
    protected String purpose;
    protected String object;
    protected String engineName;
    protected String script;
    protected String variable;
    protected DRLibrary library;
    protected String function;
    protected String resultType;
    protected ScriptEngineManager scriptEngineManager;
    protected boolean hasEvalError = false;
    protected ScriptEngine engine;
    protected Compilable compilingEngine;
    public CompiledScript compiledScript;
    protected boolean eval = false;

    public DRCustomScript(String name, String ruleId, String purp) {
        if (ruleId == null || ruleId.trim().length() == 0) {
            ruleId = new GUID().toString();
        }
        this.name = name;
        this.ruleId = ruleId;
        this.purpose = purp;
        this.setDescription(this.getName());
    }

    public DRCustomScript(String name, String ruleId, String purp, String object, String engine, String script, String variable, ScriptEngineManager scriptEngineManager, DRLibrary library, String function) {
        this(name, ruleId, purp);
        this.object = object;
        this.engineName = engine;
        this.script = script;
        this.variable = variable;
        this.scriptEngineManager = scriptEngineManager;
        this.library = library;
        this.function = function;
    }

    @Override
    public void init() {
        this.hasEvalError = false;
        this.eval = false;
        this.compiledScript = null;
        this.engine = this.scriptEngineManager.getEngineByName(this.getEngineName());
    }

    @Override
    public CheckResult doCheck(Object object) {
        block13: {
            try {
                if (this.engine == null) {
                    this.engine = this.scriptEngineManager.getEngineByName(this.getEngineName());
                }
                this.engine.put(this.getVariable(), object);
                if (this.getLibrary() == null) {
                    if (this.engine instanceof Compilable) {
                        if (this.compiledScript == null) {
                            this.compilingEngine = (Compilable)((Object)this.engine);
                            this.compiledScript = this.compilingEngine.compile(this.getScript());
                        }
                        this.compiledScript.eval();
                    } else {
                        this.engine.eval(this.getScript());
                    }
                    break block13;
                }
                if (this.engine instanceof Compilable) {
                    if (this.compiledScript == null) {
                        this.compilingEngine = (Compilable)((Object)this.engine);
                        this.compiledScript = this.compilingEngine.compile(this.getLibrary().getScript());
                    }
                    if (this.engine instanceof Invocable) {
                        if (!this.eval) {
                            this.engine.eval(this.getLibrary().getScript());
                            this.eval = true;
                        }
                        Invocable invokeEngine = (Invocable)((Object)this.engine);
                        invokeEngine.invokeFunction(this.getFunction(), object);
                        break block13;
                    }
                    JOptionPane.showMessageDialog(null, MessageFormat.format(Messages.getString("DRCustomScript.EnginNotSupportingInvocable"), this.getEngineName()), Messages.getString("DRCustomScript.Error"), 0);
                    this.hasEvalError = true;
                    return null;
                }
                if (this.engine instanceof Invocable) {
                    this.engine.eval(this.getLibrary().getScript());
                    Invocable invokeEngine = (Invocable)((Object)this.engine);
                    invokeEngine.invokeFunction(this.getFunction(), object);
                    break block13;
                }
                JOptionPane.showMessageDialog(null, MessageFormat.format(Messages.getString("DRCustomScript.EnginNotSupportingInvocable"), this.getEngineName()), Messages.getString("DRCustomScript.Error"), 0);
                this.hasEvalError = true;
                return null;
            }
            catch (ScriptException ex) {
                JOptionPane.showMessageDialog(null, Messages.getString("DRCustomScript.EvaluateError") + "\n\nName     : " + this.getName() + "\n\nLine        : " + ex.getLineNumber() + "\nColumn   : " + ex.getColumnNumber() + "\nMessage : " + ex.getMessage(), Messages.getString("DRCustomScript.Error"), 0);
                this.hasEvalError = true;
                return null;
            }
            catch (NoSuchMethodException e) {
                JOptionPane.showMessageDialog(null, MessageFormat.format(Messages.getString("DRCustomScript.NoSuchMethod"), this.getFunction()), Messages.getString("DRCustomScript.Error"), 0);
                this.hasEvalError = true;
                return null;
            }
        }
        return null;
    }

    @Override
    public String getRuleId() {
        return this.ruleId;
    }

    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }

    @Override
    public int getType() {
        if ("Error".equalsIgnoreCase(this.getResultType())) {
            return 0;
        }
        if ("Warning".equalsIgnoreCase(this.getResultType())) {
            return 1;
        }
        return 2;
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public String getPurpose() {
        return this.purpose;
    }

    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    public String getObject() {
        return this.object;
    }

    public void setObject(String object) {
        this.object = object;
    }

    public String getEngineName() {
        return this.engineName;
    }

    public void setEngineName(String engineName) {
        this.engineName = engineName;
    }

    public String getVariable() {
        return this.variable;
    }

    public void setVariable(String variable) {
        this.variable = variable;
    }

    public DRLibrary getLibrary() {
        return this.library;
    }

    public void setLibrary(DRLibrary library) {
        this.library = library;
    }

    public String getFunction() {
        return this.function;
    }

    public void setFunction(String function) {
        this.function = function;
    }

    public void setScriptEngineManager(ScriptEngineManager scriptEngineManager) {
        this.scriptEngineManager = scriptEngineManager;
    }

    public boolean hasEvalError() {
        return this.hasEvalError;
    }

    public String getResultType() {
        return this.resultType;
    }

    public void setResultType(String resultType) {
        this.resultType = resultType;
    }

    public DRCustomScript copy() {
        return new DRCustomScript(this.name, this.ruleId, this.purpose, this.object, this.engineName, this.script, this.variable, this.scriptEngineManager, this.library, this.function);
    }
}

