/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.CompositeRuleHandler;
import oracle.dbtools.crest.model.designrules.DRCustomScript;
import oracle.dbtools.crest.model.designrules.DRCustomValidationScript;
import oracle.dbtools.crest.model.designrules.RuleHandler;
import oracle.dbtools.crest.model.designrules.RuleNode;
import oracle.dbtools.crest.model.designrules.domains.RHDomain;
import oracle.dbtools.crest.model.designrules.logical.RHAttribute;
import oracle.dbtools.crest.model.designrules.logical.RHEntity;
import oracle.dbtools.crest.model.designrules.logical.RHEntityView;
import oracle.dbtools.crest.model.designrules.logical.RHKey;
import oracle.dbtools.crest.model.designrules.process.RHAgent;
import oracle.dbtools.crest.model.designrules.process.RHFlow;
import oracle.dbtools.crest.model.designrules.process.RHProcess;
import oracle.dbtools.crest.model.designrules.process.RHStore;
import oracle.dbtools.crest.model.designrules.process.RHTransformation;
import oracle.dbtools.crest.model.designrules.process.RHTransformationTask;
import oracle.dbtools.crest.model.designrules.relational.RHColumn;
import oracle.dbtools.crest.model.designrules.relational.RHIndex;
import oracle.dbtools.crest.model.designrules.relational.RHTable;
import oracle.dbtools.crest.model.designrules.relational.RHTableLevelConstraint;
import oracle.dbtools.crest.model.designrules.relational.RHView;
import oracle.dbtools.crest.model.propertyholder.functionality.UpdateListener;
import oracle.dbtools.crest.model.propertyholder.functionality.UpdateSubject;
import oracle.dbtools.crest.model.propertyholder.functionality.UpdateSubjectImpl;
import oracle.dbtools.crest.swingui.ApplicationView;

public class DesignRuleManager
implements RuleNode,
UpdateSubject {
    public static final int FILTER_ALL = 0;
    public static final int FILTER_FAIL_WARN = 1;
    public static final int FILTER_FAIL = 2;
    private int filtering = 0;
    private UpdateSubjectImpl delegate = new UpdateSubjectImpl();
    private RuleHandler firstHandler = null;
    private Design design;
    private RuleHandler logicalRH = null;
    private RuleHandler relationalRH = null;
    private RuleHandler generalRH = null;
    private CompositeRuleHandler physicalRH = null;
    private RuleHandler processModelRH = null;
    private RelationalDesign relDesign;
    private DataFlowDesign dataFlowDesign;
    private RHTable tableRH;
    private RHColumn columnRH;
    private RHIndex indexRH;
    private RHView viewRH;
    private RHTableLevelConstraint constrRH;
    private RHProcess processRH;
    private RHAgent agentRH;
    private RHStore storeRH;
    private RHFlow flowRH;
    private RHTransformation transformationRH;
    private RHTransformationTask trTaskRH;
    private TreeMap<String, Object> objects = new TreeMap();
    private ArrayList<DRCustomScript> tempListCustomDR = new ArrayList();
    private ApplicationView appView;
    public boolean res;

    public DesignRuleManager(Design design, RelationalDesign relDesign, ApplicationView appView) {
        this.appView = appView;
        this.design = design;
        this.relDesign = relDesign;
        this.initChain();
    }

    public Design getDesign() {
        return this.design;
    }

    protected void initChain() {
        CompositeRuleHandler rhGeneral = new CompositeRuleHandler();
        rhGeneral.setLabel("General");
        RHDomain domainRH = new RHDomain();
        domainRH.setRuleSubjectSet(this.getDesign().getDomainSet());
        rhGeneral.add(domainRH);
        this.addRuleHandler(rhGeneral);
        this.generalRH = rhGeneral;
        CompositeRuleHandler rhLogical = new CompositeRuleHandler();
        rhLogical.setLabel("Logical");
        RHEntity entityRH = new RHEntity();
        entityRH.setRuleSubjectSet(this.getDesign().getLogicalDesign().getEntitySet());
        rhLogical.add(entityRH);
        RHAttribute attributeRH = new RHAttribute();
        attributeRH.setRuleSubjectSet(this.getDesign().getLogicalDesign().getAttributeSet());
        rhLogical.add(attributeRH);
        RHKey keyRH = new RHKey();
        keyRH.setRuleSubjectSet(this.getDesign().getLogicalDesign().getGlobalCandidateKeySet());
        rhLogical.add(keyRH);
        RHEntityView entityViewRH = new RHEntityView();
        entityViewRH.setRuleSubjectSet(this.getDesign().getLogicalDesign().getEntityViewSet());
        rhLogical.add(entityViewRH);
        this.logicalRH = rhLogical;
        this.addRuleHandler(rhLogical);
        if (this.relDesign != null) {
            CompositeRuleHandler rhRelational = new CompositeRuleHandler();
            rhRelational.setLabel("Relational");
            this.tableRH = new RHTable();
            this.tableRH.setRuleSubjectSet(this.getTableSet());
            rhRelational.add(this.tableRH);
            this.columnRH = new RHColumn();
            this.columnRH.setRuleSubjectSet(this.getColumnSet());
            rhRelational.add(this.columnRH);
            this.indexRH = new RHIndex();
            this.indexRH.setRuleSubjectSet(this.getGlobalIndexSet());
            rhRelational.add(this.indexRH);
            this.constrRH = new RHTableLevelConstraint();
            this.constrRH.setRuleSubjectSet(this.getConstraintSet());
            rhRelational.add(this.constrRH);
            this.viewRH = new RHView();
            this.viewRH.setRuleSubjectSet(this.getTableViewSet());
            rhRelational.add(this.viewRH);
            this.relationalRH = rhRelational;
            this.addRuleHandler(rhRelational);
        }
        CompositeRuleHandler rhProcess = new CompositeRuleHandler();
        rhProcess.setLabel("Process Model");
        this.processRH = new RHProcess();
        this.processRH.setRuleSubjectSet(this.getAllProcesses());
        rhProcess.add(this.processRH);
        this.flowRH = new RHFlow();
        this.flowRH.setRuleSubjectSet(this.getAllFlows());
        rhProcess.add(this.flowRH);
        this.storeRH = new RHStore();
        this.storeRH.setRuleSubjectSet(this.getAllStores());
        rhProcess.add(this.storeRH);
        this.agentRH = new RHAgent();
        this.agentRH.setRuleSubjectSet(this.getAllAgents());
        rhProcess.add(this.agentRH);
        this.transformationRH = new RHTransformation();
        this.transformationRH.setRuleSubjectSet(this.getDesign().getProcessModel().getTransformations());
        rhProcess.add(this.transformationRH);
        this.trTaskRH = new RHTransformationTask();
        this.trTaskRH.setRuleSubjectSet(this.getDesign().getProcessModel().getAllTransformationTasks());
        rhProcess.add(this.trTaskRH);
        this.processModelRH = rhProcess;
        this.addRuleHandler(rhProcess);
        if (this.relDesign != null) {
            CompositeRuleHandler rhPhysical = new CompositeRuleHandler();
            rhPhysical.setLabel("Physical");
            this.physicalRH = rhPhysical;
            this.addRuleHandler(rhPhysical);
        }
        this.addObject(attributeRH, "Attribute");
        this.addObject(entityRH, "Entity");
        this.addObject(keyRH, "Key");
        this.addObject(this.viewRH, "View");
        this.addObject(this.agentRH, "External Agent");
        this.addObject(this.flowRH, "Information Flow");
        this.addObject(this.storeRH, "Information Store");
        this.addObject(this.processRH, "Process");
        this.addObject(this.trTaskRH, "Transformation Task");
        this.addObject(this.transformationRH, "Transformation");
        this.addObject(this.columnRH, "Column");
        this.addObject(domainRH, "Domain");
        this.addObject(this.indexRH, "Index/Constraint");
        this.addObject(this.constrRH, "Table Level Constraint");
        this.addObject(this.tableRH, "Table");
        this.addRemoveCustomRules();
    }

    public void addRemoveCustomRules() {
        ArrayList<DRCustomScript> currentCustomRules = this.appView.getCustomDesignRules();
        for (DRCustomValidationScript dRCustomValidationScript : new ArrayList<DRCustomScript>(this.tempListCustomDR)) {
            if (currentCustomRules.contains(dRCustomValidationScript)) continue;
            RuleHandler rh1 = dRCustomValidationScript.getRuleHandler();
            rh1.removeRule(dRCustomValidationScript);
            dRCustomValidationScript.setRuleHandler(null);
            this.tempListCustomDR.remove(dRCustomValidationScript);
        }
        for (DRCustomScript ob : currentCustomRules) {
            RuleHandler rh;
            DRCustomValidationScript drcs;
            if (!(ob instanceof DRCustomValidationScript) || this.tempListCustomDR.contains(drcs = (DRCustomValidationScript)ob)) continue;
            drcs.setRuleHandler((RuleHandler)this.objects.get(drcs.getObject()));
            if (drcs.getPurpose().equals("validation") && (rh = drcs.getRuleHandler()) != null) {
                rh.addRule(drcs);
            }
            this.tempListCustomDR.add(drcs);
        }
    }

    private void resetRuleSubjectSets() {
        this.tableRH.setRuleSubjectSet(this.getTableSet());
        this.columnRH.setRuleSubjectSet(this.getColumnSet());
        this.indexRH.setRuleSubjectSet(this.getGlobalIndexSet());
        this.constrRH.setRuleSubjectSet(this.getConstraintSet());
        this.viewRH.setRuleSubjectSet(this.getTableViewSet());
        this.physicalRH.clear();
        StorageDesign[] openedSD = this.relDesign.getStorageDesignFactory().getOpenStorageDesigns();
        for (int i = 0; i < openedSD.length; ++i) {
            StorageDesign sd = openedSD[i];
            this.physicalRH.add(sd.getRuleHandler());
        }
    }

    private void resetProcessRuleSubjectSets() {
        this.processRH.setRuleSubjectSet(this.getAllProcesses());
        this.agentRH.setRuleSubjectSet(this.getAllAgents());
        this.storeRH.setRuleSubjectSet(this.getAllStores());
        this.flowRH.setRuleSubjectSet(this.getAllFlows());
        this.resetTransformationRuleSubjectSets();
        this.resetTrTaskRuleSubjectSets();
    }

    private void resetTransformationRuleSubjectSets() {
        this.transformationRH.setRuleSubjectSet(this.getDesign().getProcessModel().getTransformations());
    }

    private void resetTrTaskRuleSubjectSets() {
        this.trTaskRH.setRuleSubjectSet(this.getDesign().getProcessModel().getAllTransformationTasks());
    }

    public RuleHandler getLogicalRuleHandler() {
        return this.logicalRH;
    }

    public RuleHandler getRelationalRuleHandler() {
        return this.relationalRH;
    }

    public CompositeRuleHandler getPhysicalRuleHandler() {
        return this.physicalRH;
    }

    public RuleHandler getProcessModelRuleHandler() {
        return this.processModelRH;
    }

    public RuleHandler getGeneralRuleHandler() {
        return this.generalRH;
    }

    public void addRuleHandler(RuleHandler ruleHandler) {
        if (this.firstHandler == null) {
            this.firstHandler = ruleHandler;
        } else {
            this.firstHandler.append(ruleHandler);
        }
        this.fireUpdate();
    }

    public void handle(Object object, Collection results) {
        this.firstHandler.handle(object, results);
    }

    @Override
    public int size() {
        if (this.firstHandler == null) {
            return 0;
        }
        return this.firstHandler.getIndexInList(0);
    }

    @Override
    public Object getElement(int index) {
        if (this.firstHandler == null) {
            return null;
        }
        return this.firstHandler.getNthInList(index);
    }

    @Override
    public int getIndexFor(Object child) {
        if (this.firstHandler == null) {
            return -1;
        }
        if (child instanceof RuleHandler) {
            return this.firstHandler.getIndexInListFor((RuleHandler)child, -1);
        }
        return -1;
    }

    @Override
    public void addUpdateListener(UpdateListener listener) {
        this.delegate.addUpdateListener(listener);
    }

    @Override
    public void removeUpdateListener(UpdateListener listener) {
        this.delegate.removeUpdateListener(listener);
    }

    protected void fireUpdate() {
        this.delegate.fireChange();
    }

    public Collection applyRulesToSubject() {
        Collection checkResults = this.createCollection();
        for (int i = 0; i < this.size(); ++i) {
            RuleHandler rh = (RuleHandler)this.getElement(i);
            rh.applyRulesToSubject(checkResults);
            if (!rh.hasEvalErr) continue;
            this.res = rh.hasEvalErr;
            break;
        }
        return checkResults;
    }

    public void setFilterLevel(int value) {
        this.filtering = value;
    }

    public int getFilterLevel() {
        return this.filtering;
    }

    public Collection createCollection() {
        switch (this.getFilterLevel()) {
            case 2: {
                return new FilterOkWarningList();
            }
            case 1: {
                return new FilterOkList();
            }
        }
        return new ArrayList();
    }

    public void setRelDesign(RelationalDesign relDesign) {
        this.relDesign = relDesign;
        if (relDesign != null) {
            this.resetRuleSubjectSets();
        }
    }

    public void setDataFlowDesign(DataFlowDesign dfd) {
        this.dataFlowDesign = dfd;
        this.resetProcessRuleSubjectSets();
    }

    private DesignObjectSet getTableSet() {
        if (this.relDesign != null) {
            return this.relDesign.getTableSet();
        }
        return null;
    }

    private DesignObjectSet getColumnSet() {
        if (this.relDesign != null) {
            return this.relDesign.getColumnSet();
        }
        return null;
    }

    private ModelObjectSet getGlobalIndexSet() {
        if (this.relDesign != null) {
            return this.relDesign.getGlobalIndexSet();
        }
        return null;
    }

    private List getConstraintSet() {
        if (this.relDesign != null) {
            ArrayList list = new ArrayList();
            Iterator it = this.relDesign.getTableSet().iterator();
            while (it.hasNext()) {
                Table table = (Table)it.next();
                list.addAll(table.getCheckConstraints());
            }
            return list;
        }
        return null;
    }

    private DesignObjectSet getTableViewSet() {
        if (this.relDesign != null) {
            return this.relDesign.getTableViewSet();
        }
        return null;
    }

    private List getAllProcesses() {
        if (this.dataFlowDesign != null) {
            return this.dataFlowDesign.getAllProcesses();
        }
        return null;
    }

    private DesignObjectSet getAllAgents() {
        if (this.dataFlowDesign != null) {
            return this.dataFlowDesign.getExternalAgentSet();
        }
        return null;
    }

    private DesignObjectSet getAllStores() {
        if (this.dataFlowDesign != null) {
            return this.dataFlowDesign.getInfoStoreSet();
        }
        return null;
    }

    private List getAllFlows() {
        if (this.dataFlowDesign != null) {
            return this.dataFlowDesign.getAllFlows();
        }
        return null;
    }

    public TreeMap<String, Object> getObjects() {
        return this.objects;
    }

    public void addObject(Object obj, String name) {
        this.getObjects().put(name, obj);
    }

    class FilterOkWarningList
    extends ArrayList {
        FilterOkWarningList() {
        }

        @Override
        public boolean add(Object object) {
            CheckResult cr = (CheckResult)object;
            if (cr.isOk() || cr.isWarning()) {
                return false;
            }
            return super.add(object);
        }
    }

    class FilterOkList
    extends ArrayList {
        FilterOkList() {
        }

        @Override
        public boolean add(Object object) {
            CheckResult cr = (CheckResult)object;
            if (cr.isOk()) {
                return false;
            }
            return super.add(object);
        }
    }
}

