/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxySet;
import oracle.dbtools.crest.model.designrules.DesignRule;
import oracle.dbtools.crest.model.designrules.DesignRuleSubjectSet;
import oracle.dbtools.crest.model.designrules.RuleNode;

public abstract class RuleHandler
implements RuleNode {
    public static final DesignRuleSubjectSet EMPTY_DESIGNRULE_SUBJECT_SET = new EmptyDesignRuleSubjectSet();
    public static final String GENERAL_PATH = "General";
    public static final String LOGICAL_PATH = "Logical";
    public static final String RELATIONAL_PATH = "Relational";
    public static final String PROCESSMODEL_PATH = "Process Model";
    public static final String PHYSICAL_PATH = "Physical";
    private static RuleHandler nullInstance;
    private RuleHandler successor;
    private List rules = new LinkedList();
    private String label = "Rules";
    private DesignRuleSubjectSet ruleSubjectSet = EMPTY_DESIGNRULE_SUBJECT_SET;
    public boolean hasEvalErr = false;

    public void append(RuleHandler succ) {
        if (this.successor == null) {
            this.successor = succ;
        } else {
            this.successor.append(succ);
        }
    }

    protected void doHandle(Object object, Collection results) {
        for (DesignRule rule : this.getRules()) {
            rule.collectCheckResults(results, object);
        }
    }

    protected void doHandleRule(Object object, Collection results, DesignRule rule) {
        rule.collectCheckResults(results, object);
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    protected abstract boolean canHandle(Object var1);

    public void handle(Object object, Collection results) {
        if (this.canHandle(object)) {
            this.doHandle(object, results);
        } else if (this.successor != null) {
            this.successor.handle(object, results);
        }
    }

    public void addRule(DesignRule rule) {
        rule.setRuleHandler(this);
        this.rules.add(rule);
    }

    public void removeRule(DesignRule rule) {
        this.rules.remove(rule);
    }

    public List getRules() {
        return Collections.unmodifiableList(this.rules);
    }

    public int getIndexInList(int count) {
        ++count;
        if (this.successor == null) {
            return count;
        }
        return this.successor.getIndexInList(count);
    }

    public RuleHandler getNthInList(int index) {
        if (--index == -1) {
            return this;
        }
        if (this.successor == null) {
            throw new IndexOutOfBoundsException("RuleHandler linked list");
        }
        return this.successor.getNthInList(index);
    }

    public int getIndexInListFor(RuleHandler handler, int count) {
        ++count;
        if (this.equals(handler)) {
            return count;
        }
        if (this.successor == null) {
            return -1;
        }
        return this.successor.getIndexInListFor(handler, count);
    }

    @Override
    public int size() {
        return this.rules.size();
    }

    @Override
    public Object getElement(int index) {
        return this.rules.get(index);
    }

    @Override
    public int getIndexFor(Object child) {
        return this.rules.indexOf(child);
    }

    public static RuleHandler getNullInstance() {
        if (nullInstance == null) {
            nullInstance = new RuleHandler(){

                @Override
                protected boolean canHandle(Object object) {
                    return false;
                }
            };
        }
        return nullInstance;
    }

    public void setRuleSubjectSet(DesignObjectSet set) {
        if (set != null) {
            this.setRuleSubjectSet(new DesignObjectSetWrapper(set));
        } else {
            this.ruleSubjectSet = EMPTY_DESIGNRULE_SUBJECT_SET;
        }
    }

    public void setRuleSubjectSet(ModelObjectSet set) {
        if (set != null) {
            this.setRuleSubjectSet(new ModelObjectSetWrapper(set));
        } else {
            this.ruleSubjectSet = EMPTY_DESIGNRULE_SUBJECT_SET;
        }
    }

    public void setRuleSubjectSet(RelationalObjectProxySet set) {
        if (set != null) {
            this.setRuleSubjectSet(new PhysicalObjectProxySetWrapper(set));
        }
    }

    public void setRuleSubjectSet(List list) {
        if (list != null) {
            this.setRuleSubjectSet(new ListWrapper(list));
        } else {
            this.ruleSubjectSet = EMPTY_DESIGNRULE_SUBJECT_SET;
        }
    }

    public void setRuleSubjectSet(DesignRuleSubjectSet set) {
        this.ruleSubjectSet = set == null ? EMPTY_DESIGNRULE_SUBJECT_SET : set;
    }

    public Collection applyRulesToSubject() {
        ArrayList checkResults = new ArrayList();
        return this.applyRulesToSubject(checkResults);
    }

    public Collection applyRulesToSubject(Collection checkResults) {
        Iterator it = this.ruleSubjectSet.getDesignRuleSubjects();
        while (it.hasNext()) {
            Object object = it.next();
            if (this.hasEvalErr) break;
            if (!this.canHandle(object)) continue;
            this.doHandle(object, checkResults);
        }
        return checkResults;
    }

    public Collection applyRule(Collection checkResults, DesignRule rule) {
        rule.init();
        Iterator it = this.ruleSubjectSet.getDesignRuleSubjects();
        while (it.hasNext()) {
            Object object = it.next();
            if (this.hasEvalErr) break;
            if (!this.canHandle(object)) continue;
            this.doHandleRule(object, checkResults, rule);
        }
        return checkResults;
    }

    private static class ListWrapper
    implements DesignRuleSubjectSet {
        private List list;

        private ListWrapper(List list) {
            this.list = list;
        }

        @Override
        public Iterator getDesignRuleSubjects() {
            return this.list.iterator();
        }
    }

    private static class DesignObjectSetWrapper
    implements DesignRuleSubjectSet {
        private DesignObjectSet set;

        private DesignObjectSetWrapper(DesignObjectSet set) {
            this.set = set;
        }

        @Override
        public Iterator getDesignRuleSubjects() {
            return this.set.iterator();
        }
    }

    private static class ModelObjectSetWrapper
    implements DesignRuleSubjectSet {
        private ModelObjectSet set;

        private ModelObjectSetWrapper(ModelObjectSet set) {
            this.set = set;
        }

        @Override
        public Iterator getDesignRuleSubjects() {
            return this.set.iterator();
        }
    }

    private static class PhysicalObjectProxySetWrapper
    implements DesignRuleSubjectSet {
        private RelationalObjectProxySet set;

        private PhysicalObjectProxySetWrapper(RelationalObjectProxySet set) {
            this.set = set;
        }

        @Override
        public Iterator getDesignRuleSubjects() {
            return Collections.unmodifiableCollection(this.set.getObjectCollection()).iterator();
        }
    }

    static class EmptyDesignRuleSubjectSet
    implements DesignRuleSubjectSet {
        EmptyDesignRuleSubjectSet() {
        }

        @Override
        public Iterator getDesignRuleSubjects() {
            return Collections.EMPTY_LIST.iterator();
        }
    }
}

