/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.relational;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.DesignRule;

public class DRColumnCircularRef
extends DesignRule {
    private final String RULE_ID = "BB3763EB-43B2-4C1C-60DB-A68592F83F74";
    private Column testedColumn;
    private Column lastChecked;
    List checkedCols;

    public DRColumnCircularRef() {
        this.setName(Messages.getString("DRColumnCircularRef.IdentifyCircularReferingColumns"));
        this.setDescription(Messages.getString("DRColumnCircularRef.ClumnCircularReferenceIsNotAllowed"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        this.testedColumn = (Column)object;
        boolean circRef = this.hasCircularRef();
        if (circRef) {
            return CheckResult.createFailed(object, this, MessageFormat.format(Messages.getString("DRColumnCircularRef.ColumnsHaveCircularreference"), this.testedColumn.getLongName(), this.lastChecked.getLongName()));
        }
        return CheckResult.createOk(object, this, Messages.getString("DRColumnCircularRef.ColumnDoesntHaveCircularReferences"));
    }

    @Override
    public int getType() {
        return 0;
    }

    private boolean hasCircularRef() {
        this.checkedCols = new ArrayList();
        if (this.testedColumn.isFKColumn()) {
            for (Column.FKColRefNode snode : this.testedColumn.getRefColAndAssocIDs()) {
                Column refColumn = (Column)this.testedColumn.getDesign().getDesignObject(snode.refColumnId);
                if (refColumn == null) continue;
                this.lastChecked = refColumn;
                if (this.testedColumn == refColumn) {
                    return true;
                }
                if (this.checkedCols.contains(refColumn)) continue;
                this.checkedCols.add(refColumn);
                boolean found = this.testColumn(refColumn);
                if (!found) continue;
                return found;
            }
        }
        return false;
    }

    private boolean testColumn(Column col) {
        if (col.isFKColumn()) {
            for (Column.FKColRefNode snode : col.getRefColAndAssocIDs()) {
                Column refColumn = (Column)this.testedColumn.getDesign().getDesignObject(snode.refColumnId);
                if (refColumn == null) continue;
                if (this.testedColumn == refColumn) {
                    return true;
                }
                if (this.checkedCols.contains(refColumn)) continue;
                this.checkedCols.add(refColumn);
                boolean found = this.testColumn(refColumn);
                if (!found) continue;
                return found;
            }
        }
        return false;
    }

    @Override
    public String getRuleId() {
        return "BB3763EB-43B2-4C1C-60DB-A68592F83F74";
    }
}

