/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.relational;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.designrules.DesignRule;
import oracle.dbtools.crest.model.designrules.RuleHandler;
import oracle.dbtools.crest.model.designrules.relational.DRSpatialTable;
import oracle.dbtools.crest.model.designrules.relational.DRTableCaseType;
import oracle.dbtools.crest.model.designrules.relational.DRTableMaxNameLength;
import oracle.dbtools.crest.model.designrules.relational.DRTableNamingStandard;
import oracle.dbtools.crest.model.designrules.relational.DRTableNoColumns;
import oracle.dbtools.crest.model.designrules.relational.DRTableNoPK;
import oracle.dbtools.crest.model.designrules.relational.DRTableUndefinedColumnSecurity;
import oracle.dbtools.crest.model.designrules.relational.DRTableValidCharacters;

public class RHTable
extends RuleHandler {
    public RHTable() {
        this.initDesignRules();
    }

    protected void initDesignRules() {
        this.addRule(new DRTableNoColumns());
        this.addRule(new DRTableNoPK());
        this.addRule(new DRSpatialTable());
        this.addRule(new DRTableNamingStandard());
        this.addRule(new DRTableMaxNameLength());
        this.addRule(new DRTableCaseType());
        this.addRule(new DRTableValidCharacters());
        this.addRule(new DRTableUndefinedColumnSecurity());
    }

    @Override
    public void addRule(DesignRule rule) {
        rule.setContextString(this.getContextString());
        super.addRule(rule);
    }

    public String getContextString() {
        return "Relational";
    }

    @Override
    public String getLabel() {
        return Messages.getString("RHTable.Table");
    }

    @Override
    protected boolean canHandle(Object object) {
        return object instanceof Table || object instanceof TableProxy;
    }
}

