/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage.oracle;

import java.util.Iterator;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.IndexGlobalPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexGlobalPartitionSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.storage.AbstractDRStorageDesign;

public class DRGlobalPartitionMaxValueOracle
extends AbstractDRStorageDesign {
    private final String RULE_ID = "3756DDBF-CF5E-D3DE-0748-6F4F3BD8C5D1";

    public DRGlobalPartitionMaxValueOracle(StorageDesign storageDesign) {
        super(storageDesign);
        this.setName(Messages.getString("DRGlobalPartitionMaxValueOracle.SetGlobalPartitionValueList"));
        this.setDescription(Messages.getString("DRGlobalPartitionMaxValueOracle.ValueOfvalueListAlwaysMustBeMAXVALUE"));
    }

    private boolean isLastPartition(IndexGlobalPartitionOracle partition) {
        if (partition.getIndexGlobalPartList() != null) {
            IndexGlobalPartitionSetOracle partitionSet = ((StorageDesignOracle)partition.getStorageDesign()).getIndexGlobalPartitionSet();
            Iterator it = partitionSet.iterator();
            while (it.hasNext()) {
                IndexGlobalPartitionOracle indexPartition = (IndexGlobalPartitionOracle)it.next();
                if (indexPartition.getIndexGlobalPartList() == null || !indexPartition.getIndexGlobalPartList().equals(partition.getIndexGlobalPartList()) || indexPartition.getPosition() <= partition.getPosition()) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    @Override
    public CheckResult doCheck(Object object) {
        IndexGlobalPartitionOracle partition = (IndexGlobalPartitionOracle)object;
        if (this.isLastPartition(partition)) {
            if ("MAXVALUE".equalsIgnoreCase(partition.getValueList())) {
                return CheckResult.createOk(object, this, this.getDescription());
            }
            return CheckResult.createFailed(object, this, new StringBuffer(this.getDescription()).append(Messages.getString("DRGlobalPartitionMaxValueOracle.CurrentValueIs")).append('\"').append(partition.getValueList()).append('\"').append('.').toString());
        }
        return CheckResult.createOk(object, this, Messages.getString("DRGlobalPartitionMaxValueOracle.ThisPartitionIsNotTheLastPartition"));
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getRuleId() {
        return "3756DDBF-CF5E-D3DE-0748-6F4F3BD8C5D1";
    }
}

