/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage.udb;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.udb.ContainerUDB;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.storage.AbstractDRStorageDesign;

public class DRContainerTableSpace
extends AbstractDRStorageDesign {
    private final String RULE_ID = "2057EEBE-3A5E-846E-5EEE-F5D9A62BBF20";

    public DRContainerTableSpace(StorageDesign storageDesign) {
        super(storageDesign);
        this.setName(Messages.getString("DRContainerTableSpace.CheckTablespace"));
        this.setDescription(Messages.getString("DRContainerTableSpace.tablespaceMustBeAssignedToTable"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        ContainerUDB container = (ContainerUDB)object;
        if (container.getTableSpace() == null || container.getTableSpace().isNullInstance()) {
            return CheckResult.createWarning(container, this, Messages.getString("DRContainerTableSpace.TablespaceMustBeAssignedtoContainer"));
        }
        return CheckResult.createOk(container, this, Messages.getString("DRContainerTableSpace.TablespaceIsAssignedtoTheContainer"));
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String getRuleId() {
        return "2057EEBE-3A5E-846E-5EEE-F5D9A62BBF20";
    }
}

