/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.metadata;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.ModelIDObjectSet;
import oracle.dbtools.crest.model.metadata.ClassDescription;
import oracle.dbtools.crest.model.metadata.MDXMLConstants;
import oracle.dbtools.crest.model.metadata.MetaFileLoader;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.propertymap.PropertyMap;
import oracle.dbtools.crest.util.propertymap.PropertyMapWrapper;
import oracle.dbtools.crest.util.propertymap.PropertyTranslator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MetaDataManager
implements MDXMLConstants {
    HashMap<String, ClassDescription> classesMap = new HashMap();
    public static final String MODEL_ID_OBJECT = "oracle.dbtools.crest.model.ModelObject";
    public static final String TV_DIAGRAM = "oracle.dbtools.crest.swingui.TVDiagramView";
    public static final String RECTANGLE = "java.awt.Rectangle";
    public static final String STRING = "java.lang.String";
    static final String SHORT = "short";
    static final String INT = "int";
    static final String BOOLEAN = "boolean";
    static final String LONG = "long";
    static final String DOUBLE = "double";
    static final String FLOAT = "float";
    private static PropertyTranslator[] sharedTranslators = new PropertyTranslator[]{new PropertyMapWrapper.StringPropertyTranslator(), new PropertyMapWrapper.ShortPropertyTranslator(), new PropertyMapWrapper.IntegerPropertyTranslator(), new PropertyMapWrapper.LongPropertyTranslator(), new PropertyMapWrapper.FloatPropertyTranslator(), new PropertyMapWrapper.DoublePropertyTranslator(), new PropertyMapWrapper.BooleanPropertyTranslator(), new PropertyMapWrapper.ColorPropertyTranslator()};
    private List sortedObjects = new ArrayList();
    private List tracedObjects = new ArrayList();
    boolean cyclicRef = false;
    boolean error = false;
    boolean valid = false;

    public static void main(String[] args) {
        MetaFileLoader.standalone = true;
        MetaDataManager md = new MetaDataManager();
        MetaDataManager.loadClassesinXMLMetaDir(md);
        for (ClassDescription cd : md.classesMap.values()) {
            for (ClassDescription.PropertyDescription pd : cd.getPropertiesList()) {
                if (pd.getter != null && (pd.setter != null || pd.createProperty != null) || pd.className.equals("java.util.Map")) continue;
                System.out.println(cd.toString() + "---prop=" + pd.name + " -- null getter  " + String.valueOf(pd.getter == null) + " -- null setter  " + String.valueOf(pd.setter == null));
            }
            for (ClassDescription.PropertyDescription pd : cd.getROPropertiesList()) {
                if (!pd.isSearch() || pd.getter != null) continue;
                System.out.println(cd.toString() + "+++Search - prop=" + pd.name + " -- null getter  " + String.valueOf(pd.getter == null));
            }
        }
    }

    public ClassDescription getClassDescription(String className) {
        ClassDescription cd = this.classesMap.get(className);
        if (cd == null) {
            return this.addClassDescription(className);
        }
        return cd;
    }

    private ClassDescription addClassDescription(String className) {
        ClassDescription cd = null;
        Document doc = MetaFileLoader.loadFile(className);
        if (doc == null) {
            Class<?> tclass = null;
            try {
                tclass = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            if (tclass != null && !tclass.equals(Object.class)) {
                while (doc == null && !(tclass = tclass.getSuperclass()).equals(Object.class)) {
                    doc = MetaFileLoader.loadFile(tclass.getName());
                }
            }
        }
        if (doc != null) {
            int i;
            Class<?> cl;
            int count;
            NodeList propList;
            Element root;
            block45: {
                String value;
                String parentClass;
                root = doc.getDocumentElement();
                String tag = root.getTagName();
                if (!tag.equalsIgnoreCase(className)) {
                    // empty if block
                }
                if ((parentClass = root.getAttribute("parentClass")) != null && !"".equals(parentClass)) {
                    Class<?> cl2 = null;
                    try {
                        cl2 = Class.forName(className);
                    }
                    catch (ClassNotFoundException e1) {
                        // empty catch block
                    }
                    ClassDescription parCD = this.getClassDescription(parentClass);
                    if (parCD != null) {
                        try {
                            cd = (ClassDescription)parCD.clone();
                        }
                        catch (CloneNotSupportedException e) {
                            // empty catch block
                        }
                    }
                }
                if ((value = root.getAttribute("isPropertyMap")) != null && "true".equals(value)) {
                    cd.isPropertyMap = true;
                }
                ArrayList<ClassDescription.PropertyDescription> list = new ArrayList<ClassDescription.PropertyDescription>();
                if (cd == null) {
                    cd = new ClassDescription();
                }
                cd.setClassName(className);
                String xmlName = root.getAttribute("xmlName");
                if (xmlName != null && !"".equals(xmlName)) {
                    cd.setXmlName(xmlName);
                }
                String beforeTransformName = null;
                String beforeTransformExtName = null;
                String afterInitName = null;
                String afterInitExtName = null;
                propList = root.getElementsByTagName("processing");
                count = propList.getLength();
                if (count > 0) {
                    Element el = (Element)propList.item(0);
                    beforeTransformName = el.getAttribute("beforeTransform");
                    if (beforeTransformName != null && !"".equals(beforeTransformName)) {
                        cd.beforeTransformName = beforeTransformName;
                    }
                    if ((beforeTransformExtName = el.getAttribute("beforeTransformExt")) != null && !"".equals(beforeTransformExtName)) {
                        cd.beforeTransformExtName = beforeTransformExtName;
                    }
                    if ((afterInitName = el.getAttribute("afterInit")) != null && !"".equals(afterInitName)) {
                        cd.afterInitName = afterInitName;
                    }
                    if ((afterInitExtName = el.getAttribute("afterInitExt")) != null && !"".equals(afterInitExtName)) {
                        cd.afterInitExtName = afterInitExtName;
                    }
                    if ((value = el.getAttribute("createAllExtItemsFirst")) != null && "true".equals(value)) {
                        cd.isCreateAllExtItemsFirst = true;
                    }
                }
                propList = root.getElementsByTagName("property");
                count = propList.getLength();
                for (int i2 = 0; i2 < count; ++i2) {
                    Element el = (Element)propList.item(i2);
                    this.processProperty(el, cd, list);
                }
                for (ClassDescription.PropertyDescription pd : cd.getPropertiesList()) {
                    ClassDescription.PropertyDescription rpd;
                    if (pd.relatedPropertyName == null || pd.relatedValue == null || (rpd = cd.getPropertyDescriptionByName(pd.relatedPropertyName)) == null) continue;
                    pd.relatedProperty = rpd;
                }
                cl = null;
                try {
                    Method m;
                    cl = Class.forName(className);
                    Method[] cm = cl.getMethods();
                    if (list.size() > 0) {
                        this.processMethods(cd, list, cm);
                    }
                    if (beforeTransformName != null && !"".equals(beforeTransformName)) {
                        for (i = 0; i < cm.length; ++i) {
                            m = cm[i];
                            if (!beforeTransformName.equals(m.getName()) || !this.hasNoArgument(m)) continue;
                            cd.beforeTransform = m;
                            break;
                        }
                    }
                    if (beforeTransformExtName != null && !"".equals(beforeTransformExtName)) {
                        for (i = 0; i < cm.length; ++i) {
                            m = cm[i];
                            if (!beforeTransformExtName.equals(m.getName()) || !this.hasNoArgument(m)) continue;
                            cd.beforeTransformExt = m;
                            break;
                        }
                    }
                    if (afterInitName != null && !"".equals(afterInitName)) {
                        for (i = 0; i < cm.length; ++i) {
                            m = cm[i];
                            if (!afterInitName.equals(m.getName()) || !this.hasNoArgument(m)) continue;
                            cd.afterInit = m;
                            break;
                        }
                    }
                    if (afterInitExtName == null || "".equals(afterInitExtName)) break block45;
                    for (i = 0; i < cm.length; ++i) {
                        m = cm[i];
                        if (!afterInitExtName.equals(m.getName()) || !this.hasNoArgument(m)) continue;
                        cd.afterInitExt = m;
                        break;
                    }
                }
                catch (ClassNotFoundException e1) {
                    // empty catch block
                }
            }
            ArrayList<ClassDescription.CollectionDescription> clist = new ArrayList<ClassDescription.CollectionDescription>();
            propList = root.getElementsByTagName("collection");
            count = propList.getLength();
            for (i = 0; i < count; ++i) {
                Element el = (Element)propList.item(i);
                this.processCollection(el, cd, clist);
            }
            this.processCollectionsOrder(root, cd);
            this.orderCollections(cd);
            if (clist.size() > 0) {
                cl = null;
                try {
                    cl = Class.forName(className);
                    Method[] cm = cl.getMethods();
                    this.processMethodsForCollections(clist, cm);
                }
                catch (ClassNotFoundException e1) {
                    // empty catch block
                }
            }
            propList = root.getElementsByTagName("propertyDependency");
            count = propList.getLength();
            for (int i3 = 0; i3 < count; ++i3) {
                Element dep = (Element)propList.item(i3);
                this.processPropertyDependency(dep, cd);
            }
            if (cd.propertiesDependency.size() > 0) {
                this.sortObjects(cd.getPropertiesList(), cd.propertiesDependency);
            }
            cd.resetElementsAndCollectionsFlag();
            ArrayList<ClassDescription.PropertyDescription> roPropertieslist = new ArrayList<ClassDescription.PropertyDescription>();
            propList = root.getElementsByTagName("roproperty");
            count = propList.getLength();
            for (int i4 = 0; i4 < count; ++i4) {
                Element el = (Element)propList.item(i4);
                this.processRO_SearchableProperty(el, cd, roPropertieslist);
            }
            try {
                cl = Class.forName(className);
                Method[] cm = cl.getMethods();
                if (roPropertieslist.size() > 0) {
                    this.processMethodsForROProperties(roPropertieslist, cm, cd);
                }
            }
            catch (ClassNotFoundException e1) {
                // empty catch block
            }
        }
        if (cd != null) {
            this.classesMap.put(className, cd);
        }
        return cd;
    }

    private void processPropertyDependency(Element propd, ClassDescription cd) {
        String depOnProp;
        ClassDescription.PropertyDescription dprop;
        String propName = propd.getAttribute("propDef");
        ClassDescription.PropertyDescription pd = cd.getPropertyDescriptionByName(propName);
        if (pd != null && (dprop = cd.getPropertyDescriptionByName(depOnProp = propd.getAttribute("dependOnProperty"))) != null) {
            ObjectDependence od = this.getObjectDependence(pd, cd.propertiesDependency);
            if (od == null) {
                od = new ObjectDependence(pd);
                cd.propertiesDependency.add(od);
            }
            od.dependOn.add(dprop);
        }
    }

    private void processProperty(Element prop, ClassDescription cd, List<ClassDescription.PropertyDescription> localList) {
        String search;
        String ddlrel;
        String reffer;
        int ind;
        String value;
        String name = prop.getAttribute("name");
        ClassDescription.PropertyDescription pd = cd.getPropertyDescriptionByName(name);
        if (pd != null) {
            cd.removePropertyDescription(pd);
        }
        pd = new ClassDescription.PropertyDescription();
        pd.name = name;
        pd.className = prop.getAttribute("dataType");
        pd.itemClassName = prop.getAttribute("itemClass");
        Class<?> cl = null;
        try {
            cl = Class.forName(pd.className);
        }
        catch (ClassNotFoundException e1) {
            // empty catch block
        }
        if (cl != null && Map.class.isAssignableFrom(cl)) {
            pd.isMap = true;
        }
        if (RECTANGLE.equals(pd.className)) {
            pd.isRectangle = true;
        }
        if (!STRING.equals(pd.className)) {
            pd.stringClass = false;
        }
        if ((value = prop.getAttribute("isPropertyMap")) != null && "true".equals(value)) {
            pd.isPropertyMap = true;
        }
        if ((value = prop.getAttribute("colorProperty")) != null && "true".equals(value)) {
            pd.isColorProperty = true;
        }
        if ((value = prop.getAttribute("processing")) != null && "afterColletions".equals(value)) {
            pd.isAfterCollectionProcessing = true;
        }
        if ((value = prop.getAttribute("external")) != null && "true".equals(value)) {
            pd.isExternalProperty = true;
        }
        if ((value = prop.getAttribute("loggingProp")) != null && "true".equals(value)) {
            pd.isLoggingProp = true;
        }
        if ((value = prop.getAttribute("relatedProperty")) != null && !"".equals(value)) {
            pd.relatedPropertyName = value;
        }
        if ((value = prop.getAttribute("relatedValue")) != null && !"".equals(value)) {
            pd.relatedValue = value;
        }
        if ((value = prop.getAttribute("createdTimeProp")) != null && "true".equals(value)) {
            pd.isCreatedTimeProp = true;
        }
        if ((value = prop.getAttribute("mergeCompare")) != null && "true".equals(value)) {
            pd.isMergeCompare = true;
        }
        if ((value = prop.getAttribute("listOfRefs")) != null && "true".equals(value)) {
            pd.isListOfRefs = true;
        }
        if ((value = prop.getAttribute("itemXmlName")) != null && !"".equals(value)) {
            pd.pmItemName = value;
        }
        if ((value = prop.getAttribute("keyXmlName")) != null && !"".equals(value)) {
            pd.pmKeyName = value;
        }
        if ((value = prop.getAttribute("valueXmlName")) != null && !"".equals(value)) {
            pd.pmValueName = value;
        }
        if ((value = prop.getAttribute("createItem")) != null && !"".equals(value)) {
            pd.createPropertyName = value;
        }
        if ((value = prop.getAttribute("removeItem")) != null && !"".equals(value)) {
            pd.removePropertyName = value;
        }
        if ((value = prop.getAttribute("createPMap")) != null && !"".equals(value)) {
            pd.createPMapName = value;
        }
        if ((value = prop.getAttribute("beforeCollection")) != null && !"".equals(value)) {
            pd.beforeCollection = value;
        }
        if ((value = prop.getAttribute("afterCollection")) != null && !"".equals(value)) {
            pd.afterCollection = value;
        }
        if ((ind = pd.className.lastIndexOf(32)) > -1) {
            pd.className = pd.className.substring(ind + 1);
        }
        pd.xmlName = prop.getAttribute("xmlName");
        if ("id".equalsIgnoreCase(pd.xmlName)) {
            pd.isID = true;
        }
        pd.oldXmlName = prop.getAttribute("oldXmlName");
        if ("".equals(pd.oldXmlName)) {
            pd.oldXmlName = null;
        }
        pd.presentationName = (value = prop.getAttribute("presentationName")) != null && !"".equals(value) ? value : pd.xmlName;
        String xmlType = prop.getAttribute("xmlType");
        if (!xmlType.equals("element")) {
            pd.propType = 1;
        }
        if ("true".equals(reffer = prop.getAttribute("reffered"))) {
            pd.referred = true;
        }
        pd.getterName = prop.getAttribute("getter");
        pd.setterName = prop.getAttribute("setter");
        String defv = prop.getAttribute("defaultValue");
        if (defv != null) {
            pd.defaultValue = defv;
        }
        if ((ddlrel = prop.getAttribute("ddlRelated")) != null && "true".equals(ddlrel)) {
            pd.ddlRelated = true;
        }
        if ((search = prop.getAttribute("search")) != null && "true".equals(search)) {
            pd.search = true;
        }
        if ((value = prop.getAttribute("useInReport")) != null && "true".equals(value)) {
            pd.useInReport = true;
        }
        this.processCodedEnum(prop, pd);
        cd.getPropertiesList().add(pd);
        localList.add(pd);
    }

    private void processRO_SearchableProperty(Element prop, ClassDescription cd, List<ClassDescription.PropertyDescription> localList) {
        String value;
        String name = prop.getAttribute("name");
        ClassDescription.PropertyDescription roPd = cd.getROPropertyDescriptionByName(name);
        if (roPd != null) {
            cd.removeROPropertyDescription(roPd);
        }
        roPd = new ClassDescription.PropertyDescription();
        roPd.name = name;
        roPd.className = prop.getAttribute("dataType");
        roPd.itemClassName = prop.getAttribute("itemClass");
        String search = prop.getAttribute("search");
        if (search != null && "true".equals(search)) {
            roPd.search = true;
        }
        roPd.getterName = prop.getAttribute("getter");
        if (roPd.search) {
            cd.getROPropertiesList().add(roPd);
            localList.add(roPd);
        }
        if ((value = prop.getAttribute("useInReport")) != null && "true".equals(value)) {
            roPd.useInReport = true;
        }
    }

    private void checkpropertyClass(ClassDescription cd, ClassDescription.PropertyDescription pd) {
        if (pd.className.indexOf("java.util.List") > -1 || pd.className.indexOf("java.util.Collection") > -1) {
            System.out.println(cd.getClassName() + " ||  pname=" + pd.name + "  --  " + pd.className);
        }
        if (pd.isContainedClass()) {
            if (pd.isPropertyMap) {
                if (pd.createPMapName != null && pd.removePropertyName == null || pd.createPMapName == null) {
                    System.out.println("no removeProperty for PropMap -- " + cd.getClassName() + " ||  pname=" + pd.name + "  --  " + pd.className);
                } else if (pd.createPMapName != null && pd.removePropertyName != null) {
                    // empty if block
                }
            } else if (pd.createPropertyName != null && pd.removePropertyName == null || pd.createPropertyName == null) {
                if (!pd.className.equals(RECTANGLE)) {
                    System.out.println("no removeProperty -- " + cd.getClassName() + " ||  pname=" + pd.name + "  --  " + pd.className);
                }
            } else if (pd.createPropertyName == null || pd.removePropertyName != null) {
                // empty if block
            }
        }
    }

    private void processCodedEnum(Element prop, ClassDescription.PropertyDescription pd) {
        NodeList codeList = prop.getElementsByTagName("codedEnum");
        int count = codeList.getLength();
        count = Math.min(1, count);
        for (int i = 0; i < count; ++i) {
            Element el = (Element)codeList.item(i);
            NodeList items = el.getElementsByTagName("item");
            int icount = items.getLength();
            for (int k = 0; k < icount; ++k) {
                Element item = (Element)items.item(k);
                String code = item.getAttribute("code");
                if (code == null || "".equals(code)) continue;
                String value = item.getAttribute("value");
                pd.getCoddedEnumMap().put(code, value);
            }
        }
    }

    private void processMethods(ClassDescription cd, List<ClassDescription.PropertyDescription> list, Method[] methods) {
        Class<?> idObject = null;
        try {
            idObject = Class.forName(MODEL_ID_OBJECT);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        for (ClassDescription.PropertyDescription pd : list) {
            String createPMapName = pd.createPMapName;
            if (pd.isPropertyMap) {
                for (int i = 0; i < methods.length; ++i) {
                    Class<?> returnType;
                    Method cm = methods[i];
                    if (!createPMapName.equals(cm.getName()) || !this.hasNoArgument(cm) || !PropertyMap.class.isAssignableFrom(returnType = cm.getReturnType())) continue;
                    pd.createPMap = cm;
                    break;
                }
            }
            if (pd.isMap) {
                // empty if block
            }
            String setter = pd.setterName;
            String getter = pd.getterName;
            Class paramClass = this.getClass(pd.className);
            Method getMethod = null;
            Method setMethod = null;
            if (!(paramClass == null || getter == null || setter == null && pd.isReferred())) {
                int c;
                Method cm;
                Class<?> returnType;
                int i;
                for (i = 0; i < methods.length; ++i) {
                    Method gm = methods[i];
                    if (!getter.equals(gm.getName()) || !this.hasNoArgument(gm) || !(returnType = gm.getReturnType()).equals(paramClass)) continue;
                    getMethod = gm;
                    break;
                }
                if (!pd.isReferred() && pd.createPropertyName != null && !"".equals(pd.createPropertyName)) {
                    for (i = 0; i < methods.length; ++i) {
                        cm = methods[i];
                        if (!pd.createPropertyName.equals(cm.getName()) || !this.hasNoArgument(cm) || !paramClass.isAssignableFrom(returnType = cm.getReturnType())) continue;
                        pd.createProperty = cm;
                        pd.stringClass = false;
                        pd.getter = getMethod;
                        break;
                    }
                }
                if (!pd.isReferred() && pd.removePropertyName != null && !"".equals(pd.removePropertyName)) {
                    for (i = 0; i < methods.length; ++i) {
                        cm = methods[i];
                        if (!pd.removePropertyName.equals(cm.getName()) || !this.hasNoArgument(cm) || !paramClass.isAssignableFrom(returnType = cm.getReturnType())) continue;
                        pd.removeProperty = cm;
                        pd.stringClass = false;
                        pd.getter = getMethod;
                        break;
                    }
                }
                if (pd.isPropertyMap || pd.isMap) {
                    pd.getter = getMethod;
                }
                if (getMethod != null) {
                    Class<?> singleArgument;
                    Method sm;
                    for (i = 0; i < methods.length; ++i) {
                        sm = methods[i];
                        if (!setter.equals(sm.getName()) || !this.hasSingleArgument(sm) || !this.hasVoidOrBooleanReturn(sm) || !(singleArgument = sm.getParameterTypes()[0]).equals(paramClass)) continue;
                        setMethod = sm;
                        break;
                    }
                    if (setMethod == null) {
                        for (i = 0; i < methods.length; ++i) {
                            sm = methods[i];
                            if (!setter.equals(sm.getName()) || !this.hasSingleArgument(sm) || !this.hasVoidOrBooleanReturn(sm) || !paramClass.isAssignableFrom(singleArgument = sm.getParameterTypes()[0])) continue;
                            setMethod = sm;
                            break;
                        }
                    }
                } else {
                    c = 0;
                    ++c;
                }
                if (getMethod != null && setMethod != null) {
                    pd.setter = setMethod;
                    pd.getter = getMethod;
                    pd.simpleClass = this.isSimpleClas(paramClass);
                    pd.stringClass = this.isStringClas(paramClass);
                    PropertyTranslator translator = this.getPropertyTranslatorFor(paramClass);
                    if (translator == null) {
                        if (idObject != null && idObject.isAssignableFrom(paramClass)) {
                            pd.idObjecttranslator = true;
                        }
                    } else {
                        pd.propertyTranslator = translator;
                    }
                } else {
                    c = 0;
                    ++c;
                }
            } else {
                int c = 0;
                ++c;
            }
            if (!MetaFileLoader.standalone && !ApplicationView.debugMode) continue;
            this.checkpropertyClass(cd, pd);
        }
    }

    private void processMethodsForROProperties(List<ClassDescription.PropertyDescription> list, Method[] methods, ClassDescription cd) {
        Object[] props = list.toArray();
        for (int k = 0; k < props.length; ++k) {
            ClassDescription.PropertyDescription pd = (ClassDescription.PropertyDescription)props[k];
            String getter = pd.getterName;
            Class paramClass = this.getClass(pd.className);
            if (paramClass != null && getter != null) {
                Class<?> returnType;
                Method gm;
                int i;
                for (i = 0; i < methods.length; ++i) {
                    gm = methods[i];
                    if (!getter.equals(gm.getName()) || !this.hasNoArgument(gm) || !(returnType = gm.getReturnType()).equals(paramClass)) continue;
                    pd.getter = gm;
                    break;
                }
                if (pd.getter == null) {
                    for (i = 0; i < methods.length; ++i) {
                        gm = methods[i];
                        if (!getter.equals(gm.getName()) || !this.hasNoArgument(gm) || !(returnType = gm.getReturnType()).isAssignableFrom(paramClass)) continue;
                        pd.getter = gm;
                        break;
                    }
                }
            }
            if (pd.getter != null) continue;
            cd.removeROPropertyDescription(pd);
        }
    }

    private void processCollection(Element prop, ClassDescription cd, List<ClassDescription.CollectionDescription> localList) {
        String name = prop.getAttribute("name");
        ClassDescription.CollectionDescription cold = cd.getCollectionDescriptionByName(name);
        if (cold != null) {
            cd.removeCollectionDescription(cold);
        }
        cold = new ClassDescription.CollectionDescription();
        cold.name = name;
        cold.className = prop.getAttribute("dataType");
        int ind = cold.className.lastIndexOf(32);
        if (ind > -1) {
            cold.className = cold.className.substring(ind + 1);
        }
        cold.xmlName = prop.getAttribute("xmlName");
        cold.itemXmlName = prop.getAttribute("itemXmlName");
        cold.itemClassName = prop.getAttribute("itemClass");
        String xmlType = prop.getAttribute("xmlType");
        String reffer = prop.getAttribute("reffered");
        String value = prop.getAttribute("external");
        if (value != null && "true".equals(value)) {
            cold.isExternalCollection = true;
        }
        if ((value = prop.getAttribute("itemIsRef")) != null && "true".equals(value)) {
            cold.itemIsRef = true;
        }
        if ((value = prop.getAttribute("createAllItemsFirst")) != null && "true".equals(value)) {
            cold.createAllItemsFirst = true;
        }
        if ((value = prop.getAttribute("objectViewItem")) != null && "true".equals(value)) {
            cold.isObjectViewItem = true;
        }
        if ((value = prop.getAttribute("physicalModelItem")) != null && "true".equals(value)) {
            cold.isPhysicalModelItem = true;
        }
        if ((value = prop.getAttribute("diagramViewItem")) != null && "true".equals(value)) {
            cold.isTVDiagramItem = true;
        }
        if ((value = prop.getAttribute("orderImportant")) != null && "false".equals(value)) {
            cold.isOrderImportant = false;
        }
        if ((value = prop.getAttribute("tvConnectorItem")) != null && "true".equals(value)) {
            cold.isTVConnectorItem = true;
        }
        if ((value = prop.getAttribute("proxyItem")) != null && "true".equals(value)) {
            cold.isProxyitem = true;
        }
        if ((value = prop.getAttribute("listOfRefs")) != null && "true".equals(value)) {
            cold.listOfRefs = true;
        }
        if ((value = prop.getAttribute("nativeList")) != null && "true".equals(value)) {
            cold.nativeList = true;
        }
        if ((value = prop.getAttribute("orderTheList")) != null && "true".equals(value)) {
            cold.orderTheList = true;
        }
        if ((value = prop.getAttribute("refsXMLName")) != null && !"".equals(value)) {
            cold.refsXMLName = value;
        }
        cold.getterName = prop.getAttribute("getter");
        cold.setterName = prop.getAttribute("setter");
        String mapItem = prop.getAttribute("isMapItem");
        if (mapItem != null && "true".equalsIgnoreCase(mapItem)) {
            cold.isMapItem = true;
        }
        if ((mapItem = prop.getAttribute("isEngPropertyHolderItem")) != null && "true".equalsIgnoreCase(mapItem)) {
            cold.isEngPropertyHolderItem = true;
        }
        if ((value = prop.getAttribute("useInReport")) != null && "true".equals(value)) {
            cold.useInReport = true;
        }
        cold.createItemName = prop.getAttribute("createItem");
        cold.addItemName = prop.getAttribute("addItem");
        cold.removeItemName = prop.getAttribute("removeItem");
        cold.applyListName = prop.getAttribute("applyList");
        cold.getItemByIDName = prop.getAttribute("getItemByID");
        cold.moveMethodName = prop.getAttribute("moveMethod");
        cold.preProcessName = prop.getAttribute("preProcessMethod");
        cd.getCollectionsList().add(cold);
        localList.add(cold);
    }

    private void processMethodsForCollections(List<ClassDescription.CollectionDescription> list, Method[] methods) {
        Class<?> idObject = null;
        try {
            idObject = Class.forName(MODEL_ID_OBJECT);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        block2: for (ClassDescription.CollectionDescription cold : list) {
            Method gm;
            int i;
            String setter = cold.setterName;
            String getter = cold.getterName;
            Class paramClass = this.getClass(cold.className);
            if (ModelIDObjectSet.class.isAssignableFrom(paramClass)) {
                cold.isIDObjectSet = true;
            }
            Method getMethod = null;
            Object setMethod = null;
            if (paramClass != null && getter != null) {
                Class<?> returnType;
                for (i = 0; i < methods.length; ++i) {
                    gm = methods[i];
                    if (!getter.equals(gm.getName()) || !this.hasNoArgument(gm) || !(returnType = gm.getReturnType()).equals(paramClass)) continue;
                    getMethod = gm;
                    break;
                }
                if (getMethod == null) {
                    for (i = 0; i < methods.length; ++i) {
                        gm = methods[i];
                        if (!getter.equals(gm.getName()) || !this.hasNoArgument(gm) || !(returnType = gm.getReturnType()).isAssignableFrom(paramClass)) continue;
                        getMethod = gm;
                        break;
                    }
                }
                cold.getter = getMethod;
            } else {
                int c = 0;
                ++c;
            }
            if (cold.createItemName != null && !"".equals(cold.createItemName)) {
                for (i = 0; i < methods.length; ++i) {
                    gm = methods[i];
                    if (!cold.createItemName.equals(gm.getName()) || !this.hasNoArgument(gm) || this.hasVoidReturn(gm)) continue;
                    cold.createItem = gm;
                    break;
                }
            }
            if (cold.removeItemName != null && !"".equals(cold.removeItemName)) {
                for (i = 0; i < methods.length; ++i) {
                    gm = methods[i];
                    if (!cold.removeItemName.equals(gm.getName()) || !this.hasSingleArgument(gm)) continue;
                    cold.removeItem = gm;
                    break;
                }
            }
            if (cold.addItemName != null && !"".equals(cold.addItemName)) {
                for (i = 0; i < methods.length; ++i) {
                    gm = methods[i];
                    if (!cold.addItemName.equals(gm.getName()) || !this.hasSingleArgument(gm)) continue;
                    cold.addItem = gm;
                    break;
                }
            }
            if (cold.applyListName != null && !"".equals(cold.applyListName)) {
                for (i = 0; i < methods.length; ++i) {
                    gm = methods[i];
                    if (!cold.applyListName.equals(gm.getName()) || !this.hasSingleArgument(gm) || !this.hasVoidReturn(gm)) continue;
                    cold.applyList = gm;
                    break;
                }
            }
            if (cold.getItemByIDName != null && !"".equals(cold.getItemByIDName)) {
                for (i = 0; i < methods.length; ++i) {
                    gm = methods[i];
                    if (!cold.getItemByIDName.equals(gm.getName()) || !this.hasSingleArgument(gm)) continue;
                    cold.getItemByID = gm;
                    break;
                }
            }
            if (cold.moveMethodName != null && !"".equals(cold.moveMethodName)) {
                for (i = 0; i < methods.length; ++i) {
                    gm = methods[i];
                    if (!cold.moveMethodName.equals(gm.getName()) || !this.hasTwoArguments(gm)) continue;
                    cold.moveMethod = gm;
                    break;
                }
            }
            if (cold.preProcessName == null || "".equals(cold.preProcessName)) continue;
            for (i = 0; i < methods.length; ++i) {
                gm = methods[i];
                if (!cold.preProcessName.equals(gm.getName()) || !this.hasNoArgument(gm)) continue;
                cold.preProcess = gm;
                continue block2;
            }
        }
    }

    private boolean hasSingleArgument(Method method) {
        return method.getParameterTypes().length == 1;
    }

    private boolean hasTwoArguments(Method method) {
        return method.getParameterTypes().length == 2;
    }

    private boolean hasVoidOrBooleanReturn(Method method) {
        return Void.TYPE.equals(method.getReturnType()) || Boolean.TYPE.equals(method.getReturnType());
    }

    private boolean hasVoidReturn(Method method) {
        return Void.TYPE.equals(method.getReturnType());
    }

    private boolean hasNoArgument(Method method) {
        return method.getParameterTypes().length == 0;
    }

    private PropertyTranslator getPropertyTranslatorFor(Class cls) {
        for (int i = 0; i < sharedTranslators.length; ++i) {
            if (!sharedTranslators[i].canHandleClass(cls)) continue;
            return sharedTranslators[i];
        }
        return null;
    }

    private Class getClass(String className) {
        if (SHORT.equals(className)) {
            return Short.TYPE;
        }
        if (INT.equals(className)) {
            return Integer.TYPE;
        }
        if (BOOLEAN.equals(className)) {
            return Boolean.TYPE;
        }
        if (DOUBLE.equals(className)) {
            return Double.TYPE;
        }
        if (FLOAT.equals(className)) {
            return Float.TYPE;
        }
        if (LONG.equals(className)) {
            return Long.TYPE;
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private boolean isSimpleClas(Class checked) {
        return checked.equals(Integer.TYPE) || checked.equals(Integer.class) || checked.equals(Short.TYPE) || checked.equals(Short.class) || checked.equals(Double.TYPE) || checked.equals(Double.class) || checked.equals(Float.TYPE) || checked.equals(Float.class) || checked.equals(Long.TYPE) || checked.equals(Long.class) || checked.equals(Boolean.TYPE) || checked.equals(Boolean.class) || checked.equals(Color.class);
    }

    private boolean isStringClas(Class checked) {
        return checked.equals(String.class);
    }

    private void sortObjects(List objects, List objectDependencies) {
        this.sortedObjects.clear();
        this.tracedObjects.clear();
        this.cyclicRef = false;
        ArrayList havingDependencies = new ArrayList();
        for (Object object : objects) {
            ObjectDependence od = this.getObjectDependence(object, objectDependencies);
            if (od == null || od.dependOn.size() == 0) {
                this.sortedObjects.add(object);
                this.tracedObjects.add(object);
                continue;
            }
            havingDependencies.add(object);
        }
        for (Object object : havingDependencies) {
            this.addToSorted(object, objectDependencies);
            if (!this.cyclicRef) continue;
            return;
        }
        if (this.sortedObjects.size() == objects.size()) {
            objects.clear();
            objects.addAll(this.sortedObjects);
        } else {
            int k = 0;
            ++k;
        }
    }

    private void addToSorted(Object object, List objectDependencies) {
        if (this.sortedObjects.contains(object)) {
            return;
        }
        ObjectDependence od = this.getObjectDependence(object, objectDependencies);
        if (od == null) {
            this.sortedObjects.add(object);
            this.tracedObjects.add(object);
            return;
        }
        if (od.dependOn.size() == 0) {
            this.sortedObjects.add(object);
            this.tracedObjects.add(object);
            return;
        }
        this.tracedObjects.add(object);
        for (Object obj : od.dependOn) {
            if (this.tracedObjects.contains(obj) && !this.sortedObjects.contains(obj)) {
                this.cyclicRef = true;
                this.error = true;
                this.valid = false;
                return;
            }
            if (this.sortedObjects.contains(obj)) continue;
            this.addToSorted(obj, objectDependencies);
            if (!this.cyclicRef) continue;
            return;
        }
        this.sortedObjects.add(object);
    }

    private ObjectDependence getObjectDependence(Object object, List objectDependencies) {
        for (ObjectDependence od : objectDependencies) {
            if (od.object != object) continue;
            return od;
        }
        return null;
    }

    private void processCollectionsOrder(Element root, ClassDescription cd) {
        NodeList propList = root.getElementsByTagName("collectionOrder");
        int count = propList.getLength();
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                NodeList items;
                int icount;
                Element el = (Element)propList.item(i);
                String context = el.getAttribute("context");
                if (!cd.getContexts().contains(context)) {
                    cd.getContexts().add(context);
                }
                if ((icount = (items = el.getElementsByTagName("collectionOrd")).getLength()) > 0) {
                    ArrayList<String> list = new ArrayList<String>();
                    for (int k = 0; k < icount; ++k) {
                        Element item = (Element)items.item(k);
                        String name = item.getAttribute("name");
                        if (name == null || "".equals(name)) continue;
                        list.add(name);
                    }
                    if (list.size() > 0) {
                        cd.getContextMap().put(context + "collectionOrderNames", list);
                        continue;
                    }
                    cd.getContextMap().remove(context + "collectionOrderNames");
                    continue;
                }
                cd.getContextMap().remove(context + "collectionOrderNames");
            }
        }
    }

    private void orderCollections(ClassDescription cd) {
        for (String context : cd.getContexts()) {
            List list = (List)cd.getContextMap().get(context + "collectionOrderNames");
            ArrayList<ClassDescription.CollectionDescription> olist = new ArrayList<ClassDescription.CollectionDescription>();
            if (list != null) {
                for (String name : list) {
                    ClassDescription.CollectionDescription cold = cd.getCollectionDescriptionByName(name);
                    if (cold == null) continue;
                    olist.add(cold);
                }
            }
            for (ClassDescription.CollectionDescription cold : cd.getCollectionsList()) {
                if (olist.contains(cold)) continue;
                olist.add(cold);
            }
            cd.getContextMap().put(context + "collectionOrder", olist);
        }
    }

    private static void loadClassesinXMLMetaDir(MetaDataManager md) {
        File dir = new File(new File(MetaFileLoader.standaloneBaseDir), "xmlmetadata");
        if (dir.exists() && dir.isDirectory()) {
            File[] files;
            for (File file : files = dir.listFiles()) {
                int ind;
                if (file.isDirectory()) continue;
                Document doc = null;
                try {
                    doc = MetaFileLoader.loadDocForFile(file.getCanonicalPath());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (doc == null) continue;
                Element root = doc.getDocumentElement();
                String className = root.getTagName();
                String inner = root.getAttribute("innerClass");
                if (inner != null && "true".equalsIgnoreCase(inner) && (ind = className.lastIndexOf(46)) > -1 && ind + 1 < className.length()) {
                    className = className.substring(0, ind) + '$' + className.substring(ind + 1);
                }
                ClassDescription cd = md.getClassDescription(className);
            }
        }
    }

    class ObjectDependence {
        Object object;
        List dependOn = new ArrayList();

        ObjectDependence(Object object) {
            this.object = object;
        }
    }
}

