/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.metadata;

import java.awt.geom.Point2D;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.metadata.ClassDescription;
import oracle.dbtools.crest.model.metadata.MDTransformationManager;
import oracle.dbtools.crest.model.metadata.MDTransformer;
import oracle.dbtools.crest.model.metadata.MDXMLConstants;
import oracle.dbtools.crest.model.metadata.XMLTransformationManager;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class XMLFromMapTransformer
extends MDTransformer
implements MDXMLConstants {
    public static Document transformFromMap(Map object) {
        Document doc = null;
        try {
            DocumentBuilderFactory dbf;
            DocumentBuilder db;
            Element rootElement;
            XMLFromMapTransformer tr;
            ClassDescription cd;
            String className = XMLFromMapTransformer.getObjectClassName(object);
            if (className != null && !"".equals(className) && (cd = XMLFromMapTransformer.getClassDecription(object)) != null && (tr = XMLFromMapTransformer.getXMLFromMapTransformer(className)) != null && (rootElement = tr.transformFromMap(object, null, doc = (db = (dbf = DocumentBuilderFactory.newInstance()).newDocumentBuilder()).newDocument())) != null) {
                doc.appendChild(rootElement);
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        return doc;
    }

    public static XMLFromMapTransformer getXMLFromMapTransformer(String className) {
        MDTransformationManager transformationManager = ApplicationView.getInstance().getXMLTransformationManager().getXMLMapTransformationManager();
        XMLFromMapTransformer tr = (XMLFromMapTransformer)transformationManager.getFromObjectTransformerFor(className);
        return tr;
    }

    public Element transformFromMap(Map object, String tagName, Document doc) {
        return this.transformFromMap(object, tagName, doc, false);
    }

    public Element transformFromMap(Map object, String tagName, Document doc, boolean skipClassName) {
        Element rootElement = null;
        try {
            ClassDescription cd = XMLFromMapTransformer.getClassDecription(object);
            if (cd != null) {
                rootElement = tagName != null ? doc.createElement(tagName) : doc.createElement(cd.getXmlName());
                if (!SKP_CLASS_NAME && !skipClassName) {
                    rootElement.setAttribute("class", cd.getClassName());
                }
                this.processProperties(object, rootElement, cd);
                this.processClassPropertyMap(object, rootElement, cd);
                this.processCollections(object, rootElement, cd);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return rootElement;
    }

    private void processProperties(Map object, Element rootElement, ClassDescription cd) {
        Document doc = rootElement.getOwnerDocument();
        for (ClassDescription.PropertyDescription pd : cd.getPropertiesList()) {
            Element element;
            String className;
            XMLFromMapTransformer xmltr;
            if (pd.isRectangle) {
                Object obj = object.get(pd.xmlName);
                if (obj == null || !(obj instanceof Map)) continue;
                this.appendBounds(rootElement, pd.xmlName, (Map)obj);
                continue;
            }
            if (pd.isPropertyMap) {
                this.processPropertyAsPropertyMap(object, rootElement, pd);
                continue;
            }
            if (pd.isMap) {
                this.processMapProperty(object, rootElement, pd);
                continue;
            }
            if (pd.isSimpleClass() || pd.isStringClass() || pd.isReferred()) {
                String value = (String)object.get(pd.xmlName);
                if (value == null || SKP_DEFAULTS && value.equalsIgnoreCase(pd.defaultValue)) continue;
                value = StringUtilities.encodeAttributeValue(value);
                if (pd.isAttribute()) {
                    rootElement.setAttribute(pd.xmlName, value);
                    continue;
                }
                Element element2 = doc.createElement(pd.xmlName);
                Text content = doc.createTextNode(value);
                element2.appendChild(content);
                rootElement.appendChild(element2);
                continue;
            }
            Map nested = (Map)object.get(pd.xmlName);
            if (nested == null || (xmltr = XMLFromMapTransformer.getXMLFromMapTransformer(className = XMLFromMapTransformer.getObjectClassName(nested))) == null || (element = xmltr.transformFromMap(nested, pd.xmlName, doc)) == null) continue;
            rootElement.appendChild(element);
        }
    }

    private void processPropertyAsPropertyMap(Map object, Element rootElement, ClassDescription.PropertyDescription pd) {
        Object obj;
        if (pd.isPropertyMap && (obj = object.get(pd.xmlName)) != null && obj instanceof Map) {
            Document doc = rootElement.getOwnerDocument();
            Map pm = (Map)obj;
            Iterator it = pm.keySet().iterator();
            Element pmElement = null;
            while (it.hasNext()) {
                String key = (String)it.next();
                String value = (String)pm.get(key);
                if (value == null) continue;
                if (pmElement == null) {
                    pmElement = doc.createElement(pd.xmlName);
                    rootElement.appendChild(pmElement);
                }
                Element element = doc.createElement(pd.pmItemName);
                element.setAttribute(pd.pmKeyName, StringUtilities.encodeAttributeValue(key));
                element.setAttribute(pd.pmValueName, StringUtilities.encodeAttributeValue(value));
                pmElement.appendChild(element);
            }
        }
    }

    private void processMapProperty(Map object, Element rootElement, ClassDescription.PropertyDescription pd) {
        Object obj;
        if (pd.isMap && (obj = object.get(pd.xmlName)) != null && obj instanceof Map) {
            Document doc = rootElement.getOwnerDocument();
            Map pm = (Map)obj;
            Iterator it = pm.keySet().iterator();
            Element pmElement = null;
            while (it.hasNext()) {
                String key = (String)it.next();
                String value = (String)pm.get(key);
                if (value == null) continue;
                if (pmElement == null) {
                    pmElement = doc.createElement(pd.xmlName);
                    rootElement.appendChild(pmElement);
                }
                Element element = doc.createElement(pd.pmItemName);
                element.setAttribute("key", StringUtilities.encodeAttributeValue(key));
                element.setAttribute("value", StringUtilities.encodeAttributeValue(value));
                pmElement.appendChild(element);
            }
        }
    }

    private void processClassPropertyMap(Map object, Element rootElement, ClassDescription cd) {
        if (cd.isPropertyMap) {
            Document doc = rootElement.getOwnerDocument();
            Map pmap = (Map)object.get("propertyMap");
            if (pmap != null) {
                Iterator it = pmap.keySet().iterator();
                Element element = null;
                while (it.hasNext()) {
                    String key = (String)it.next();
                    if (this.skipProperty(key)) continue;
                    String value = (String)pmap.get(key);
                    if (element == null) {
                        element = doc.createElement("propertyMap");
                        rootElement.appendChild(element);
                    }
                    Element prop = doc.createElement("property");
                    prop.setAttribute("name", StringUtilities.encodeAttributeValue(key));
                    prop.setAttribute("value", StringUtilities.encodeAttributeValue(value));
                    element.appendChild(prop);
                }
            }
        }
    }

    private boolean skipProperty(String name) {
        return false;
    }

    private void processCollections(Map object, Element parent, ClassDescription cd) {
        for (ClassDescription.CollectionDescription cold : cd.getCollectionsList()) {
            Object col = object.get(cold.xmlName);
            if (col == null || !(col instanceof Collection) || SKP_DEFAULTS && ((Collection)col).size() <= 0) continue;
            if (cold.itemIsRef) {
                this.processCollectionWithRefs(object, (Collection)col, parent, cold);
                continue;
            }
            this.processCollectionWithContained((Collection)col, parent, cold);
        }
    }

    private void processCollectionWithRefs(Object object, Collection col, Element parent, ClassDescription.CollectionDescription cold) {
        Document doc = parent.getOwnerDocument();
        Element colelem = doc.createElement(cold.xmlName);
        parent.appendChild(colelem);
        if (!cold.listOfRefs) {
            for (Object item : col) {
                if (item != null && item instanceof String) {
                    String id = (String)item;
                    Element element = doc.createElement(cold.itemXmlName);
                    Text content = doc.createTextNode(id);
                    element.appendChild(content);
                    colelem.appendChild(element);
                    continue;
                }
                int k = 0;
                ++k;
            }
        } else {
            StringBuffer sb = new StringBuffer();
            boolean first = true;
            for (Object item : col) {
                String id;
                if (item == null || !(item instanceof String) || (id = (String)item) == null) continue;
                if (first) {
                    sb.append(id);
                    first = false;
                    continue;
                }
                sb.append(' ').append(id);
            }
            String name = cold.refsXMLName;
            String idrefs = sb.toString();
            colelem.setAttribute(name, idrefs);
        }
    }

    private void processCollectionWithContained(Collection col, Element parent, ClassDescription.CollectionDescription cold) {
        Element element;
        Document doc = parent.getOwnerDocument();
        Element colelem = doc.createElement(cold.xmlName);
        parent.appendChild(colelem);
        if (cold.isEngPropertyHolderItem) {
            for (Object item : col) {
                if (!(item instanceof EngPropertyHolder)) continue;
                EngPropertyHolder ph = (EngPropertyHolder)item;
                Element element2 = doc.createElement(cold.itemXmlName);
                element2.setAttribute("name", ph.getName());
                element2.setAttribute("selected", String.valueOf(ph.isSelected()));
                colelem.appendChild(element2);
            }
        }
        boolean first = true;
        boolean skipClassName = false;
        boolean mapItem = cold.isMapItem;
        String className = null;
        String itemClassName = cold.itemClassName;
        if (!ApplicationView.INCLUDE_CLASS_NAME_IN_ITEM_XML && itemClassName != null && !"".equals(itemClassName)) {
            colelem.setAttribute("itemClass", itemClassName);
            skipClassName = true;
        }
        XMLFromMapTransformer xmltr = null;
        if (!mapItem) {
            for (Object item : col) {
                if (!(item instanceof Map)) continue;
                String clName = XMLFromMapTransformer.getObjectClassName((Map)item);
                if ((clName == null || "".equals(clName)) && itemClassName != null && !"".equals(itemClassName)) {
                    clName = itemClassName;
                    ((Map)item).put("class", clName);
                }
                if (first || className != null && clName != null && !clName.equals(className)) {
                    className = clName;
                    xmltr = XMLFromMapTransformer.getXMLFromMapTransformer(className);
                    first = false;
                }
                element = null;
                if (xmltr != null) {
                    element = xmltr.transformFromMap((Map)item, cold.itemXmlName, doc, skipClassName);
                }
                if (element == null) continue;
                colelem.appendChild(element);
                this.processTopView(element, (Map)item, cold);
            }
        }
        if (mapItem) {
            for (Object item : col) {
                if (!(item instanceof Map)) continue;
                mapItem = true;
                Map map = (Map)item;
                element = doc.createElement(cold.itemXmlName);
                for (Map.Entry entry : map.entrySet()) {
                    Object value = entry.getValue();
                    Object key = entry.getKey();
                    if (value == null || key == null || !(value instanceof String) || !(key instanceof String)) continue;
                    element.setAttribute(StringUtilities.encodeAttributeValue((String)key), StringUtilities.encodeAttributeValue((String)value));
                    colelem.appendChild(element);
                }
            }
        }
    }

    private void processTopView(Element element, Map item, ClassDescription.CollectionDescription cold) {
        if (cold.isObjectViewItem || cold.isTVDiagramItem || cold.isTVConnectorItem) {
            List list;
            String oid = (String)item.get("oid");
            String type = (String)item.get("otype");
            String vid = (String)item.get("vid");
            String dpvid = (String)item.get("dpv_id");
            String vnum = (String)item.get("vnum");
            String vid_source = (String)item.get("vid_source");
            String vid_target = (String)item.get("vid_target");
            boolean connector = false;
            if (oid != null && !"".equals(oid)) {
                element.setAttribute("oid", StringUtilities.encodeAttributeValue(oid));
            }
            if (type != null && !"".equals(type)) {
                element.setAttribute("otype", StringUtilities.encodeAttributeValue(type));
            }
            if (vid != null && !"".equals(vid)) {
                element.setAttribute("vid", StringUtilities.encodeAttributeValue(vid));
            }
            if (dpvid != null && !"".equals(dpvid)) {
                element.setAttribute("vid", StringUtilities.encodeAttributeValue(dpvid));
            }
            if (vnum != null && !"".equals(vnum)) {
                element.setAttribute("vnum", StringUtilities.encodeAttributeValue(vnum));
            }
            if (vid_source != null && !"".equals(vid_source)) {
                element.setAttribute("vid_source", StringUtilities.encodeAttributeValue(vid_source));
                connector = true;
            }
            if (vid_target != null && !"".equals(vid_target)) {
                element.setAttribute("vid_target", StringUtilities.encodeAttributeValue(vid_target));
                connector = true;
            }
            if ((cold.isTVConnectorItem || connector) && (list = (List)item.get("points")) != null) {
                this.addCollectionOfPoints(element, "points", list);
            }
        }
    }

    private void appendBounds(Element element, String elemName, Map map) {
        if (map != null) {
            Integer x = (Integer)map.get("x");
            Integer y = (Integer)map.get("y");
            Integer w = (Integer)map.get("width");
            Integer h = (Integer)map.get("height");
            if (x != null) {
                Element boundsElem = element.getOwnerDocument().createElement(elemName);
                boundsElem.setAttribute("x", String.valueOf(x));
                boundsElem.setAttribute("y", String.valueOf(y));
                boundsElem.setAttribute("width", String.valueOf(w));
                boundsElem.setAttribute("height", String.valueOf(h));
                element.appendChild(boundsElem);
            }
        }
    }

    private void addCollectionOfPoints(Element element, String elemName, Collection points) {
        if (points.size() > 0) {
            Document doc = element.getOwnerDocument();
            Element elem = doc.createElement(elemName);
            for (Object obj : points) {
                if (!(obj instanceof Point2D)) continue;
                Element pelem = doc.createElement("point");
                Point2D p = (Point2D)obj;
                pelem.setAttribute("x", String.valueOf((int)p.getX()));
                pelem.setAttribute("y", String.valueOf((int)p.getY()));
                elem.appendChild(pelem);
            }
            element.appendChild(elem);
        }
    }

    public static String transformFromObjectToString(Map object) {
        try {
            Document doc = XMLFromMapTransformer.transformFromMap(object);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(doc);
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            transformer.transform(source, result);
            return sw.getBuffer().toString();
        }
        catch (TransformerConfigurationException e) {
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
        return null;
    }

    public static String getObjectClassName(Map metaMap) {
        if (metaMap == null) {
            return null;
        }
        return (String)metaMap.get("class");
    }

    public static ClassDescription getClassDecription(Map metaMap) {
        String className = XMLFromMapTransformer.getObjectClassName(metaMap);
        if (className != null && !"".equals(className)) {
            return ApplicationView.getInstance().getXMLTransformationManager().getMetaDataManager().getClassDescription(className);
        }
        return null;
    }

    public Class getObjectClass(Map metaMap) {
        String name = XMLFromMapTransformer.getObjectClassName(metaMap);
        Class<?> objectClass = null;
        if (name != null && !"".equals(name)) {
            try {
                objectClass = Class.forName(name);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        return objectClass;
    }

    @Override
    public String transformFromObjectToString(Object object, List excludeProps) {
        if (object instanceof Map) {
            return XMLFromMapTransformer.transformFromObjectToString((Map)object);
        }
        return null;
    }

    public static void transformMapToXMLFile(Map map, String fileName, boolean compressed) {
        Document doc = XMLFromMapTransformer.transformFromMap(map);
        XMLTransformationManager.saveDocument(fileName, doc, compressed);
    }
}

