/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.metadata;

import java.awt.Point;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.process.TransformationTask;
import oracle.dbtools.crest.model.metadata.ClassDescription;
import oracle.dbtools.crest.model.metadata.MDTransformationManager;
import oracle.dbtools.crest.model.metadata.MDTransformer;
import oracle.dbtools.crest.model.metadata.MDXMLConstants;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import oracle.ide.net.InflaterInputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLToMapTransformer
extends MDTransformer
implements MDXMLConstants {
    private static final Logger LOGGER = new Logger(XMLToMapTransformer.class);
    public static DocumentBuilder DOCUMENT_BUILDER = null;

    @Override
    public String transformFromObjectToString(Object object, List excludeProps) {
        return null;
    }

    public static void transformToMap(Map object, String xml) {
        StringReader reader = new StringReader(xml);
        InputSource inputSource = new InputSource(reader);
        XMLToMapTransformer.transformToMap(object, inputSource);
        reader.close();
    }

    public static void transformToMap(Map object, File file) throws FileNotFoundException, UnsupportedEncodingException {
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
        if (reader != null) {
            InputSource inputSource = new InputSource(reader);
            XMLToMapTransformer.transformToMap(object, inputSource);
            try {
                reader.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public static void transformToMap(Map object, InputStream inputStream, boolean compressed) throws UnsupportedEncodingException {
        if (compressed) {
            try {
                int cnt;
                InflaterInputStream iis = new InflaterInputStream(inputStream);
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                int size = 1024;
                byte[] buffer = new byte[size];
                while ((cnt = iis.read(buffer)) != -1) {
                    bos.write(buffer, 0, cnt);
                }
                ByteArrayInputStream in = new ByteArrayInputStream(bos.toByteArray());
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document doc = db.parse(in);
                bos.close();
                ((InputStream)in).close();
                XMLToMapTransformer.transformToMap(object, doc);
            }
            catch (Exception e) {}
        } else {
            InputStreamReader reader = new InputStreamReader(inputStream, "UTF-8");
            if (reader != null) {
                InputSource inputSource = new InputSource(reader);
                XMLToMapTransformer.transformToMap(object, inputSource);
                try {
                    reader.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
    }

    public static void transformToMap(Map object, InputSource inputSource) {
        Document doc = null;
        try {
            doc = DOCUMENT_BUILDER.parse(inputSource);
        }
        catch (SAXException e) {
            LOGGER.error("XMLToMapTransformer:", e);
        }
        catch (IOException e) {
            LOGGER.error("XMLToMapTransformer:", e);
        }
        if (doc != null) {
            XMLToMapTransformer.transformToMap(object, doc);
        }
    }

    public static void transformToMap(Map object, Document doc) {
        MDTransformationManager transformationManager;
        XMLToMapTransformer tr;
        Element root = doc.getDocumentElement();
        String className = root.getAttribute("class");
        if (className != null && !"".equals(className) && (tr = (XMLToMapTransformer)(transformationManager = ApplicationView.getInstance().getXMLTransformationManager().getXMLMapTransformationManager()).getToObjectTransformerFor(className)) != null) {
            tr.transformToMap(object, root);
        }
    }

    public void transformToMap(Map object, Element rootElement) {
        ClassDescription cd = this.getClassDescription();
        Map propsMap = this.loadElementsAndAttributes(rootElement);
        for (ClassDescription.PropertyDescription pd : cd.getPropertiesList()) {
            this.processProperty(object, propsMap, rootElement, pd);
        }
        String className = (String)object.get("class");
        if (className == null && (className = rootElement.getAttribute("class")) != null && !"".equals(className)) {
            object.put("class", className);
        }
        this.processClassPropertyMap(object, propsMap, cd);
        for (ClassDescription.CollectionDescription cold : cd.getCollectionsList()) {
            this.processCollection(object, propsMap, rootElement, cold);
        }
    }

    private void processClassPropertyMap(Map object, Map propsMap, ClassDescription cd) {
        NodeList elems;
        int count;
        Element element;
        if (cd.isPropertyMap && (element = (Element)propsMap.get("propertyMap")) != null && (count = (elems = element.getElementsByTagName("property")).getLength()) > 0) {
            TreeMap<String, String> map = new TreeMap<String, String>();
            for (int i = 0; i < count; ++i) {
                Element item = (Element)elems.item(i);
                String name = item.getAttribute("name");
                if (name == null || "".equals(name)) continue;
                String value = item.getAttribute("value");
                map.put(StringUtilities.decodeAttributeValue(name), StringUtilities.decodeAttributeValue(value));
            }
            object.put("propertyMap", map);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void processProperty(Map object, Map propsMap, Element root, ClassDescription.PropertyDescription pd) {
        String value;
        block12: {
            boolean useDefault;
            block13: {
                Element element;
                Object node;
                block14: {
                    value = null;
                    useDefault = false;
                    node = propsMap.get(pd.xmlName);
                    if (node == null && pd.oldXmlName != null) {
                        node = propsMap.get(pd.oldXmlName);
                    }
                    if (node == null) break block13;
                    if (!(node instanceof Node) || node instanceof Element) break block14;
                    value = ((Node)node).getNodeValue();
                    break block12;
                }
                if (node instanceof Element && (element = (Element)node) != null) {
                    if (pd.isRectangle) {
                        this.processRectangle(element, object, pd);
                        return;
                    }
                    if (pd.isPropertyMap) {
                        this.processPropertyAsPropertyMap(object, element, pd);
                        return;
                    }
                    if (pd.isMap) {
                        this.processMapProperty(object, element, pd);
                        return;
                    }
                    if (pd.isSimpleClass() || pd.isStringClass() || pd.isReferred()) {
                        Node textNode = element.getFirstChild();
                        if (textNode != null) {
                            value = textNode.getNodeValue();
                            if (!pd.isReferred()) {
                                // empty if block
                            }
                        }
                        break block12;
                    } else if (!pd.isReferred()) {
                        XMLToMapTransformer tr;
                        HashMap nested = new HashMap();
                        object.put(pd.xmlName, nested);
                        String className = element.getAttribute("class");
                        if (className != null && !"".equals(className) && (tr = (XMLToMapTransformer)this.getTransformationManager().getToObjectTransformerFor(className)) != null) {
                            tr.transformToMap(nested, element);
                        }
                        return;
                    }
                }
                break block12;
            }
            useDefault = true;
        }
        if (value != null) {
            value = StringUtilities.decodeAttributeValue(value);
            object.put(pd.xmlName, value);
        }
    }

    private void processPropertyAsPropertyMap(Map object, Element pmElement, ClassDescription.PropertyDescription pd) {
        NodeList elems = pmElement.getElementsByTagName(pd.pmItemName);
        int count = elems.getLength();
        if (count > 0) {
            TreeMap<String, String> map = new TreeMap<String, String>();
            for (int i = 0; i < count; ++i) {
                Element item = (Element)elems.item(i);
                String key = item.getAttribute(pd.pmKeyName);
                String value = item.getAttribute(pd.pmValueName);
                if (key == null || value == null || "".equals(key)) continue;
                map.put(StringUtilities.decodeAttributeValue(key), StringUtilities.decodeAttributeValue(value));
            }
            object.put(pd.xmlName, map);
        }
    }

    private void processMapProperty(Map object, Element pmElement, ClassDescription.PropertyDescription pd) {
        NodeList elems = pmElement.getElementsByTagName(pd.pmItemName);
        int count = elems.getLength();
        if (count > 0) {
            TreeMap<String, String> map = new TreeMap<String, String>();
            for (int i = 0; i < count; ++i) {
                Element item = (Element)elems.item(i);
                String key = item.getAttribute("key");
                String value = item.getAttribute("value");
                if (key == null || value == null || "".equals(key)) continue;
                map.put(StringUtilities.decodeAttributeValue(key), StringUtilities.decodeAttributeValue(value));
            }
            object.put(pd.xmlName, map);
        }
    }

    private void processCollection(Map container, Map propsMap, Element root, ClassDescription.CollectionDescription cold) {
        Element element = (Element)propsMap.get(cold.xmlName);
        if (element != null) {
            NodeList elems;
            int count;
            if (this.canProcessCollectionItem(cold)) {
                ArrayList newItems = new ArrayList();
                if (!cold.itemIsRef) {
                    this.processCollectionWithContained(container, element, cold, newItems);
                } else {
                    this.processCollectionWithRefs(container, element, cold, newItems);
                }
                container.put(cold.xmlName, newItems);
            } else if (cold.isMapItem && (count = (elems = element.getElementsByTagName(cold.itemXmlName)).getLength()) > 0) {
                ArrayList list = new ArrayList();
                for (int i = 0; i < count; ++i) {
                    Element item = (Element)elems.item(i);
                    NamedNodeMap nmap = item.getAttributes();
                    int c = nmap.getLength();
                    if (c <= 0) continue;
                    TreeMap<String, String> map = new TreeMap<String, String>();
                    for (int k = 0; k < c; ++k) {
                        Node node = nmap.item(k);
                        String name = node.getNodeName();
                        String value = node.getNodeValue();
                        map.put(StringUtilities.decodeAttributeValue(name), StringUtilities.decodeAttributeValue(value));
                    }
                    list.add(map);
                }
                container.put(cold.xmlName, list);
            }
        }
    }

    private void processCollectionWithContained(Map container, Element element, ClassDescription.CollectionDescription cold, List newItems) {
        String itemClassName = null;
        if (cold.itemClassName != null && !"".equals(cold.itemClassName)) {
            itemClassName = element.getAttribute("itemClass");
        }
        XMLToMapTransformer tr = null;
        NodeList elems = element.getElementsByTagName(cold.itemXmlName);
        int count = elems.getLength();
        for (int i = 0; i < count; ++i) {
            Element item = (Element)elems.item(i);
            HashMap<String, String> map = new HashMap<String, String>();
            if (map == null) continue;
            String className = item.getAttribute("class");
            if (className == null || "".equals(className)) {
                className = itemClassName;
            }
            if ("".equals(className) && cold.itemClassName != null) {
                className = cold.itemClassName;
            }
            map.put("class", className);
            tr = (XMLToMapTransformer)this.getTransformationManager().getToObjectTransformerFor(className);
            if (tr != null) {
                tr.transformToMap(map, item);
            }
            this.processTopView(map, item, cold);
            newItems.add(map);
        }
    }

    private void processTopView(Map object, Element item, ClassDescription.CollectionDescription cold) {
        String oid = StringUtilities.decodeAttributeValue(item.getAttribute("oid"));
        String type = StringUtilities.decodeAttributeValue(item.getAttribute("otype"));
        String vid = StringUtilities.decodeAttributeValue(item.getAttribute("vid"));
        String dpvid = StringUtilities.decodeAttributeValue(item.getAttribute("dpv_id"));
        String vnum = StringUtilities.decodeAttributeValue(item.getAttribute("vnum"));
        String vid_source = StringUtilities.decodeAttributeValue(item.getAttribute("vid_source"));
        String vid_target = StringUtilities.decodeAttributeValue(item.getAttribute("vid_target"));
        boolean connector = false;
        if (oid != null && !"".equals(oid)) {
            object.put("oid", oid);
        }
        if (type != null && !"".equals(type)) {
            object.put("otype", type);
        }
        if (vid != null && !"".equals(vid)) {
            object.put("vid", vid);
        }
        if (dpvid != null && !"".equals(dpvid)) {
            object.put("vid", dpvid);
        }
        if (vnum != null && !"".equals(vnum)) {
            object.put("vnum", vnum);
        }
        if (vid_source != null && !"".equals(vid_source)) {
            object.put("vid_source", vid_source);
            connector = true;
        }
        if (vid_target != null && !"".equals(vid_target)) {
            object.put("vid_target", vid_target);
            connector = true;
        }
        if (cold.isTVConnectorItem || connector) {
            this.processPointsCollection(item, object);
        } else if (object instanceof ContainerView) {
            // empty if block
        }
    }

    private void processRectangle(Element propElement, Map object, ClassDescription.PropertyDescription pd) {
        String xs = propElement.getAttribute("x");
        String ys = propElement.getAttribute("y");
        String ws = propElement.getAttribute("width");
        String hs = propElement.getAttribute("height");
        Integer x = 0;
        Integer y = 0;
        Integer w = 20;
        Integer h = 20;
        try {
            x = Integer.valueOf(xs);
            y = Integer.valueOf(ys);
            w = Integer.valueOf(ws);
            h = Integer.valueOf(hs);
        }
        catch (Exception e) {
            // empty catch block
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("x", x);
        map.put("y", y);
        map.put("width", w);
        map.put("height", h);
        object.put(pd.xmlName, map);
    }

    private void processPointsCollection(Element element, Map object) {
        NodeList plist;
        int plLength;
        Element points = XMLToMapTransformer.getFirstChildByTagName(element, "points");
        if (points != null && (plLength = (plist = points.getElementsByTagName("point")).getLength()) > 0) {
            ArrayList<Point> list = new ArrayList<Point>();
            for (int kk = 0; kk < plLength; ++kk) {
                Element point = (Element)plist.item(kk);
                String px = point.getAttribute("x");
                String py = point.getAttribute("y");
                int x = 0;
                int y = 0;
                try {
                    x = Integer.valueOf(px);
                    y = Integer.valueOf(py);
                }
                catch (Exception e) {
                    // empty catch block
                }
                Point p = new Point(x, y);
                list.add(p);
            }
            object.put("points", list);
        }
    }

    public static Element getFirstChildByTagName(Element parent, String tagName) {
        NodeList children = parent.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !((Element)child).getTagName().equals(tagName)) continue;
            return (Element)child;
        }
        return null;
    }

    private Object getOrCreateTopView(DesignPartView dpv, Element item, ClassDescription.CollectionDescription cold) {
        if (cold.isObjectViewItem) {
            String oid = StringUtilities.decodeAttributeValue(item.getAttribute("oid"));
            DesignObject object = dpv.getDesignPart().getDesign().getDesignObject(oid);
            if (object == null && dpv.getDesignPart() instanceof TransformationTask) {
                String type = StringUtilities.decodeAttributeValue(item.getAttribute("otype"));
                if ("InOutParams".equalsIgnoreCase(type)) {
                    object = ((TransformationTask)dpv.getDesignPart()).getInOutParamsObjectById(oid);
                } else if ("InfoStore".equalsIgnoreCase(type)) {
                    object = ((TransformationTask)dpv.getDesignPart()).getInfoStoreSet().getObjectByID(oid);
                }
            }
            if (object != null) {
                String vid = StringUtilities.decodeAttributeValue(item.getAttribute("vid"));
                String vnum = StringUtilities.decodeAttributeValue(item.getAttribute("vnum"));
                int num = 0;
                try {
                    num = Integer.valueOf(vnum);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                TopView cv = object.getTopViewByID(dpv, vid, num);
                if (cv == null) {
                    cv = dpv.createTopViewForGlobal(object);
                }
                cv.setViewID(vid);
                return cv;
            }
        }
        return null;
    }

    private void processCollectionWithRefs(Map container, Element element, ClassDescription.CollectionDescription cold, List newItems) {
        block4: {
            block3: {
                if (!cold.listOfRefs) break block3;
                String refs = element.getAttribute(cold.refsXMLName);
                if (refs == null || "".equals(refs)) break block4;
                String[] ids = refs.split(" ");
                for (int i = 0; i < ids.length; ++i) {
                    newItems.add(ids[i]);
                }
                break block4;
            }
            NodeList elems = element.getElementsByTagName(cold.itemXmlName);
            int count = elems.getLength();
            if (count > 0) {
                for (int i = 0; i < count; ++i) {
                    Element item = (Element)elems.item(i);
                    Node textNode = item.getFirstChild();
                    if (textNode == null) continue;
                    String value = textNode.getNodeValue();
                    newItems.add(value);
                }
            }
        }
    }

    private Map loadElementsAndAttributes(Element root) {
        HashMap<String, Node> map = new HashMap<String, Node>();
        NodeList nodes = root.getChildNodes();
        int count = nodes.getLength();
        for (int i = 0; i < count; ++i) {
            Node child = nodes.item(i);
            if (child.getNodeType() != 1) continue;
            Element element = (Element)child;
            map.put(element.getTagName(), element);
        }
        NamedNodeMap nmap = root.getAttributes();
        int c = nmap.getLength();
        if (c > 0) {
            for (int k = 0; k < c; ++k) {
                Node node = nmap.item(k);
                String name = node.getNodeName();
                map.put(name, node);
            }
        }
        return map;
    }

    static {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DOCUMENT_BUILDER = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
    }
}

