/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.metadata.compare;

import java.util.Map;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.metadata.ClassDescription;

public class MetaPropertyHolder
extends EngPropertyHolder {
    private ClassDescription.PropertyDescription pd;
    private Map leftMap;
    private Map rightMap;
    private String leftValuePresentation;
    private String rightValuePresentation;
    private String presentationName;
    private boolean merged = false;

    public MetaPropertyHolder(ClassDescription.PropertyDescription pd, Map leftMap, Map rightMap) {
        super(pd.name);
        this.setPresentationName(pd.presentationName);
        this.pd = pd;
        this.leftMap = leftMap;
        this.rightMap = rightMap;
    }

    public MetaPropertyHolder(String name) {
        super(name);
    }

    public boolean isColorProperty() {
        if (this.pd == null) {
            return false;
        }
        return this.pd.isColorProperty || "java.awt.Color".equals(this.pd.className);
    }

    public String getLeftValuePresentation() {
        if (this.leftValuePresentation != null) {
            return this.leftValuePresentation;
        }
        return this.getLeftValue();
    }

    public String getRightValuePresentation() {
        if (this.rightValuePresentation != null) {
            return this.rightValuePresentation;
        }
        return this.getRightValue();
    }

    public void setLeftValuePresentation(String leftValuePresentation) {
        this.leftValuePresentation = leftValuePresentation;
    }

    public void setRightValuePresentation(String rightValuePresentation) {
        this.rightValuePresentation = rightValuePresentation;
    }

    public String getPresentationName() {
        if (this.presentationName == null) {
            return this.getName();
        }
        return this.presentationName;
    }

    public void setPresentationName(String presentationName) {
        this.presentationName = presentationName;
    }

    public ClassDescription.PropertyDescription getPropertyDescription() {
        return this.pd;
    }

    public Map getLeftMap() {
        return this.leftMap;
    }

    public Map getRightMap() {
        return this.rightMap;
    }

    public boolean isMerged() {
        return this.merged;
    }

    public void setMerged(boolean merged) {
        this.merged = merged;
    }
}

