/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.zip.InflaterInputStream;
import oracle.dbtools.crest.model.MDConfiguration;
import oracle.dbtools.crest.model.persistence.AbstractFileManager;
import oracle.dbtools.crest.model.persistence.PersistenceManager;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.jdbc.OracleDriver;
import oracle.jdbc.OraclePreparedStatement;
import oracle.sql.BLOB;

public class FileManager
extends AbstractFileManager {
    private File defaultPath;
    private String designPath = "";
    private FilenameFilter extensionFilter;
    private static final Logger LOGGER;
    public static int DB_REPOSITORY;
    public static int FILE_REPOSITORY;
    public static int REPOSITORY_TYPE;
    Connection conn = null;
    OraclePreparedStatement stmt = null;

    public FileManager() {
        String path = MDConfiguration.getDefaultInstance().get("defaultFilePath");
        this.setBasePath(path);
    }

    @Override
    public boolean setBasePath(String path) {
        File p = new File(path);
        if (!p.exists()) {
            p.mkdirs();
        }
        this.defaultPath = p;
        return true;
    }

    public File getBasePath() {
        return this.defaultPath;
    }

    protected FilenameFilter getExtensionFilter() {
        if (this.extensionFilter == null) {
            this.extensionFilter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(FileManager.this.getFileExtension());
                }
            };
        }
        return this.extensionFilter;
    }

    @Override
    public boolean store(PersistenceManager pm, String location, String name, String data) {
        try {
            File path = this.getAbsolutePath(pm, location, name, true);
            File file = new File(path, this.toFileName(name));
            if (!path.exists()) {
                path.mkdirs();
            }
            file.createNewFile();
            BufferedWriter fout = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            fout.write(data);
            ((Writer)fout).close();
            return true;
        }
        catch (IOException e) {
            LOGGER.error("Can not write data! Location: " + location + " - Name: " + name, e);
            pm.setSaveFailed(true);
            return false;
        }
    }

    @Override
    public boolean store(PersistenceManager pm, String location, String name, InputStream data) {
        return this.store(pm, location, name, data, this.getStartWriterThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean store(PersistenceManager pm, String location, String name, InputStream data, boolean seperateThread) {
        try {
            File path = this.getAbsolutePath(pm, location, name, true);
            if (name.endsWith("_Domains")) {
                File lockFile = new File("c:/lock.pid");
                lockFile.createNewFile();
                try {
                    File file = new File(path, this.toFileName(name));
                    file.createNewFile();
                    FileOutputStream fout = new FileOutputStream(file);
                    if (seperateThread) {
                        Thread thread = new Thread(new StreamCopier(data, fout));
                        thread.start();
                    }
                    new StreamCopier(data, fout).run();
                }
                finally {
                    lockFile.delete();
                }
            } else {
                File file = new File(path, this.toFileName(name));
                file.createNewFile();
                FileOutputStream fout = new FileOutputStream(file);
                if (seperateThread) {
                    Thread thread = new Thread(new StreamCopier(data, fout));
                    thread.start();
                } else {
                    new StreamCopier(data, fout).run();
                }
            }
            return true;
        }
        catch (IOException e) {
            LOGGER.error("Can not write data! Location: " + location + " - Name: " + name, e);
            pm.setSaveFailed(true);
            return false;
        }
    }

    @Override
    public String readData(PersistenceManager pm, String location, String name) {
        try {
            InputStream is = this.getDataInputStreamWithoutExtension(pm, location, name);
            if (is == null) {
                LOGGER.error("Stream for: " + location + " " + name + " was null.");
                return "";
            }
            BufferedReader fin = new BufferedReader(new InputStreamReader(is));
            StringBuffer buffer = new StringBuffer();
            while (fin.ready()) {
                buffer.append(fin.readLine());
            }
            fin.close();
            return buffer.toString();
        }
        catch (IOException e) {
            LOGGER.error("Can not read data: ", e);
            return null;
        }
    }

    protected File[] listFiles(String location) {
        File path = this.getAbsolutePath(location, false);
        return path.listFiles(this.getExtensionFilter());
    }

    @Override
    public boolean exists(PersistenceManager pm, String location, String filenameNoExt) {
        File file = null;
        file = filenameNoExt == null ? this.getAbsolutePath(pm, location, filenameNoExt, false) : new File(this.getAbsolutePath(pm, location, filenameNoExt, false), this.toFileName(filenameNoExt));
        return file.exists();
    }

    @Override
    public boolean deleteDesign(PersistenceManager pm, String location, String filenameNoExt, String user) {
        File file = null;
        boolean result = true;
        if (filenameNoExt != null) {
            file = new File(this.getAbsolutePath(pm, location, filenameNoExt, false), this.toFileName(filenameNoExt));
            if (file.exists()) {
                result = file.delete();
            }
            if ((file = new File(this.getAbsolutePath(pm, location, filenameNoExt, false), filenameNoExt)).exists() && file.isDirectory()) {
                result = this.deleteDirectory(file, user);
            }
        }
        return result;
    }

    private boolean deleteDirectory(File dir, String user) {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.deleteDirectory(files[i], user);
                continue;
            }
            files[i].delete();
        }
        return dir.delete();
    }

    @Override
    public boolean unlockDesign(String location, String filenameNoExt, String user) {
        return true;
    }

    @Override
    public Object[] listNames(String location) {
        File path = this.getAbsolutePath(location, true);
        return path.list(this.getExtensionFilter());
    }

    @Override
    public InputStream getDataInputStreamWithoutExtension(PersistenceManager pm, String location, String name) {
        return this.getDataInputStream(pm, location, this.toFileName(name));
    }

    @Override
    public InputStream getDataInputStream(PersistenceManager pm, String location, Object name) {
        try {
            String fpath;
            String fileName = this.toFileName((String)name);
            File path = this.getAbsolutePath(pm, location, fileName, false);
            File file = new File(path, fileName);
            if (REPOSITORY_TYPE == DB_REPOSITORY && this.isDBPath(fpath = file.getAbsolutePath())) {
                try {
                    return this.getStreamFromDB(fpath);
                }
                catch (Exception e) {
                    LOGGER.error("getStreamFromDB: Can not read data", e);
                    return null;
                }
            }
            return new FileInputStream(file);
        }
        catch (IOException e) {
            String sname;
            boolean logit = true;
            if (name != null && name instanceof String && (sname = (String)name).indexOf("defaultdomains.") > -1) {
                logit = false;
            }
            if (logit) {
                LOGGER.error("getDataInputStream: Can not read data", e);
            }
            return null;
        }
    }

    private boolean isDBPath(String path) {
        String pupp = path.toUpperCase();
        return pupp.indexOf("\\MTC2.XML") <= -1 && pupp.indexOf("\\logtypes\\types.xml".toUpperCase()) <= -1 && pupp.indexOf("\\domains\\defaultdomains.xml".toUpperCase()) <= -1 && pupp.indexOf("RDBMSSites.xml".toUpperCase()) <= -1 && pupp.indexOf("\\mtc2_Domains.xml".toUpperCase()) <= -1 && pupp.indexOf("\\businessinfo\\".toUpperCase()) <= -1 && pupp.indexOf("\\mtc2\\datatypes\\".toUpperCase()) <= -1 && pupp.indexOf("mtc2\\processmodel\\".toUpperCase()) <= -1 && pupp.indexOf("mtc2\\owbmetadata\\".toUpperCase()) <= -1;
    }

    private InputStream getStreamFromDB(String path) throws SQLException, IOException {
        BLOB blob;
        String url = "";
        String pass = "";
        String user = "";
        if (this.conn == null) {
            DriverManager.registerDriver((Driver)new OracleDriver());
            this.conn = DriverManager.getConnection(url, user, pass);
            this.conn.setAutoCommit(false);
            this.stmt = (OraclePreparedStatement)this.conn.prepareStatement("select xml_content from jr.tables_4 where file_name = ?");
        }
        this.stmt.setString(1, path);
        ResultSet rs = this.stmt.executeQuery();
        if (rs.next() && (blob = (BLOB)rs.getBlob(1)) != null) {
            int cnt;
            int size = blob.getBufferSize();
            ByteArrayOutputStream out = new ByteArrayOutputStream(size);
            InflaterInputStream z = new InflaterInputStream(blob.getBinaryStream());
            byte[] buffer = new byte[size];
            int all_cnt = 0;
            while ((cnt = z.read(buffer)) != -1) {
                out.write(buffer, 0, cnt);
                all_cnt += cnt;
            }
            byte[] result = out.toByteArray();
            z.close();
            out.close();
            return new ByteArrayInputStream(result);
        }
        return null;
    }

    @Override
    public String[] listNamesNoFileExtension(String location) {
        int suffixLength = this.getFileExtension().length() + 1;
        String[] namesExt = (String[])this.listNames(location);
        if (namesExt != null) {
            for (int i = 0; i < namesExt.length; ++i) {
                namesExt[i] = namesExt[i].substring(0, namesExt[i].length() - suffixLength);
            }
            return namesExt;
        }
        return null;
    }

    @Override
    public File getAbsolutePath(PersistenceManager pm, String location, String name, boolean makeDirs) {
        if (this.isSystemName(this.removeExt(name))) {
            String sysTypesPath = pm.getAppView().getSettings().getDefaultSystemTypesPath();
            File file = new File(sysTypesPath);
            if (sysTypesPath.length() == 0 || !file.exists()) {
                return this.getAbsolutePath(location, makeDirs);
            }
            return file;
        }
        File path = this.designPath == null || "".equalsIgnoreCase(this.designPath) ? new File(location) : new File(this.designPath, location);
        if (makeDirs) {
            path.mkdirs();
        }
        return path;
    }

    public File getAbsolutePath(String location, boolean makeDirs) {
        File path = this.defaultPath == null ? new File(location) : new File(this.defaultPath, location);
        if (makeDirs) {
            path.mkdirs();
        }
        return path;
    }

    private boolean isSystemName(String name) {
        String[] VALID_NAMES = new String[]{"defaultRDBMSSites", "defaultdomains", "types"};
        HashSet<String> vns = new HashSet<String>();
        vns.addAll(Arrays.asList(VALID_NAMES));
        return vns.contains(name);
    }

    @Override
    public String getDataPath() {
        return this.designPath;
    }

    @Override
    public boolean isWriteFinished() {
        File lockFile = new File("c:/lock.pid");
        return !lockFile.exists();
    }

    @Override
    public void setDesignPath(String designPath) {
        this.designPath = designPath;
    }

    @Override
    public boolean deleteFiles(List files) {
        boolean result = false;
        System.gc();
        for (int i = 0; i < files.size(); ++i) {
            File file;
            String filePath = (String)files.get(i);
            if (filePath == null || !(file = new File(this.fixFilePath(filePath))).exists()) continue;
            if (file.isDirectory()) {
                result = this.deleteDirectory(file, "");
                continue;
            }
            result = file.delete();
            if (result) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            result = file.delete();
        }
        return result;
    }

    static {
        DB_REPOSITORY = 2;
        REPOSITORY_TYPE = FILE_REPOSITORY = 1;
        LOGGER = new Logger(FileManager.class);
    }

    private class StreamCopier
    implements Runnable {
        InputStream in;
        OutputStream out;

        private StreamCopier(InputStream in, OutputStream out) {
            this.in = in;
            this.out = out;
        }

        @Override
        public void run() {
            try {
                int c;
                while (-1 != (c = this.in.read())) {
                    this.out.write(c);
                }
                this.out.flush();
                this.out.close();
            }
            catch (IOException e) {
                LOGGER.error("Error in StreamCopier.run", e);
            }
        }
    }
}

