/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.ChangeRequest;
import oracle.dbtools.crest.model.MDConfiguration;
import oracle.dbtools.crest.model.MDUser;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.businessinfo.BusinessInfoDesign;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.LogicalDatatypeSet;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.ProcessModel;
import oracle.dbtools.crest.model.design.process.TransformationTask;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.RDBMSSiteSet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.persistence.AbstractFileManager;
import oracle.dbtools.crest.model.persistence.FileManager;
import oracle.dbtools.crest.model.persistence.PersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLReader;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLWriter;
import oracle.dbtools.crest.model.persistence.xml.RXMLArc;
import oracle.dbtools.crest.model.persistence.xml.RXMLChangeRequest;
import oracle.dbtools.crest.model.persistence.xml.RXMLDesign;
import oracle.dbtools.crest.model.persistence.xml.RXMLDomain;
import oracle.dbtools.crest.model.persistence.xml.RXMLDomainFile;
import oracle.dbtools.crest.model.persistence.xml.RXMLEntity;
import oracle.dbtools.crest.model.persistence.xml.RXMLEntityView;
import oracle.dbtools.crest.model.persistence.xml.RXMLFKArc;
import oracle.dbtools.crest.model.persistence.xml.RXMLForeignKey;
import oracle.dbtools.crest.model.persistence.xml.RXMLInheritanceRelation;
import oracle.dbtools.crest.model.persistence.xml.RXMLLogicalDesign;
import oracle.dbtools.crest.model.persistence.xml.RXMLLogicalNote;
import oracle.dbtools.crest.model.persistence.xml.RXMLLogicalType;
import oracle.dbtools.crest.model.persistence.xml.RXMLRDBMSSiteSet;
import oracle.dbtools.crest.model.persistence.xml.RXMLRelation;
import oracle.dbtools.crest.model.persistence.xml.RXMLRelationalDesign;
import oracle.dbtools.crest.model.persistence.xml.RXMLRelationalNote;
import oracle.dbtools.crest.model.persistence.xml.RXMLSubview;
import oracle.dbtools.crest.model.persistence.xml.RXMLTable;
import oracle.dbtools.crest.model.persistence.xml.RXMLTableView;
import oracle.dbtools.crest.model.persistence.xml.WXMLArc;
import oracle.dbtools.crest.model.persistence.xml.WXMLChangeRequest;
import oracle.dbtools.crest.model.persistence.xml.WXMLDesign;
import oracle.dbtools.crest.model.persistence.xml.WXMLDomain;
import oracle.dbtools.crest.model.persistence.xml.WXMLDomainFile;
import oracle.dbtools.crest.model.persistence.xml.WXMLEntity;
import oracle.dbtools.crest.model.persistence.xml.WXMLEntityView;
import oracle.dbtools.crest.model.persistence.xml.WXMLFKArc;
import oracle.dbtools.crest.model.persistence.xml.WXMLForeignKey;
import oracle.dbtools.crest.model.persistence.xml.WXMLInheritanceRelation;
import oracle.dbtools.crest.model.persistence.xml.WXMLLogicalDesign;
import oracle.dbtools.crest.model.persistence.xml.WXMLNote;
import oracle.dbtools.crest.model.persistence.xml.WXMLRDBMSSiteSet;
import oracle.dbtools.crest.model.persistence.xml.WXMLRelation;
import oracle.dbtools.crest.model.persistence.xml.WXMLRelationalDesign;
import oracle.dbtools.crest.model.persistence.xml.WXMLSubview;
import oracle.dbtools.crest.model.persistence.xml.WXMLTable;
import oracle.dbtools.crest.model.persistence.xml.WXMLTableView;
import oracle.dbtools.crest.model.persistence.xml.WXMLTypesFile;
import oracle.dbtools.crest.model.persistence.xml.WordMapperWriter;
import oracle.dbtools.crest.model.persistence.xml.businessinfo.RXMLBusinessInfoDesign;
import oracle.dbtools.crest.model.persistence.xml.businessinfo.RXMLContact;
import oracle.dbtools.crest.model.persistence.xml.businessinfo.RXMLDocument;
import oracle.dbtools.crest.model.persistence.xml.businessinfo.RXMLEmail;
import oracle.dbtools.crest.model.persistence.xml.businessinfo.RXMLLocation;
import oracle.dbtools.crest.model.persistence.xml.businessinfo.RXMLParty;
import oracle.dbtools.crest.model.persistence.xml.businessinfo.RXMLPhone;
import oracle.dbtools.crest.model.persistence.xml.businessinfo.RXMLUrl;
import oracle.dbtools.crest.model.persistence.xml.businessinfo.WXMLBusinessInfoDesign;
import oracle.dbtools.crest.model.persistence.xml.businessinfo.WXMLContact;
import oracle.dbtools.crest.model.persistence.xml.businessinfo.WXMLDocument;
import oracle.dbtools.crest.model.persistence.xml.businessinfo.WXMLEmail;
import oracle.dbtools.crest.model.persistence.xml.businessinfo.WXMLLocation;
import oracle.dbtools.crest.model.persistence.xml.businessinfo.WXMLParty;
import oracle.dbtools.crest.model.persistence.xml.businessinfo.WXMLPhone;
import oracle.dbtools.crest.model.persistence.xml.businessinfo.WXMLUrl;
import oracle.dbtools.crest.model.persistence.xml.datatypes.RXMLCollectionType;
import oracle.dbtools.crest.model.persistence.xml.datatypes.RXMLDTNote;
import oracle.dbtools.crest.model.persistence.xml.datatypes.RXMLDataTypesDesign;
import oracle.dbtools.crest.model.persistence.xml.datatypes.RXMLDistinctType;
import oracle.dbtools.crest.model.persistence.xml.datatypes.RXMLStructuredType;
import oracle.dbtools.crest.model.persistence.xml.datatypes.WXMLCollectionType;
import oracle.dbtools.crest.model.persistence.xml.datatypes.WXMLDataTypesDesign;
import oracle.dbtools.crest.model.persistence.xml.datatypes.WXMLDistinctType;
import oracle.dbtools.crest.model.persistence.xml.datatypes.WXMLStructuredType;
import oracle.dbtools.crest.model.persistence.xml.mapping.RXMLExtendedMap;
import oracle.dbtools.crest.model.persistence.xml.mapping.WXMLExtendedMap;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.RXMLCube;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.RXMLDimension;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.RXMLFactEntitiesJoin;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.RXMLHierarchy;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.RXMLLevel;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.RXMLLink;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.RXMLMDNote;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.RXMLMeasure;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.RXMLMeasureFolder;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.RXMLMultidimensionalDesign;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.RXMLRaggedHLink;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.RXMLRollupLink;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.RXMLSQLAccessToAW;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.RXMLSelectionCriteria;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.RXMLSlice;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.WXMLCube;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.WXMLDimension;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.WXMLFactEntitiesJoin;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.WXMLHierarchy;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.WXMLLevel;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.WXMLLink;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.WXMLMeasure;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.WXMLMeasureFolder;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.WXMLMultidimensionalDesign;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.WXMLRaggedHLink;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.WXMLRollupLink;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.WXMLSQLAccessToAW;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.WXMLSelectionCriteria;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.WXMLSlice;
import oracle.dbtools.crest.model.persistence.xml.process.RXMLAgent;
import oracle.dbtools.crest.model.persistence.xml.process.RXMLDataFlowDesign;
import oracle.dbtools.crest.model.persistence.xml.process.RXMLDataFlowNote;
import oracle.dbtools.crest.model.persistence.xml.process.RXMLEvent;
import oracle.dbtools.crest.model.persistence.xml.process.RXMLExternalData;
import oracle.dbtools.crest.model.persistence.xml.process.RXMLFlow;
import oracle.dbtools.crest.model.persistence.xml.process.RXMLInfoStructure;
import oracle.dbtools.crest.model.persistence.xml.process.RXMLProcess;
import oracle.dbtools.crest.model.persistence.xml.process.RXMLProcessModel;
import oracle.dbtools.crest.model.persistence.xml.process.RXMLRecordStructure;
import oracle.dbtools.crest.model.persistence.xml.process.RXMLRole;
import oracle.dbtools.crest.model.persistence.xml.process.RXMLStore;
import oracle.dbtools.crest.model.persistence.xml.process.RXMLTrTaskNote;
import oracle.dbtools.crest.model.persistence.xml.process.RXMLTransformation;
import oracle.dbtools.crest.model.persistence.xml.process.RXMLTransformationFlow;
import oracle.dbtools.crest.model.persistence.xml.process.RXMLTransformationPackage;
import oracle.dbtools.crest.model.persistence.xml.process.RXMLTransformationTask;
import oracle.dbtools.crest.model.persistence.xml.process.WXMLAgent;
import oracle.dbtools.crest.model.persistence.xml.process.WXMLDataFlowDesign;
import oracle.dbtools.crest.model.persistence.xml.process.WXMLEvent;
import oracle.dbtools.crest.model.persistence.xml.process.WXMLExternalData;
import oracle.dbtools.crest.model.persistence.xml.process.WXMLFlow;
import oracle.dbtools.crest.model.persistence.xml.process.WXMLInfoStructure;
import oracle.dbtools.crest.model.persistence.xml.process.WXMLProcess;
import oracle.dbtools.crest.model.persistence.xml.process.WXMLProcessModel;
import oracle.dbtools.crest.model.persistence.xml.process.WXMLRecordStructure;
import oracle.dbtools.crest.model.persistence.xml.process.WXMLRole;
import oracle.dbtools.crest.model.persistence.xml.process.WXMLStore;
import oracle.dbtools.crest.model.persistence.xml.process.WXMLTransfomationPackage;
import oracle.dbtools.crest.model.persistence.xml.process.WXMLTransformation;
import oracle.dbtools.crest.model.persistence.xml.process.WXMLTransformationFlow;
import oracle.dbtools.crest.model.persistence.xml.process.WXMLTransformationTask;
import oracle.dbtools.crest.model.persistence.xml.storage.db2.v70.RXMLStorageDesignDB2v70;
import oracle.dbtools.crest.model.persistence.xml.storage.db2.v70.WXMLStorageDesignDB2v70;
import oracle.dbtools.crest.model.persistence.xml.storage.db2.v80.RXMLStorageDesignDB2v80;
import oracle.dbtools.crest.model.persistence.xml.storage.db2.v80.WXMLStorageDesignDB2v80;
import oracle.dbtools.crest.model.persistence.xml.storage.oracle.v10g.RXMLStorageDesignOraclev10g;
import oracle.dbtools.crest.model.persistence.xml.storage.oracle.v10g.WXMLStorageDesignOraclev10g;
import oracle.dbtools.crest.model.persistence.xml.storage.oracle.v11g.RXMLStorageDesignOraclev11g;
import oracle.dbtools.crest.model.persistence.xml.storage.oracle.v11g.WXMLStorageDesignOraclev11g;
import oracle.dbtools.crest.model.persistence.xml.storage.oracle.v12c.RXMLStorageDesignOraclev12c;
import oracle.dbtools.crest.model.persistence.xml.storage.oracle.v12c.WXMLStorageDesignOraclev12c;
import oracle.dbtools.crest.model.persistence.xml.storage.oracle.v9i.RXMLStorageDesignOraclev9i;
import oracle.dbtools.crest.model.persistence.xml.storage.oracle.v9i.WXMLStorageDesignOraclev9i;
import oracle.dbtools.crest.model.persistence.xml.storage.sqlserver.v2k.RXMLStorageDesignSqlServerv2k;
import oracle.dbtools.crest.model.persistence.xml.storage.sqlserver.v2k.WXMLStorageDesignSqlServerv2k;
import oracle.dbtools.crest.model.persistence.xml.storage.sqlserver.v2k5.RXMLStorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.persistence.xml.storage.sqlserver.v2k5.WXMLStorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.persistence.xml.storage.udb.v71.RXMLStorageDesignUDBv71;
import oracle.dbtools.crest.model.persistence.xml.storage.udb.v71.WXMLStorageDesignUDBv71;
import oracle.dbtools.crest.model.persistence.xml.storage.udb.v81.RXMLStorageDesignUDBv81;
import oracle.dbtools.crest.model.persistence.xml.storage.udb.v81.WXMLStorageDesignUDBv81;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.propertymap.wrapperpool.PMWPoolMap;
import oracle.dbtools.crest.util.runtime.RuntimeMonitor;
import org.w3c.dom.Document;

public class XMLPersistenceManager
extends PersistenceManager {
    protected AbstractFileManager filemanager;
    private AbstractXMLWriter firstWriter;
    private AbstractXMLWriter relationalDesignWriter;
    private AbstractXMLWriter logicalDesignWriter;
    private AbstractXMLWriter processModelWriter;
    private AbstractXMLWriter dataflowDesignWriter;
    private AbstractXMLWriter transformationTaskWriter;
    private AbstractXMLWriter mdDesignWriter;
    private AbstractXMLWriter biDesignWriter;
    private AbstractXMLWriter dtDesignWriter;
    protected AbstractXMLReader firstReader;
    protected AbstractXMLReader relationalDesignReader;
    protected AbstractXMLReader logicalDesignReader;
    protected AbstractXMLReader extendedMapReader;
    protected AbstractXMLReader processModelReader;
    protected AbstractXMLReader dataflowDesignReader;
    protected AbstractXMLReader transformationTaskReader;
    protected AbstractXMLReader mdDesignReader;
    protected AbstractXMLReader biDesignReader;
    protected AbstractXMLReader dtDesignReader;
    protected Map bypassReaders = new TreeMap();
    private RXMLDesign designReader;
    private PMWPoolMap pmwPoolMap;
    private ApplicationView appView;
    private WXMLSubview designPartViewWriter;
    private RXMLSubview designPartViewReader;
    private WXMLDomain domainWriter = null;
    private RXMLDomain domainReader = null;
    private RXMLDomainFile domainFileReader = null;
    private WXMLTypesFile ldtWriter = null;
    private RXMLLogicalType ldtReader = null;
    private WXMLRDBMSSiteSet rdbmsWriter = null;
    private RXMLRDBMSSiteSet rdbmsReader = null;
    private static final Logger LOGGER = new Logger(XMLPersistenceManager.class);

    public XMLPersistenceManager(MDConfiguration config) {
        this.filemanager = new FileManager();
        this.filemanager.setBasePath(config.get("defaultFilePath"));
        this.filemanager.setUserName(new MDUser().toString());
    }

    protected AbstractXMLWriter getFirstWriter() {
        if (this.firstWriter == null) {
            this.initWriterChain();
        }
        return this.firstWriter;
    }

    private void initWriterChain() {
        this.appendWriter(new WXMLTypesFile(this));
        this.appendWriter(new WXMLDesign(this));
        this.appendWriter(new WXMLExtendedMap(this));
        this.appendWriter(new WXMLChangeRequest(this));
        this.dtDesignWriter = new WXMLDataTypesDesign(this);
        this.appendWriter(this.dtDesignWriter);
        this.logicalDesignWriter = new WXMLLogicalDesign(this);
        this.appendWriter(this.logicalDesignWriter);
        this.relationalDesignWriter = new WXMLRelationalDesign(this);
        this.appendWriter(this.relationalDesignWriter);
        this.processModelWriter = new WXMLProcessModel(this);
        this.appendWriter(this.processModelWriter);
        this.dataflowDesignWriter = new WXMLDataFlowDesign(this);
        this.appendWriter(this.dataflowDesignWriter);
        this.mdDesignWriter = new WXMLMultidimensionalDesign(this);
        this.appendWriter(this.mdDesignWriter);
        this.biDesignWriter = new WXMLBusinessInfoDesign(this);
        this.appendWriter(this.biDesignWriter);
        this.appendWriter(new WXMLDistinctType(this));
        this.appendWriter(new WXMLStructuredType(this));
        this.appendWriter(new WXMLCollectionType(this));
        this.appendWriter(new WXMLEntity(this));
        this.appendWriter(new WXMLEntityView(this));
        this.appendWriter(new WXMLRelation(this));
        this.appendWriter(new WXMLInheritanceRelation(this));
        this.appendWriter(new WXMLArc(this));
        this.appendWriter(new WXMLTable(this));
        this.appendWriter(new WXMLForeignKey(this));
        this.appendWriter(new WXMLFKArc(this));
        this.appendWriter(new WXMLTableView(this));
        this.appendWriter(new WXMLNote(this));
        this.appendWriter(new WXMLDomainFile(this));
        this.appendWriter(new WXMLRDBMSSiteSet(this));
        this.appendWriter(new WXMLSelectionCriteria(this));
        this.appendWriter(new WXMLLevel(this));
        this.appendWriter(new WXMLHierarchy(this));
        this.appendWriter(new WXMLDimension(this));
        this.appendWriter(new WXMLSlice(this));
        this.appendWriter(new WXMLMeasure(this));
        this.appendWriter(new WXMLCube(this));
        this.appendWriter(new WXMLLink(this));
        this.appendWriter(new WXMLRollupLink(this));
        this.appendWriter(new WXMLRaggedHLink(this));
        this.appendWriter(new WXMLFactEntitiesJoin(this));
        this.appendWriter(new WXMLMeasureFolder(this));
        this.appendWriter(new WXMLSQLAccessToAW(this));
        this.appendWriter(new WXMLProcess(this));
        this.appendWriter(new WXMLAgent(this));
        this.appendWriter(new WXMLStore(this));
        this.appendWriter(new WXMLFlow(this));
        this.appendWriter(new WXMLInfoStructure(this));
        this.appendWriter(new WXMLEvent(this));
        this.appendWriter(new WXMLRole(this));
        this.appendWriter(new WXMLExternalData(this));
        this.appendWriter(new WXMLRecordStructure(this));
        this.appendWriter(new WXMLTransfomationPackage(this));
        this.transformationTaskWriter = new WXMLTransformationTask(this);
        this.appendWriter(this.transformationTaskWriter);
        this.appendWriter(new WXMLTransformation(this));
        this.appendWriter(new WXMLTransformationFlow(this));
        this.appendWriter(new WXMLStorageDesignOraclev9i(this));
        this.appendWriter(new WXMLStorageDesignOraclev10g(this));
        this.appendWriter(new WXMLStorageDesignOraclev11g(this));
        this.appendWriter(new WXMLStorageDesignOraclev12c(this));
        this.appendWriter(new WXMLStorageDesignSqlServerv2k(this));
        this.appendWriter(new WXMLStorageDesignSqlServerv2k5(this));
        this.appendWriter(new WXMLStorageDesignUDBv71(this));
        this.appendWriter(new WXMLStorageDesignUDBv81(this));
        this.appendWriter(new WXMLStorageDesignDB2v70(this));
        this.appendWriter(new WXMLStorageDesignDB2v80(this));
        this.appendWriter(new WordMapperWriter(this));
        this.appendWriter(new WXMLDocument(this));
        this.appendWriter(new WXMLParty(this));
        this.appendWriter(new WXMLContact(this));
        this.appendWriter(new WXMLEmail(this));
        this.appendWriter(new WXMLLocation(this));
        this.appendWriter(new WXMLPhone(this));
        this.appendWriter(new WXMLUrl(this));
        this.designPartViewWriter = new WXMLSubview(this);
    }

    @Override
    public String[] getLocationAndNameFor(Object object) {
        AbstractXMLWriter writer = this.getFirstWriter().getWriterFor(object);
        if (writer != null) {
            return new String[]{writer.getRelativePath(object), writer.getFilenameFor(object)};
        }
        return new String[0];
    }

    public void appendWriter(AbstractXMLWriter writer) {
        if (this.firstWriter == null) {
            this.firstWriter = writer;
        } else {
            this.firstWriter.getLast().setSuccessor(writer);
        }
    }

    protected AbstractXMLReader getFirstReader() {
        if (this.firstReader == null) {
            this.initReaderChain();
        }
        return this.firstReader;
    }

    private void initReaderChain() {
        this.designReader = new RXMLDesign(this);
        this.appendReader(this.designReader);
        this.appendReader(new RXMLLogicalType(this));
        this.appendReader(this.getDomainFileReader());
        this.dtDesignReader = new RXMLDataTypesDesign(this);
        this.appendReader(this.dtDesignReader);
        this.biDesignReader = new RXMLBusinessInfoDesign(this);
        this.appendReader(this.biDesignReader);
        this.appendReader(new RXMLChangeRequest(this));
        this.logicalDesignReader = new RXMLLogicalDesign(this);
        this.appendReader(this.logicalDesignReader);
        this.relationalDesignReader = new RXMLRelationalDesign(this);
        this.appendReader(this.relationalDesignReader);
        this.processModelReader = new RXMLProcessModel(this);
        this.appendReader(this.processModelReader);
        this.dataflowDesignReader = new RXMLDataFlowDesign(this);
        this.appendReader(this.dataflowDesignReader);
        this.mdDesignReader = new RXMLMultidimensionalDesign(this);
        this.appendReader(this.mdDesignReader);
        this.appendReader(new RXMLDistinctType(this));
        this.appendReader(new RXMLStructuredType(this));
        this.appendReader(new RXMLDTNote(this));
        this.appendReader(new RXMLCollectionType(this));
        this.appendReader(new RXMLEmail(this));
        this.appendReader(new RXMLPhone(this));
        this.appendReader(new RXMLLocation(this));
        this.appendReader(new RXMLUrl(this));
        this.appendReader(new RXMLContact(this));
        this.appendReader(new RXMLDocument(this));
        this.appendReader(new RXMLParty(this));
        this.appendReader(new RXMLEntity(this));
        this.appendReader(new RXMLEntityView(this));
        this.appendReader(new RXMLRelation(this));
        this.appendReader(new RXMLInheritanceRelation(this));
        this.appendReader(new RXMLArc(this));
        this.appendReader(new RXMLTable(this));
        this.appendReader(new RXMLForeignKey(this));
        this.appendReader(new RXMLFKArc(this));
        this.appendReader(new RXMLTableView(this));
        this.appendReader(new RXMLLogicalNote(this));
        this.appendReader(new RXMLRelationalNote(this));
        this.extendedMapReader = new RXMLExtendedMap(this);
        this.appendReader(this.extendedMapReader);
        this.appendReader(new RXMLRDBMSSiteSet(this));
        this.appendReader(new RXMLSelectionCriteria(this));
        this.appendReader(new RXMLLevel(this));
        this.appendReader(new RXMLHierarchy(this));
        this.appendReader(new RXMLDimension(this));
        this.appendReader(new RXMLSlice(this));
        this.appendReader(new RXMLMeasure(this));
        this.appendReader(new RXMLCube(this));
        this.appendReader(new RXMLRollupLink(this));
        this.appendReader(new RXMLRaggedHLink(this));
        this.appendReader(new RXMLLink(this));
        this.appendReader(new RXMLMDNote(this));
        this.appendReader(new RXMLFactEntitiesJoin(this));
        this.appendReader(new RXMLMeasureFolder(this));
        this.appendReader(new RXMLSQLAccessToAW(this));
        this.appendReader(new RXMLInfoStructure(this));
        this.appendReader(new RXMLEvent(this));
        this.appendReader(new RXMLProcess(this));
        this.appendReader(new RXMLExternalData(this));
        this.appendReader(new RXMLAgent(this));
        this.appendReader(new RXMLStore(this));
        this.appendReader(new RXMLFlow(this));
        this.appendReader(new RXMLRole(this));
        this.appendReader(new RXMLDataFlowNote(this));
        this.appendReader(new RXMLRecordStructure(this));
        this.appendReader(new RXMLTransformationPackage(this));
        this.transformationTaskReader = new RXMLTransformationTask(this);
        this.appendReader(this.transformationTaskReader);
        this.appendReader(new RXMLTransformation(this));
        this.appendReader(new RXMLTransformationFlow(this));
        this.appendReader(new RXMLTrTaskNote(this));
        this.appendReader(new RXMLStorageDesignOraclev9i(this));
        this.appendReader(new RXMLStorageDesignOraclev10g(this));
        this.appendReader(new RXMLStorageDesignOraclev11g(this));
        this.appendReader(new RXMLStorageDesignOraclev12c(this));
        this.appendReader(new RXMLStorageDesignSqlServerv2k(this));
        this.appendReader(new RXMLStorageDesignSqlServerv2k5(this));
        this.appendReader(new RXMLStorageDesignDB2v70(this));
        this.appendReader(new RXMLStorageDesignDB2v80(this));
        this.appendReader(new RXMLStorageDesignUDBv71(this));
        this.appendReader(new RXMLStorageDesignUDBv81(this));
        this.designPartViewReader = new RXMLSubview(this);
    }

    private void appendReader(AbstractXMLReader reader) {
        if (this.firstReader == null) {
            this.firstReader = reader;
        } else {
            this.firstReader.getLast().setSuccessor(reader);
        }
        String idSeq = reader.getIdStartSequence();
        if (idSeq != null && idSeq.length() > 0) {
            this.bypassReaders.put(idSeq, reader);
        }
    }

    @Override
    public Object read(Object name, Design design, ProgressDialog monitor) {
        boolean wasReading = this.getIsReading();
        this.setIsReadingx(true);
        if (name instanceof String) {
            // empty if block
        }
        Object result = this.getFirstReader().handleRecreateObject(name, design, monitor);
        this.setIsReadingx(wasReading);
        return result;
    }

    @Override
    public Object read(Object name, Design design, boolean readWriteAccess) {
        Object result;
        boolean wasReading = this.getIsReading();
        this.setIsReadingx(true);
        if (name instanceof String) {
            String sname = (String)name;
            String[] keys = this.bypassReaders.keySet().toArray(new String[0]);
            for (int i = 0; i < keys.length; ++i) {
                AbstractXMLReader reader;
                String key = keys[i];
                if (!sname.startsWith(key) || !this.bypassReaders.containsKey(key) || (reader = (AbstractXMLReader)this.bypassReaders.get(name)) == null || !reader.canRead(name)) continue;
                Object result2 = reader.handleRecreateObject(name, design, readWriteAccess);
                if (result2 != null && result2 instanceof ModelIDObject) {
                    ((ModelIDObject)result2).setDirty(false);
                }
                this.setIsReadingx(wasReading);
                return result2;
            }
        }
        if ((result = this.getFirstReader().handleRecreateObject(name, design, readWriteAccess)) != null && result instanceof ModelIDObject) {
            ((ModelIDObject)result).setDirty(false);
        }
        this.setIsReadingx(wasReading);
        return result;
    }

    public Object readDomainFile(Object name, Design design, boolean readWriteAccess) {
        boolean wasReading = this.getIsReading();
        this.setIsReadingx(true);
        Object result = this.getDomainFileReader().handleRecreateObject(name, design, readWriteAccess);
        this.setIsReadingx(wasReading);
        return result;
    }

    @Override
    public Object readSystemInit(Design design) {
        this.appView = design.getAppView();
        this.getLogicalTypesReader().recreateObject((Object)"types", design, false);
        this.getDomainFileReader().recreateObject((Object)"defaultdomains", design, false);
        design.buildNativeToLogicalMappings();
        return design;
    }

    @Override
    public boolean writeDomains(Object object) {
        if (object instanceof Design) {
            this.appView = ((Design)object).getAppView();
        }
        ApplicationView.log(Messages.getString("XMLPersistenceManager.WritingDomains"));
        boolean result = false;
        result = this.getFirstWriter().handleWrite(object);
        return result;
    }

    @Override
    public boolean writeTypes(Object object) {
        if (object instanceof Design) {
            this.appView = ((Design)((Object)object)).getAppView();
            ArrayList collection = new ArrayList();
            ((Design)((Object)object)).getLogicalDatatypeSet().addAllElementsTo(collection);
            object = collection;
        }
        ApplicationView.log(Messages.getString("XMLPersistenceManager.WritingTypes"));
        boolean result = false;
        result = this.getLogicalTypesWriter().handleWrite(object);
        return result;
    }

    @Override
    public boolean writeRDBMSSites(Object object) {
        ApplicationView.log(Messages.getString("XMLPersistenceManager.WritingRDBMSSites"));
        boolean result = false;
        result = this.getFirstWriter().handleWrite(object);
        return result;
    }

    @Override
    public boolean write(Object object) {
        if (object instanceof Design) {
            this.appView = ((Design)object).getAppView();
        }
        boolean result = false;
        result = this.getFirstWriter().handleWrite(object);
        if (object instanceof Design) {
            this.setSaveFailed(false);
            Design design = (Design)object;
            this.getFirstWriter().handleWrite(design.getExtendedMap());
            Iterator requests = design.getChangeRequestSet().iterator();
            while (requests.hasNext()) {
                ChangeRequest req = (ChangeRequest)requests.next();
                this.getFirstWriter().handleWrite(req);
            }
            if (design.getLogicalDesign().isLoaded() && (design.shouldExportFull(design.getLogicalDesign()) || design.shouldExportPartial(design.getLogicalDesign()))) {
                design.getLogicalDesign().save();
            }
            if (design.getDataTypesDesign().isLoaded() && (design.shouldExportFull(design.getDataTypesDesign()) || design.shouldExportPartial(design.getDataTypesDesign()))) {
                design.getDataTypesDesign().save();
            }
            if (this.isCheckDirty()) {
                if (design.getBusinessInfoDesign().isLoaded() && (design.getBusinessInfoDesign().isDirty() || design.getBusinessInfoDesign().hasDirtyStorableObjects())) {
                    design.getBusinessInfoDesign().save();
                }
            } else if (design.getBusinessInfoDesign().isLoaded() && design.shouldExportFull(design.getBusinessInfoDesign())) {
                design.getBusinessInfoDesign().save();
            }
            Iterator it = design.getRelationalDesigns().iterator();
            while (it.hasNext()) {
                RelationalDesign relDesign = (RelationalDesign)it.next();
                if (!relDesign.isLoaded() || !design.shouldExportFull(relDesign) && !design.shouldExportPartial(relDesign)) continue;
                relDesign.save();
            }
            if (design.getProcessModel().isLoaded() && design.shouldExportFull(design.getProcessModel())) {
                ProcessModel processModel = design.getProcessModel();
                processModel.save();
                it = processModel.getDataFlowDesigns().iterator();
                while (it.hasNext()) {
                    DataFlowDesign dfDesign = (DataFlowDesign)it.next();
                    if (!dfDesign.isLoaded()) continue;
                    dfDesign.save();
                }
            }
            it = design.getMultidimensionalDesigns().iterator();
            while (it.hasNext()) {
                MultidimensionalDesign mdDesign = (MultidimensionalDesign)it.next();
                if (!mdDesign.isLoaded() || !design.shouldExportFull(mdDesign) && !design.shouldExportPartial(mdDesign)) continue;
                mdDesign.save();
            }
            if (this.isSaveFailed()) {
                MessageDialogs.showErrorMessage(Messages.getString("XMLPersistenceManager.SomeObjectsAreNotSavedCorrectly"), true);
            }
        }
        return result;
    }

    @Override
    public boolean writeAll(Object object) {
        if (object instanceof Design) {
            this.appView = ((Design)object).getAppView();
        }
        if (object instanceof ModelObject) {
            ApplicationView.log(Messages.getString("XMLPersistenceManager.Writing") + ((ModelObject)object).getName());
        }
        boolean result = false;
        result = this.getFirstWriter().handleWrite(object);
        if (object instanceof Design) {
            DataFlowDesign dfDesign;
            ProcessModel processModel;
            this.setSaveFailed(false);
            Design design = (Design)object;
            this.getFirstWriter().handleWrite(design.getExtendedMap());
            design.saveDesignLevelSettings();
            Iterator requests = design.getChangeRequestSet().iterator();
            while (requests.hasNext()) {
                ChangeRequest req = (ChangeRequest)requests.next();
                this.getFirstWriter().handleWrite(req);
            }
            if (design.getLogicalDesign().isLoaded() && (design.shouldExportFull(design.getLogicalDesign()) || design.shouldExportPartial(design.getLogicalDesign()))) {
                design.getLogicalDesign().save();
            }
            if (design.getDataTypesDesign().isLoaded() && (design.shouldExportFull(design.getDataTypesDesign()) || design.shouldExportPartial(design.getDataTypesDesign()))) {
                design.getDataTypesDesign().save();
            }
            if (this.isCheckDirty()) {
                if (design.getBusinessInfoDesign().isLoaded() && (design.getBusinessInfoDesign().isDirty() || design.getBusinessInfoDesign().hasDirtyStorableObjects())) {
                    design.getBusinessInfoDesign().save();
                }
            } else if (design.getBusinessInfoDesign().isLoaded() && design.shouldExportFull(design.getBusinessInfoDesign())) {
                design.getBusinessInfoDesign().save();
            }
            Iterator it = design.getRelationalDesigns().iterator();
            while (it.hasNext()) {
                RelationalDesign relDesign = (RelationalDesign)it.next();
                if (relDesign.isLoaded() && (design.shouldExportFull(relDesign) || design.shouldExportPartial(relDesign))) {
                    relDesign.save();
                }
                StorageDesign[] storageDesigns = relDesign.getStorageDesignFactory().getOpenStorageDesigns();
                for (int i = 0; i < storageDesigns.length; ++i) {
                    if (!storageDesigns[i].isOpen()) continue;
                    if (this.isCheckDirty()) {
                        if (!storageDesigns[i].isDirty() && !storageDesigns[i].hasDirtyStorableObjects()) continue;
                        storageDesigns[i].save();
                        continue;
                    }
                    storageDesigns[i].save();
                }
                if (design.getCurrentOperation() == 5) continue;
                relDesign.setDirty(false);
            }
            if (this.isCheckDirty()) {
                if (design.getProcessModel().isLoaded()) {
                    processModel = design.getProcessModel();
                    processModel.save();
                    it = processModel.getDataFlowDesigns().iterator();
                    while (it.hasNext()) {
                        dfDesign = (DataFlowDesign)it.next();
                        if (this.isCheckDirty()) {
                            if (!dfDesign.isLoaded() || !dfDesign.isDirty() && !dfDesign.hasDirtyStorableObjects()) continue;
                            dfDesign.save();
                            continue;
                        }
                        dfDesign.save();
                    }
                }
            } else if (design.getProcessModel().isLoaded() && design.shouldExportFull(design.getProcessModel())) {
                processModel = design.getProcessModel();
                processModel.save();
                it = processModel.getDataFlowDesigns().iterator();
                while (it.hasNext()) {
                    dfDesign = (DataFlowDesign)it.next();
                    if (this.isCheckDirty()) {
                        if (!dfDesign.isLoaded() || !dfDesign.isDirty() && !dfDesign.hasDirtyStorableObjects()) continue;
                        dfDesign.save();
                        continue;
                    }
                    if (!dfDesign.isLoaded()) continue;
                    dfDesign.save();
                }
            }
            it = design.getMultidimensionalDesigns().iterator();
            while (it.hasNext()) {
                MultidimensionalDesign mdDesign = (MultidimensionalDesign)it.next();
                if (this.isCheckDirty()) {
                    if (!mdDesign.isLoaded() || !mdDesign.isDirty() && !mdDesign.hasDirtyStorableObjects()) continue;
                    mdDesign.save();
                    continue;
                }
                if (!mdDesign.isLoaded() || !design.shouldExportFull(mdDesign) && !design.shouldExportPartial(mdDesign)) continue;
                mdDesign.save();
            }
            if (this.isSaveFailed()) {
                MessageDialogs.showErrorMessage(Messages.getString("XMLPersistenceManager.SomeObjectsAreNotSavedCorrectlySeeErrLog"), true);
            }
        }
        return result;
    }

    public AbstractXMLWriter getWriterFor(Object object) {
        return this.getFirstWriter().getWriterFor(object);
    }

    public AbstractXMLReader getReaderFor(Object object) {
        return this.getFirstReader().getReaderFor(object);
    }

    public AbstractXMLReader getReaderForClass(Class type) {
        if (type == DesignPartView.class) {
            return this.getDesignPartViewReader();
        }
        if (type == Domain.class) {
            return this.getDomainReader();
        }
        if (type == LogicalDatatypeSet.class) {
            return this.getLogicalTypesReader();
        }
        if (type == RDBMSSiteSet.class) {
            return this.getRDBMSReader();
        }
        return this.getFirstReader().getReaderFor(type);
    }

    public boolean storeDocument(Document doc, String path, String filenameNoExt, AbstractXMLWriter xmlWriter) {
        try {
            StringBuffer buffer = new StringBuffer();
            String data = xmlWriter.prettyPrint(doc, buffer);
            this.filemanager.setDesignPath(this.getDesignLocation());
            this.filemanager.store((PersistenceManager)this, path, filenameNoExt, data);
        }
        catch (Exception e) {
            LOGGER.error("Error in storeDocument: ", e);
        }
        return false;
    }

    @Override
    public InputStream getInputStreamFor(String location, String name) {
        this.filemanager.setDesignPath(this.getDesignLocation());
        return this.filemanager.getDataInputStreamWithoutExtension(this, location, name);
    }

    public InputStream getInputStreamWithExtensionFor(String location, String name) {
        this.filemanager.setDesignPath(this.getDesignLocation());
        return this.filemanager.getDataInputStream(this, location, name);
    }

    @Override
    public boolean exists(String location, String name) {
        this.filemanager.setDesignPath(this.getDesignLocation());
        return this.filemanager.exists(this, location, name);
    }

    @Override
    public Object[] getAvailableDesigns() {
        return this.getAvailableNames(this.getDesignLocation());
    }

    @Override
    public Object[] getAvailableNames(String location) {
        this.filemanager.setDesignPath(this.getDesignLocation());
        return this.filemanager.listNamesNoFileExtension(location);
    }

    @Override
    public AbstractFileManager getFileManager() {
        return this.filemanager;
    }

    public final PMWPoolMap getPMWPoolMap() {
        if (this.pmwPoolMap == null) {
            this.pmwPoolMap = PMWPoolMap.getInstance();
        }
        return this.pmwPoolMap;
    }

    public final void removePMWPoolMap() {
        this.pmwPoolMap = null;
        PMWPoolMap.clearInstance();
    }

    public boolean storeText(String data, String path, String filenameExt) {
        try {
            PipedOutputStream os = new PipedOutputStream();
            PipedInputStream is = new PipedInputStream(os);
            this.filemanager.setDesignPath(this.getDesignLocation());
            this.filemanager.store((PersistenceManager)this, path, filenameExt, is);
            Thread thread = new Thread(new TextWriterThread(data, os, filenameExt));
            thread.start();
        }
        catch (IOException e) {
            LOGGER.error("Error in storeText: ", e);
        }
        return false;
    }

    @Override
    public ApplicationView getAppView() {
        return this.appView;
    }

    @Override
    public void setAppView(ApplicationView appView) {
        this.appView = appView;
    }

    @Override
    public boolean isWriteFinished() {
        this.filemanager.setDesignPath(this.getDesignLocation());
        return this.filemanager.isWriteFinished();
    }

    @Override
    public boolean deleteDesign(String location, String name, String user) {
        this.filemanager.setDesignPath(this.getDesignLocation());
        return this.filemanager.deleteDesign(this, location, name, user);
    }

    @Override
    public boolean unlockDesign(String location, String name, String user) {
        this.filemanager.setDesignPath(this.getDesignLocation());
        return this.filemanager.unlockDesign(location, name, user);
    }

    @Override
    public String getDataPath() {
        this.filemanager.setDesignPath(this.getDesignLocation());
        return this.filemanager.getDataPath();
    }

    @Override
    public Object read(Object name, DesignPart design, boolean readWriteAccess) {
        Object result = this.getFirstReader().handleRecreateDesign(name, design, readWriteAccess);
        return result;
    }

    @Override
    public String getDesignLocation() {
        if (this.getAppView() != null) {
            return this.getAppView().getCurrentDesign().getDesignPath();
        }
        return "";
    }

    private AbstractXMLReader getLogicalDesignReader() {
        if (this.firstReader == null) {
            this.initReaderChain();
        }
        return this.logicalDesignReader;
    }

    private AbstractXMLWriter getLogicalDesignWriter() {
        if (this.firstWriter == null) {
            this.initWriterChain();
        }
        return this.logicalDesignWriter;
    }

    private AbstractXMLReader getDataTypesDesignReader() {
        if (this.firstReader == null) {
            this.initReaderChain();
        }
        return this.dtDesignReader;
    }

    private AbstractXMLWriter getDataTypesDesignWriter() {
        if (this.firstWriter == null) {
            this.initWriterChain();
        }
        return this.dtDesignWriter;
    }

    public AbstractXMLReader getBusinessInfoDesignReader() {
        if (this.firstReader == null) {
            this.initReaderChain();
        }
        return this.biDesignReader;
    }

    public AbstractXMLWriter getBusinessInfoDesignWriter() {
        if (this.firstWriter == null) {
            this.initWriterChain();
        }
        return this.biDesignWriter;
    }

    private AbstractXMLReader getRelationalDesignReader() {
        if (this.firstReader == null) {
            this.initReaderChain();
        }
        return this.relationalDesignReader;
    }

    public AbstractXMLReader getExtendedMapReader() {
        if (this.firstReader == null) {
            this.initReaderChain();
        }
        return this.extendedMapReader;
    }

    private AbstractXMLWriter getRelationalDesignWriter() {
        if (this.firstWriter == null) {
            this.initWriterChain();
        }
        return this.relationalDesignWriter;
    }

    private AbstractXMLReader getProcessModelReader() {
        if (this.firstReader == null) {
            this.initReaderChain();
        }
        return this.processModelReader;
    }

    private AbstractXMLWriter getProcessModelWriter() {
        if (this.firstWriter == null) {
            this.initWriterChain();
        }
        return this.processModelWriter;
    }

    private AbstractXMLReader getDataFlowDesignReader() {
        if (this.firstReader == null) {
            this.initReaderChain();
        }
        return this.dataflowDesignReader;
    }

    private AbstractXMLWriter getMDDesignWriter() {
        if (this.firstWriter == null) {
            this.initWriterChain();
        }
        return this.mdDesignWriter;
    }

    private AbstractXMLReader getMDDesignReader() {
        if (this.firstReader == null) {
            this.initReaderChain();
        }
        return this.mdDesignReader;
    }

    private AbstractXMLWriter getDataFlowDesignWriter() {
        if (this.firstWriter == null) {
            this.initWriterChain();
        }
        return this.dataflowDesignWriter;
    }

    public AbstractXMLReader getTransformationTaskReader() {
        if (this.firstReader == null) {
            this.initReaderChain();
        }
        return this.transformationTaskReader;
    }

    private AbstractXMLWriter getTransformationTaskWriter() {
        if (this.firstWriter == null) {
            this.initWriterChain();
        }
        return this.transformationTaskWriter;
    }

    public AbstractXMLReader getDesignPartReader(DesignPart dp) {
        if (dp instanceof LogicalDesign) {
            return this.getLogicalDesignReader();
        }
        if (dp instanceof DataTypesDesign) {
            return this.getDataTypesDesignReader();
        }
        if (dp instanceof RelationalDesign) {
            return this.getRelationalDesignReader();
        }
        if (dp instanceof ProcessModel) {
            return this.getProcessModelReader();
        }
        if (dp instanceof DataFlowDesign) {
            return this.getDataFlowDesignReader();
        }
        if (dp instanceof MultidimensionalDesign) {
            return this.getMDDesignReader();
        }
        if (dp instanceof BusinessInfoDesign) {
            return this.getBusinessInfoDesignReader();
        }
        if (dp instanceof TransformationTask) {
            return this.getTransformationTaskReader();
        }
        return null;
    }

    public AbstractXMLWriter getDesignPartWriter(DesignPart dp) {
        if (dp instanceof LogicalDesign) {
            return this.getLogicalDesignWriter();
        }
        if (dp instanceof DataTypesDesign) {
            return this.getDataTypesDesignWriter();
        }
        if (dp instanceof RelationalDesign) {
            return this.getRelationalDesignWriter();
        }
        if (dp instanceof ProcessModel) {
            return this.getProcessModelWriter();
        }
        if (dp instanceof DataFlowDesign) {
            return this.getDataFlowDesignWriter();
        }
        if (dp instanceof MultidimensionalDesign) {
            return this.getMDDesignWriter();
        }
        if (dp instanceof BusinessInfoDesign) {
            return this.getBusinessInfoDesignWriter();
        }
        if (dp instanceof TransformationTask) {
            return this.getTransformationTaskWriter();
        }
        return null;
    }

    @Override
    public boolean deleteFiles(List files) {
        return this.filemanager.deleteFiles(files);
    }

    public WXMLSubview getDesignPartViewWriter() {
        return this.designPartViewWriter;
    }

    public RXMLSubview getDesignPartViewReader() {
        return this.designPartViewReader;
    }

    public WXMLDomain getDomainWriter() {
        if (this.domainWriter == null) {
            this.domainWriter = new WXMLDomain(this);
        }
        return this.domainWriter;
    }

    public WXMLTypesFile getLogicalTypesWriter() {
        if (this.ldtWriter == null) {
            this.ldtWriter = new WXMLTypesFile(this);
        }
        return this.ldtWriter;
    }

    public RXMLLogicalType getLogicalTypesReader() {
        if (this.ldtReader == null) {
            this.ldtReader = new RXMLLogicalType(this);
        }
        return this.ldtReader;
    }

    public WXMLRDBMSSiteSet getRDBMSWriter() {
        if (this.rdbmsWriter == null) {
            this.rdbmsWriter = new WXMLRDBMSSiteSet(this);
        }
        return this.rdbmsWriter;
    }

    public RXMLRDBMSSiteSet getRDBMSReader() {
        if (this.rdbmsReader == null) {
            this.rdbmsReader = new RXMLRDBMSSiteSet(this);
        }
        return this.rdbmsReader;
    }

    public RXMLDomainFile getDomainFileReader() {
        if (this.domainFileReader == null) {
            this.domainFileReader = new RXMLDomainFile(this);
        }
        return this.domainFileReader;
    }

    public RXMLDomain getDomainReader() {
        if (this.domainReader == null) {
            this.domainReader = new RXMLDomain(this);
        }
        return this.domainReader;
    }

    public RXMLDesign getDesignReader() {
        return this.designReader;
    }

    private class TextWriterThread
    implements Runnable {
        private PipedOutputStream os;
        private String description;
        private String data;

        TextWriterThread(String data, PipedOutputStream os, String description) {
            this.os = os;
            this.description = description;
            this.data = data;
        }

        @Override
        public void run() {
            RuntimeMonitor.getInstance().incrementThreadCount();
            ApplicationView.log(MessageFormat.format(Messages.getString("XMLPersistenceManager.StartWriting"), this.description));
            PrintWriter out = new PrintWriter(new BufferedOutputStream(this.os));
            out.print(this.data);
            out.flush();
            out.close();
            this.os = null;
            this.description = null;
            this.data = null;
            RuntimeMonitor.getInstance().decrementThreadCount();
        }
    }
}

