/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.db.oracle;

import java.io.StringReader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.ChangeRequest;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.businessinfo.BIContact;
import oracle.dbtools.crest.model.businessinfo.BIDocument;
import oracle.dbtools.crest.model.businessinfo.BIEmail;
import oracle.dbtools.crest.model.businessinfo.BILocation;
import oracle.dbtools.crest.model.businessinfo.BIPhone;
import oracle.dbtools.crest.model.businessinfo.BIResourceLocator;
import oracle.dbtools.crest.model.businessinfo.BIResponsibleParty;
import oracle.dbtools.crest.model.design.DLDomains;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.LogicalDatatypeSet;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.RLDomains;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.logical.Arc;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.InheritanceRelation;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.Dimension;
import oracle.dbtools.crest.model.design.multidimensional.FactEntitiesJoin;
import oracle.dbtools.crest.model.design.multidimensional.Hierarchy;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Link;
import oracle.dbtools.crest.model.design.multidimensional.Measure;
import oracle.dbtools.crest.model.design.multidimensional.MeasureFolder;
import oracle.dbtools.crest.model.design.multidimensional.RaggedHLink;
import oracle.dbtools.crest.model.design.multidimensional.RollupLink;
import oracle.dbtools.crest.model.design.multidimensional.SQLAccessToAW;
import oracle.dbtools.crest.model.design.multidimensional.SelectionCriteria;
import oracle.dbtools.crest.model.design.multidimensional.Slice;
import oracle.dbtools.crest.model.design.process.Event;
import oracle.dbtools.crest.model.design.process.ExternalAgent;
import oracle.dbtools.crest.model.design.process.ExternalData;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.design.process.InfoStore;
import oracle.dbtools.crest.model.design.process.InfoStructure;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.design.process.RecordStructure;
import oracle.dbtools.crest.model.design.process.Role;
import oracle.dbtools.crest.model.design.process.Transformation;
import oracle.dbtools.crest.model.design.process.TransformationFlow;
import oracle.dbtools.crest.model.design.process.TransformationPackage;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RDBMSSiteSet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.persistence.ObjectTypes;
import oracle.dbtools.crest.model.persistence.PersistenceManager;
import oracle.dbtools.crest.model.persistence.db.AbstractRepositoryManager;
import oracle.dbtools.crest.model.persistence.db.RepositoryObject;
import oracle.dbtools.crest.model.persistence.db.oracle.CheckInOutManager;
import oracle.dbtools.crest.model.persistence.db.oracle.ReadManager;
import oracle.dbtools.crest.model.persistence.db.oracle.RepositoryFactory;
import oracle.dbtools.crest.model.persistence.db.oracle.WriteManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLHandler;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLReader;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLWriter;
import oracle.dbtools.crest.model.persistence.xml.RXMLDesign;
import oracle.dbtools.crest.model.xtdmapping.ExtendedMap;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.editor.NewRepositoryDesignDialog;
import oracle.dbtools.crest.util.DBLoginDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.jdbc.OracleDriver;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class OracleRepositoryManager
extends AbstractRepositoryManager {
    private Map tableNames = new TreeMap();
    public static String T_TABLES = "DMR_TABLES";
    public static String T_PACKAGES = "DMR_PACKAGES";
    public static String T_PACKAGE_MEMBERS = "DMR_PACKAGE_MEMBERS";
    public static String T_REPOSITORY = "REPOSITORY";
    public static String T_VIEWS = "DMR_VIEWS";
    public static String T_ENTITIES = "DMR_ENTITIES";
    public static String T_RELATIONS = "DMR_RELATIONS";
    public static String T_HRELATIONS = "DMR_HRELATIONS";
    public static String T_ENTVIEWS = "DMR_ENTVIEWS";
    public static String T_FKEYS = "DMR_FKEYS";
    public static String T_ARC = "DMR_ARCS";
    public static String T_FKARC = "DMR_FKARCS";
    public static String T_USERS = "DMR_USERS";
    public static String T_OBJECT_REGISTER = "OBJECT_REGISTER";
    public static String T_LOGICAL_DATATYPES = "DMR_LOGICAL_DATATYPES";
    public static String T_RDBMS_SITES = "DMR_RDBMS_SITES";
    public static String T_DOMAINS = "DMR_DOMAINS";
    public static String T_XMAPPING = "DMR_MAPPINGS";
    public static String T_PHYSMODELS = "DMR_PHYSMODELS";
    public static String T_PHYSMODELS_MEMBERS = "DMR_PHYSMODELS_MEMBERS";
    public static String T_PM_OBJECT_REGISTER = "PM_OBJECT_REGISTER";
    public static String T_STRUCTURED_TYPES = "DMR_STRUCTUREDTYPES";
    public static String T_COLLECTION_TYPES = "DMR_COLLECTIONTYPES";
    public static String T_DISTINCT_TYPES = "DMR_DISTINCTTYPES";
    public static String T_PHYSICAL_OBJECTS = "DMR_PHYSICAL_OBJECTS";
    public static String T_SELECTION_CRITERIA = "DMR_SelectionCriterias";
    public static String T_LEVEL = "DMR_Levels";
    public static String T_ROLLUP_LINK = "DMR_RollupLinks";
    public static String T_RAGGED_HLINK = "DMR_RaggedHLinks";
    public static String T_DIMENSION = "DMR_Dimensions";
    public static String T_MEASURE = "DMR_Measures";
    public static String T_SLICE = "DMR_Slices";
    public static String T_FACT_ENTITIES_JOIN = "DMR_FactEntitiesJoins";
    public static String T_CUBE = "DMR_Cubes";
    public static String T_LINK = "DMR_Links";
    public static String T_HIERARCHY = "DMR_Hierarchies";
    public static String T_MEASURE_FOLDER = "DMR_MeasureFolders";
    public static String T_SQLACCESSTOAW = "DMR_SQLAccessToAWs";
    public static String T_RECORD_STRUCTURE = "DMR_RecordStructures";
    public static String T_EXTERNAL_DATA = "DMR_ExternalDatas";
    public static String T_EVENT = "DMR_Events";
    public static String T_INFO_STRUCTURE = "DMR_InfoStructures";
    public static String T_INFO_STORE = "DMR_InfoStores";
    public static String T_ROLE = "DMR_Roles";
    public static String T_TRANSFORMATION_PACKAGE = "DMR_TransformationPackages";
    public static String T_PROCESS = "DMR_Processes";
    public static String T_EXTERNAL_AGENT = "DMR_ExternalAgents";
    public static String T_FLOW = "DMR_Flows";
    public static String T_TRANSFORMATION = "DMR_Transformations";
    public static String T_TRANSFORMATION_FLOW = "DMR_TransformationFlows";
    public static String T_BI_EMAILS = "DMR_BIEmails".toUpperCase();
    public static String T_BI_LOCATIONS = "DMR_BILocations".toUpperCase();
    public static String T_BI_PHONES = "DMR_BIPhones".toUpperCase();
    public static String T_BI_RESOURCE_LOCATORS = "DMR_BIResourceLocators".toUpperCase();
    public static String T_BI_CONTACTS = "DMR_BIContacts".toUpperCase();
    public static String T_BI_RESPONSIBLE_PARTYS = "DMR_BIResponsibleParties".toUpperCase();
    public static String T_BI_DOCUMENTS = "DMR_BIDocuments".toUpperCase();
    public static String T_NOTES = "DMR_Notes".toUpperCase();
    public static String T_CHANGE_REQUESTS = "DMR_ChangeRequests".toUpperCase();
    public static String T_DL_SETTINGS = "DMR_DL_Settings".toUpperCase();
    private RepositoryFactory repositoryFactory;
    private CheckInOutManager checkInOutManager;
    private ReadManager readManager;
    private WriteManager writeManager;
    private String lastError = "";
    private static final Logger LOGGER = new Logger(OracleRepositoryManager.class);

    public OracleRepositoryManager(Design design) {
        super(design);
        this.initTableNames();
    }

    public OracleRepositoryManager(String connectionURL, String user, String password, Design design) {
        super(connectionURL, user, password, design);
        this.initTableNames();
    }

    private void initTableNames() {
        this.tableNames.put(ObjectTypes.TABLE, T_TABLES);
        this.tableNames.put(ObjectTypes.LOGICAL_MODEL, T_PACKAGES);
        this.tableNames.put(ObjectTypes.RELATIONAL_MODEL, T_PACKAGES);
        this.tableNames.put(ObjectTypes.REL_VIEW, T_VIEWS);
        this.tableNames.put(ObjectTypes.DESIGN, T_PACKAGES);
        this.tableNames.put(ObjectTypes.ENTITY, T_ENTITIES);
        this.tableNames.put(ObjectTypes.ENTVIEW, T_ENTVIEWS);
        this.tableNames.put(ObjectTypes.RELATION, T_RELATIONS);
        this.tableNames.put(ObjectTypes.HRELATION.toUpperCase(), T_HRELATIONS);
        this.tableNames.put(ObjectTypes.ARC, T_ARC);
        this.tableNames.put(ObjectTypes.FKARC, T_FKARC);
        this.tableNames.put(ObjectTypes.SUBVIEW, T_PACKAGES);
        this.tableNames.put(ObjectTypes.MAINVIEW, T_PACKAGES);
        this.tableNames.put(ObjectTypes.FKEY, T_FKEYS);
        this.tableNames.put(ObjectTypes.XMAPPING, T_XMAPPING);
        this.tableNames.put(ObjectTypes.FKINDEXASSOCIATION, T_FKEYS);
        this.tableNames.put(ObjectTypes.LOGICAL_DATATYPES, T_LOGICAL_DATATYPES);
        this.tableNames.put(ObjectTypes.RDBMS_SITES, T_RDBMS_SITES);
        this.tableNames.put(ObjectTypes.DOMAIN, T_DOMAINS);
        this.tableNames.put(ObjectTypes.PHYSOBJECT, T_PHYSICAL_OBJECTS);
        this.tableNames.put(ObjectTypes.STORAGEOBJECT, T_PHYSICAL_OBJECTS);
        this.tableNames.put(ObjectTypes.PHYSMODEL, T_PHYSMODELS);
        this.tableNames.put(ObjectTypes.STRUCTUREDTYPE, T_STRUCTURED_TYPES);
        this.tableNames.put(ObjectTypes.COLLECTIONTYPE, T_COLLECTION_TYPES);
        this.tableNames.put(ObjectTypes.DISTINCTTYPE, T_DISTINCT_TYPES);
        this.tableNames.put(ObjectTypes.SELECTION_CRITERIA, T_SELECTION_CRITERIA);
        this.tableNames.put(ObjectTypes.LEVEL, T_LEVEL);
        this.tableNames.put(ObjectTypes.ROLLUP_LINK, T_ROLLUP_LINK);
        this.tableNames.put(ObjectTypes.RAGGED_HLINK, T_RAGGED_HLINK);
        this.tableNames.put(ObjectTypes.DIMENSION, T_DIMENSION);
        this.tableNames.put(ObjectTypes.MEASURE, T_MEASURE);
        this.tableNames.put(ObjectTypes.SLICE, T_SLICE);
        this.tableNames.put(ObjectTypes.FACT_ENTITIES_JOIN, T_FACT_ENTITIES_JOIN);
        this.tableNames.put(ObjectTypes.CUBE, T_CUBE);
        this.tableNames.put(ObjectTypes.LINK, T_LINK);
        this.tableNames.put(ObjectTypes.HIERARCHY, T_HIERARCHY);
        this.tableNames.put(ObjectTypes.MEASURE_FOLDER, T_MEASURE_FOLDER);
        this.tableNames.put(ObjectTypes.SQLACCESSTOAW, T_SQLACCESSTOAW);
        this.tableNames.put(ObjectTypes.RECORD_STRUCTURE, T_RECORD_STRUCTURE);
        this.tableNames.put(ObjectTypes.EXTERNAL_DATA, T_EXTERNAL_DATA);
        this.tableNames.put(ObjectTypes.EVENT, T_EVENT);
        this.tableNames.put(ObjectTypes.INFO_STRUCTURE, T_INFO_STRUCTURE);
        this.tableNames.put(ObjectTypes.INFO_STORE, T_INFO_STORE);
        this.tableNames.put(ObjectTypes.ROLE, T_ROLE);
        this.tableNames.put(ObjectTypes.TRANSFORMATION_PACKAGE, T_PACKAGES);
        this.tableNames.put(ObjectTypes.PROCESS, T_PROCESS);
        this.tableNames.put(ObjectTypes.EXTERNAL_AGENT, T_EXTERNAL_AGENT);
        this.tableNames.put(ObjectTypes.FLOW, T_FLOW);
        this.tableNames.put(ObjectTypes.TRANSFORMATION, T_TRANSFORMATION);
        this.tableNames.put(ObjectTypes.TRANSFORMATION_FLOW, T_TRANSFORMATION_FLOW);
        this.tableNames.put(ObjectTypes.BI_EMAIL, T_BI_EMAILS);
        this.tableNames.put(ObjectTypes.BI_LOCATION, T_BI_LOCATIONS);
        this.tableNames.put(ObjectTypes.BI_PHONE, T_BI_PHONES);
        this.tableNames.put(ObjectTypes.BI_RESOURCE_LOCATOR, T_BI_RESOURCE_LOCATORS);
        this.tableNames.put(ObjectTypes.BI_CONTACT, T_BI_CONTACTS);
        this.tableNames.put(ObjectTypes.BI_RESPONSIBLE_PARTY, T_BI_RESPONSIBLE_PARTYS);
        this.tableNames.put(ObjectTypes.BI_DOCUMENT, T_BI_DOCUMENTS);
        this.tableNames.put(ObjectTypes.NOTE, T_NOTES);
        this.tableNames.put(ObjectTypes.CHANGE_REQUEST, T_CHANGE_REQUESTS);
    }

    @Override
    public boolean canUpgradeRepository() {
        return false;
    }

    @Override
    public void connect() {
        try {
            DriverManager.registerDriver((Driver)new OracleDriver());
            boolean canTest = true;
            String userName = this.user;
            String fPassword = this.password;
            if (userName == null || "".equalsIgnoreCase(userName) || this.password == null || "".equalsIgnoreCase(this.password)) {
                DBLoginDialog dialog = new DBLoginDialog();
                if (dialog.showDialog(userName)) {
                    userName = dialog.getUserName();
                    this.password = dialog.getPassword();
                } else {
                    canTest = false;
                }
            }
            if (canTest) {
                this.connection = DriverManager.getConnection(this.connectionURL, userName, fPassword);
            }
        }
        catch (SQLException sqlex) {
            String error;
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if ((error = sqlex.getMessage()) == null || "".equalsIgnoreCase(error)) {
                error = "Error occured while connecting to repository.";
            }
            MessageDialogs.showErrorMessage(error);
        }
    }

    @Override
    protected void readRepositoryDetails() {
        super.readRepositoryDetails();
    }

    @Override
    public void dropRepository() {
        this.getRepositoryFactory().dropRepository(this.getConnection());
    }

    @Override
    public void upgradeRepository() {
        this.getRepositoryFactory().upgradeRepository(this.getConnection());
    }

    private AbstractXMLWriter getXMLWriter(Object object) {
        if (object instanceof Domain) {
            return this.getDesign().getAppView().getPersistenceManager().getDomainWriter();
        }
        if (object instanceof StorageObject) {
            StorageDesign sd = ((StorageObject)object).getStorageDesign();
            AbstractXMLWriter writer = this.getDesign().getAppView().getPersistenceManager().getWriterFor(sd);
            if (writer != null) {
                return writer.getWriterFor(object);
            }
        }
        return this.getDesign().getAppView().getPersistenceManager().getWriterFor(object);
    }

    public String getXML(Object object) {
        AbstractXMLWriter xw;
        if (object instanceof DesignPartView && (xw = this.getDesign().getAppView().getPersistenceManager().getDesignPartViewWriter()) != null) {
            return xw.getDocumentAsString(object);
        }
        if (object instanceof LogicalDatatypeSet && (xw = this.getDesign().getAppView().getPersistenceManager().getLogicalTypesWriter()) != null) {
            return xw.getDocumentAsString(((LogicalDatatypeSet)object).getLogicalDataTypes());
        }
        if (object instanceof RDBMSSiteSet && (xw = this.getDesign().getAppView().getPersistenceManager().getRDBMSWriter()) != null) {
            return xw.getDocumentAsString(object);
        }
        xw = this.getXMLWriter(object);
        if (xw != null) {
            return xw.getDocumentAsString(object);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeDesign(Design design) {
        if (this.isConnected()) {
            try {
                ProgressDialog monitor = new ProgressDialog(design.getAppView(), "", 0, 100);
                try {
                    this.getDesign().getAppView().getPersistenceManager().setReadMode(PersistenceManager.READ_MODE_DATABASE);
                    if (!design.isLoadFromDB()) {
                        AbstractRepositoryManager.INITIAL_WRITE_TODB = true;
                    }
                    TimeLog.log();
                    monitor.setNote("Saving Repository Level Domains...");
                    monitor.setProgress(5);
                    monitor.setNote("Saving Design...");
                    monitor.setProgress(10);
                    boolean newDes = false;
                    if (design.getRepositoryOID() == null) {
                        newDes = true;
                        String oldName = design.getName();
                        String oldComment = design.getComment();
                        try {
                            NewRepositoryDesignDialog dialog = new NewRepositoryDesignDialog(design.getAppView(), oldName);
                            dialog.showDialog();
                            String name = dialog.getName();
                            String desc = dialog.getDescription();
                            design.setName(name);
                            design.setComment(desc);
                            this.getWriteManager().writePackageRecord(design.getObjectTypeName(), design);
                        }
                        finally {
                            design.setName(oldName);
                            design.setComment(oldComment);
                        }
                    }
                    this.writeDLDomains(design);
                    List requests = this.writeChangeRequests(design);
                    ArrayList<DesignPart> newObjects = new ArrayList<DesignPart>(requests);
                    List list = design.getStorableDesignParts();
                    Iterator it = list.iterator();
                    int progress = 20;
                    while (it.hasNext()) {
                        DesignPart dp = (DesignPart)it.next();
                        monitor.setNote("Saving Model: " + dp.getName());
                        monitor.setProgress(progress);
                        if (newDes || design.isCheckedOutByMe()) {
                            if (dp.getRepositoryOID() == null) {
                                newObjects.add(dp);
                            }
                            this.writeDesignPart(dp);
                        }
                        progress += 10;
                    }
                    monitor.setNote("Saving Finishing...");
                    monitor.setProgress(progress);
                    ExtendedMap xmap = design.getExtendedMap();
                    this.getWriteManager().writeXMap(xmap);
                    List dlist = design.getDesignPartsToDeleteFromRepository();
                    if (newDes) {
                        list.add(xmap);
                        list.addAll(requests);
                        this.getWriteManager().writePackageMembers(design.getRepositoryOID(), design.getRepositoryOVID(), list);
                    } else {
                        if (newObjects.size() > 0) {
                            this.getWriteManager().writePackageMembers(design.getRepositoryOID(), design.getRepositoryOVID(), newObjects);
                        }
                        if (design.isCheckedOutByMe()) {
                            this.getWriteManager().removeDeleted(dlist, design.getRepositoryOVID(), false);
                        }
                    }
                    if (!newDes && design.isDirty() && design.isCheckedOutByMe()) {
                        this.getWriteManager().updatePackageRecord(design.getObjectTypeName(), design);
                    }
                    this.writeDesignLevelSettings(design);
                    design.createDP_RepositoryMap();
                    design.setDirty(false);
                    design.setLoadFromDB(true);
                }
                finally {
                    monitor.close();
                    this.getDesign().getAppView().getPersistenceManager().setReadMode(PersistenceManager.READ_MODE_FILESYTEM);
                    AbstractRepositoryManager.INITIAL_WRITE_TODB = false;
                    TimeLog.log();
                }
            }
            catch (SQLException e) {
                this.lastError = e.toString();
                LOGGER.error("OracleRepositoryManager.checkInObject():\n" + this.lastError + "\n", e);
            }
        }
    }

    public void writeLogicalDatatypes(Design design) {
        LogicalDatatypeSet ldts = design.getLogicalDatatypeSet();
        if (ldts.getRepositoryOID() == null) {
            this.initPackageObject(ldts);
        }
        this.getWriteManager().writeRepSet(ldts);
    }

    public void writeRDBMSSites(Design design) {
        RDBMSSiteSet rdbms = design.getRDBMSSiteSet();
        rdbms.setSaveDefaults(true);
        if (rdbms.getRepositoryOID() == null) {
            this.initPackageObject(rdbms);
        }
        this.getWriteManager().writeRepSet(rdbms);
    }

    public void writeRLDomains(Design design) {
        RLDomains rlDomains = design.getRLDomains();
        boolean init = true;
        if (rlDomains.getRepositoryOID() == null) {
            init = this.initDomainObject(rlDomains);
        }
        if (init) {
            this.getWriteManager().writeDomains(rlDomains);
        }
    }

    private void writeDLDomains(Design design) {
        DLDomains dlDomains = design.getDLDomains();
        boolean init = true;
        if (dlDomains.getRepositoryOID() == null) {
            init = this.initDLDomains(dlDomains);
        }
        if (init) {
            this.getWriteManager().writeDomains(dlDomains);
        }
    }

    private List writeChangeRequests(Design design) throws SQLException {
        return this.getWriteManager().writeChangeRequests(design);
    }

    public String getTableName(Object object) {
        if (object instanceof DesignPart || object instanceof DesignPartView || object instanceof LogicalDatatypeSet || object instanceof RDBMSSiteSet) {
            return T_PACKAGES;
        }
        if (object instanceof StorageDesign) {
            return T_PHYSMODELS;
        }
        String type = "";
        type = object instanceof String ? ((String)object).toUpperCase() : ObjectTypes.getObjectType(object);
        String name = (String)this.tableNames.get(type);
        if (name == null) {
            return ObjectTypes.UNKNOWN;
        }
        return name;
    }

    public String getObjectType(Object object) {
        if (object instanceof DesignPartView) {
            DesignPartView dpv = (DesignPartView)object;
            if (dpv.getDesignPart().getMainView() == dpv) {
                return "MainView";
            }
            return "SubView";
        }
        if (object instanceof ExtendedMap) {
            return "ExtendedMap";
        }
        if (object instanceof XtdMapping) {
            return ObjectTypes.getObjectType(object);
        }
        if (object instanceof ModelIDObject) {
            return ((ModelIDObject)object).getObjectTypeName();
        }
        if (object instanceof DLDomains) {
            return "DLDomains";
        }
        if (object instanceof LogicalDatatypeSet) {
            return "LogicalDatatypeSet";
        }
        if (object instanceof RDBMSSiteSet) {
            return "RDBMSSiteSet";
        }
        return "undefined";
    }

    public static Document getDocument(String xmldata) {
        try {
            StringReader sr = new StringReader(xmldata);
            InputSource inputSource = new InputSource(sr);
            Document doc = AbstractXMLHandler.DOCUMENT_BUILDER.parse(inputSource);
            sr.close();
            return doc;
        }
        catch (Exception e) {
            Design.openFailed();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readDesign(Design design, String oid, String ovid) {
        System.out.println("Load from DB start " + System.currentTimeMillis());
        ProgressDialog monitor = null;
        try {
            ApplicationView.loading = true;
            ApplicationView.canLogging = false;
            ApplicationView view = design.getAppView();
            design.setLoadedVersion(2.4f);
            this.getReadManager().readUserRights(design);
            RelationalDesign oldDesign = design.getRelationalDesign();
            oldDesign.setMainViewVisible(false);
            design.getLogicalDesign().setLoaded(false);
            design.getLogicalDesign().setMainViewVisible(false);
            design.getBusinessInfoDesign().setLoaded(false);
            design.getDataTypesDesign().setLoaded(false);
            design.getDataTypesDesign().getMainView();
            oldDesign.setLoaded(false);
            monitor = new ProgressDialog(view, "", 0, 100);
            monitor.setNote("Open Design: \"" + design.getName() + '\"');
            monitor.setProgress(5);
            this.getDesign().getAppView().getPersistenceManager().setReadMode(PersistenceManager.READ_MODE_DATABASE);
            design.setRepositoryOID(oid);
            design.setRepositoryOVID(ovid);
            String user = this.getUser();
            String checkout_user = this.getCheckoutByUser(design);
            if (checkout_user != null) {
                design.setCheckedOutBy(checkout_user);
                design.setCheckedOut(true);
                if (user != null && user.equalsIgnoreCase(checkout_user)) {
                    design.setCheckedOutByMe(true);
                }
            }
            Document doc = this.getReadManager().getDesignDoc(ovid);
            RXMLDesign designReader = this.getDesign().getAppView().getPersistenceManager().getDesignReader();
            if (doc != null) {
                designReader.readVersion(doc, design);
            }
            this.readDLDomains(design);
            this.getReadManager().readChangerequests(design);
            this.getReadManager().readDesignParts(design, oid, ovid, monitor);
            if (doc != null) {
                designReader.recreateObject(doc, design, monitor);
            }
            monitor.setNote("Show Models...");
            monitor.setProgress(98);
            if (design.getLogicalDesign().isVisible()) {
                design.getLogicalDesign().setMainViewVisible(true);
            }
            design.showLogicalSubViews();
            design.showAllRelationalDesigns();
            design.showDataTypesDesign();
            design.showAllMultidimensionalDesigns();
            design.showAllDataFlowDesigns();
            design.showAllTransformationTask();
            if (design.getRelationalDesign().getTableSet().size() > 0 && design.getRelationalDesign().getMainView().isVisible()) {
                view.setCurrentDPV(design.getRelationalDesign().getMainView());
            } else if (design.getLogicalDesign().getEntitySet().size() > 0 && design.getLogicalDesign().getMainView().isVisible()) {
                view.setCurrentDPV(design.getLogicalDesign().getMainView());
            }
            design.getRelationalDesign().setDirty(false);
            design.getLogicalDesign().setDirty(false);
            design.setDirty(false);
            design.setLoadFromDB(true);
            design.createDP_RepositoryMap();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        finally {
            ApplicationView.loading = false;
            ApplicationView.canLogging = true;
            this.getDesign().getAppView().getPersistenceManager().setReadMode(PersistenceManager.READ_MODE_FILESYTEM);
            design.getAppView().clearTree();
            if (monitor != null) {
                monitor.close();
            }
            System.out.println("Load from DB end " + System.currentTimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initDomainObject(RepositoryObject repObj) {
        boolean result = true;
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rset = null;
        try {
            try {
                String query = "select oid, ovid from " + T_PACKAGES + " where type = '" + repObj.getName() + "'";
                stmt = conn.createStatement();
                rset = stmt.executeQuery(query);
                if (rset.next()) {
                    String oid = rset.getString(1);
                    String ovid = rset.getString(2);
                    repObj.setRepositoryOID(oid);
                    repObj.setRepositoryOVID(ovid);
                } else {
                    this.getWriteManager().writePackageRecord(repObj.getName(), repObj);
                }
            }
            finally {
                if (rset != null) {
                    rset.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        catch (SQLException e) {
            result = false;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initPackageObject(RepositoryObject repObj) {
        boolean result = true;
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rset = null;
        try {
            try {
                String objectType = repObj.getName();
                String query = "select m.type, m.oid, m.ovid, r.check_out_version, r.checkout_by, m.xml_content from " + T_PACKAGES + " m, " + T_OBJECT_REGISTER + " r where m.type = '" + objectType + "' and m.oid = r.oid and r.last_version = m.ovid and (r.check_out_version is null or  r.check_out_version is not null and r.checkout_by <> user)";
                query = query + " union all " + "select m.type, m.oid, m.ovid, r.check_out_version, r.checkout_by, m.xml_content from " + T_PACKAGES + " m, " + T_OBJECT_REGISTER + " r where m.type = '" + objectType + "' and m.oid = r.oid and r.check_out_version = m.ovid and r.check_out_version is not null and r.checkout_by = user";
                stmt = conn.createStatement();
                rset = stmt.executeQuery(query);
                if (rset.next()) {
                    String oid = rset.getString(2);
                    String ovid = rset.getString(3);
                    repObj.setRepositoryOID(oid);
                    repObj.setRepositoryOVID(ovid);
                } else {
                    result = false;
                }
            }
            finally {
                if (rset != null) {
                    rset.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        catch (SQLException e) {
            result = false;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initDLDomains(DLDomains dlDomains) {
        boolean result = true;
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rset = null;
        try {
            try {
                String query = "select oid, ovid from " + T_PACKAGES + " where type = '" + dlDomains.getType() + "'";
                stmt = conn.createStatement();
                rset = stmt.executeQuery(query);
                if (rset.next()) {
                    String oid = rset.getString(1);
                    String ovid = rset.getString(2);
                    dlDomains.setRepositoryOID(oid);
                    dlDomains.setRepositoryOVID(ovid);
                } else {
                    ArrayList<DLDomains> list = new ArrayList<DLDomains>();
                    list.add(dlDomains);
                    this.getWriteManager().writePackageRecord(dlDomains.getType(), dlDomains);
                    this.getWriteManager().writePackageMembers(dlDomains.getDesign().getRepositoryOID(), dlDomains.getDesign().getRepositoryOVID(), list);
                }
            }
            finally {
                if (rset != null) {
                    rset.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        catch (SQLException e) {
            result = false;
        }
        return result;
    }

    public void readLogicalDatatypes(Design design) throws SQLException {
        LogicalDatatypeSet ldts = design.getLogicalDatatypeSet();
        boolean init = true;
        if (ldts.getRepositoryOID() == null) {
            init = this.initPackageObject(ldts);
        }
        if (init) {
            this.getReadManager().readRepSet(ldts);
        }
    }

    public void readRDBMSSites(Design design) throws SQLException {
        RDBMSSiteSet rdbms = design.getRDBMSSiteSet();
        boolean init = true;
        if (rdbms.getRepositoryOID() == null) {
            init = this.initPackageObject(rdbms);
        }
        if (init) {
            rdbms.setLoadFromRepository(true);
            this.getReadManager().readRepSet(rdbms);
        }
    }

    public void readRLDomains(Design design) throws SQLException {
        RLDomains rlDomains = design.getRLDomains();
        boolean init = true;
        if (rlDomains.getRepositoryOID() == null) {
            init = this.initPackageObject(rlDomains);
        }
        if (init) {
            this.getReadManager().readDomains(design, rlDomains);
        }
    }

    private void readDLDomains(Design design) throws SQLException {
        DLDomains dlDomains = design.getDLDomains();
        boolean init = true;
        if (dlDomains.getRepositoryOID() == null) {
            init = this.initDLDomains(dlDomains);
        }
        if (init) {
            this.getReadManager().readDomains(design, dlDomains);
        }
    }

    public AbstractXMLReader getXMReader(String type) {
        Class ctype = this.getClassforType(type);
        if (ctype != null) {
            AbstractXMLReader reader = this.getDesign().getAppView().getPersistenceManager().getReaderForClass(ctype);
            return reader;
        }
        return null;
    }

    private Class getClassforType(String type) {
        if (type.equalsIgnoreCase("Table")) {
            return Table.class;
        }
        if (type.equalsIgnoreCase("FKIndexAssociation")) {
            return FKIndexAssociation.class;
        }
        if (type.equalsIgnoreCase("View")) {
            return TableView.class;
        }
        if (type.equalsIgnoreCase("Relation")) {
            return Relation.class;
        }
        if (type.equalsIgnoreCase("Hierarchy relation")) {
            return InheritanceRelation.class;
        }
        if (type.equalsIgnoreCase("Entity")) {
            return Entity.class;
        }
        if (type.equalsIgnoreCase("EntityView")) {
            return EntityView.class;
        }
        if (type.equalsIgnoreCase("Arc")) {
            return Arc.class;
        }
        if (type.equalsIgnoreCase("FKArc")) {
            return FKArc.class;
        }
        if (type.equalsIgnoreCase(ObjectTypes.XMAPPING)) {
            return XtdMapping.class;
        }
        if (type.equalsIgnoreCase("SubView") || type.equalsIgnoreCase("MainView")) {
            return DesignPartView.class;
        }
        if (type.equalsIgnoreCase("LogicalDatatypeSet")) {
            return LogicalDatatypeSet.class;
        }
        if (type.equalsIgnoreCase("RDBMSSiteSet")) {
            return RDBMSSiteSet.class;
        }
        if (type.equalsIgnoreCase("Domain")) {
            return Domain.class;
        }
        if (type.equalsIgnoreCase("StorageObject")) {
            return StorageObject.class;
        }
        if (type.equalsIgnoreCase("CollectionType")) {
            return CollectionType.class;
        }
        if (type.equalsIgnoreCase("StructuredType")) {
            return StructuredType.class;
        }
        if (type.equalsIgnoreCase("DistinctType")) {
            return DistinctType.class;
        }
        if (type.equalsIgnoreCase("SelectionCriteria")) {
            return SelectionCriteria.class;
        }
        if (type.equalsIgnoreCase("Level")) {
            return Level.class;
        }
        if (type.equalsIgnoreCase("RollupLink")) {
            return RollupLink.class;
        }
        if (type.equalsIgnoreCase("RaggedHLink")) {
            return RaggedHLink.class;
        }
        if (type.equalsIgnoreCase("Dimension")) {
            return Dimension.class;
        }
        if (type.equalsIgnoreCase("Measure")) {
            return Measure.class;
        }
        if (type.equalsIgnoreCase("Slice")) {
            return Slice.class;
        }
        if (type.equalsIgnoreCase("FactEntitiesJoin")) {
            return FactEntitiesJoin.class;
        }
        if (type.equalsIgnoreCase("Cube")) {
            return Cube.class;
        }
        if (type.equalsIgnoreCase("Link")) {
            return Link.class;
        }
        if (type.equalsIgnoreCase("Hierarchy")) {
            return Hierarchy.class;
        }
        if (type.equalsIgnoreCase("MeasureFolder")) {
            return MeasureFolder.class;
        }
        if (type.equalsIgnoreCase("SQLAccessToAW")) {
            return SQLAccessToAW.class;
        }
        if (type.equalsIgnoreCase("RecordStructure")) {
            return RecordStructure.class;
        }
        if (type.equalsIgnoreCase("ExternalData")) {
            return ExternalData.class;
        }
        if (type.equalsIgnoreCase("Event")) {
            return Event.class;
        }
        if (type.equalsIgnoreCase("InfoStructure")) {
            return InfoStructure.class;
        }
        if (type.equalsIgnoreCase("InfoStore")) {
            return InfoStore.class;
        }
        if (type.equalsIgnoreCase("Role")) {
            return Role.class;
        }
        if (type.equalsIgnoreCase("TransformationPackage")) {
            return TransformationPackage.class;
        }
        if (type.equalsIgnoreCase("Process")) {
            return Process.class;
        }
        if (type.equalsIgnoreCase("ExtAgent")) {
            return ExternalAgent.class;
        }
        if (type.equalsIgnoreCase(Flow.TYPE_NAME)) {
            return Flow.class;
        }
        if (type.equalsIgnoreCase("Transformation")) {
            return Transformation.class;
        }
        if (type.equalsIgnoreCase(TransformationFlow.TYPE_NAME)) {
            return TransformationFlow.class;
        }
        if (type.equalsIgnoreCase("Email")) {
            return BIEmail.class;
        }
        if (type.equalsIgnoreCase("Location")) {
            return BILocation.class;
        }
        if (type.equalsIgnoreCase("Phone")) {
            return BIPhone.class;
        }
        if (type.equalsIgnoreCase("ResLocator")) {
            return BIResourceLocator.class;
        }
        if (type.equalsIgnoreCase("Contact")) {
            return BIContact.class;
        }
        if (type.equalsIgnoreCase("ResponsibleParty")) {
            return BIResponsibleParty.class;
        }
        if (type.equalsIgnoreCase("Document")) {
            return BIDocument.class;
        }
        if (type.equalsIgnoreCase("Note")) {
            return Note.class;
        }
        if (type.equalsIgnoreCase("ChangeRequest")) {
            return ChangeRequest.class;
        }
        return null;
    }

    @Override
    public List getDesigns(boolean lastVersionsOnly) {
        return this.getReadManager().getDesigns(lastVersionsOnly);
    }

    @Override
    public RepositoryFactory getRepositoryFactory() {
        if (this.repositoryFactory == null) {
            this.repositoryFactory = new RepositoryFactory(this);
        }
        return this.repositoryFactory;
    }

    public CheckInOutManager getCheckInOutManager() {
        if (this.checkInOutManager == null) {
            this.checkInOutManager = new CheckInOutManager(this);
        }
        return this.checkInOutManager;
    }

    @Override
    public boolean checkOutObject(RepositoryObject object) {
        try {
            return this.getCheckInOutManager().checkOutObject(object);
        }
        catch (SQLException e) {
            this.lastError = e.toString();
            LOGGER.error("OracleRepositoryManager.checkOutObject():\n" + this.lastError + "\n", e);
            return false;
        }
    }

    public boolean checkInObject(ModelIDObject object) {
        try {
            return this.getCheckInOutManager().checkInObject(object);
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    public ReadManager getReadManager() {
        if (this.readManager == null) {
            this.readManager = new ReadManager(this);
        }
        return this.readManager;
    }

    public WriteManager getWriteManager() {
        if (this.writeManager == null) {
            this.writeManager = new WriteManager(this);
        }
        return this.writeManager;
    }

    @Override
    public void writeDesignPart(DesignPart designPart) {
        this.getWriteManager().writeDesignPart(designPart);
    }

    @Override
    public void writeObject(RepositoryObject object) {
        if (object instanceof Design) {
            this.writeDesign((Design)object);
        } else {
            this.getWriteManager().writeObject(object);
        }
    }

    @Override
    public void writeObjects(List objects, String type) throws SQLException {
        this.getWriteManager().writeObjects(objects, type);
    }

    @Override
    public boolean checkInObject(RepositoryObject object) {
        try {
            return this.getCheckInOutManager().checkInObject(object);
        }
        catch (SQLException e) {
            this.lastError = e.toString();
            LOGGER.error("OracleRepositoryManager.checkInObject():\n" + this.lastError + "\n", e);
            return false;
        }
    }

    @Override
    public String getCheckoutByUser(RepositoryObject object) throws SQLException {
        return this.getCheckInOutManager().getCheckoutByUser(object);
    }

    @Override
    public void readPhysicalModel(StorageDesign stoDes) {
        try {
            this.getReadManager().readPhysicalModel(stoDes);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public void writeDesignLevelSettings(Design design) {
        String dlsettings = design.getDesignLevelSettings().getDesignLevelSettingsAsString();
        this.getWriteManager().writeDLSettings(design, dlsettings);
    }

    public boolean readDLSettings(Design design) {
        boolean result = false;
        try {
            result = this.getReadManager().readDLSettings(design);
        }
        catch (SQLException e) {
            return false;
        }
        return result;
    }
}

