/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLWriter;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public abstract class AbstractWXMLModelIDObject
extends AbstractXMLWriter {
    public AbstractWXMLModelIDObject(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    protected Element appendObjectInfo(Document doc, Element parentNode, DesignObject object) {
        return this.appendObjectInfo(doc, parentNode, object, object.getObjectTypeName());
    }

    protected Element appendObjectInfo(Document doc, Element parentNode, ModelIDObject object, String objectTypeName) {
        String notes;
        object.setPersisted(true);
        Element objInfo = doc.createElement("object");
        objInfo.setAttribute("type", objectTypeName);
        objInfo.setAttribute("id", object.getObjectID());
        objInfo.setAttribute("rep_oid", object.getRepositoryOID());
        objInfo.setAttribute("rep_ovid", object.getRepositoryOVID());
        objInfo.setAttribute("is_checkedout", String.valueOf(object.isCheckedOut()));
        objInfo.setAttribute("checkedout_by", object.getCheckedOutBy());
        if (!object.hasOwnerDesignName() && object.isWriteable()) {
            object.setOwnerDesign();
        }
        Element child = doc.createElement("name");
        Text content = doc.createTextNode(StringUtilities.encodeAttributeValue(object.getName()));
        child.appendChild(content);
        objInfo.appendChild(child);
        String comment = object.getComment();
        if (comment != null) {
            child = doc.createElement("comment");
            content = doc.createTextNode(StringUtilities.encodeAttributeValue(comment));
            child.appendChild(content);
            objInfo.appendChild(child);
        }
        if ((notes = object.getNotes()) != null) {
            child = doc.createElement("notes");
            content = doc.createTextNode(StringUtilities.encodeAttributeValue(notes));
            child.appendChild(content);
            objInfo.appendChild(child);
        }
        this.appendChange(objInfo, object.getCreation(), "created");
        this.appendChange(objInfo, object.getChange(), "changed");
        String generatorID = object.getGeneratorID();
        if (!ModelIDObject.USER_GENERATED.equalsIgnoreCase(generatorID)) {
            child = doc.createElement("generator");
            content = doc.createTextNode(generatorID);
            child.appendChild(content);
            objInfo.appendChild(child);
        }
        parentNode.appendChild(objInfo);
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            buffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        buffer.append(this.getRelativePath()).append('/').append(object.getObjectID()).append(".dmd");
        object.setFilePath(buffer.toString());
        return objInfo;
    }
}

