/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RDBMSSiteSet;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.RDBMSTypeSet;
import oracle.dbtools.crest.model.persistence.xml.RXMLRDBMSSiteSet;
import oracle.dbtools.crest.model.persistence.xml.XMLConstants;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class RXMLDefaultRDBMSSiteSet
implements XMLConstants {
    private static final Logger LOGGER = new Logger(RXMLRDBMSSiteSet.class);

    public Object readDefaultRDBMSSites(String path, Design design) {
        return this.readDefaultRDBMSSites(path, design, new RDBMSSiteSet(design));
    }

    public Object readDefaultRDBMSSites(String path, Design design, RDBMSSiteSet set) {
        File file = new File(path);
        try {
            if (file.exists()) {
                RDBMSTypeSet typeSet;
                FileInputStream fis = new FileInputStream(file);
                InputSource inputSource = new InputSource(new InputStreamReader((InputStream)fis, "UTF-8"));
                DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = builderFactory.newDocumentBuilder();
                Document doc = builder.parse(inputSource);
                if (design != null) {
                    typeSet = design.getDefaultRDBMSTypeSet();
                } else {
                    typeSet = new RDBMSTypeSet();
                    LOGGER.error("recreateObject(...): RDBMSTypeSet NOT from model, Design or Model was null");
                }
                Element root = doc.getDocumentElement();
                NodeList siteList = root.getElementsByTagName("site");
                HashMap<String, String> map = new HashMap<String, String>();
                int length = siteList.getLength();
                for (int i = 0; i < length; ++i) {
                    RDBMSSite site = this.recreateSite((Element)siteList.item(i), set, typeSet);
                    if (site == null) continue;
                    map.put(site.getObjectID(), site.getName());
                }
                Object[] sites = set.toArray();
                for (int i = 0; i < sites.length; ++i) {
                    RDBMSSite site = (RDBMSSite)sites[i];
                    if (site.isDesignLevel() || map.get(site.getObjectID()) != null) continue;
                    set.remove(site);
                }
                return set;
            }
        }
        catch (Exception e) {
            LOGGER.error(e);
        }
        return set;
    }

    private void removeUnexistingSites(RDBMSSiteSet set, Set<String> existingSites) {
        HashSet<RDBMSSite> unexistingSites = new HashSet<RDBMSSite>();
        Collection currentSites = set.getValueSet();
        for (RDBMSSite site : currentSites) {
            if (existingSites.contains(site.getObjectID())) continue;
            unexistingSites.add(site);
        }
        if (!unexistingSites.isEmpty()) {
            set.removeAll(unexistingSites);
        }
    }

    public RDBMSSite recreateSite(Element siteElm, RDBMSSiteSet set, RDBMSTypeSet typeSet) {
        String name = this.getEncoded(siteElm, "name");
        String typeStr = siteElm.getAttribute("type");
        String siteID = this.getEncoded(siteElm, "oid");
        String pathIDStr = siteElm.getAttribute("pathid");
        RDBMSSite site = set.getByObjectID(siteID);
        if (site != null) {
            site.setName(name);
            site.setIsDefault(true);
            site.setDesignLevel(false);
            return site;
        }
        site = set.createSite(name, set.getDesign());
        site.setIsDefault(true);
        site.setDesignLevel(false);
        int type = 8;
        try {
            type = Integer.parseInt(typeStr);
        }
        catch (Exception e) {
            // empty catch block
        }
        RDBMSType rdbmsType = typeSet.get(type);
        site.setType(rdbmsType);
        site.setObjectID(siteID);
        int pathID = 0;
        try {
            pathID = Integer.parseInt(pathIDStr);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            type = Integer.parseInt(typeStr);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (pathID > 0) {
            site.setPathID(pathID);
            set.updateMaxIndex(pathID);
        } else {
            site.setPathID(set.nextIndex());
        }
        if (rdbmsType == null) {
            LOGGER.error("Unknown RDBMS type: " + type);
        }
        return site;
    }

    private String getEncoded(Element siteElement, String name) {
        return StringUtilities.decodeAttributeValue(siteElement.getAttribute(name));
    }
}

