/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.TypeSubstitution;
import oracle.dbtools.crest.model.businessinfo.BIDocument;
import oracle.dbtools.crest.model.businessinfo.BIResponsibleParty;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.DiagramView;
import oracle.dbtools.crest.model.design.Label;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableSet;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.relational.TableViewSet;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLReader;
import oracle.dbtools.crest.model.persistence.xml.RXMLSubview;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.TVDiagramView;
import oracle.dbtools.crest.swingui.TVNote;
import oracle.dbtools.crest.swingui.TVTypeSubstitution;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.relational.DPVRelationalSubView;
import oracle.dbtools.crest.swingui.relational.TVFKRelation;
import oracle.dbtools.crest.swingui.relational.TVTable;
import oracle.dbtools.crest.swingui.relational.TVView;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RXMLRelationalDesign
extends AbstractXMLReader {
    private static Logger LOGGER;
    private boolean xmlFromDB = false;
    private static float NFS;
    private float loadedVersion = NFS;

    public RXMLRelationalDesign(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public Object recreateDesign(Document doc, DesignPart design, boolean tryReadWriteLocking) {
        DesignObject object;
        String aID;
        int i;
        this.loadedVersion = design.getDesign().getLoadedVersion();
        this.xmlFromDB = this.getPersistenceManager().isXML_FromDataBase();
        Element root = doc.getDocumentElement();
        String id = root.getAttribute("id");
        if (!"".equalsIgnoreCase(id)) {
            design.setObjectID(StringUtilities.decodeAttributeValue(id));
        }
        String defaultDB = root.getAttribute("defaultRDBMSSite");
        RDBMSSite site = design.getDesign().getRDBMSSiteSet().getByObjectID(defaultDB);
        if (site != null) {
            design.getDesign().setSelectedRDBMSSite(site);
        }
        DesignPartView dpv = null;
        if (this.loadedVersion < NFS) {
            dpv = design.getMainView();
            this.readDisplayProperties(root, dpv);
            dpv.getWorkSpace().updateSettings();
            int ind = dpv.getTabbedPane().indexOfComponent(dpv);
            if (ind < 0) {
                dpv.getTabbedPane().setName(dpv.getName());
                dpv.getTabbedPane().add(dpv);
            }
        }
        NodeList objectElements = RXMLRelationalDesign.getFirstChildByTagName(root, "ref").getElementsByTagName("objectid");
        int length = objectElements.getLength();
        for (int i2 = 0; i2 < length; ++i2) {
            Element elm = (Element)objectElements.item(i2);
            String role = elm.getAttribute("role");
            String oid = elm.getAttribute("oid");
            String markGenerate = elm.getAttribute("marked_generate");
            boolean getlock = "contains".equalsIgnoreCase(role) && tryReadWriteLocking;
            DesignObject object2 = null;
            object2 = !this.xmlFromDB ? (DesignObject)this.getPersistenceManager().read((Object)oid, design.getDesign(), getlock) : design.getDesign().getDesignObject(oid);
            if (object2 != null) {
                if (markGenerate != null) {
                    if ("true".equalsIgnoreCase(markGenerate) || "".equalsIgnoreCase(markGenerate)) {
                        object2.setMarkedGenerate(true);
                    } else {
                        object2.setMarkedGenerate(false);
                    }
                } else {
                    object2.setMarkedGenerate(true);
                }
                object2.setTemporaryWriteable(true);
                if (!object2.belongsToDesign(design.getDesign())) {
                    object2.setReadOnly(true);
                }
                if (this.loadedVersion < NFS) {
                    this.readGraphicalInfo(elm, object2);
                }
                object2.setTemporaryWriteable(false);
                continue;
            }
            LOGGER.error("Read object returns null - " + oid);
        }
        Map objMap = this.getProperties(root, "documents");
        Object[] objects = objMap.keySet().toArray();
        for (i = 0; i < objects.length; ++i) {
            aID = (String)objMap.get(objects[i]);
            object = design.getDesign().getDesignObject(aID);
            if (object == null) continue;
            design.addDocument((BIDocument)object);
        }
        objMap = this.getProperties(root, "parties");
        objects = objMap.keySet().toArray();
        for (i = 0; i < objects.length; ++i) {
            aID = (String)objMap.get(objects[i]);
            object = design.getDesign().getDesignObject(aID);
            if (object == null) continue;
            design.addResponsibleParty((BIResponsibleParty)object);
        }
        this.reconnectColumnPlaceholders((RelationalDesign)design);
        this.getPersistenceManager().runTasks();
        if (this.loadedVersion < NFS) {
            this.readViewSynonyms(root, (RelationalDesign)design);
            this.readFKtoSynonyms(root, (RelationalDesign)design);
        }
        this.readTypeSubstitutions(root, (RelationalDesign)design);
        if (!this.xmlFromDB && !(this.loadedVersion < NFS)) {
            RXMLSubview rsv = this.getPersistenceManager().getDesignPartViewReader();
            rsv.readExtSubViews(root, design);
        }
        if (this.loadedVersion < NFS) {
            this.readSubordinateDisplays(root, dpv);
            dpv.getTabbedPane().setSelectedComponent(dpv);
            this.readSubordinateDisplays(root, design.getMainView());
            this.readPhysicalSubViews(root, (RelationalDesign)design);
            this.readDiagramViews(root, design);
        }
        this.readIndAndFKeysMarkGenerate(root, (RelationalDesign)design);
        this.readNamingOptions(root, design);
        ((RelationalDesign)design).showFkeysInSubviews();
        Iterator it = ((RelationalDesign)design).getFKIndexAssociationSet().iterator();
        while (it.hasNext()) {
            FKIndexAssociation fk = (FKIndexAssociation)it.next();
            fk.resetEdgeParams();
        }
        design.setLoaded(true);
        design.getAppView().getXMLTransformationManager().loadExistingPhysicalModels((RelationalDesign)design);
        return design;
    }

    @Override
    protected Map getProperties(Element objInfo, String id) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        Element propertiesElm = RXMLRelationalDesign.getFirstChildByTagName(objInfo, id);
        if (propertiesElm != null) {
            NodeList propList = propertiesElm.getElementsByTagName("parameter");
            int length = propList.getLength();
            for (int j = 0; j < length; ++j) {
                Element param = (Element)propList.item(j);
                map.put(param.getAttribute("name"), param.getAttribute("value"));
            }
        }
        return map;
    }

    private void readPhysicalSubViews(Element root, RelationalDesign design) {
        ApplicationView.log(Messages.getString("RXMLRelationalDesign.ReadPhysicalSubViews"));
        if (design.getAppView() != null) {
            TableSet ts = design.getTableSet();
            TableViewSet tvs = design.getTableViewSet();
            Element dpvlist = RXMLRelationalDesign.getFirstChildByTagName(root, "physical_sub_views_collection");
            if (dpvlist != null) {
                NodeList objectElements = dpvlist.getElementsByTagName("physical_sub_view");
                int length = objectElements.getLength();
                for (int i = 0; i < length; ++i) {
                    Element elm = (Element)objectElements.item(i);
                    String dpvName = elm.getAttribute("subview_name");
                    String dpvId = elm.getAttribute("id");
                    String generatorId = elm.getAttribute("generator");
                    DesignPartView dpv = design.createDesignPartSubView();
                    this.readDisplayProperties(elm, dpv);
                    dpv.setName(StringUtilities.decodeAttributeValue(dpvName));
                    dpv.setVisible(false);
                    if (dpvId != null && !"".equalsIgnoreCase(dpvId) && !"null".equalsIgnoreCase(dpvId)) {
                        dpv.setDPVId(dpvId);
                    }
                    if (generatorId != null && !"".equalsIgnoreCase(generatorId) && !"null".equalsIgnoreCase(generatorId)) {
                        dpv.setGeneratorId(generatorId);
                    }
                    String visible = elm.getAttribute("visible");
                    NodeList elements = elm.getElementsByTagName("objectid");
                    int ln = elements.getLength();
                    for (int k = 0; k < ln; ++k) {
                        String y;
                        String x;
                        Element point;
                        int kk;
                        TVConnector tvfk;
                        int plLength;
                        NodeList plist;
                        Element points;
                        FKIndexAssociation fk;
                        FKArc arc;
                        String vid;
                        TopView tvt;
                        ContainerObject tab;
                        Element tv = (Element)elements.item(k);
                        if (tv.getParentNode() != elm) continue;
                        String type = tv.getAttribute("type");
                        String oid = tv.getAttribute("oid");
                        String tvgenId = tv.getAttribute("tv_generator_id");
                        if (type.equalsIgnoreCase("Table")) {
                            tab = (Table)ts.getObjectByID(oid);
                            tvt = (TVTable)((TVTable)tab.getTopView()).createViewSynonim(dpv);
                            vid = tv.getAttribute("viewid");
                            tvt.setViewID(vid);
                            if (tvgenId != null && !"".equalsIgnoreCase(tvgenId) && !"null".equalsIgnoreCase(tvgenId)) {
                                tvt.setGeneratorID(tvgenId);
                            }
                            this.readGraphicalInfo(tv, tvt);
                        }
                        if (type.equalsIgnoreCase("VIEW")) {
                            tab = (TableView)tvs.getObjectByID(oid);
                            tvt = (TVView)((TVView)tab.getTopView()).createViewSynonim(dpv);
                            vid = tv.getAttribute("viewid");
                            tvt.setViewID(vid);
                            if (tvgenId != null && !"".equalsIgnoreCase(tvgenId) && !"null".equalsIgnoreCase(tvgenId)) {
                                tvt.setGeneratorID(tvgenId);
                            }
                            this.readGraphicalInfo(tv, tvt);
                        }
                        if (type.equalsIgnoreCase("FKArc") && (arc = (FKArc)design.getDesign().getDesignObject(oid)) != null) {
                            tvt = dpv.createTopViewFor(arc);
                            vid = tv.getAttribute("viewid");
                            String genId = tv.getAttribute("tv_generator_id");
                            tvt.setViewID(vid);
                            if (genId != null && !"".equalsIgnoreCase(genId) && !"null".equalsIgnoreCase(genId)) {
                                tvt.setGeneratorID(genId);
                            }
                            this.readGraphicalInfo(tv, tvt);
                        }
                        if (type.equalsIgnoreCase("Note")) {
                            Note note = (Note)this.getPersistenceManager().read((Object)oid, design.getDesign(), true);
                            tvt = (TVNote)((TVNote)note.getTopView()).createViewSynonim(dpv);
                            ((TVNote)note.getTopView()).remove(false);
                            vid = tv.getAttribute("viewid");
                            tvt.setViewID(vid);
                            this.readGraphicalInfo(tv, tvt);
                        }
                        if (type.equalsIgnoreCase("FKIndexAssociation") && (fk = (FKIndexAssociation)design.getFKIndexAssociationSet().getObjectByID(oid)) != null) {
                            Element labels;
                            String svid = tv.getAttribute("viewid_source");
                            String tvid = tv.getAttribute("viewid_target");
                            if (!svid.equals("null")) {
                                fk.setSourceTVTable((TVTable)fk.getRemoteTable().getTopViewByID(dpv, svid));
                            }
                            if (!tvid.equals("null")) {
                                fk.setTargetTVTable((TVTable)fk.getContainerWithKeyObject().getTopViewByID(dpv, tvid));
                            }
                            if ((points = RXMLRelationalDesign.getFirstChildByTagName(tv, "points")) != null) {
                                plist = points.getElementsByTagName("point");
                                plLength = plist.getLength();
                                tvfk = (TVFKRelation)fk.getViewFor(dpv);
                                for (kk = 0; kk < plLength; ++kk) {
                                    point = (Element)plist.item(kk);
                                    x = point.getAttribute("x_coordinate");
                                    y = point.getAttribute("y_coordinate");
                                    tvfk.getEdgePoints().add(DiagramConstants.createPoint(Double.parseDouble(x), Double.parseDouble(y)));
                                }
                            }
                            if ((labels = RXMLRelationalDesign.getFirstChildByTagName(tv, "labels")) != null) {
                                TVFKRelation tvfk2 = (TVFKRelation)fk.getViewFor(dpv);
                                Element lbl = RXMLRelationalDesign.getFirstChildByTagName(labels, "main_label");
                                if (lbl != null) {
                                    String x2 = lbl.getAttribute("x_coordinate");
                                    String y2 = lbl.getAttribute("y_coordinate");
                                    String w = lbl.getAttribute("width");
                                    String h = lbl.getAttribute("height");
                                    if (x2 != null && !"".equals(x2)) {
                                        if (w == null || "".equalsIgnoreCase(w)) {
                                            w = "-1";
                                        }
                                        if (h == null || "".equalsIgnoreCase(h)) {
                                            h = "-1";
                                        }
                                        tvfk2.setLabelBounds(new Rectangle((int)Double.parseDouble(x2), (int)Double.parseDouble(y2), (int)Double.parseDouble(w), (int)Double.parseDouble(h)));
                                        Label label = tvfk2.getTempCenterLabel();
                                        if (label != null) {
                                            this.readColorInfo(lbl, label);
                                            this.readFontsInfo(lbl, label);
                                        }
                                    }
                                }
                            }
                        }
                        if (!type.equalsIgnoreCase("TypeSubstitution")) continue;
                        TypeSubstitution tsub = (TypeSubstitution)design.getTypeSubstitutionSet().getObjectByID(oid);
                        String chid = tv.getAttribute("view_id_child");
                        String parid = tv.getAttribute("view_id_parent");
                        if (!chid.equals("null")) {
                            tsub.setChildCV((ContainerView)tsub.getChildContainerObject().getTopViewByID(dpv, chid));
                        }
                        if (!parid.equals("null")) {
                            tsub.setParentCV((ContainerView)tsub.getParentContainerObject().getTopViewByID(dpv, parid));
                        }
                        if ((points = RXMLRelationalDesign.getFirstChildByTagName(tv, "points")) == null) continue;
                        plist = points.getElementsByTagName("point");
                        plLength = plist.getLength();
                        tvfk = (TVTypeSubstitution)tsub.getViewFor(dpv);
                        for (kk = 0; kk < plLength; ++kk) {
                            point = (Element)plist.item(kk);
                            x = point.getAttribute("x_coordinate");
                            y = point.getAttribute("y_coordinate");
                            tvfk.getEdgePoints().add(DiagramConstants.createPoint(Double.parseDouble(x), Double.parseDouble(y)));
                        }
                    }
                    NodeList diagramViews = elm.getElementsByTagName("diagram_view");
                    int l = diagramViews.getLength();
                    for (int m = 0; m < l; ++m) {
                        Element dvElm = (Element)diagramViews.item(m);
                        String dvID = dvElm.getAttribute("objectid");
                        String dpvID = dvElm.getAttribute("dpv_id");
                        String name = dvElm.getAttribute("dpv_name");
                        String composite = dvElm.getAttribute("composite");
                        DiagramView dv = design.recreateDiagramView(dvID);
                        dv.setDpvID(dpvID);
                        dv.setDpvName(name);
                        dv.setCompositeView(Boolean.valueOf(composite));
                        design.getDesign().addDiagramView(dv);
                        TVDiagramView tvt = (TVDiagramView)dpv.createTopViewFor(dv);
                        design.getMainView().removeViewFor(dv);
                        TopView fv = dv.getFirstViewForDPV(design.getMainView());
                        if (fv != null) {
                            dv.removeTopView(fv, true);
                        }
                        this.readGraphicalInfo(dvElm, tvt);
                    }
                    dpv.setMustBeVisible(visible.equalsIgnoreCase("true"));
                    String comment = elm.getAttribute("comment");
                    ((DesignPartViewPlaceHolder)((DPVRelationalSubView)dpv).getPlaceHolder()).setComment(StringUtilities.decodeAttributeValue(comment));
                    String notes = elm.getAttribute("notes");
                    ((DesignPartViewPlaceHolder)dpv.getPlaceHolder()).setNotes(StringUtilities.decodeAttributeValue(notes));
                    dpv.getTabbedPane().setName(dpv.getName());
                    dpv.getWorkSpace().updateSettings();
                    this.readSubordinateDisplays(elm, dpv);
                    dpv.getTabbedPane().setSelectedComponent(dpv);
                }
            }
        }
    }

    private void readFKtoSynonyms(Element root, RelationalDesign design) {
        ApplicationView.log(Messages.getString("RXMLRelationalDesign.ReadForeignKeysToSynonyms"));
        if (design.getAppView() != null) {
            DesignPartView dpv = design.getMainView();
            Element fklist = RXMLRelationalDesign.getFirstChildByTagName(root, "view_fkeys");
            if (fklist != null) {
                NodeList objectElements = fklist.getElementsByTagName("objectid");
                int length = objectElements.getLength();
                for (int i = 0; i < length; ++i) {
                    String width;
                    Element graphical;
                    Element lbl;
                    String y;
                    String x;
                    TVTable tvTable;
                    Element elm = (Element)objectElements.item(i);
                    String oid = elm.getAttribute("oid");
                    FKIndexAssociation fk = (FKIndexAssociation)design.getFKIndexAssociationSet().getObjectByID(oid);
                    if (fk == null) continue;
                    String svid = elm.getAttribute("viewid_source");
                    String tvid = elm.getAttribute("viewid_target");
                    if (!svid.equals("null") && (tvTable = (TVTable)fk.getRemoteTable().getTopViewByID(dpv, svid)) != null) {
                        fk.setSourceTVTable(tvTable);
                    }
                    if (!tvid.equals("null") && (tvTable = (TVTable)fk.getContainerWithKeyObject().getTopViewByID(dpv, tvid)) != null) {
                        fk.setTargetTVTable(tvTable);
                    }
                    Element points = RXMLRelationalDesign.getFirstChildByTagName(elm, "points");
                    NodeList plist = points.getElementsByTagName("point");
                    int plLength = plist.getLength();
                    TVFKRelation tv = (TVFKRelation)fk.getTopView();
                    for (int kk = 0; kk < plLength; ++kk) {
                        Element point = (Element)plist.item(kk);
                        x = point.getAttribute("x_coordinate");
                        y = point.getAttribute("y_coordinate");
                        tv.getEdgePoints().add(DiagramConstants.createPoint(Double.parseDouble(x), Double.parseDouble(y)));
                    }
                    Element labels = RXMLRelationalDesign.getFirstChildByTagName(elm, "labels");
                    if (labels != null && (lbl = RXMLRelationalDesign.getFirstChildByTagName(labels, "main_label")) != null) {
                        x = lbl.getAttribute("x_coordinate");
                        y = lbl.getAttribute("y_coordinate");
                        String w = lbl.getAttribute("width");
                        String h = lbl.getAttribute("height");
                        if (x != null && !"".equals(x)) {
                            if (w == null || "".equalsIgnoreCase(w)) {
                                w = "-1";
                            }
                            if (h == null || "".equalsIgnoreCase(h)) {
                                h = "-1";
                            }
                            tv.setLabelBounds(new Rectangle((int)Double.parseDouble(x), (int)Double.parseDouble(y), (int)Double.parseDouble(w), (int)Double.parseDouble(h)));
                            Label label = tv.getTempCenterLabel();
                            if (label != null) {
                                this.readColorInfo(lbl, label);
                                this.readFontsInfo(lbl, label);
                            }
                        }
                    }
                    if ((graphical = RXMLRelationalDesign.getFirstChildByTagName(elm, "graphical")) == null) continue;
                    NodeList paramList = graphical.getElementsByTagName("parameter");
                    HashMap<String, String> map = new HashMap<String, String>();
                    int plength = paramList.getLength();
                    for (int l = 0; l < plength; ++l) {
                        Element param = (Element)paramList.item(l);
                        map.put(param.getAttribute("name"), param.getAttribute("value"));
                    }
                    String useDefault = (String)map.get("use_default_color");
                    boolean useDef = true;
                    if (useDefault != null) {
                        useDef = Boolean.valueOf(useDefault);
                    }
                    tv.setUseDefaultColor(useDef);
                    if (useDef) continue;
                    String color = (String)map.get("color");
                    if (color != null && !"null".equalsIgnoreCase(color)) {
                        Color backgroundColor = new Color(Integer.parseInt(color));
                        tv.setBackgroundColor(backgroundColor);
                    }
                    if ((width = (String)map.get("width")) == null || "null".equalsIgnoreCase(width)) continue;
                    int lineWidth = Integer.parseInt(width);
                    tv.setLineWidth(lineWidth);
                }
            }
        }
    }

    private void readIndAndFKeysMarkGenerate(Element root, RelationalDesign design) {
        Element fklist;
        ApplicationView.log(Messages.getString("RXMLRelationalDesign.ReadMarkgenerateForIndexesAndFKeys"));
        if (design.getAppView() != null && (fklist = RXMLRelationalDesign.getFirstChildByTagName(root, "marked_generate_for_indexes")) != null) {
            NodeList objectElements = fklist.getElementsByTagName("objectid");
            int length = objectElements.getLength();
            for (int i = 0; i < length; ++i) {
                Element elm = (Element)objectElements.item(i);
                String oid = elm.getAttribute("oid");
                Index ind = (Index)design.getGlobalIndexSet().getObjectByID(oid);
                String markGen = elm.getAttribute("marked_generate");
                if (ind == null || markGen == null) continue;
                if ("true".equalsIgnoreCase(markGen)) {
                    ind.setMarkedGenerate(true);
                    continue;
                }
                ind.setMarkedGenerate(false);
            }
        }
    }

    private void readTypeSubstitutions(Element root, RelationalDesign design) {
        ApplicationView.log(Messages.getString("RXMLRelationalDesign.ReadTypeSubstitutions"));
        if (design.getAppView() != null) {
            DesignPartView dpv = design.getMainView();
            Element fklist = RXMLRelationalDesign.getFirstChildByTagName(root, "type_substitutions");
            if (fklist != null) {
                NodeList objectElements = fklist.getElementsByTagName("objectid");
                int length = objectElements.getLength();
                for (int i = 0; i < length; ++i) {
                    String width;
                    Element elm = (Element)objectElements.item(i);
                    String oid = elm.getAttribute("oid");
                    String childOid = elm.getAttribute("child_id");
                    ContainerObject parent = null;
                    ContainerObject child = null;
                    if (childOid == null) {
                        childOid = "null";
                    } else {
                        child = (ContainerObject)design.getDesign().getDesignObject(childOid);
                    }
                    String parentOid = elm.getAttribute("parent_id");
                    if (parentOid == null) {
                        parentOid = "null";
                    } else {
                        parent = (ContainerObject)design.getDesign().getDesignObject(parentOid);
                    }
                    if (parent == null || child == null) continue;
                    TypeSubstitution ts = (TypeSubstitution)design.getDesign().getDesignObject(oid);
                    if (ts == null) {
                        ts = design.createTypeSubstitution(oid);
                    }
                    String chid = elm.getAttribute("view_id_child");
                    String parid = elm.getAttribute("view_id_parent");
                    if (!chid.equals("null")) {
                        ts.setChildCV((ContainerView)child.getTopViewByID(dpv, chid));
                    }
                    if (!parid.equals("null")) {
                        ts.setParentCV((ContainerView)parent.getTopViewByID(dpv, parid));
                    }
                    if (!(this.loadedVersion < NFS)) continue;
                    Element points = RXMLRelationalDesign.getFirstChildByTagName(elm, "points");
                    NodeList plist = points.getElementsByTagName("point");
                    int plLength = plist.getLength();
                    TVTypeSubstitution tv = (TVTypeSubstitution)ts.getTopView();
                    for (int kk = 0; kk < plLength; ++kk) {
                        Element point = (Element)plist.item(kk);
                        String x = point.getAttribute("x_coordinate");
                        String y = point.getAttribute("y_coordinate");
                        tv.getEdgePoints().add(DiagramConstants.createPoint(Double.parseDouble(x), Double.parseDouble(y)));
                    }
                    Element graphical = RXMLRelationalDesign.getFirstChildByTagName(elm, "graphical");
                    if (graphical == null) continue;
                    NodeList paramList = graphical.getElementsByTagName("parameter");
                    HashMap<String, String> map = new HashMap<String, String>();
                    int plength = paramList.getLength();
                    for (int l = 0; l < plength; ++l) {
                        Element param = (Element)paramList.item(l);
                        map.put(param.getAttribute("name"), param.getAttribute("value"));
                    }
                    String useDefault = (String)map.get("use_default_color");
                    boolean useDef = true;
                    if (useDefault != null) {
                        useDef = Boolean.valueOf(useDefault);
                    }
                    tv.setUseDefaultColor(useDef);
                    if (useDef) continue;
                    String color = (String)map.get("color");
                    if (color != null && !"null".equalsIgnoreCase(color)) {
                        Color backgroundColor = new Color(Integer.parseInt(color));
                        tv.setBackgroundColor(backgroundColor);
                    }
                    if ((width = (String)map.get("width")) == null || "null".equalsIgnoreCase(width)) continue;
                    int lineWidth = Integer.parseInt(width);
                    tv.setLineWidth(lineWidth);
                }
            }
        }
    }

    private void readViewSynonyms(Element root, RelationalDesign design) {
        ApplicationView.log(Messages.getString("RXMLRelationalDesign.ReadViewsSynonyms"));
        if (design.getAppView() != null) {
            DesignPartView dpvp = design.getMainView();
            Element vlist = RXMLRelationalDesign.getFirstChildByTagName(root, "view_synonyms");
            if (vlist != null) {
                NodeList objectElements = vlist.getElementsByTagName("objectid");
                int length = objectElements.getLength();
                for (int i = 0; i < length; ++i) {
                    ContainerView tvt;
                    DesignObject object;
                    Element elm = (Element)objectElements.item(i);
                    String oid = elm.getAttribute("oid");
                    String vid = elm.getAttribute("viewid");
                    String tvgenId = elm.getAttribute("tv_generator_id");
                    String type = elm.getAttribute("type");
                    if (type.equalsIgnoreCase("Table")) {
                        object = design.getTableSet().getObjectByID(oid);
                        tvt = (TVTable)object.getTopView().createViewSynonim(dpvp);
                        tvt.setViewID(vid);
                        if (tvgenId != null && !"".equalsIgnoreCase(tvgenId) && !"null".equalsIgnoreCase(tvgenId)) {
                            tvt.setGeneratorID(tvgenId);
                        }
                        this.readGraphicalInfo(elm, tvt);
                    }
                    if (!type.equalsIgnoreCase("VIEW")) continue;
                    object = design.getTableViewSet().getObjectByID(oid);
                    tvt = (TVView)object.getTopView().createViewSynonim(dpvp);
                    tvt.setViewID(vid);
                    if (tvgenId != null && !"".equalsIgnoreCase(tvgenId) && !"null".equalsIgnoreCase(tvgenId)) {
                        tvt.setGeneratorID(tvgenId);
                    }
                    this.readGraphicalInfo(elm, tvt);
                }
            }
        }
    }

    public void readGraphicalInfo(Element objInfo, TopView tv) {
        DesignObject object = tv.getModel();
        ApplicationView view = object.getDesign().getAppView();
        if (view != null) {
            NodeList list = objInfo.getElementsByTagName("graphical");
            HashMap<String, String> map = null;
            int length = list.getLength();
            for (int i = 0; i < length; ++i) {
                Element elm = (Element)list.item(i);
                map = new HashMap<String, String>();
                NodeList paramList = elm.getElementsByTagName("parameter");
                int plength = paramList.getLength();
                for (int j = 0; j < plength; ++j) {
                    Element param = (Element)paramList.item(j);
                    map.put(param.getAttribute("name"), param.getAttribute("value"));
                }
                view.setGraphicalPropsFor(tv, map);
            }
        }
    }

    private void reconnectColumnPlaceholders(RelationalDesign design) {
        Iterator it = design.getTableSet().iterator();
        while (it.hasNext()) {
            Table table = (Table)it.next();
            if (table.reconnectFKColumns()) {
                ApplicationView.log(Messages.getString("RXMLRelationalDesign.ReconnectColumnsInTable") + table);
                continue;
            }
            ApplicationView.log(Messages.getString("RXMLRelationalDesign.CanNotReconnectColumnsInTable") + table);
        }
    }

    public void readGraphicalInfo(Element objInfo, DesignObject object) {
        if (object == null || object.getDesign() == null) {
            LOGGER.error("readGraphicalInfo: DesignObject = null or design = null");
            return;
        }
        ApplicationView view = object.getDesign().getAppView();
        if (view != null) {
            NodeList list = objInfo.getElementsByTagName("graphical");
            HashMap<String, String> map = null;
            int length = list.getLength();
            for (int i = 0; i < length; ++i) {
                Element elm = (Element)list.item(i);
                map = new HashMap<String, String>();
                NodeList paramList = elm.getElementsByTagName("parameter");
                int plength = paramList.getLength();
                for (int j = 0; j < plength; ++j) {
                    Element param = (Element)paramList.item(j);
                    map.put(param.getAttribute("name"), param.getAttribute("value"));
                }
                view.setGraphicalPropsFor(object, map);
            }
        }
    }

    @Override
    public Object recreateObject(Document doc, Design design, boolean tryReadWriteLocking) {
        return null;
    }

    @Override
    public String getRelativePath() {
        if (this.getPersistenceManager().getAppView() != null) {
            String designName = this.getPersistenceManager().getAppView().getDesignName();
            StringBuffer buffer = new StringBuffer();
            buffer.append(designName).append('/');
            if (this.isOldDesign()) {
                buffer.append("relational");
            } else {
                buffer.append("rel");
            }
            return buffer.toString();
        }
        return "rel";
    }

    static {
        NFS = 2.4f;
        LOGGER = new Logger(RXMLRelationalDesign.class);
    }
}

