/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import java.util.HashMap;
import java.util.List;
import oracle.dbtools.crest.model.MDPreferences;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RXMLTableView
extends AbstractRXMLDesignObject {
    public RXMLTableView(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            String designName = this.getPersistenceManager().getAppView().getDesignName();
            buffer.append(designName).append('/');
            if (this.isOldDesign()) {
                String relDesName = this.getPersistenceManager().getAppView().getCurrentDesign().getRelationalDesign().getObjectID();
                buffer.append("relational").append('/').append(relDesName).append('/');
            } else {
                String relDesName = this.getPersistenceManager().getAppView().getCurrentDesign().getRelationalDesign().getPathIDString();
                buffer.append("rel").append('/').append(relDesName).append('/');
            }
        }
        buffer.append(this.getConfiguration().get("tableViewPath"));
        return buffer.toString();
    }

    @Override
    public String getIdStartSequence() {
        return MDPreferences.getDefaultInstance().get("tableview id prefix");
    }

    @Override
    protected DesignObject instantiateDesignObject(String objectID, Design design, Element objInfo) {
        return design.getRelationalDesign().getTableViewSet().createTableView(StringUtilities.decodeAttributeValue(objectID));
    }

    @Override
    protected void readObjectInfo(Element objInfo, ModelIDObject desObject, boolean tryReadWriteLocking) {
        if (desObject instanceof TableView) {
            String having;
            Node textNode;
            Element havingElm;
            String where;
            Node textNode2;
            Element whereElm;
            String userDefinedSQL;
            Node textNode3;
            Element userDefinedSQLElm;
            String userDefined;
            Node textNode4;
            Element userDefinedElm;
            String typesubst;
            TableView view = (TableView)desObject;
            String structuredTypeID = objInfo.getAttribute("structuredType");
            if (structuredTypeID != null) {
                StructuredType structuredType = (StructuredType)desObject.getDesign().getDataTypesDesign().getStructuredTypeSet().getObjectByID(structuredTypeID);
                view.setBasedOnStructuredType(structuredType);
                String oid_text = objInfo.getAttribute("oid_text");
                if (oid_text != null && !"".equalsIgnoreCase(oid_text)) {
                    view.setOidText(StringUtilities.decodeAttributeValue(oid_text));
                }
            }
            if ((typesubst = objInfo.getAttribute("allow_type_substitution")) != null) {
                view.setAllowTypeSubstitution(Boolean.valueOf(typesubst));
            }
            if ((userDefinedElm = RXMLTableView.getFirstChildByTagName(objInfo, "userDefined")) != null && (textNode4 = userDefinedElm.getFirstChild()) != null && (userDefined = textNode4.getNodeValue()) != null) {
                view.setUserDefined(Boolean.valueOf(StringUtilities.decodeAttributeValue(userDefined)));
            }
            if ((userDefinedSQLElm = RXMLTableView.getFirstChildByTagName(objInfo, "userDefinedSQL")) != null && (textNode3 = userDefinedSQLElm.getFirstChild()) != null && (userDefinedSQL = textNode3.getNodeValue()) != null) {
                view.setUserDefinedSQL(StringUtilities.decodeAttributeValue(userDefinedSQL));
            }
            if ((whereElm = RXMLTableView.getFirstChildByTagName(objInfo, "where")) != null && (textNode2 = whereElm.getFirstChild()) != null && (where = textNode2.getNodeValue()) != null) {
                view.setWhere(StringUtilities.decodeAttributeValue(where));
            }
            if ((havingElm = RXMLTableView.getFirstChildByTagName(objInfo, "having")) != null && (textNode = havingElm.getFirstChild()) != null && (having = textNode.getNodeValue()) != null) {
                view.setHaving(StringUtilities.decodeAttributeValue(having));
            }
            NodeList contElms = objInfo.getElementsByTagName("container");
            int clength = contElms.getLength();
            for (int i = 0; i < clength; ++i) {
                Element containElm = (Element)contElms.item(i);
                String alias = StringUtilities.decodeAttributeValue(containElm.getAttribute("alias"));
                String objectId = StringUtilities.decodeAttributeValue(containElm.getAttribute("cid"));
                if (objectId == null || alias == null) continue;
                view.addToContainers(objectId, alias);
            }
            this.recreateScript(objInfo, view);
        }
    }

    @Override
    protected void readContainedObjectInfo(Element objInfo, ContainerObject container, ContainedObject contObject, boolean tryReadWriteLocking) {
        String dataType;
        Node textNode;
        Element dataTypeElm;
        String expression;
        Node textNode2;
        Element expressionElm;
        String viewID;
        Node textNode3;
        Element viewElm;
        String tID;
        Node textNode4;
        Element tableElm;
        String refColumnID;
        Node textNode5;
        Element refColumnElmView;
        String refColumnID2;
        Node textNode6;
        Element refColumnElm;
        String alias;
        Node textNode7;
        Element tableAliasElm;
        String alias2;
        Node textNode8;
        Element aliasElm;
        String name;
        Node textNode9;
        Element nameElm;
        String oid;
        Element scopeElm;
        StructuredType st;
        DesignObject table;
        ColumnView adapter = (ColumnView)contObject;
        String tableID = objInfo.getAttribute("tableid");
        if (tableID != null && (table = container.getDesign().getDesignObject(tableID)) != null) {
            adapter.setContainer((ContainerObject)table);
        }
        String reference = objInfo.getAttribute("reference");
        adapter.setReference(Boolean.valueOf(reference));
        String stID = objInfo.getAttribute("dttype");
        if (!"".equalsIgnoreCase(stID) && (st = (StructuredType)container.getDesign().getDataTypesDesign().getStructuredTypeSet().getObjectByID(stID)) != null) {
            adapter.setStructuredType(st);
        }
        if ((scopeElm = RXMLTableView.getFirstChildByTagName(objInfo, "scope")) != null && (oid = scopeElm.getAttribute("objectid")) != null) {
            adapter.setScopeId(oid);
        }
        if ((nameElm = RXMLTableView.getFirstChildByTagName(objInfo, "name")) != null && (textNode9 = nameElm.getFirstChild()) != null && (name = textNode9.getNodeValue()) != null) {
            adapter.setName(StringUtilities.decodeAttributeValue(name));
        }
        if ((aliasElm = RXMLTableView.getFirstChildByTagName(objInfo, "alias")) != null && (textNode8 = aliasElm.getFirstChild()) != null && (alias2 = textNode8.getNodeValue()) != null) {
            adapter.setAlias(StringUtilities.decodeAttributeValue(alias2));
        }
        if ((tableAliasElm = RXMLTableView.getFirstChildByTagName(objInfo, "tableAlias")) != null && (textNode7 = tableAliasElm.getFirstChild()) != null && (alias = textNode7.getNodeValue()) != null) {
            adapter.setTableAlias(StringUtilities.decodeAttributeValue(alias));
        }
        if ((refColumnElm = RXMLTableView.getFirstChildByTagName(objInfo, "refcolumn")) != null && (textNode6 = refColumnElm.getFirstChild()) != null && (refColumnID2 = textNode6.getNodeValue()) != null) {
            Column column = (Column)container.getDesign().getDesignObject(refColumnID2);
            adapter.setReferencedColumn(column);
        }
        if ((refColumnElmView = RXMLTableView.getFirstChildByTagName(objInfo, "ref_column_view")) != null && (textNode5 = refColumnElmView.getFirstChild()) != null && (refColumnID = textNode5.getNodeValue()) != null) {
            ContainedObject column = (ContainedObject)container.getDesign().getDesignObject(refColumnID);
            if (column != null) {
                adapter.setReferencedColumnView(column);
            }
            adapter.setReferencedColumnViewID(refColumnID);
        }
        if ((tableElm = RXMLTableView.getFirstChildByTagName(objInfo, "table")) != null && (textNode4 = tableElm.getFirstChild()) != null && (tID = textNode4.getNodeValue()) != null) {
            Table table2 = (Table)container.getDesign().getDesignObject(tID);
            adapter.setTable(table2);
        }
        if ((viewElm = RXMLTableView.getFirstChildByTagName(objInfo, "view")) != null && (textNode3 = viewElm.getFirstChild()) != null && (viewID = textNode3.getNodeValue()) != null) {
            TableView view = (TableView)container.getDesign().getDesignObject(viewID);
            adapter.setView(view);
        }
        if ((expressionElm = RXMLTableView.getFirstChildByTagName(objInfo, "expression")) != null && (textNode2 = expressionElm.getFirstChild()) != null && (expression = textNode2.getNodeValue()) != null) {
            adapter.setExpression(StringUtilities.decodeAttributeValue(expression));
        }
        if ((dataTypeElm = RXMLTableView.getFirstChildByTagName(objInfo, "datatype")) != null && (textNode = dataTypeElm.getFirstChild()) != null && (dataType = textNode.getNodeValue()) != null) {
            adapter.setDataType(StringUtilities.decodeAttributeValue(dataType));
        }
        if (!container.contains(contObject)) {
            container.add(contObject);
        }
    }

    @Override
    public Object recreateDesign(Document doc, DesignPart design, boolean tryReadWriteLocking) {
        return null;
    }

    @Override
    public Object recreateObject(Element objInfo, Design design, boolean tryReadWriteLocking) {
        TableView view = (TableView)super.recreateObject(objInfo, design, tryReadWriteLocking);
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            buffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        buffer.append(this.getRelativePath()).append('/').append(StringUtilities.decodeAttributeValue(view.getObjectID())).append(".dmd");
        view.setFilePath(buffer.toString());
        return view;
    }

    @Override
    protected void readGroupBy(Element mappingElement, String id, ContainerObject obj, List list) {
        TableView view = (TableView)obj;
        Element node = RXMLTableView.getFirstChildByTagName(mappingElement, id);
        if (node != null) {
            NodeList propList = node.getElementsByTagName("cv_id");
            int l = propList.getLength();
            for (int j = 0; j < l; ++j) {
                Element param = (Element)propList.item(j);
                String cid = param.getAttribute("value");
                ColumnView cv = view.getColumnByObjectID(cid);
                if (cv == null || list.contains(cv)) continue;
                list.add(cv);
            }
        }
    }

    @Override
    protected void readOrderBy(Element parent, ContainerObject object) {
        TableView view = (TableView)object;
        Element orderByEl = RXMLTableView.getFirstChildByTagName(parent, "orderby");
        HashMap<String, String> sortMap = new HashMap<String, String>();
        NodeList columnElms = orderByEl.getElementsByTagName("columnview");
        int length = columnElms.getLength();
        for (int i = 0; i < length; ++i) {
            Element containElm = (Element)columnElms.item(i);
            String objectId = StringUtilities.decodeAttributeValue(containElm.getAttribute("objectid"));
            String sortType = containElm.getAttribute("sortorder");
            String containerID = containElm.getAttribute("cid");
            String name = StringUtilities.decodeAttributeValue(containElm.getAttribute("name"));
            for (ColumnView clmView : view.getElementsCollection()) {
                if (!clmView.getName().equalsIgnoreCase(name)) continue;
                view.addToOrderBy(clmView, sortType);
                sortMap.put(objectId, sortType);
                break;
            }
            if (view.getElementByName(name) != null) continue;
            ColumnView newClmView = new ColumnView(view.getDesignPart());
            newClmView.setObjectID(objectId);
            newClmView.setName(name);
            if ((Table)((RelationalDesign)view.getDesignPart()).getTableSet().getObjectByID(containerID) != null) {
                newClmView.setTableAlias(((Table)((RelationalDesign)view.getDesignPart()).getTableSet().getObjectByID(containerID)).getName());
            }
            view.addToOrderBy(newClmView, sortType);
        }
    }

    @Override
    public boolean isReaderForClass(Class type) {
        return type == TableView.class;
    }
}

