/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import java.util.List;
import oracle.dbtools.crest.model.design.AbstractView;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.AttributeView;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class WXMLEntityView
extends AbstractWXMLDesignObject {
    EntityView view = null;

    public WXMLEntityView(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean result = object instanceof EntityView;
        if (result) {
            this.view = (EntityView)object;
        }
        return result;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.view != null) {
            String designName = this.view.getDesignPart().getAppView().getDesignName();
            buffer.append(designName).append('/').append("logical").append('/');
        }
        buffer.append(this.getConfiguration().get("tableViewPath"));
        return buffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element parentNode, DesignObject object) {
        if (object instanceof EntityView) {
            String where;
            EntityView view = (EntityView)object;
            Document doc = parentNode.getOwnerDocument();
            parentNode.setAttribute("viewtype", view.getViewType());
            if (view.getBasedOnStructuredType() != null) {
                parentNode.setAttribute("structuredType", StringUtilities.encodeAttributeValue(view.getBasedOnStructuredType().getObjectID()));
            }
            parentNode.setAttribute("allow_type_substitution", String.valueOf(view.isAllowTypeSubstitution()));
            Element containerInfo = doc.createElement("containers");
            parentNode.appendChild(containerInfo);
            for (AbstractView.ContainerHolder ch : view.getUsedContainers()) {
                this.appendContainerInfo(doc, containerInfo, StringUtilities.encodeAttributeValue(ch.getContainer().getObjectID()), ch.getAlias());
            }
            String userDefined = "" + view.getUserDefined();
            Element child = doc.createElement("userDefined");
            Text content = doc.createTextNode(StringUtilities.encodeAttributeValue(userDefined));
            child.appendChild(content);
            parentNode.appendChild(child);
            String userDefinedSQL = view.getUserDefinedSQL();
            if (userDefinedSQL != null) {
                child = doc.createElement("userDefinedSQL");
                content = doc.createTextNode(StringUtilities.encodeAttributeValue(userDefinedSQL));
                child.appendChild(content);
                parentNode.appendChild(child);
            }
            if ((where = view.getWhere()) != null) {
                child = doc.createElement("where");
                content = doc.createTextNode(StringUtilities.encodeAttributeValue(where));
                child.appendChild(content);
                parentNode.appendChild(child);
            }
            child = doc.createElement("groupby");
            this.appendGroupBy(parentNode, child, view.getGroupByList());
            String having = view.getHaving();
            if (having != null) {
                child = doc.createElement("having");
                content = doc.createTextNode(StringUtilities.encodeAttributeValue(having));
                child.appendChild(content);
                parentNode.appendChild(child);
            }
            Element objectInfo = doc.createElement("orderby");
            parentNode.appendChild(objectInfo);
            for (ContainedObject col : view.getOrderByList()) {
                String sort = view.getSortOrder(StringUtilities.encodeAttributeValue(col.getObjectID()));
                if (sort == "") {
                    sort = "ASC";
                }
                if (((AttributeView)col).getEntity() != null) {
                    this.appendOrderByInfo(doc, objectInfo, StringUtilities.encodeAttributeValue(col.getObjectID()), StringUtilities.encodeAttributeValue(col.getName()), StringUtilities.encodeAttributeValue(((AttributeView)col).getEntity().getObjectID()), sort);
                    continue;
                }
                if (((AttributeView)col).getView() != null) {
                    this.appendOrderByInfo(doc, objectInfo, StringUtilities.encodeAttributeValue(col.getObjectID()), StringUtilities.encodeAttributeValue(col.getName()), StringUtilities.encodeAttributeValue(((AttributeView)col).getView().getObjectID()), sort);
                    continue;
                }
                this.appendOrderByInfo(doc, objectInfo, StringUtilities.encodeAttributeValue(col.getObjectID()), StringUtilities.encodeAttributeValue(col.getName()), StringUtilities.encodeAttributeValue(((AttributeView)col).getContainer().getObjectID()), sort);
            }
        }
    }

    protected final Element appendOrderByInfo(Document doc, Element containerNode, String objectID, String name, String containerID, String sortOrder) {
        Element objectInfo = doc.createElement("columnview");
        objectInfo.setAttribute("objectid", StringUtilities.encodeAttributeValue(objectID));
        objectInfo.setAttribute("name", StringUtilities.encodeAttributeValue(name));
        objectInfo.setAttribute("cid", StringUtilities.encodeAttributeValue(containerID));
        objectInfo.setAttribute("sortorder", sortOrder);
        containerNode.appendChild(objectInfo);
        return objectInfo;
    }

    protected final Element appendContainerInfo(Document doc, Element containerNode, String objectID, String alias) {
        Element objectInfo = doc.createElement("container");
        objectInfo.setAttribute("alias", StringUtilities.encodeAttributeValue(alias));
        objectInfo.setAttribute("cid", StringUtilities.encodeAttributeValue(objectID));
        containerNode.appendChild(objectInfo);
        return objectInfo;
    }

    @Override
    protected void appendContainedObjectInfo(Element parentNode, ContainedObject object) {
        String dataType;
        String expression;
        String view;
        String table;
        String refColumn;
        String tableAlias;
        Text content;
        Element child;
        AttributeView attributeView = (AttributeView)object;
        Document doc = parentNode.getOwnerDocument();
        parentNode.setAttribute("tableid", StringUtilities.encodeAttributeValue(attributeView.getContainer().getObjectID()));
        parentNode.setAttribute("reference", String.valueOf(attributeView.isReference()));
        parentNode.setAttribute("dttype", attributeView.getStructuredType() != null ? StringUtilities.encodeAttributeValue(attributeView.getStructuredType().getObjectID()) : "");
        this.appendScopeInfo(parentNode, attributeView);
        String alias = attributeView.getAlias();
        if (alias != null) {
            child = doc.createElement("alias");
            content = doc.createTextNode(StringUtilities.encodeAttributeValue(alias));
            child.appendChild(content);
            parentNode.appendChild(child);
        }
        if ((tableAlias = attributeView.getEntityAlias()) != null) {
            child = doc.createElement("tableAlias");
            content = doc.createTextNode(StringUtilities.encodeAttributeValue(tableAlias));
            child.appendChild(content);
            parentNode.appendChild(child);
        }
        if (attributeView.getReferencedAttribute() != null && (refColumn = attributeView.getReferencedAttribute().getObjectID()) != null) {
            child = doc.createElement("refcolumn");
            content = doc.createTextNode(StringUtilities.encodeAttributeValue(refColumn));
            child.appendChild(content);
            parentNode.appendChild(child);
        }
        if (attributeView.getEntity() != null && (table = attributeView.getEntity().getObjectID()) != null) {
            child = doc.createElement("table");
            content = doc.createTextNode(StringUtilities.encodeAttributeValue(table));
            child.appendChild(content);
            parentNode.appendChild(child);
        }
        if (attributeView.getView() != null && (view = attributeView.getView().getObjectID()) != null) {
            child = doc.createElement("view");
            content = doc.createTextNode(StringUtilities.encodeAttributeValue(view));
            child.appendChild(content);
            parentNode.appendChild(child);
        }
        if ((expression = attributeView.getExpression()) != null) {
            child = doc.createElement("expression");
            content = doc.createTextNode(StringUtilities.encodeAttributeValue(expression));
            child.appendChild(content);
            parentNode.appendChild(child);
        }
        if ((dataType = attributeView.getDataType()) != null) {
            child = doc.createElement("datatype");
            content = doc.createTextNode(StringUtilities.encodeAttributeValue(dataType));
            child.appendChild(content);
            parentNode.appendChild(child);
        }
    }

    private void appendGroupBy(Element mappingNode, Element element, List list) {
        if (list.size() > 0) {
            for (AttributeView cv : list) {
                if (cv == null) continue;
                Element node = mappingNode.getOwnerDocument().createElement("cv_id");
                node.setAttribute("value", StringUtilities.encodeAttributeValue(cv.getObjectID()));
                element.appendChild(node);
            }
            mappingNode.appendChild(element);
        }
    }
}

