/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RDBMSSiteSet;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLWriter;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WXMLRDBMSSiteSet
extends AbstractXMLWriter {
    public WXMLRDBMSSiteSet(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public boolean canWrite(Object object) {
        return object instanceof RDBMSSiteSet;
    }

    @Override
    public String getFilenameFor(Object object) {
        StringBuffer buffer = new StringBuffer();
        String designName = this.getPersistenceManager().getAppView().getDesignName();
        buffer.append(designName).append("_RDBMSSites");
        return buffer.toString();
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        String designName = this.getPersistenceManager().getAppView().getDesignName();
        buffer.append(designName).append('/').append(this.getConfiguration().get("rdbmsSitePath"));
        return buffer.toString();
    }

    @Override
    public Document writeDocument(Object object) {
        RDBMSSiteSet set = (RDBMSSiteSet)object;
        Document doc = this.createDocument();
        Element root = doc.getDocumentElement();
        RDBMSSite[] array = (RDBMSSite[])set.toArray();
        for (int i = 0; i < array.length; ++i) {
            if (set.canSaveDefaults()) {
                this.appendSiteNode(root, array[i]);
                continue;
            }
            if (array[i].getIsDefault() && array[i].getPathID() <= 9) continue;
            this.appendSiteNode(root, array[i]);
        }
        return doc;
    }

    public void appendSiteNode(Element root, RDBMSSite site) {
        Document doc = root.getOwnerDocument();
        Element siteElm = doc.createElement("site");
        siteElm.setAttribute("name", StringUtilities.encodeAttributeValue(site.getLongName()));
        if (site.getType() != null) {
            siteElm.setAttribute("type", String.valueOf(site.getType().getType()));
        }
        siteElm.setAttribute("oid", StringUtilities.encodeAttributeValue(site.getObjectID()));
        siteElm.setAttribute("pathid", site.getPathIDString());
        root.appendChild(siteElm);
    }
}

