/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.process;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.TopViewCollection;
import oracle.dbtools.crest.model.businessinfo.BIDocument;
import oracle.dbtools.crest.model.businessinfo.BIResponsibleParty;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Label;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLReader;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.process.AbstractDataFlowTV;
import oracle.dbtools.crest.swingui.process.DPVProcess;
import oracle.dbtools.crest.swingui.process.TVFlow;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RXMLDataFlowDesign
extends AbstractXMLReader {
    private boolean xmlFromDB = false;
    private static Logger LOGGER = new Logger(RXMLDataFlowDesign.class);
    private Map map = new TreeMap();

    public RXMLDataFlowDesign(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public Object recreateObject(Document doc, Design design, boolean tryReadWriteLocking) {
        return null;
    }

    @Override
    public Object recreateDesign(Document doc, DesignPart design, boolean tryReadWriteLocking) {
        String aID;
        int i;
        this.xmlFromDB = this.getPersistenceManager().isXML_FromDataBase();
        Element root = doc.getDocumentElement();
        String id = root.getAttribute("id");
        if (!"".equalsIgnoreCase(id)) {
            design.setObjectID(StringUtilities.decodeAttributeValue(id));
        }
        this.map.clear();
        NodeList objectElements = RXMLDataFlowDesign.getFirstChildByTagName(root, "ref").getElementsByTagName("objectid");
        int length = objectElements.getLength();
        for (int i2 = 0; i2 < length; ++i2) {
            Element elm = (Element)objectElements.item(i2);
            String role = elm.getAttribute("role");
            String type = elm.getAttribute("type");
            String oid = elm.getAttribute("oid");
            boolean getlock = "contains".equalsIgnoreCase(role) && tryReadWriteLocking;
            DesignObject object = null;
            object = !this.xmlFromDB ? (DesignObject)this.getPersistenceManager().read((Object)oid, design.getDesign(), getlock) : design.getDesign().getDesignObject(oid);
            if (object != null) {
                String prNumber;
                if ("Process".equalsIgnoreCase(type) && (prNumber = elm.getAttribute("process_number")) != null && !"".equals(prNumber)) {
                    this.map.put(new Integer(prNumber), object);
                }
                object.setTemporaryWriteable(true);
                if (!object.belongsToDesign(design.getDesign())) {
                    object.setReadOnly(true);
                }
                this.readGraphicalInfo(elm, object);
                object.setTemporaryWriteable(false);
                continue;
            }
            LOGGER.error("RXMLDataFlowDesign: Read object returns null (objectID: " + oid);
        }
        for (Integer key : this.map.keySet()) {
            DataFlowDesign dfd;
            Object obj = this.map.get(key);
            if (!(obj instanceof Process) || !(dfd = (DataFlowDesign)((DesignObject)obj).getDesignPart()).getProcessOrderList().remove(obj)) continue;
            dfd.getProcessOrderList().add(key - 1, obj);
        }
        Map objMap = this.getProperties(root, "documents");
        Object[] objects = objMap.keySet().toArray();
        for (i = 0; i < objects.length; ++i) {
            aID = (String)objMap.get(objects[i]);
            DesignObject object = design.getDesign().getDesignObject(aID);
            if (object == null) continue;
            design.addDocument((BIDocument)object);
        }
        objMap = this.getProperties(root, "parties");
        objects = objMap.keySet().toArray();
        for (i = 0; i < objects.length; ++i) {
            aID = (String)objMap.get(objects[i]);
            DesignObject object = design.getDesign().getDesignObject(aID);
            if (object == null) continue;
            design.addResponsibleParty((BIResponsibleParty)object);
        }
        this.readSynonymsForGlobals(root, (DataFlowDesign)design);
        this.readFlows(root, (DataFlowDesign)design);
        this.readDisplayProperties(root, design.getMainView());
        design.getMainView().getWorkSpace().updateSettings();
        this.readDiagramViews(root, design);
        design.setLoaded(true);
        design.setDirty(false);
        if (design.getMainView() != null) {
            design.getMainView().setDirty(false);
        }
        return design;
    }

    @Override
    protected Map getProperties(Element objInfo, String id) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        Element propertiesElm = RXMLDataFlowDesign.getFirstChildByTagName(objInfo, id);
        if (propertiesElm != null) {
            NodeList propList = propertiesElm.getElementsByTagName("parameter");
            int length = propList.getLength();
            for (int j = 0; j < length; ++j) {
                Element param = (Element)propList.item(j);
                map.put(param.getAttribute("name"), param.getAttribute("value"));
            }
        }
        return map;
    }

    private void readFlows(Element root, DataFlowDesign design) {
        Element fklist;
        ApplicationView.log(Messages.getString("RXMLDataFlowDesign.ReadFlows"));
        DesignPartView dpv = design.getMainView();
        if (design.getAppView() != null && (fklist = RXMLDataFlowDesign.getFirstChildByTagName(root, "view_flows")) != null) {
            NodeList objectElements = fklist.getElementsByTagName("objectid");
            int length = objectElements.getLength();
            for (int i = 0; i < length; ++i) {
                String width;
                Element graphical;
                Element lbl;
                String y;
                String x;
                TopView tv;
                TopViewCollection col;
                Element elm = (Element)objectElements.item(i);
                String oid = elm.getAttribute("oid");
                Flow flow = (Flow)design.getFlowSet().getObjectByID(oid);
                String svid = elm.getAttribute("viewid_source");
                String tvid = elm.getAttribute("viewid_target");
                if (!svid.equals("null") && flow.getSourceProcessObject() != null && (col = flow.getSourceProcessObject().getViewsForDPV(dpv)).size() == 1) {
                    tv = (TopView)col.get(0);
                    flow.setSourceTV((AbstractDataFlowTV)tv);
                }
                if (!tvid.equals("null") && flow.getTargetProcessObject() != null && (col = flow.getTargetProcessObject().getViewsForDPV(dpv)).size() == 1) {
                    tv = (TopView)col.get(0);
                    flow.setTargetTV((AbstractDataFlowTV)tv);
                }
                Element points = RXMLDataFlowDesign.getFirstChildByTagName(elm, "points");
                NodeList plist = points.getElementsByTagName("point");
                int plLength = plist.getLength();
                TVFlow tv2 = (TVFlow)flow.getTopView();
                for (int kk = 0; kk < plLength; ++kk) {
                    Element point = (Element)plist.item(kk);
                    x = point.getAttribute("x_coordinate");
                    y = point.getAttribute("y_coordinate");
                    tv2.getEdgePoints().add(DiagramConstants.createPoint(Double.parseDouble(x), Double.parseDouble(y)));
                }
                Element labels = RXMLDataFlowDesign.getFirstChildByTagName(elm, "labels");
                if (labels != null && (lbl = RXMLDataFlowDesign.getFirstChildByTagName(labels, "main_label")) != null) {
                    x = lbl.getAttribute("x_coordinate");
                    y = lbl.getAttribute("y_coordinate");
                    String w = lbl.getAttribute("width");
                    String h = lbl.getAttribute("height");
                    if (w == null || "".equalsIgnoreCase(w)) {
                        w = "-1";
                    }
                    if (h == null || "".equalsIgnoreCase(h)) {
                        h = "-1";
                    }
                    tv2.setLabelBounds(new Rectangle((int)Double.parseDouble(x), (int)Double.parseDouble(y), (int)Double.parseDouble(w), (int)Double.parseDouble(h)));
                    Label label = tv2.getTempCenterLabel();
                    if (label != null) {
                        this.readColorInfo(lbl, label);
                        this.readFontsInfo(lbl, label);
                    }
                }
                if ((graphical = RXMLDataFlowDesign.getFirstChildByTagName(elm, "graphical")) == null) continue;
                NodeList paramList = graphical.getElementsByTagName("parameter");
                HashMap<String, String> map = new HashMap<String, String>();
                int plength = paramList.getLength();
                for (int l = 0; l < plength; ++l) {
                    Element param = (Element)paramList.item(l);
                    map.put(param.getAttribute("name"), param.getAttribute("value"));
                }
                String useDefault = (String)map.get("use_default_color");
                boolean useDef = true;
                if (useDefault != null) {
                    useDef = Boolean.valueOf(useDefault);
                }
                tv2.setUseDefaultColor(useDef);
                if (useDef) continue;
                String color = (String)map.get("color");
                if (color != null && !"null".equalsIgnoreCase(color)) {
                    Color backgroundColor = new Color(Integer.parseInt(color));
                    tv2.setBackgroundColor(backgroundColor);
                }
                if ((width = (String)map.get("width")) == null || "null".equalsIgnoreCase(width)) continue;
                int lineWidth = Integer.parseInt(width);
                tv2.setLineWidth(lineWidth);
            }
        }
    }

    private void readSynonymsForGlobals(Element root, DataFlowDesign design) {
        Element fklist;
        ApplicationView.log(Messages.getString("RXMLDataFlowDesign.ReadSynonymsForGlobalPMObjects"));
        DPVProcess dpv = (DPVProcess)design.getMainView();
        if (design.getAppView() != null && (fklist = RXMLDataFlowDesign.getFirstChildByTagName(root, "synonyms_for_globals")) != null) {
            NodeList objectElements = fklist.getElementsByTagName("objectid");
            int length = objectElements.getLength();
            for (int i = 0; i < length; ++i) {
                Element elm = (Element)objectElements.item(i);
                String oid = elm.getAttribute("oid");
                String type = elm.getAttribute("type");
                AbstractProcessObject po = null;
                if ("ExtAgent".equalsIgnoreCase(type)) {
                    po = (AbstractProcessObject)design.getExternalAgentSet().getObjectByID(oid);
                } else if ("InfoStore".equalsIgnoreCase(type)) {
                    po = (AbstractProcessObject)design.getInfoStoreSet().getObjectByID(oid);
                } else if ("Process".equalsIgnoreCase(type)) {
                    po = (AbstractProcessObject)design.getDesign().getDesignObject(oid);
                }
                if (po == null || dpv == null) continue;
                TopView tv = po.getFirstViewForDPV(dpv);
                if (tv == null) {
                    tv = dpv.createViewSynonim(po);
                }
                this.readGraphicalInfo(elm, po, tv);
            }
        }
    }

    public void readGraphicalInfo(Element objInfo, DesignObject object) {
        if (object == null || object.getDesign() == null) {
            LOGGER.error("readGraphicalInfo: DesignObject = null or design = null");
            return;
        }
        ApplicationView view = object.getDesign().getAppView();
        if (view != null) {
            NodeList list = objInfo.getElementsByTagName("graphical");
            HashMap<String, String> map = null;
            int length = list.getLength();
            for (int i = 0; i < length; ++i) {
                Element elm = (Element)list.item(i);
                map = new HashMap<String, String>();
                NodeList paramList = elm.getElementsByTagName("parameter");
                int plength = paramList.getLength();
                for (int j = 0; j < plength; ++j) {
                    Element param = (Element)paramList.item(j);
                    map.put(param.getAttribute("name"), param.getAttribute("value"));
                }
                view.setGraphicalPropsFor(object, map);
            }
        }
    }

    public void readGraphicalInfo(Element objInfo, DesignObject object, TopView tv) {
        if (object == null || object.getDesign() == null) {
            LOGGER.error("readGraphicalInfo: DesignObject = null or design = null");
            return;
        }
        ApplicationView view = object.getDesign().getAppView();
        if (view != null) {
            NodeList list = objInfo.getElementsByTagName("graphical");
            HashMap<String, String> map = null;
            int length = list.getLength();
            for (int i = 0; i < length; ++i) {
                Element elm = (Element)list.item(i);
                map = new HashMap<String, String>();
                NodeList paramList = elm.getElementsByTagName("parameter");
                int plength = paramList.getLength();
                for (int j = 0; j < plength; ++j) {
                    Element param = (Element)paramList.item(j);
                    map.put(param.getAttribute("name"), param.getAttribute("value"));
                }
                view.setGraphicalPropsFor(tv, map);
            }
        }
    }

    @Override
    public String getRelativePath() {
        if (this.getPersistenceManager().getAppView() != null) {
            String designName = this.getPersistenceManager().getAppView().getDesignName();
            StringBuffer buffer = new StringBuffer();
            buffer.append(designName).append('/');
            if (this.isOldDesign()) {
                buffer.append("processmodel/dataflows");
            } else {
                buffer.append("pm/dflows");
            }
            return buffer.toString();
        }
        return "pm/dflows";
    }
}

