/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.process;

import java.util.Map;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.process.Event;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.process.DFConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RXMLEvent
extends AbstractRXMLDesignObject
implements DFConstants {
    public RXMLEvent(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    protected DesignObject instantiateDesignObject(String objectID, Design design, Element objInfo) {
        return design.getProcessModel().getEventSet().createEvent(StringUtilities.decodeAttributeValue(objectID), 0);
    }

    @Override
    public Object recreateObject(Element objInfo, Design design, boolean tryReadWriteLocking) {
        Event event = (Event)super.recreateObject(objInfo, design, tryReadWriteLocking);
        String synonym = objInfo.getAttribute("synonym");
        if (synonym != null) {
            event.setSynonym(StringUtilities.decodeAttributeValue(synonym));
        }
        Map map = this.getProperties(objInfo, "attributes");
        try {
            int type = Integer.parseInt((String)map.get("type"));
            event.setEventType(type);
        }
        catch (Exception e) {
            // empty catch block
        }
        event.setText((String)map.get("eventtext"));
        try {
            int value = Integer.parseInt((String)map.get("frequency"));
            event.setFrequency(value);
        }
        catch (Exception e) {
            // empty catch block
        }
        event.setOnDay(Boolean.valueOf((String)map.get("onday")));
        event.setDayOfWeek((String)map.get("dayofweek"));
        try {
            int value = Integer.parseInt((String)map.get("dayofmonth"));
            event.setDayOfMonth(value);
        }
        catch (Exception e) {
            // empty catch block
        }
        event.setMonths((String)map.get("months"));
        try {
            int value = Integer.parseInt((String)map.get("quarter"));
            event.setQuarter(value);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            int value = Integer.parseInt((String)map.get("year"));
            event.setYear(value);
        }
        catch (Exception e) {
            // empty catch block
        }
        event.setFiscal(Boolean.valueOf((String)map.get("fiscal")));
        try {
            int value = Integer.parseInt((String)map.get("timeswhenrun"));
            event.setTimesWhenRun(value);
        }
        catch (Exception e) {
            // empty catch block
        }
        event.setAtTime(Boolean.valueOf((String)map.get("attime")));
        try {
            int value = Integer.parseInt((String)map.get("hour"));
            event.setHour(value);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            int value = Integer.parseInt((String)map.get("minute"));
            event.setMinute(value);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            int value = Integer.parseInt((String)map.get("timefreq"));
            event.setTimeFreq(value);
        }
        catch (Exception e) {
            // empty catch block
        }
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            buffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        buffer.append(this.getRelativePath()).append('/').append(StringUtilities.decodeAttributeValue(event.getObjectID())).append(".dmd");
        event.setFilePath(buffer.toString());
        return event;
    }

    @Override
    public Object recreateDesign(Document doc, DesignPart design, boolean tryReadWriteLocking) {
        return null;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            String designName = this.getPersistenceManager().getAppView().getDesignName();
            if (this.isOldDesign()) {
                buffer.append(designName).append('/').append("processmodel").append('/');
            } else {
                buffer.append(designName).append('/').append("pm").append('/');
            }
        }
        buffer.append(this.getConfiguration().get("eventPath"));
        return buffer.toString();
    }

    @Override
    public boolean isReaderForClass(Class type) {
        return type == Event.class;
    }
}

