/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.process;

import java.util.StringTokenizer;
import java.util.TreeMap;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.process.ExternalData;
import oracle.dbtools.crest.model.design.process.ParameterObject;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.design.process.TargetElement;
import oracle.dbtools.crest.model.design.process.Transformation;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.process.DFConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RXMLTransformation
extends AbstractRXMLDesignObject
implements DFConstants {
    public RXMLTransformation(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    protected DesignObject instantiateDesignObject(String objectID, Design design, Element objInfo) {
        return design.getProcessModel().getTransformationPackage().getLastTaskAdded().createTransformation(StringUtilities.decodeAttributeValue(objectID));
    }

    @Override
    public Object recreateObject(Element objInfo, Design design, boolean tryReadWriteLocking) {
        String jcondition;
        TreeMap<String, String> map;
        String fcondition;
        Transformation process = (Transformation)super.recreateObject(objInfo, design, tryReadWriteLocking);
        NodeList list = objInfo.getElementsByTagName("primary");
        if (list.getLength() > 0) {
            Element engineerElm = (Element)list.item(0);
            String value = engineerElm.getAttribute("is_primary");
            if (value != null && value.equals(VALUE_TRUE)) {
                process.setPrimary(true);
            } else {
                process.setPrimary(false);
            }
        }
        if ((fcondition = (String)(map = this.getProperties(objInfo, "attributes")).get("filter_condition")) != null) {
            process.setFilterCondition(fcondition);
        }
        if ((jcondition = (String)map.get("join_condition")) != null) {
            process.setJoinCondition(jcondition);
        }
        NodeList objElms = RXMLTransformation.getFirstChildByTagName(objInfo, "contained").getElementsByTagName("targetelement");
        int length = objElms.getLength();
        for (int i = 0; i < length; ++i) {
            Element child = (Element)objElms.item(i);
            map = new TreeMap<String, String>();
            NodeList propList = child.getElementsByTagName("parameter");
            int plength = propList.getLength();
            for (int j = 0; j < plength; ++j) {
                Element param = (Element)propList.item(j);
                map.put(param.getAttribute("name"), param.getAttribute("value"));
            }
            String flowID = (String)map.get("flowid");
            String attrID = (String)map.get("attributeid");
            DesignObject attribute = process.getDesign().getLogicalDesign().getAttributeSet().getObjectByID(attrID);
            if (attribute == null) {
                attribute = process.getDesign().getProcessModel().getExternalDataSet().getObjectByID(attrID);
            }
            if (attribute == null) {
                attribute = process.getDesign().getProcessModel().getTransformationTask().getParameterObjectById(attrID);
            }
            if ("".equalsIgnoreCase(flowID) || attribute == null) continue;
            TargetElement target = new TargetElement(attribute);
            process.getTargetElements().add(target);
            String type = (String)map.get("type");
            target.setTransformationType(type);
            String description = (String)map.get("description");
            target.setDescription(description);
            String sources = (String)map.get("sources");
            StringTokenizer tokenizer = new StringTokenizer(sources, ",");
            while (tokenizer.hasMoreTokens()) {
                String sourceID = tokenizer.nextToken();
                attribute = process.getDesign().getLogicalDesign().getAttributeSet().getObjectByID(sourceID);
                if (attribute != null) {
                    target.addSource(attribute);
                    continue;
                }
                ExternalData extData = (ExternalData)process.getDesign().getProcessModel().getExternalDataSet().getObjectByID(sourceID);
                if (extData != null) {
                    target.addSource(extData);
                    continue;
                }
                ParameterObject dobj = process.getDesign().getProcessModel().getTransformationTask().getParameterObjectById(sourceID);
                target.addSource(dobj);
            }
        }
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            buffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        buffer.append(this.getRelativePath()).append('/').append(StringUtilities.decodeAttributeValue(process.getObjectID())).append(".dmd");
        process.setFilePath(buffer.toString());
        return process;
    }

    @Override
    public Object recreateDesign(Document doc, DesignPart design, boolean tryReadWriteLocking) {
        return null;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            String designName = this.getPersistenceManager().getAppView().getDesignName();
            if (this.getPersistenceManager().getAppView().getCurrentDesign().getProcessModel().getTransformationPackage() != null) {
                String trPackName = this.getPersistenceManager().getAppView().getCurrentDesign().getProcessModel().getTransformationPackage().getObjectID();
                String trTaskName = this.getPersistenceManager().getAppView().getCurrentDesign().getProcessModel().getTransformationPackage().getLastTaskAdded().getObjectID();
                buffer.append(designName).append('/');
                if (this.isOldDesign()) {
                    buffer.append("processmodel/tansformationpackages");
                } else {
                    buffer.append("pm/tp");
                    trTaskName = this.getPersistenceManager().getAppView().getCurrentDesign().getProcessModel().getTransformationPackage().getLastTaskAdded().getPathIDString();
                }
                buffer.append('/').append(trPackName).append('/').append(trTaskName).append('/');
            } else {
                buffer.append(designName).append('/');
                if (this.isOldDesign()) {
                    buffer.append("processmodel/tansformationpackages");
                } else {
                    buffer.append("pm/tp");
                }
                buffer.append('/');
            }
        }
        buffer.append(this.getConfiguration().get("processPath"));
        return buffer.toString();
    }

    @Override
    public boolean isReaderForClass(Class type) {
        return type != Process.class && type == Transformation.class;
    }
}

