/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.process;

import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.process.TransformationPackage;
import oracle.dbtools.crest.model.design.process.TransformationTask;
import oracle.dbtools.crest.model.design.process.TransformationTaskSet;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.process.DFConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RXMLTransformationPackage
extends AbstractRXMLDesignObject
implements DFConstants {
    private boolean xmlFromDB = false;

    public RXMLTransformationPackage(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    protected DesignObject instantiateDesignObject(String objectID, Design design, Element objInfo) {
        TransformationPackage trp = design.getProcessModel().createTransformationPackage(StringUtilities.decodeAttributeValue(objectID));
        design.getProcessModel().setTransformationPackage(trp);
        return trp;
    }

    @Override
    public Object recreateObject(Element objInfo, Design design, boolean tryReadWriteLocking) {
        TransformationPackage trPack = (TransformationPackage)super.recreateObject(objInfo, design, tryReadWriteLocking);
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            buffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        buffer.append(this.getRelativePath()).append('/').append(StringUtilities.decodeAttributeValue(trPack.getObjectID())).append(".dmd");
        trPack.setFilePath(buffer.toString());
        this.recreateReferenced(objInfo, design, trPack);
        return trPack;
    }

    @Override
    public Object recreateDesign(Document doc, DesignPart design, boolean tryReadWriteLocking) {
        return null;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            String designName = this.getPersistenceManager().getAppView().getDesignName();
            buffer.append(designName).append('/');
            if (this.isOldDesign()) {
                buffer.append("processmodel/tansformationpackages");
            } else {
                buffer.append("pm/tp");
            }
            buffer.append('/');
        }
        return buffer.toString();
    }

    private void recreateReferenced(Element objInfo, Design design, TransformationPackage trPack) {
        this.xmlFromDB = this.getPersistenceManager().isXML_FromDataBase();
        TransformationTaskSet set = design.getProcessModel().getTransformationPackage().getTransformationTaskSet();
        Document doc = objInfo.getOwnerDocument();
        Element root = doc.getDocumentElement();
        NodeList objectElements = RXMLTransformationPackage.getFirstChildByTagName(root, "ref").getElementsByTagName("transformation_task");
        int length = objectElements.getLength();
        for (int i = 0; i < length; ++i) {
            Element elm = (Element)objectElements.item(i);
            String oid = elm.getAttribute("oid");
            String type = elm.getAttribute("type");
            String name = RXMLTransformationPackage.getFirstChildByTagName(elm, "name").getFirstChild().getNodeValue();
            String visible = elm.getAttribute("is_visible");
            String comment = "";
            if (RXMLTransformationPackage.getFirstChildByTagName(elm, "comment").getFirstChild() != null) {
                comment = RXMLTransformationPackage.getFirstChildByTagName(elm, "comment").getFirstChild().getNodeValue();
            }
            if (!type.equalsIgnoreCase("TransformationTask")) continue;
            TransformationTask task = null;
            task = !this.xmlFromDB ? design.getProcessModel().getTransformationPackage().createTransformationTask(oid) : (TransformationTask)set.getObjectByID(oid);
            if (task == null) continue;
            if (!this.isOldDesign()) {
                String path_id_str = elm.getAttribute("path_id");
                try {
                    int path_id = Integer.parseInt(path_id_str);
                    task.setPathID(path_id);
                    design.getProcessModel().getTransformationPackage().getTransformationTaskSet().updateMaxIndex(path_id);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            String inp_id = elm.getAttribute("input_parameters_id");
            String outp_id = elm.getAttribute("output_parameters_id");
            boolean new_ids = false;
            if (inp_id != null && !"".equals(inp_id) && !"null".equals(inp_id)) {
                new_ids = true;
                task.getInputParamsObject().setObjectID(inp_id);
            }
            if (outp_id != null && !"".equals(outp_id) && !"null".equals(outp_id)) {
                new_ids = true;
                task.getOutputParamsObject().setObjectID(outp_id);
            }
            if (!new_ids) {
                task.assignOldLocalIDs();
            }
            if (!this.xmlFromDB) {
                task.load();
            }
            task.setName(name);
            task.setComment(StringUtilities.decodeAttributeValue(comment));
            if (visible == null) continue;
            task.setVisible(Boolean.valueOf(visible));
        }
    }

    @Override
    public boolean isReaderForClass(Class type) {
        return type == TransformationPackage.class;
    }
}

