/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.process;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.StringTokenizer;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.TopViewCollection;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Label;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.design.process.InOutParams;
import oracle.dbtools.crest.model.design.process.InfoStore;
import oracle.dbtools.crest.model.design.process.TransformationTask;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLReader;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.process.AbstractDataFlowTV;
import oracle.dbtools.crest.swingui.process.DPVTransformation;
import oracle.dbtools.crest.swingui.process.TVFlow;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RXMLTransformationTask
extends AbstractXMLReader {
    private boolean xmlFromDB = false;
    private static Logger LOGGER = new Logger(RXMLTransformationTask.class);

    public RXMLTransformationTask(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public Object recreateObject(Document doc, Design design, boolean tryReadWriteLocking) {
        return null;
    }

    @Override
    public Object recreateDesign(Document doc, DesignPart design, boolean tryReadWriteLocking) {
        this.xmlFromDB = this.getPersistenceManager().isXML_FromDataBase();
        Element root = doc.getDocumentElement();
        String id = root.getAttribute("id");
        if (!"".equalsIgnoreCase(id)) {
            design.setObjectID(StringUtilities.decodeAttributeValue(id));
        }
        TransformationTask task = (TransformationTask)design;
        String mainViewId = root.getAttribute("main_view_id");
        if (mainViewId != null && !"".equalsIgnoreCase(mainViewId) && !"null".equalsIgnoreCase(mainViewId)) {
            task.getMainView().setDPVId(mainViewId);
        }
        this.readInputParams(root, "input_parameters", task.getInputParamsObject());
        this.readInputParams(root, "output_parameters", task.getOutputParamsObject());
        NodeList objectElements = RXMLTransformationTask.getFirstChildByTagName(root, "ref").getElementsByTagName("objectid");
        int length = objectElements.getLength();
        for (int i = 0; i < length; ++i) {
            Element elm = (Element)objectElements.item(i);
            String role = elm.getAttribute("role");
            String oid = elm.getAttribute("oid");
            boolean getlock = "contains".equalsIgnoreCase(role) && tryReadWriteLocking;
            DesignObject object = null;
            object = !this.xmlFromDB ? (DesignObject)this.getPersistenceManager().read((Object)oid, design.getDesign(), getlock) : design.getDesign().getDesignObject(oid);
            if (object != null) {
                object.setTemporaryWriteable(true);
                if (!object.belongsToDesign(design.getDesign())) {
                    object.setReadOnly(true);
                }
                this.readGraphicalInfo(elm, object);
                object.setTemporaryWriteable(false);
                continue;
            }
            LOGGER.error("RXMLTransformationTask: Read object returns null (objectID: " + oid);
        }
        this.readSources(root, task, design);
        this.readTargets(root, task, design);
        this.readSynonymsForGlobals(root, (TransformationTask)design);
        this.readFlows(root, (TransformationTask)design);
        this.readDisplayProperties(root, design.getMainView());
        design.getMainView().getWorkSpace().updateSettings();
        this.readDiagramViews(root, design);
        design.setLoaded(true);
        return design;
    }

    private void readSources(Element objInfo, TransformationTask task, DesignPart design) {
        NodeList docsInfo = objInfo.getElementsByTagName("source_stores");
        int length = docsInfo.getLength();
        for (int i = 0; i < length; ++i) {
            if (i != 0) continue;
            Element elm = (Element)docsInfo.item(i);
            String ids = elm.getAttribute("id");
            StringTokenizer tokenizer = new StringTokenizer(ids, ",");
            while (tokenizer.hasMoreTokens()) {
                String objid = tokenizer.nextToken().trim();
                DesignObject object = design.getDesign().getDesignObject(objid);
                if (object == null) continue;
                task.addSource((InfoStore)object);
            }
        }
    }

    private void readTargets(Element objInfo, TransformationTask task, DesignPart design) {
        NodeList docsInfo = objInfo.getElementsByTagName("target_stores");
        int length = docsInfo.getLength();
        for (int i = 0; i < length; ++i) {
            if (i != 0) continue;
            Element elm = (Element)docsInfo.item(i);
            String ids = elm.getAttribute("id");
            StringTokenizer tokenizer = new StringTokenizer(ids, ",");
            while (tokenizer.hasMoreTokens()) {
                String objid = tokenizer.nextToken().trim();
                DesignObject object = design.getDesign().getDesignObject(objid);
                if (object == null) continue;
                task.addTarget((InfoStore)object);
            }
        }
    }

    private void readInputParams(Element root, String type, InOutParams params) {
        Element element = RXMLTransformationTask.getFirstChildByTagName(root, type);
        String multiplicity = element.getAttribute("parameters_multiplicity");
        params.setParametersMultiplicity(multiplicity);
        String comment = "";
        if (RXMLTransformationTask.getFirstChildByTagName(element, "comment").getFirstChild() != null) {
            comment = RXMLTransformationTask.getFirstChildByTagName(element, "comment").getFirstChild().getNodeValue();
        }
        String notes = "";
        if (RXMLTransformationTask.getFirstChildByTagName(element, "comment").getFirstChild() != null) {
            notes = RXMLTransformationTask.getFirstChildByTagName(element, "comment").getFirstChild().getNodeValue();
        }
        params.setNotes(notes);
        params.setComment(StringUtilities.decodeAttributeValue(comment));
        this.readColorInfo(element, params);
        this.readFontsInfo(element, params);
        NodeList list = element.getElementsByTagName("inout_parameter");
        int length = list.getLength();
        for (int i = 0; i < length; ++i) {
            Element inout = (Element)list.item(i);
            String oid = inout.getAttribute("oid");
            String name = inout.getAttribute("name");
            String ltype = inout.getAttribute("dttype");
            params.addParam(oid, name, ltype);
        }
        this.readGraphicalInfo(element, params);
    }

    private void readFlows(Element root, TransformationTask design) {
        Element fklist;
        ApplicationView.log(Messages.getString("RXMLTransformationTask.ReadFlows"));
        DesignPartView dpv = design.getMainView();
        if (design.getAppView() != null && (fklist = RXMLTransformationTask.getFirstChildByTagName(root, "view_flows")) != null) {
            NodeList objectElements = fklist.getElementsByTagName("objectid");
            int length = objectElements.getLength();
            for (int i = 0; i < length; ++i) {
                String width;
                Element graphical;
                Element lbl;
                String y;
                String x;
                TopView tv;
                TopViewCollection col;
                Element elm = (Element)objectElements.item(i);
                String oid = elm.getAttribute("oid");
                Flow flow = (Flow)design.getFlowSet().getObjectByID(oid);
                String svid = elm.getAttribute("viewid_source");
                String tvid = elm.getAttribute("viewid_target");
                if (!svid.equals("null") && (col = flow.getSourceProcessObject().getViewsForDPV(dpv)).size() == 1) {
                    tv = (TopView)col.get(0);
                    flow.setSourceTV((AbstractDataFlowTV)tv);
                }
                if (!tvid.equals("null") && (col = flow.getTargetProcessObject().getViewsForDPV(dpv)).size() == 1) {
                    tv = (TopView)col.get(0);
                    flow.setTargetTV((AbstractDataFlowTV)tv);
                }
                Element points = RXMLTransformationTask.getFirstChildByTagName(elm, "points");
                NodeList plist = points.getElementsByTagName("point");
                int plLength = plist.getLength();
                TVFlow tv2 = (TVFlow)flow.getTopView();
                for (int kk = 0; kk < plLength; ++kk) {
                    Element point = (Element)plist.item(kk);
                    x = point.getAttribute("x_coordinate");
                    y = point.getAttribute("y_coordinate");
                    tv2.getEdgePoints().add(DiagramConstants.createPoint(Double.parseDouble(x), Double.parseDouble(y)));
                }
                Element labels = RXMLTransformationTask.getFirstChildByTagName(elm, "labels");
                if (labels != null && (lbl = RXMLTransformationTask.getFirstChildByTagName(labels, "main_label")) != null) {
                    x = lbl.getAttribute("x_coordinate");
                    y = lbl.getAttribute("y_coordinate");
                    String w = lbl.getAttribute("width");
                    String h = lbl.getAttribute("height");
                    if (w == null || "".equalsIgnoreCase(w)) {
                        w = "-1";
                    }
                    if (h == null || "".equalsIgnoreCase(h)) {
                        h = "-1";
                    }
                    tv2.setLabelBounds(new Rectangle((int)Double.parseDouble(x), (int)Double.parseDouble(y), (int)Double.parseDouble(w), (int)Double.parseDouble(h)));
                    Label label = tv2.getTempCenterLabel();
                    if (label != null) {
                        this.readColorInfo(lbl, label);
                        this.readFontsInfo(lbl, label);
                    }
                }
                if ((graphical = RXMLTransformationTask.getFirstChildByTagName(elm, "graphical")) == null) continue;
                NodeList paramList = graphical.getElementsByTagName("parameter");
                HashMap<String, String> map = new HashMap<String, String>();
                int plength = paramList.getLength();
                for (int l = 0; l < plength; ++l) {
                    Element param = (Element)paramList.item(l);
                    map.put(param.getAttribute("name"), param.getAttribute("value"));
                }
                String useDefault = (String)map.get("use_default_color");
                boolean useDef = true;
                if (useDefault != null) {
                    useDef = Boolean.valueOf(useDefault);
                }
                tv2.setUseDefaultColor(useDef);
                if (useDef) continue;
                String color = (String)map.get("color");
                if (color != null && !"null".equalsIgnoreCase(color)) {
                    Color backgroundColor = new Color(Integer.parseInt(color));
                    tv2.setBackgroundColor(backgroundColor);
                }
                if ((width = (String)map.get("width")) == null || "null".equalsIgnoreCase(width)) continue;
                int lineWidth = Integer.parseInt(width);
                tv2.setLineWidth(lineWidth);
            }
        }
    }

    private void readSynonymsForGlobals(Element root, TransformationTask design) {
        Element fklist;
        ApplicationView.log(Messages.getString("RXMLTransformationTask.ReadSynonymsForGlobalPMObjects"));
        DPVTransformation dpv = (DPVTransformation)design.getMainView();
        if (design.getAppView() != null && (fklist = RXMLTransformationTask.getFirstChildByTagName(root, "synonyms_for_globals")) != null) {
            NodeList objectElements = fklist.getElementsByTagName("objectid");
            int length = objectElements.getLength();
            for (int i = 0; i < length; ++i) {
                Element elm = (Element)objectElements.item(i);
                String oid = elm.getAttribute("oid");
                String type = elm.getAttribute("type");
                AbstractProcessObject po = null;
                if ("InfoStore".equalsIgnoreCase(type)) {
                    po = (AbstractProcessObject)design.getInfoStoreSet().getObjectByID(oid);
                } else if ("Process".equalsIgnoreCase(type)) {
                    po = (AbstractProcessObject)design.getDesign().getDesignObject(oid);
                }
                if (po == null || dpv == null) continue;
                TopView tv = po.getFirstViewForDPV(dpv);
                if (tv == null) {
                    tv = dpv.createViewSynonim(po);
                }
                this.readGraphicalInfo(elm, po, tv);
            }
        }
    }

    public void readGraphicalInfo(Element objInfo, DesignObject object) {
        if (object == null || object.getDesign() == null) {
            LOGGER.error("readGraphicalInfo: DesignObject = null or design = null");
            return;
        }
        ApplicationView view = object.getDesign().getAppView();
        if (view != null) {
            NodeList list = objInfo.getElementsByTagName("graphical");
            HashMap<String, String> map = null;
            int length = list.getLength();
            for (int i = 0; i < length; ++i) {
                Element elm = (Element)list.item(i);
                map = new HashMap<String, String>();
                NodeList paramList = elm.getElementsByTagName("parameter");
                int plength = paramList.getLength();
                for (int j = 0; j < plength; ++j) {
                    Element param = (Element)paramList.item(j);
                    map.put(param.getAttribute("name"), param.getAttribute("value"));
                }
                view.setGraphicalPropsFor(object, map);
            }
        }
    }

    public void readGraphicalInfo(Element objInfo, DesignObject object, TopView tv) {
        if (object == null || object.getDesign() == null) {
            LOGGER.error("readGraphicalInfo: DesignObject = null or design = null");
            return;
        }
        ApplicationView view = object.getDesign().getAppView();
        if (view != null) {
            NodeList list = objInfo.getElementsByTagName("graphical");
            HashMap<String, String> map = null;
            int length = list.getLength();
            for (int i = 0; i < length; ++i) {
                Element elm = (Element)list.item(i);
                map = new HashMap<String, String>();
                NodeList paramList = elm.getElementsByTagName("parameter");
                int plength = paramList.getLength();
                for (int j = 0; j < plength; ++j) {
                    Element param = (Element)paramList.item(j);
                    map.put(param.getAttribute("name"), param.getAttribute("value"));
                }
                view.setGraphicalPropsFor(tv, map);
            }
        }
    }

    @Override
    public String getRelativePath() {
        if (this.getPersistenceManager().getAppView() != null) {
            String designName = this.getPersistenceManager().getAppView().getDesignName();
            Design design = this.getPersistenceManager().getAppView().getCurrentDesign();
            StringBuffer buffer = new StringBuffer();
            if (design.getProcessModel().getTransformationPackage() != null) {
                buffer.append(designName).append('/');
                if (this.isOldDesign()) {
                    buffer.append("processmodel/tansformationpackages");
                } else {
                    buffer.append("pm/tp");
                }
                buffer.append('/').append(StringUtilities.decodeAttributeValue(design.getProcessModel().getTransformationPackage().getObjectID())).append('/');
            } else {
                buffer.append(designName).append('/');
                if (this.isOldDesign()) {
                    buffer.append("processmodel/tansformationpackages");
                } else {
                    buffer.append("pm/tp");
                }
                buffer.append('/');
            }
            return buffer.toString();
        }
        return "pm/tp";
    }
}

