/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.process;

import java.util.Iterator;
import java.util.TreeMap;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.design.process.TargetElement;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.process.DFConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;

public class WXMLProcess
extends AbstractWXMLDesignObject
implements DFConstants {
    private Process process = null;

    public WXMLProcess(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean result = object instanceof Process;
        if (result) {
            this.process = (Process)object;
        }
        return result;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.process != null) {
            String designName = this.process.getDesignPart().getAppView().getDesignName();
            buffer.append(designName).append('/').append("pm/dflows").append('/').append(StringUtilities.encodeAttributeValue(this.process.getDesignPart().getObjectID())).append('/');
        }
        buffer.append(this.getConfiguration().get("processPath"));
        return buffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element objectInfoNode, DesignObject object) {
        if (object instanceof Process) {
            Process process = (Process)object;
            if (process.getSynonym() != null && !"".equalsIgnoreCase(process.getSynonym())) {
                objectInfoNode.setAttribute("synonym", StringUtilities.encodeAttributeValue(process.getSynonym()));
            }
            TreeMap<String, String> map = new TreeMap<String, String>();
            map.put("filter_condition", process.getFilterCondition());
            map.put("join_condition", process.getJoinCondition());
            map.put("type", Integer.toString(process.getType()));
            map.put("diagram", process.getDiagram() != null ? StringUtilities.encodeAttributeValue(process.getDiagram().getObjectID()) : "null");
            map.put("footnote", StringUtilities.encodeAttributeValue(process.getFootNote()));
            map.put("frequencytimes", Integer.toString(process.getFrequencyTimes()));
            map.put("frequencytimeunit", process.getFrequencyTimeUnit());
            map.put("priority", process.getPriority());
            map.put("mode", process.getMode());
            map.put("batchmintransactions", Integer.toString(process.getBatchMinimumTransactions()));
            map.put("batchtimeunit", process.getBatchTimeUnit());
            map.put("longestresponsetime", Integer.toString(process.getInteractiveLongestResponseTime()));
            map.put("responsetimeunit", process.getInteractiveResponseTimeUnit());
            boolean[] peakPeriods = process.getPeakPeriods();
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < peakPeriods.length; ++i) {
                buffer.append(peakPeriods[i] ? "1" : "0");
            }
            map.put("peakperiods", buffer.toString());
            map.put("trtask_input_params", process.getParamsWrappersString());
            String trTaskId = "none";
            if (process.getTransformationTask() != null) {
                trTaskId = process.getTransformationTask().getObjectID();
            }
            map.put("transformation_task", StringUtilities.encodeAttributeValue(trTaskId));
            this.appendProperties(objectInfoNode, "attributes", map);
            this.appendObjects(objectInfoNode, process.getEvents().toArray(), "events");
            process.removeInvalidElements();
            Element contained = objectInfoNode.getOwnerDocument().createElement("contained");
            objectInfoNode.appendChild(contained);
            for (TargetElement target : process.getTargetElements()) {
                this.appendTargetInfo(contained, target);
            }
        }
    }

    private void appendTargetInfo(Element objectInfoNode, TargetElement target) {
        Element propertiesList = objectInfoNode.getOwnerDocument().createElement("targetelement");
        Element param = objectInfoNode.getOwnerDocument().createElement("parameter");
        propertiesList.appendChild(param);
        param = objectInfoNode.getOwnerDocument().createElement("parameter");
        propertiesList.appendChild(param);
        this.appendProperty(param, "attributeid", StringUtilities.encodeAttributeValue(target.getTarget().getObjectID()));
        Iterator it = target.getSources().iterator();
        StringBuffer buffer = new StringBuffer();
        boolean first = true;
        while (it.hasNext()) {
            if (first) {
                first = false;
            } else {
                buffer.append(',');
            }
            buffer.append(StringUtilities.encodeAttributeValue(((DesignObject)it.next()).getObjectID()));
        }
        param = objectInfoNode.getOwnerDocument().createElement("parameter");
        propertiesList.appendChild(param);
        this.appendProperty(param, "sources", buffer.toString());
        param = objectInfoNode.getOwnerDocument().createElement("parameter");
        propertiesList.appendChild(param);
        this.appendProperty(param, "type", target.getTransformationType());
        param = objectInfoNode.getOwnerDocument().createElement("parameter");
        propertiesList.appendChild(param);
        this.appendProperty(param, "description", target.getDescription());
        objectInfoNode.appendChild(propertiesList);
    }
}

