/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.process;

import java.util.Iterator;
import java.util.TreeMap;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.process.TargetElement;
import oracle.dbtools.crest.model.design.process.Transformation;
import oracle.dbtools.crest.model.design.process.TransformationTask;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.process.DFConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;

public class WXMLTransformation
extends AbstractWXMLDesignObject
implements DFConstants {
    private Transformation process = null;

    public WXMLTransformation(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean result;
        boolean bl = result = Transformation.class == object.getClass();
        if (result) {
            this.process = (Transformation)object;
        }
        return result;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.process != null) {
            String designName = this.process.getDesignPart().getAppView().getDesignName();
            buffer.append(designName).append('/').append("pm/tp").append('/').append(StringUtilities.encodeAttributeValue(((TransformationTask)this.process.getDesignPart()).getTransformationPackage().getObjectID())).append('/').append(this.process.getDesignPart().getPathIDString()).append('/');
        }
        buffer.append(this.getConfiguration().get("processPath"));
        return buffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element objectInfoNode, DesignObject object) {
        if (Transformation.class == object.getClass()) {
            Transformation process = (Transformation)object;
            if (process.getSynonym() != null && !process.getSynonym().equalsIgnoreCase("")) {
                objectInfoNode.setAttribute("synonym", StringUtilities.encodeAttributeValue(process.getSynonym()));
            }
            Element primaryElm = this.createElement(objectInfoNode, "primary");
            primaryElm.setAttribute("is_primary", process.isPrimary() ? VALUE_TRUE : VALUE_FALSE);
            TreeMap<String, String> map = new TreeMap<String, String>();
            map.put("filter_condition", process.getFilterCondition());
            map.put("join_condition", process.getJoinCondition());
            this.appendProperties(objectInfoNode, "attributes", map);
            process.updateTargetElements();
            Element contained = objectInfoNode.getOwnerDocument().createElement("contained");
            objectInfoNode.appendChild(contained);
            for (TargetElement target : process.getTargetElements()) {
                this.appendTargetInfo(contained, target);
            }
        }
    }

    private void appendTargetInfo(Element objectInfoNode, TargetElement target) {
        Element propertiesList = objectInfoNode.getOwnerDocument().createElement("targetelement");
        Element param = objectInfoNode.getOwnerDocument().createElement("parameter");
        propertiesList.appendChild(param);
        param = objectInfoNode.getOwnerDocument().createElement("parameter");
        propertiesList.appendChild(param);
        this.appendProperty(param, "attributeid", StringUtilities.encodeAttributeValue(target.getTarget().getObjectID()));
        Iterator it = target.getSources().iterator();
        StringBuffer buffer = new StringBuffer();
        boolean first = true;
        while (it.hasNext()) {
            if (first) {
                first = false;
            } else {
                buffer.append(',');
            }
            buffer.append(StringUtilities.encodeAttributeValue(((DesignObject)it.next()).getObjectID()));
        }
        param = objectInfoNode.getOwnerDocument().createElement("parameter");
        propertiesList.appendChild(param);
        this.appendProperty(param, "sources", buffer.toString());
        param = objectInfoNode.getOwnerDocument().createElement("parameter");
        propertiesList.appendChild(param);
        this.appendProperty(param, "type", target.getTransformationType());
        param = objectInfoNode.getOwnerDocument().createElement("parameter");
        propertiesList.appendChild(param);
        this.appendProperty(param, "description", target.getDescription());
        objectInfoNode.appendChild(propertiesList);
    }
}

